/*
 *  TOPPERS Software
 *      Toyohashi Open Platform for Embedded Real-Time Systems
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2007-2010 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ(1)(4)ξ˸¤ꡤܥեȥ
 *  ܥեȥѤΤޤࡥʲƱˤѡʣ
 *  ѡۡʰʲѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *      ޤܥեȥΥ桼ޤϥɥ桼Τʤ
 *      ͳ˴Ťᤫ⡤嵭ԤTOPPERSץȤ
 *      դ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơλŪ
 *  ФŬޤơʤݾڤԤʤޤܥեȥ
 *  ѤˤľŪޤϴŪʤ»˴ؤƤ⡤
 *  Ǥʤ
 * 
 *  $Id$
 */

/*
 *		get_utm˴ؤƥ(1)
 *
 * ڥƥȤŪ
 *
 *  ǽɾѥƥ郎չԤ뤳ȤʤȤƥȤ롥
 *
 * ڥƥȤơ
 *
 *  ᥤ󥿥Ǥϡǽɾѥƥ򷫤֤郎
 *  ʤʤå롥¹Ԥơϥɥ1ߥ
 *  Ǽ¹ԤǤǽɾѥƥơ郎
 *  ʤʤå롥
 *
 *  ʤǽɾѥƥ郎ͤĶ0ϹθƤ
 *  ʤ
 */

#include <kernel.h>
#include <test_lib.h>
#include <t_syslog.h>
#include "kernel_cfg.h"
#include "test_utm1.h"

#define	NO_LOOP		ULONG_C(100000)

SYSUTM	recent_sysutm;
char	*recent_sysutm_pos;
uint_t	cyclic_count;

void
cyclic_handler(intptr_t exinf)
{
	SYSUTM		sysutm, prev_sysutm;
	char		*prev_sysutm_pos;

	iloc_cpu();
	get_utm(&sysutm);
	prev_sysutm = recent_sysutm;
	prev_sysutm_pos = recent_sysutm_pos;
	recent_sysutm = sysutm;
	recent_sysutm_pos = "CYC";
	iunl_cpu();

	if (prev_sysutm > sysutm) {
		syslog(LOG_NOTICE,
				"system performance time goes back: %ld(%s) %ld(CYC)",
				((long_t) prev_sysutm), prev_sysutm_pos, ((ulong_t) sysutm));
	}
	cyclic_count += 1;
}

void
main_task(intptr_t exinf)
{
	SYSUTM		sysutm, prev_sysutm;
	char		*prev_sysutm_pos;
	ulong_t		i;

	cyclic_count = 0U;
	get_utm(&recent_sysutm);
	syslog(LOG_NOTICE, "system performance time test starts.");

	for (i = 0; i < NO_LOOP; i++) {
		loc_cpu();
		get_utm(&sysutm);
		prev_sysutm = recent_sysutm;
		prev_sysutm_pos = recent_sysutm_pos;
		recent_sysutm = sysutm;
		recent_sysutm_pos = "TSK";
		unl_cpu();

		if (prev_sysutm > sysutm) {
			syslog(LOG_NOTICE,
				"system performance time goes back: %ld(%s) %ld(TSK)",
				((long_t) prev_sysutm), prev_sysutm_pos, ((ulong_t) sysutm));
		}
	}

	syslog(LOG_NOTICE, "system performance time test finishes.");
	syslog(LOG_NOTICE, "number of cyclic handler execution: %d", cyclic_count);
	test_finish();
}
