/*
 *  TOPPERS Software
 *      Toyohashi Open Platform for Embedded Real-Time Systems
 * 
 *  Copyright (C) 2006-2009 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ(1)(4)ξ˸¤ꡤܥեȥ
 *  ܥեȥѤΤޤࡥʲƱˤѡʣ
 *  ѡۡʰʲѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *      ޤܥեȥΥ桼ޤϥɥ桼Τʤ
 *      ͳ˴Ťᤫ⡤嵭ԤTOPPERSץȤ
 *      դ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơλŪ
 *  ФŬޤơʤݾڤԤʤޤܥեȥ
 *  ѤˤľŪޤϴŪʤ»˴ؤƤ⡤
 *  Ǥʤ
 * 
 *  @(#) $Id$
 */

/*
 *		ͥǽɾץ(4)
 *
 *  act_tskiact_tskν֤ȥڴ֤¬뤿Υץ
 *  ࡥʲ3Ĥλ֤¬ꤹ롥
 *
 *  (1) ڴ򵯤ʤact_tskν֡ͥ
 *      㤤Фact_tskȯԤٻ߾֤¹ԤǤ
 *      ܤλ֡
 *
 *  (2) ڴ򵯤act_tskν֡ͥ٤ι
 *      Фact_tskȯԤٻ߾֤¹ԤǤ֤
 *      ܤڴ򵯤ơ⤤ͥ٤Υμ¹ԤϤ
 *      ޤǤλ֡
 *
 *  (3) ڴ򵯤iact_tskν֡ϥɥ餫顤¹
 *      ֤Υ⤤ͥ٤ΥФact_tskȯԤ
 *      ߾֤¹ԤǤ֤ܤȤ˼ϥɥ餫꥿
 *      󤷡ڴ򵯤ơ⤤ͥ٤Υμ¹ԤϤޤ
 *      ޤǤλ֡
 */

#include <kernel.h>
#include <t_syslog.h>
#include <test_lib.h>
#include <histogram.h>
#include "kernel_cfg.h"
#include "perf4.h"

/*
 *  ¬ȼ¹ԻʬۤϿ
 */
#define NO_MEASURE	10000U			/* ¬ */
#define MAX_TIME	1000U			/* ¹ԻʬۤϿ */

/*
 *  ¹ԻʬۤϿΰ
 */
static uint_t	histarea1[MAX_TIME + 1];
static uint_t	histarea2[MAX_TIME + 1];
static uint_t	histarea3[MAX_TIME + 1];

/*
 *  ¬1ʹͥ١
 */
void task1(intptr_t exinf)
{
	end_measure(2);
	ext_tsk();
}

/*
 *  ¬2ȥᥤ󥿥ζͭѿ
 */
volatile uint_t		task2_count;

/*
 *  ¬2ʹͥ١
 */
void task2(intptr_t exinf)
{
	end_measure(3);
	task2_count++;
	ext_tsk();
}

/*
 *  ¬3ͥ١
 */
void task3(intptr_t exinf)
{
	ext_tsk();
}

/*
 *  ¬4ʺͥ١
 */
void task4(intptr_t exinf)
{
	while (true) {
		wup_tsk(MAIN_TASK);
	}
}

/*
 *  ϥɥ
 */
void cyclic_handler(intptr_t exinf)
{
	begin_measure(3);
	iact_tsk(TASK2);
}

/*
 *  ᥤ󥿥ͥ١
 */
void main_task(intptr_t exinf)
{
	uint_t	i;

	syslog_0(LOG_NOTICE, "Performance evaluation program (4)");
	init_hist(1, MAX_TIME, histarea1);
	init_hist(2, MAX_TIME, histarea2);
	init_hist(3, MAX_TIME, histarea3);
	syslog_flush();

	/*
	 *  ڴ򵯤ʤact_tskν֤¬
	 */
	for (i = 0; i < NO_MEASURE; i++) {
		begin_measure(1);
		act_tsk(TASK3);
		end_measure(1);
		slp_tsk();
	}

	/*
	 *  ڴ򵯤act_tskν֤¬
	 */
	for (i = 0; i < NO_MEASURE; i++) {
		begin_measure(2);
		act_tsk(TASK1);
	}

	/*
	 *  ڴ򵯤iact_tskν֤¬¬10ʬ1
	 */
	task2_count = 0;
	sta_cyc(CYC1);
	while (task2_count < NO_MEASURE / 10) ;
	stp_cyc(CYC1);

	syslog_0(LOG_NOTICE, "Execution times of act_tsk without task switch");
	print_hist(1);
	syslog_0(LOG_NOTICE, "Execution times of act_tsk with task switch");
	print_hist(2);
	syslog_0(LOG_NOTICE, "Execution times of iact_tsk with task switch");
	print_hist(3);
	test_finish();
}
