/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005-2010 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ(1)(4)ξ˸¤ꡤܥեȥ
 *  ܥեȥѤΤޤࡥʲƱˤѡʣ
 *  ѡۡʰʲѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *      ޤܥեȥΥ桼ޤϥɥ桼Τʤ
 *      ͳ˴Ťᤫ⡤嵭ԤTOPPERSץȤ
 *      դ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơλŪ
 *  ФŬޤơʤݾڤԤʤޤܥեȥ
 *  ѤˤľŪޤϴŪʤ»˴ؤƤ⡤
 *  Ǥʤ
 * 
 *  @(#) $Id$
 */

/*
 *		ޥɥ饤СMac OS Xѡ
 */

#ifndef TOPPERS_TARGET_TIMER_H
#define TOPPERS_TARGET_TIMER_H

#include <sil.h>
#include "macosx.h"
#ifndef TOPPERS_MACRO_ONLY
#include <sys/time.h>
#endif /* TOPPERS_MACRO_ONLY */

/*
 *  ޳ߥϥɥϿΤ
 */
#define INHNO_TIMER		SIGALRM				/* ߥϥɥֹ */
#define INTNO_TIMER		SIGALRM				/* ֹ */
#define INTPRI_TIMER	(TMAX_INTPRI - 1)	/* ͥ */
#define INTATR_TIMER	TA_EDGE				/* ° */

#ifndef TOPPERS_MACRO_ONLY

/*
 *  ͤɽη
 */
typedef uint32_t	CLOCK;

/*
 *  ͤɽȥߥáޥñ̤ȤѴ
 *
 *  Mac OS XǤϡ󥿡Х륿ޤ1ޥ˥ȥåפ롥
 */
#define TIMER_CLOCK				1000U
#define TO_CLOCK(nume, deno)	((CLOCK)(TIMER_CLOCK * (nume) / (deno)))
#define TO_USEC(clock)			((SYSUTM) clock)

/*
 *  ǤΥ޼ñ̤ɽ
 */
#define MAX_CLOCK		((CLOCK) 999999U)

/*
 *  ޤεư
 *
 *  ޤŪʥ޳׵ȯ롥
 */
extern void	target_timer_initialize(intptr_t exinf);

/*
 *  ޤ߽
 *
 *  ޤưߤ롥
 */
extern void	target_timer_terminate(intptr_t exinf);

/*
 *  ޤθͤɽФ
 */
extern CLOCK target_timer_get_current(void);

/*
 *  ޳׵Υå
 */
extern bool_t target_timer_probe_int(void);

#ifdef TOPPERS_SUPPORT_OVRHDR

/*
 *  Х󥿥ޤν
 */
extern void target_ovrtimer_initialize(intptr_t exinf);

/*
 *  Х󥿥ޤ߽
 */
extern void target_ovrtimer_terminate(intptr_t exinf);

/*
 *  Х󥿥ޤư
 */
extern void target_ovrtimer_start(OVRTIM ovrtim);

/*
 *  Х󥿥ޤ
 */
extern OVRTIM target_ovrtimer_stop(void);

/*
 *  Х󥿥ޤθͤɽФ
 */
extern OVRTIM target_ovrtimer_get_current(void);

#endif /* TOPPERS_SUPPORT_OVRHDR */

/*
 *  ޳ߥϥɥ
 */
extern void	target_timer_handler(void);

#endif /* TOPPERS_MACRO_ONLY */
#endif /* TOPPERS_TARGET_TIMER_H */
