/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2005,2006 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ(1)(4)ξ˸¤ꡤܥեȥ
 *  ܥեȥѤΤޤࡥʲƱˤѡʣ
 *  ѡۡʰʲѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *      ޤܥեȥΥ桼ޤϥɥ桼Τʤ
 *      ͳ˴Ťᤫ⡤嵭ԤTOPPERSץȤ
 *      դ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơλŪ
 *  ФŬޤơʤݾڤԤʤޤܥեȥ
 *  ѤˤľŪޤϴŪʤ»˴ؤƤ⡤
 *  Ǥʤ
 * 
 *  @(#) $Id$
 */

/*
 *		ޥɥ饤СDVE68K/40ѡ
 */

#include "kernel_impl.h"
#include "time_event.h"
#include <sil.h>
#include "target_timer.h"

/*
 *  ޤεư
 */
void
target_timer_initialize(intptr_t exinf)
{
	CLOCK	cyc = TO_CLOCK(TIC_NUME, TIC_DENO);

	/*
	 *  ޼ꤷޤư򳫻Ϥ롥
	 */
	assert(cyc <= MAX_CLOCK);
	dga_write((void *) TADR_DGA_CSR12, CSR12_START | cyc);

	/*
	 *  ޳׵򥯥ꥢ롥
	 */
	x_clear_int(INTNO_TIMER);
}

/*
 *  ޤ߽
 */
void
target_timer_terminate(intptr_t exinf)
{
	/*
	 *  ޤưߤ롥
	 */
	dga_write((void *) TADR_DGA_CSR12, CSR12_STOP);
}

/*
 *  ޳ߥϥɥ
 */
void
target_timer_handler(void)
{
	i_begin_int(INTNO_TIMER);
	signal_time();					/* ƥåζ */
	i_end_int(INTNO_TIMER);
}
