/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005-2011 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ(1)(4)ξ˸¤ꡤܥեȥ
 *  ܥեȥѤΤޤࡥʲƱˤѡʣ
 *  ѡۡʰʲѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *      ޤܥեȥΥ桼ޤϥɥ桼Τʤ
 *      ͳ˴Ťᤫ⡤嵭ԤTOPPERSץȤ
 *      դ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơλŪ
 *  ФŬޤơʤݾڤԤʤޤܥեȥ
 *  ѤˤľŪޤϴŪʤ»˴ؤƤ⡤
 *  Ǥʤ
 * 
 *  @(#) $Id$
 */

/*
 *		ꥢI/OǥХSIO˥ɥ饤СDVE68K/40ѡ
 */

#include <kernel.h>
#include <t_syslog.h>
#include "dve68k.h"
#include "pdic/upd72001/upd72001.h"
#include "target_serial.h"

/*
 *  SIOɥ饤Фν
 */
void
sio_initialize(intptr_t exinf)
{
	upd72001_initialize();
}

/*
 *  ꥢI/OݡȤΥץ
 */
SIOPCB *
sio_opn_por(ID siopid, intptr_t exinf)
{
	SIOPCB	*p_siopcb;
	bool_t	opnflg;
	ER		ercd;

	/*
	 *  ץ󤷤ݡȤ뤫opnflgɤǤ
	 */
	opnflg = upd72001_openflag();

	/*
	 *  ǥХ¸Υץ
	 */
	p_siopcb = upd72001_opn_por(siopid, exinf);

	/*
	 *  ꥢI/OߤΥޥ롥
	 */
	if (!opnflg) {
		ercd = ena_int(INTNO_SIO);
		assert(ercd == E_OK);
	}
	return(p_siopcb);
}

/*
 *  ꥢI/OݡȤΥ
 */
void
sio_cls_por(SIOPCB *p_siopcb)
{
	ER		ercd;

	/*
	 *  ǥХ¸Υ
	 */
	upd72001_cls_por(p_siopcb);

	/*
	 *  ꥢI/Oߤޥ롥
	 */
	if (!upd72001_openflag()) {
		ercd = dis_int(INTNO_SIO);
		assert(ercd == E_OK);
	}
}

/*
 *  SIOγߥӥ롼
 */
void
sio_isr(intptr_t exinf)
{
	upd72001_isr();
}

/*
 *  ꥢI/OݡȤؤʸ
 */
bool_t
sio_snd_chr(SIOPCB *siopcb, char c)
{
	return(upd72001_snd_chr(siopcb, c));
}

/*
 *  ꥢI/OݡȤʸ
 */
int_t
sio_rcv_chr(SIOPCB *siopcb)
{
	return(upd72001_rcv_chr(siopcb));
}

/*
 *  ꥢI/OݡȤΥХåε
 */
void
sio_ena_cbr(SIOPCB *siopcb, uint_t cbrtn)
{
	upd72001_ena_cbr(siopcb, cbrtn);
}

/*
 *  ꥢI/OݡȤΥХåζػ
 */
void
sio_dis_cbr(SIOPCB *siopcb, uint_t cbrtn)
{
	upd72001_dis_cbr(siopcb, cbrtn);
}

/*
 *  ꥢI/OݡȤǽХå
 */
void
upd72001_irdy_snd(intptr_t exinf)
{
	sio_irdy_snd(exinf);
}

/*
 *  ꥢI/OݡȤμΥХå
 */
void
upd72001_irdy_rcv(intptr_t exinf)
{
	sio_irdy_rcv(exinf);
}
