/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005-2011 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ(1)(4)ξ˸¤ꡤܥեȥ
 *  ܥեȥѤΤޤࡥʲƱˤѡʣ
 *  ѡۡʰʲѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *      ޤܥեȥΥ桼ޤϥɥ桼Τʤ
 *      ͳ˴Ťᤫ⡤嵭ԤTOPPERSץȤ
 *      դ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơλŪ
 *  ФŬޤơʤݾڤԤʤޤܥեȥ
 *  ѤˤľŪޤϴŪʤ»˴ؤƤ⡤
 *  Ǥʤ
 * 
 *  @(#) $Id$
 */

/*
 *		åȰ¸⥸塼DVE68K/40ѡ
 */

#include "kernel_impl.h"
#include <sil.h>

/*
 *  ץå̤Τѿʥޥץåб
 */
uint_t	board_id;			/* ܡID */
void	*board_addr;		/* Ƭɥ쥹 */

/*
 *  åȰ¸ν
 */
void
target_initialize(void)
{
	/*
	 *  ץå¸ν
	 */
	prc_initialize();

	/*
	 *  ץå̤Τѿν
	 */
	board_id = ((uint_t)(sil_rew_mem((void *) TADR_BOARD_REG0)) & 0x1fU);
	board_addr = (void *)(board_id << 24);

	/*
	 *  ߴϢν
	 *
	 *  °ꤵƤ뤫Ƚ̤뤿ѿ롥
	 *  ޤ٤Ƥγߤޥꥢߥ٥ȥꤹ
	 *  롥
	 */
	dga_write((void *) TADR_DGA_CSR21, 0U);
	dga_write((void *) TADR_DGA_CSR23, ~0U);
	dga_write((void *) TADR_DGA_CSR19, (TVEC_G0I << 24) | (TVEC_G1I << 16)
										| (TVEC_SWI << 8) | TVEC_SPRI);

	/*
	 *  ܡȳߤNMI
	 *
	 *  ܡȳߤ򥨥åȥꥬߥ٥NMIꤷޥ
	 *  롥
	 */
	x_config_int(TINTNO_ABT, TA_EDGE, TIRQ_NMI);

	/*
	 *  ΰ
	 *
	 *  VMEХǤƬɥ쥹ȥ16MBˤ
	 *  դ褦ꤹ롥ޤVMEХĥɥ쥹
	 *  դ褦ˤꤹ롥
	 */
	dga_write((void *) TADR_DGA_CSR4, (uint32_t) board_addr | 0x00ffU);
	dga_write((void *) TADR_DGA_CSR5, 0x0000012fU);

	/*
	 *  󥿥ե쥸IFRˤ
	 *
	 *  󥿥ե쥸Υ١ɥ쥹ꤹ롥ޤ
	 *  ե쥸0Υӥꥯȥե饰򥯥ꥢ󥿥ե
	 *  쥸3˥ܡɤIDֹꡥ
	 */
	dga_write((void *) TADR_DGA_CSR3, (board_id << 4) | 0x3U);
	dga_write((void *) TADR_DGA_IFR0, 0x80000000U);
	dga_write((void *) TADR_DGA_IFR3, board_id);

	/*
	 *  饦ɥӥ⡼ɤʥޥץåб
	 */
	dga_write((void *) TADR_DGA_CSR1,
						(dga_read((void *) TADR_DGA_CSR1) & 0xffeffcffU)
									| (1U << 20) | ((board_id % 4) << 8));
}

/*
 *  åȰ¸νλ
 */
void
target_exit(void)
{
	/*
	 *  ץå¸νλ
	 */
	prc_terminate();

	/*
	 *  ٤Ƥγߤޥꥢ롥
	 */
	dga_write((void *) TADR_DGA_CSR21, 0U);
	dga_write((void *) TADR_DGA_CSR23, ~0U);

	/*
	 *  ȯĶ¸νλ
	 */
	dve68k_exit();
}

/*
 *  ƥ٥ϤΤʸ
 */
void
target_fput_log(char c)
{
	if (c == '\n') {
		dve68k_putc('\r');
	}
	dve68k_putc(c);
}

/*
 *  ׵饤°
 *
 *  ASPͥǤѤꤷơѥ᡼顼ϥǥ
 *  Ƥ롥cfg_intӥߤˤϡ顼֤褦
 *  ˤ٤Ǥ
 */
void
x_config_int(INTNO intno, ATR intatr, PRI intpri)
{
	uint32_t	bitpat = DGA_INT_BITPAT(intno);

	assert(VALID_INTNO_CFGINT(intno));
	assert(TIRQ_NMI <= intpri && intpri <= TIRQ_LEVEL1);

	/*
	 *  ߤΥޥ
	 *
	 *  ߤդޤޡ٥ȥꥬåȥꥬ䡤
	 *  ͥ٤ԤΤϴʤᡤ°ˤ餺
	 *  öޥ롥
	 */
	(void) x_disable_int(intno);

	/*
	 *  ٥ȥꥬåȥꥬ
	 */
	if ((bitpat & DGA_INT_TRG_CONF) != 0U) {
		/*
		 *  ˤǤ
		 */
		if ((intatr & TA_EDGE) != 0U) {
			dga_bit_or((void *) TADR_DGA_CSR18, (1U << (24 - (intno))));
			x_clear_int(intno);
		}
		else {
			dga_bit_and((void *) TADR_DGA_CSR18, ~(1U << (24 - (intno))));
		}
	}
	else if ((bitpat & DGA_INT_TRG_EDGE) != 0U) {
		/*
		 *  åȥꥬ˸ꤵƤ
		 */
		assert((intatr & TA_EDGE) != 0U);
		x_clear_int(intno);
	}
	else {
		/*
		 *  ٥ȥꥬ˸ꤵƤ
		 */
		assert((intatr & TA_EDGE) == 0U);
	}

	/*
	 *  ͥ٤
	 */
	dga_set_ilv((void *)(TADR_DGA_CSR24 + (intno - 1) / 8 * 4),
				(uint_t)(((32 - intno) % 8) * 4), (uint_t)(7 + intpri));

	/*
	 *  ߤΥޥɬפʾ
 	 */
	if ((intatr & TA_ENAINT) != 0U) {
		(void) x_enable_int(intno);
	}
}
