/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2000 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005-2011 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ(1)(4)ξ˸¤ꡤܥեȥ
 *  ܥեȥѤΤޤࡥʲƱˤѡʣ
 *  ѡۡʰʲѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *      ޤܥեȥΥ桼ޤϥɥ桼Τʤ
 *      ͳ˴Ťᤫ⡤嵭ԤTOPPERSץȤ
 *      դ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơλŪ
 *  ФŬޤơʤݾڤԤʤޤܥեȥ
 *  ѤˤľŪޤϴŪʤ»˴ؤƤ⡤
 *  Ǥʤ
 * 
 *  @(#) $Id$
 */

/*
 *		Ԥִ⥸塼
 */

#ifndef TOPPERS_WAIT_H
#define TOPPERS_WAIT_H

#include "task.h"
#include "time_event.h"

/*
 *  ͥٽԤ塼ؤ
 *
 *  p_tcbǻꤵ륿򡤥ͥٽΥ塼p_queue롥
 *  塼Ʊͥ٤ΥˤϡκǸ롥
 */
Inline void
queue_insert_tpri(QUEUE *p_queue, TCB *p_tcb)
{
	QUEUE	*p_entry;
	uint_t	pri = p_tcb->priority;

	for (p_entry = p_queue->p_next; p_entry != p_queue;
										p_entry = p_entry->p_next) {
		if (pri < ((TCB *) p_entry)->priority) {
			break;
		}
	}
	queue_insert_prev(p_entry, &(p_tcb->task_queue));
}

/*
 *  Ԥ֤ؤ
 *
 *  ¹ΥԤ֤ܤ롥Ūˤϡ¹Υ
 *  ǥ塼TCBp_winfoեɡWINFOp_tmevtbե
 *  ɤꤹ롥
 */
Inline void
make_wait(WINFO *p_winfo)
{
	(void) make_non_runnable(p_runtsk);
	p_runtsk->p_winfo = p_winfo;
	p_winfo->p_tmevtb = NULL;
}

/*
 *  Ԥ֤ؤܡʥॢȻ
 *
 *  ¹Υ򡤥ॢȻդԤ֤ܤ롥
 *  Ūˤϡ¹Υǥ塼TCBp_winfoե
 *  ɡWINFOp_tmevtbեɤꤹ롥ޤ।٥ȥ
 *  åϿ롥
 */
extern void	make_wait_tmout(WINFO *p_winfo, TMEVTB *p_tmevtb, TMO tmout);

/*
 *  ԤΤΥ֤ι
 *
 *  p_tcbǻꤵ륿Ԥ褦֤򹹿롥
 *  Ԥ륿¹ԤǤ֤ˤʤϡǥ塼ˤĤ
 *  ޤǥѥåɬפʾˤtrue֤
 */
Inline bool_t
make_non_wait(TCB *p_tcb)
{
	assert(TSTAT_WAITING(p_tcb->tstat));

	if (!TSTAT_SUSPENDED(p_tcb->tstat)) {
		/*
		 *  Ԥ֤¹ԤǤ֤ؤ
		 */
		p_tcb->tstat = TS_RUNNABLE;
		LOG_TSKSTAT(p_tcb);
		return(make_runnable(p_tcb));
	}
	else {
		/*
		 *  Ԥ֤鶯Ԥ֤ؤ
		 */
		p_tcb->tstat = TS_SUSPENDED;
		LOG_TSKSTAT(p_tcb);
		return(false);
	}
}

/*
 *  ֥Ԥ塼κ
 *
 *  p_tcbǻꤵ륿Ʊ֥̿ȤԤ塼ˤ
 *  ʤƤСԤ塼롥
 */
Inline void
wait_dequeue_wobj(TCB *p_tcb)
{
	if (TSTAT_WAIT_WOBJ(p_tcb->tstat)) {
		queue_delete(&(p_tcb->task_queue));
	}
}

/*
 *  ԤΤΥ।٥ȥ֥åϿ
 *
 *  p_tcbǻꤵ륿ФơԤΤΥ।٥ȥ
 *  åϿƤСϿ롥
 */
Inline void
wait_dequeue_tmevtb(TCB *p_tcb)
{
	if (p_tcb->p_winfo->p_tmevtb != NULL) {
		tmevtb_dequeue(p_tcb->p_winfo->p_tmevtb);
	}
}

/*
 *  Ԥ
 *
 *  p_tcbǻꤵ륿Ԥ֤롥Ūˤϡ।
 *  ٥ȥ֥åϿƤСϿ롥ޤ
 *  ֤򹹿ԤͤE_OKȤ롥Ԥ塼
 *  κϹԤʤԤؤΥǥѥåɬפʾ
 *  ˤtrue֤
 */
extern bool_t	wait_complete(TCB *p_tcb);

/*
 *  ॢȤȼԤ
 *
 *  p_tcbǻꤵ륿Ԥ塼ˤĤʤƤԤ塼
 *  ֤򹹿롥ޤԤ
 *  ͤwait_tmoutǤE_TMOUTwait_tmout_okǤE_OKȤ롥Ԥ
 *  ؤΥǥѥåɬפʻϡreqflgtrueˤ롥
 *
 *  wait_tmout_okϡdly_tskǻȤΤΤǡԤ塼
 *  Ԥʤ
 *
 *  δؿ⡤।٥ȤΥХåؿȤѤ뤿
 *  Τǡߥϥɥ餫ƤӽФ뤳ȤꤷƤ롥
 */
extern void	wait_tmout(TCB *p_tcb);
extern void	wait_tmout_ok(TCB *p_tcb);

/*
 *  Ԥ֤ζ
 *
 *  p_tcbǻꤵ륿Ԥ֤Ū˲롥Ūˤϡ
 *  Ԥ塼ˤĤʤƤԤ塼।
 *  ٥ȥ֥åϿƤФϿ롥ޤ
 *  ֤򹹿ԤͤE_RLWAIȤ롥ޤ
 *  ԤؤΥǥѥåɬפʾˤtrue֤
 */
extern bool_t	wait_release(TCB *p_tcb);

/*
 *  Ԥ塼ƬΥID
 *
 *  p_wait_queueǻꤷԤ塼ƬΥID֤Ԥ塼
 *  ξˤϡTSK_NONE֤
 */
Inline ID
wait_tskid(QUEUE *p_wait_queue)
{
	if (!queue_empty(p_wait_queue)) {
		return(TSKID((TCB *) p_wait_queue->p_next));
	}
	else {
		return(TSK_NONE);
	}
}

/*
 *  Ʊ֥̿Ȥδ֥åζʬ롼
 *
 *  Ʊ֥̿Ȥν֥åȴ֥åƬʬ϶
 *  ̤ˤʤäƤ롥ʲϡζʬ򰷤ηӥ롼
 *  Ǥ롥
 *
 *  ʣԤ塼Ʊ֥̿Ȥξ硤ƬʳԤ
 *  塼ˤϡΥ롼ϻȤʤޤ֥
 *  °TA_TPRIӥåȤ򻲾ȤΤǡΥӥåȤ¾Ū˻Ȥä
 *  ⡤Υ롼ϻȤʤ
 */

/*
 *  Ʊ֥̿Ȥν֥åζʬ
 */
typedef struct wait_object_initialization_block {
	ATR			wobjatr;		/* ֥° */
} WOBJINIB;

/*
 *  Ʊ֥̿Ȥδ֥åζʬ
 */
typedef struct wait_object_control_block {
	QUEUE		wait_queue;		/* Ԥ塼 */
	const WOBJINIB *p_wobjinib;	/* ֥åؤΥݥ */
} WOBJCB;

/*
 *  Ʊ֥̿ȤԤ֥åζʬ
 *
 *  ι¤ΤϡԤ֥åWINFOˤĥʥ֥Ȼظ
 *  ηѾˤΤǤ뤬WINFOΤƤ뤿
 *  ˡ1ĤΥեɤȤƴޤƤ롥
 */
typedef struct wait_object_waiting_information {
	WINFO	winfo;			/* ɸԤ֥å */
	WOBJCB	*p_wobjcb;		/* Ԥ֥Ȥδ֥å */
} WINFO_WOBJ;

/*
 *  Ʊ֥̿ȤФԤ֤ؤ
 *  
 *  ¹ΥԤ֤ܤƱ֥̿ȤԤ塼
 *  ˤĤʤޤԤ֥åWINFOˤp_wobjcbꤹ롥
 *  wobj_make_wait_tmoutϡ।٥ȥ֥åϿԤ
 */
extern void	wobj_make_wait(WOBJCB *p_wobjcb, WINFO_WOBJ *p_winfo);
extern void	wobj_make_wait_tmout(WOBJCB *p_wobjcb, WINFO_WOBJ *p_winfo,
											TMEVTB *p_tmevtb, TMO tmout);

/*
 *  ͥѹν
 *
 *  Ʊ֥̿ȤФԤ֤ˤ륿ͥ٤ѹ
 *  줿ˡԤ塼ǤΥΰ֤롥
 */
Inline void
wobj_change_priority(WOBJCB *p_wobjcb, TCB *p_tcb)
{
	if ((p_wobjcb->p_wobjinib->wobjatr & TA_TPRI) != 0U) {
		queue_delete(&(p_tcb->task_queue));
		queue_insert_tpri(&(p_wobjcb->wait_queue), p_tcb);
	}
}

/*
 *  Ԥ塼ν
 *
 *  Ԥ塼ˤĤʤƤ륿򤹤٤Ԥ롥Ԥ
 *  ͤϡE_DLTȤ롥ԤؤΥǥѥå
 *  ɬפʾtrueǤʤfalse֤
 */
extern bool_t	init_wait_queue(QUEUE *p_wait_queue);

#endif /* TOPPERS_WAIT_H */
