/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2000 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005-2011 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ(1)(4)ξ˸¤ꡤܥեȥ
 *  ܥեȥѤΤޤࡥʲƱˤѡʣ
 *  ѡۡʰʲѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *      ޤܥեȥΥ桼ޤϥɥ桼Τʤ
 *      ͳ˴Ťᤫ⡤嵭ԤTOPPERSץȤ
 *      դ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơλŪ
 *  ФŬޤơʤݾڤԤʤޤܥեȥ
 *  ѤˤľŪޤϴŪʤ»˴ؤƤ⡤
 *  Ǥʤ
 * 
 *  @(#) $Id$
 */

/*
 *		᡼ܥåǽ
 */

#ifndef TOPPERS_MAILBOX_H
#define TOPPERS_MAILBOX_H

#include "wait.h"

/*
 *  ᡼ܥå֥å
 *
 *  ι¤ΤϡƱ֥̿Ȥν֥åζʬ
 *  WOBJINIBˤĥʥ֥ȻظηѾˤΤǡ
 *  ǽΥեɤ̤ˤʤäƤ롥
 */
typedef struct mailbox_initialization_block {
	ATR			mbxatr;			/* ᡼ܥå° */
	PRI			maxmpri;		/* åͥ٤κ */
} MBXINIB;

/*
 *  ᡼ܥå֥å
 *
 *  ι¤ΤϡƱ֥̿Ȥδ֥åζʬWOBJCB
 *  ĥʥ֥ȻظηѾˤΤǡǽ2Ĥ
 *  եɤ̤ˤʤäƤ롥
 *
 *  å塼åͥٽξˤϡpk_lastϻȤ
 *  ޤå塼ξpk_headNULLξˤˤ⡤
 *  pk_last̵Ǥ롥
 */
typedef struct mailbox_control_block {
	QUEUE		wait_queue;		/* ᡼ܥåԤ塼 */
	const MBXINIB *p_mbxinib;	/* ֥åؤΥݥ */
	T_MSG		*pk_head;		/* ƬΥå */
	T_MSG		*pk_last;		/* Υå */
} MBXCB;

/*
 *  ᡼ܥåԤ֥å
 *
 *  ι¤ΤϡƱ֥̿ȤԤ֥åζʬ
 *  WINFO_WOBJˤĥʥ֥ȻظηѾˤΤǡ
 *  ǽ2ĤΥեɤ̤ˤʤäƤ롥
 */
typedef struct mailbox_waiting_information {
	WINFO		winfo;			/* ɸԤ֥å */
	MBXCB		*p_mbxcb;		/* ԤäƤ᡼ܥåδ֥å */
	T_MSG		*pk_msg;		/* å */
} WINFO_MBX;

/*
 *  ᡼ܥåIDκ͡kernel_cfg.c
 */
extern const ID	tmax_mbxid;

/*
 *  ᡼ܥå֥åΥꥢkernel_cfg.c
 */
extern const MBXINIB	mbxinib_table[];

/*
 *  ᡼ܥå֥åΥꥢkernel_cfg.c
 */
extern MBXCB	mbxcb_table[];

/*
 *  ᡼ܥå֥å᡼ܥåIDФΥޥ
 */
#define	MBXID(p_mbxcb)	((ID)(((p_mbxcb) - mbxcb_table) + TMIN_MBXID))

/*
 *  ᡼ܥåǽν
 */
extern void	initialize_mailbox(void);

#endif /* TOPPERS_MAILBOX_H */
