$ ======================================================================
$ 
$   TOPPERS/ASP Kernel
$       Toyohashi Open Platform for Embedded Real-Time Systems/
$       Advanced Standard Profile Kernel
$ 
$   Copyright (C) 2011 by Embedded and Real-Time Systems Laboratory
$               Graduate School of Information Science, Nagoya Univ., JAPAN
$  
$   嵭Ԥϡʲ(1)(4)ξ˸¤ꡤܥեȥ
$   ܥեȥѤΤޤࡥʲƱˤѡʣ
$   ѡۡʰʲѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
$   (1) ܥեȥ򥽡ɤηѤˤϡ嵭
$       ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
$       ˴ޤޤƤ뤳ȡ
$   (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
$       ѤǤǺۤˤϡۤȼɥȡ
$       ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
$       ̵ݾڵǺܤ뤳ȡ
$   (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
$       ѤǤʤǺۤˤϡΤ줫ξ
$       ȡ
$     (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
$         ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
$     (b) ۤη֤̤ˡˤäơTOPPERSץȤ
$         𤹤뤳ȡ
$   (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
$       ⡤嵭ԤTOPPERSץȤդ뤳ȡ
$       ޤܥեȥΥ桼ޤϥɥ桼Τʤ
$       ͳ˴Ťᤫ⡤嵭ԤTOPPERSץȤ
$       դ뤳ȡ
$  
$   ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
$   TOPPERSץȤϡܥեȥ˴ؤơλŪ
$   ФŬޤơʤݾڤԤʤޤܥեȥ
$   ѤˤľŪޤϴŪʤ»˴ؤƤ⡤
$   Ǥʤ
$ 
$   $Id$
$ 
$ =====================================================================

$ 
$  #defineǥ쥯ƥ֤
$ 
$FUNCTION DEFINE$
	#define $ARGV[1]$$TAB$$FORMAT("%d", +ARGV[2])$$NL$
$END$

$ 
$  ӥåȤΥ
$ 
$FUNCTION SEARCH_BIT$
	$_val = ARGV[1]$
	$FOREACH _val_bit RANGE(0,7)$
		$IF (_val & 1) != 0$
			$RESULT = _val_bit$
		$END$
		$_val = _val >> 1$
	$END$
$END$

$ 
$  ӥåȥեɤΥեåȤȥӥåȰ֤
$ 
$FUNCTION DEFINE_BIT$
	$label = ARGV[1]$
	$struct_size = ARGV[2]$
	$output_size = ARGV[3]$

	$top = SYMBOL(label)$
	$IF !LENGTH(top)$
		$ERROR$$FORMAT("label %1% not found", label)$$END$
	$ELSE$
		$val = 0$
		$FOREACH i RANGE(0,struct_size-1)$
			$tmp_val = PEEK(top + i, 1)$
			$IF val == 0 && tmp_val != 0$
				$val = tmp_val$
				$offset = i$
			$END$
		$END$

		$IF val == 0$
			$ERROR$$FORMAT("bit not found in %1%", ARGV[1])$$END$
		$ELSE$
			$val_bit = SEARCH_BIT(val)$
			$RESULT = {}$
			$IF EQ(output_size, "W")$
				$IF SIL_ENDIAN_BIG$
					$val_bit = val_bit + 24 - ((offset & 0x03) << 3)$
				$ELSE$
					$val_bit = val_bit + ((offset & 0x03) << 3)$
				$END$
				$offset = offset & ~0x03$
			$ELSE$$IF EQ(output_size, "H")$
				$IF SIL_ENDIAN_BIG$
					$val_bit = val_bit + 8 - ((offset & 0x01) << 3)$
				$ELSE$
					$val_bit = val_bit + ((offset & 0x01) << 3)$
				$END$
				$offset = offset & ~0x01$
			$END$$END$
		$END$

		#define $label$$TAB$$FORMAT("%d", +offset)$$NL$
		#define $label$_bit$TAB$$FORMAT("%d", +val_bit)$$NL$
		#define $label$_mask$TAB$$FORMAT("0x%x", 1 << val_bit)$$NL$
	$END$
$END$

$ 
$  Х֤Υå
$ 
$FUNCTION MAGIC_CHECK$
	$size = ARGV[1]$
	$check = ARGV[2]$

	$label = FORMAT("MAGIC_%d", +size)$
	$top = SYMBOL(label)$
	$IF !LENGTH(top)$
		$ERROR$$FORMAT("label %1% not found", label)$$END$
	$ELSE$
		$FOREACH offset RANGE(1,size)$
			$IF SIL_ENDIAN_BIG$
				$val = PEEK(top + offset - 1, 1)$
			$ELSE$
				$val = PEEK(top + size - offset, 1)$
			$END$
			$IF val != AT(check, offset - 1)$
				$ERROR$$FORMAT("value check of %1% failed", label)$$END$
			$END$
		$END$
	$END$
$END$

$MAGIC_CHECK(1, { 0x12 })$
$MAGIC_CHECK(2, { 0x12, 0x34 })$
$MAGIC_CHECK(4, { 0x12, 0x34, 0x56, 0x78 })$

$ 
$  եإå
$ 
$FILE "offset.h"$
/* offset.h */$NL$
$NL$
