/*
 *  TOPPERS Software
 *      Toyohashi Open Platform for Embedded Real-Time Systems
 * 
 *  Copyright (C) 2014 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ(1)(4)ξ˸¤ꡤܥեȥ
 *  ܥեȥѤΤޤࡥʲƱˤѡʣ
 *  ѡۡʰʲѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *      ޤܥեȥΥ桼ޤϥɥ桼Τʤ
 *      ͳ˴Ťᤫ⡤嵭ԤTOPPERSץȤ
 *      դ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơλŪ
 *  ФŬޤơʤݾڤԤʤޤܥեȥ
 *  ѤˤľŪޤϴŪʤ»˴ؤƤ⡤
 *  Ǥʤ
 * 
 *  $Id$
 */

/* 
 *		åХåեΥƥ(3)
 *
 * ڥƥȤŪ
 *
 *  ͥٽåХåեΡFIFOåХåեȰۤ
 *  뿶񤤤ƥȤ롥
 *
 * ڥƥȹܡ
 *
 *	(A) Ԥ塼ͥ٤Ǥ뤳
 *		(A-1) 夫夷ͥ٥ˤĤʤ뤳
 *		(A-2) Ʊͥ٤ΥFIFOǤ뤳
 *	(B) Ԥ塼˥뤿Ԥ֤ˤʤΰ㤤
 *		(B-1) Ԥ塼ξ
 *		(B-2) Ԥ塼㤤ͥ٤ΥΤߤ
 *		(B-3) Ԥ塼Ʊ⤤ͥ٤Υ
 *	(C) Ԥ塼Ƭͥ٤򲼤ƬѤ
 *		(C-1) ԤԤʤ
 *		(C-2) Ԥ1ĤޤʣˤԤʥڴʤ
 *		(C-3) Ԥ1ĤޤʣˤԤʥڴ
 *	(D) Ԥ塼楿ͥ٤夲ƬѤ
 *		(D-1) ԤԤʤ
 *		(D-2) Ԥ1ĤޤʣˤԤʥڴʤ
 *		(D-3) Ԥ1ĤޤʣˤԤʥڴ
 *
 * ڻѥ꥽
 *
 *	TASK1: ͥ٥ᥤ󥿥ǽ餫鵯ư
 *	TASK2: ͥ٥
 *	TASK3: ͥ٥
 *	TASK4: ͥ٥
 *	MBF1: åХåեTA_TPRI°å26
 *		  ХåեΰΥ26ºݤˤ28
 *
 * ڥƥȥ󥹡
 *
 *	== TASK1ͥ١==
 *		call(set_bit_func(bit_kernel))
 *	1:	act_tsk(TASK2)
 *		act_tsk(TASK4)
 *		slp_tsk()
 *	== TASK2ͥ١==
 *	2:	snd_mbf(MBF1, string1, 26)
 *	== TASK4ͥ١==
 *	3:	wup_tsk(TASK1)
 *	== TASK1³==
 *	4:	snd_mbf(MBF1, string2, 25)						... (A-1)
 *	== TASK4³==
 *	5:	ref_mbf(MBF1, &rmbf)
 *		assert(rmbf.stskid == TASK1)
 *		assert(rmbf.rtskid == TSK_NONE)
 *		assert(rmbf.smbfcnt == 0)
 *		rcv_mbf(MBF1, buf1) -> 25
 *	== TASK1³==
 *	6:	assert(strncmp(buf1, string2, 25) == 0)
 *		act_tsk(TASK3)
 *		slp_tsk()
 *	== TASK3ͥ١==
 *	7:	snd_mbf(MBF1, string2, 26)						... (A-2)
 *	== TASK4³==
 *	8:	rcv_mbf(MBF1, buf1) -> 26
 *	== TASK2³==
 *	9:	assert(strncmp(buf1, string1, 26) == 0)
 *		rcv_mbf(MBF1, buf1) -> 26
 *		assert(strncmp(buf1, string2, 26) == 0)
 *	10:	snd_mbf(MBF1, string3, 10)						... (B-1)
 *		rcv_mbf(MBF1, buf1) -> 10
 *		assert(strncmp(buf1, string3, 10) == 0)
 *	11:	snd_mbf(MBF1, string1, 26)
 *	== TASK3³==
 *	12:	wup_tsk(TASK1)
 *	== TASK1³==
 *	13:	snd_mbf(MBF1, string2, 10)						... (B-2)
 *		rcv_mbf(MBF1, buf1) -> 10
 *		assert(strncmp(buf1, string2, 10) == 0)
 *		slp_tsk()
 *	== TASK3³==
 *	14:	snd_mbf(MBF1, string3, 10)						... (B-3)
 *	== TASK4³==
 *	15:	rcv_mbf(MBF1, buf1) -> 26
 *	== TASK2³==
 *	16:	assert(strncmp(buf1, string1, 26) == 0)
 *		rcv_mbf(MBF1, buf1) -> 10
 *		assert(strncmp(buf1, string3, 10) == 0)
 *	17:	snd_mbf(MBF1, string1, 26)
 *	== TASK3³==
 *	18:	snd_mbf(MBF1, string2, 26)
 *	== TASK4³==
 *	19:	chg_pri(TASK2, LOW_PRIORITY)					... (C-1)
 *		rcv_mbf(MBF1, buf1) -> 26
 *	== TASK3³==
 *	20:	assert(strncmp(buf1, string2, 26) == 0)
 *		rcv_mbf(MBF1, buf1) -> 26
 *		assert(strncmp(buf1, string1, 26) == 0)
 *		chg_pri(TASK2, TPRI_INI)						... ᤹
 *	21:	snd_mbf(MBF1, string1, 26)
 *	== TASK2³==
 *	22:	snd_mbf(MBF1, string2, 10)
 *	== TASK4³==
 *	23:	wup_tsk(TASK1)
 *	== TASK1³==
 *	24:	chg_pri(TASK3, LOW_PRIORITY)					... (C-2)
 *		slp_tsk()
 *	== TASK2³==
 *	25:	rcv_mbf(MBF1, buf1) -> 10
 *		assert(strncmp(buf1, string2, 10) == 0)
 *		chg_pri(TASK3, TPRI_INI)						... ᤹
 *	26:	snd_mbf(MBF1, string3, 10)
 *	== TASK4³==
 *	27:	chg_pri(TASK3, LOW_PRIORITY)					... (C-3)
 *	== TASK2³==
 *	28:	rcv_mbf(MBF1, buf1) -> 10
 *		assert(strncmp(buf1, string3, 10) == 0)
 *		chg_pri(TASK3, TPRI_INI)						... ᤹
 *	29:	snd_mbf(MBF1, string1, 26)
 *	== TASK4³==
 *	30:	chg_pri(TASK2, HIGH_PRIORITY)					... (D-1)
 *		rcv_mbf(MBF1, buf1) -> 26
 *	== TASK2³==
 *	31:	assert(strncmp(buf1, string1, 26) == 0)
 *		chg_pri(TSK_SELF, TPRI_INI)						... ᤹
 *	32:	snd_mbf(MBF1, string2, 10)
 *	== TASK4³==
 *	33:	wup_tsk(TASK1)
 *	== TASK1³==
 *	34:	chg_pri(TASK2, HIGH_PRIORITY)					... (D-2)
 *		slp_tsk()
 *	== TASK2³==
 *	35:	rcv_mbf(MBF1, buf1) -> 10
 *		assert(strncmp(buf1, string2, 10) == 0)
 *		chg_pri(TSK_SELF, TPRI_INI)						... ᤹
 *	36:	snd_mbf(MBF1, string3, 10)
 *	== TASK4³==
 *	37:	chg_pri(TASK2, HIGH_PRIORITY)					... (D-3)
 *	== TASK2³==
 *	38:	rcv_mbf(MBF1, buf1) -> 10
 *		assert(strncmp(buf1, string3, 10) == 0)
 *		rcv_mbf(MBF1, buf1) -> 26
 *		assert(strncmp(buf1, string1, 26) == 0)
 *	39:	END
 */

#include <kernel.h>
#include <t_syslog.h>
#include "kernel_cfg.h"
#include "test_lib.h"
#include "test_messagebuf3.h"
#include <string.h>

const char string1[26] = "abcdefghijklmnopqrstuvwxyz";
const char string2[26] = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
const char string3[16] = "0123456789abcdef";

char buf1[26];

extern ER	bit_kernel(void);

/* DO NOT DELETE THIS LINE -- gentest depends on it. */

void
task1(intptr_t exinf)
{
	ER_UINT	ercd;

	test_start(__FILE__);

	set_bit_func(bit_kernel);

	check_point(1);
	ercd = act_tsk(TASK2);
	check_ercd(ercd, E_OK);

	ercd = act_tsk(TASK4);
	check_ercd(ercd, E_OK);

	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(4);
	ercd = snd_mbf(MBF1, string2, 25);
	check_ercd(ercd, E_OK);

	check_point(6);
	check_assert(strncmp(buf1, string2, 25) == 0);

	ercd = act_tsk(TASK3);
	check_ercd(ercd, E_OK);

	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(13);
	ercd = snd_mbf(MBF1, string2, 10);
	check_ercd(ercd, E_OK);

	ercd = rcv_mbf(MBF1, buf1);
	check_ercd(ercd, 10);

	check_assert(strncmp(buf1, string2, 10) == 0);

	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(24);
	ercd = chg_pri(TASK3, LOW_PRIORITY);
	check_ercd(ercd, E_OK);

	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(34);
	ercd = chg_pri(TASK2, HIGH_PRIORITY);
	check_ercd(ercd, E_OK);

	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(0);
}

void
task2(intptr_t exinf)
{
	ER_UINT	ercd;

	check_point(2);
	ercd = snd_mbf(MBF1, string1, 26);
	check_ercd(ercd, E_OK);

	check_point(9);
	check_assert(strncmp(buf1, string1, 26) == 0);

	ercd = rcv_mbf(MBF1, buf1);
	check_ercd(ercd, 26);

	check_assert(strncmp(buf1, string2, 26) == 0);

	check_point(10);
	ercd = snd_mbf(MBF1, string3, 10);
	check_ercd(ercd, E_OK);

	ercd = rcv_mbf(MBF1, buf1);
	check_ercd(ercd, 10);

	check_assert(strncmp(buf1, string3, 10) == 0);

	check_point(11);
	ercd = snd_mbf(MBF1, string1, 26);
	check_ercd(ercd, E_OK);

	check_point(16);
	check_assert(strncmp(buf1, string1, 26) == 0);

	ercd = rcv_mbf(MBF1, buf1);
	check_ercd(ercd, 10);

	check_assert(strncmp(buf1, string3, 10) == 0);

	check_point(17);
	ercd = snd_mbf(MBF1, string1, 26);
	check_ercd(ercd, E_OK);

	check_point(22);
	ercd = snd_mbf(MBF1, string2, 10);
	check_ercd(ercd, E_OK);

	check_point(25);
	ercd = rcv_mbf(MBF1, buf1);
	check_ercd(ercd, 10);

	check_assert(strncmp(buf1, string2, 10) == 0);

	ercd = chg_pri(TASK3, TPRI_INI);
	check_ercd(ercd, E_OK);

	check_point(26);
	ercd = snd_mbf(MBF1, string3, 10);
	check_ercd(ercd, E_OK);

	check_point(28);
	ercd = rcv_mbf(MBF1, buf1);
	check_ercd(ercd, 10);

	check_assert(strncmp(buf1, string3, 10) == 0);

	ercd = chg_pri(TASK3, TPRI_INI);
	check_ercd(ercd, E_OK);

	check_point(29);
	ercd = snd_mbf(MBF1, string1, 26);
	check_ercd(ercd, E_OK);

	check_point(31);
	check_assert(strncmp(buf1, string1, 26) == 0);

	ercd = chg_pri(TSK_SELF, TPRI_INI);
	check_ercd(ercd, E_OK);

	check_point(32);
	ercd = snd_mbf(MBF1, string2, 10);
	check_ercd(ercd, E_OK);

	check_point(35);
	ercd = rcv_mbf(MBF1, buf1);
	check_ercd(ercd, 10);

	check_assert(strncmp(buf1, string2, 10) == 0);

	ercd = chg_pri(TSK_SELF, TPRI_INI);
	check_ercd(ercd, E_OK);

	check_point(36);
	ercd = snd_mbf(MBF1, string3, 10);
	check_ercd(ercd, E_OK);

	check_point(38);
	ercd = rcv_mbf(MBF1, buf1);
	check_ercd(ercd, 10);

	check_assert(strncmp(buf1, string3, 10) == 0);

	ercd = rcv_mbf(MBF1, buf1);
	check_ercd(ercd, 26);

	check_assert(strncmp(buf1, string1, 26) == 0);

	check_finish(39);
	check_point(0);
}

void
task3(intptr_t exinf)
{
	ER_UINT	ercd;

	check_point(7);
	ercd = snd_mbf(MBF1, string2, 26);
	check_ercd(ercd, E_OK);

	check_point(12);
	ercd = wup_tsk(TASK1);
	check_ercd(ercd, E_OK);

	check_point(14);
	ercd = snd_mbf(MBF1, string3, 10);
	check_ercd(ercd, E_OK);

	check_point(18);
	ercd = snd_mbf(MBF1, string2, 26);
	check_ercd(ercd, E_OK);

	check_point(20);
	check_assert(strncmp(buf1, string2, 26) == 0);

	ercd = rcv_mbf(MBF1, buf1);
	check_ercd(ercd, 26);

	check_assert(strncmp(buf1, string1, 26) == 0);

	ercd = chg_pri(TASK2, TPRI_INI);
	check_ercd(ercd, E_OK);

	check_point(21);
	ercd = snd_mbf(MBF1, string1, 26);
	check_ercd(ercd, E_OK);

	check_point(0);
}

void
task4(intptr_t exinf)
{
	ER_UINT	ercd;
	T_RMBF	rmbf;

	check_point(3);
	ercd = wup_tsk(TASK1);
	check_ercd(ercd, E_OK);

	check_point(5);
	ercd = ref_mbf(MBF1, &rmbf);
	check_ercd(ercd, E_OK);

	check_assert(rmbf.stskid == TASK1);

	check_assert(rmbf.rtskid == TSK_NONE);

	check_assert(rmbf.smbfcnt == 0);

	ercd = rcv_mbf(MBF1, buf1);
	check_ercd(ercd, 25);

	check_point(8);
	ercd = rcv_mbf(MBF1, buf1);
	check_ercd(ercd, 26);

	check_point(15);
	ercd = rcv_mbf(MBF1, buf1);
	check_ercd(ercd, 26);

	check_point(19);
	ercd = chg_pri(TASK2, LOW_PRIORITY);
	check_ercd(ercd, E_OK);

	ercd = rcv_mbf(MBF1, buf1);
	check_ercd(ercd, 26);

	check_point(23);
	ercd = wup_tsk(TASK1);
	check_ercd(ercd, E_OK);

	check_point(27);
	ercd = chg_pri(TASK3, LOW_PRIORITY);
	check_ercd(ercd, E_OK);

	check_point(30);
	ercd = chg_pri(TASK2, HIGH_PRIORITY);
	check_ercd(ercd, E_OK);

	ercd = rcv_mbf(MBF1, buf1);
	check_ercd(ercd, 26);

	check_point(33);
	ercd = wup_tsk(TASK1);
	check_ercd(ercd, E_OK);

	check_point(37);
	ercd = chg_pri(TASK2, HIGH_PRIORITY);
	check_ercd(ercd, E_OK);

	check_point(0);
}
