/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005-2014 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ(1)(4)ξ˸¤ꡤܥեȥ
 *  ܥեȥѤΤޤࡥʲƱˤѡʣ
 *  ѡۡʰʲѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *      ޤܥեȥΥ桼ޤϥɥ桼Τʤ
 *      ͳ˴Ťᤫ⡤嵭ԤTOPPERSץȤ
 *      դ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơλŪ
 *  ФŬޤơʤݾڤԤʤޤܥեȥ
 *  ѤˤľŪޤϴŪʤ»˴ؤƤ⡤
 *  Ǥʤ
 * 
 *  $Id$
 */

/*
 *		åХåեǽ
 */

#ifndef TOPPERS_MESSAGEBUF_H
#define TOPPERS_MESSAGEBUF_H

#include "wait.h"

/*
 *  åХåե֥å
 *
 *  ι¤ΤϡƱ֥̿Ȥν֥åζʬ
 *  WOBJINIBˤĥʥ֥ȻظηѾˤΤǡ
 *  ǽΥեɤ̤ˤʤäƤ롥
 */
typedef struct messagebuf_initialization_block {
	ATR			mbfatr;			/* åХåե° */
	uint_t		maxmsz;			/* åκĹ */
	SIZE		mbfsz;			/* åХåեΰΥ */
	void		*mbfmb;			/* åХåեΰƬ */
} MBFINIB;

/*
 *  åХåե֥å
 *
 *  ι¤ΤϡƱ֥̿Ȥδ֥åζʬWOBJCB
 *  ĥʥ֥ȻظηѾˤΤǡǽ2Ĥ
 *  եɤ̤ˤʤäƤ롥
 */
typedef struct messagebuf_control_block {
	QUEUE		swait_queue;	/* åХåեԤ塼 */
	const MBFINIB *p_mbfinib;	/* ֥åؤΥݥ */
	QUEUE		rwait_queue;	/* åХåեԤ塼 */
	SIZE		fmbfsz;			/* ΰΥ */
	SIZE		head;			/* ǽΥåγǼ */
	SIZE		tail;			/* ǸΥåγǼμ */
	uint_t		smbfcnt;		/* ΰ˳ǼƤåο */
} MBFCB;

/*
 *  åХåեԤ֥å
 *
 *  ι¤ΤϡƱ֥̿ȤԤ֥åζʬ
 *  WINFO_WOBJˤĥʥ֥ȻظηѾˤΤǡ
 *  ǽ2ĤΥեɤ̤ˤʤäƤ롥
 *  åХåեؤԤȥåХåեμԤǡ
 *  ƱԤ֥åȤ
 */
typedef struct messagebuf_waiting_information {
	WINFO		winfo;			/* ɸԤ֥å */
	MBFCB		*p_mbfcb;		/* ԤäƤåХåեδ֥å */
	void		*msg;			/* å */
	uint_t		msgsz;			/* å */
} WINFO_MBF;

/*
 *  åХåեIDκ͡kernel_cfg.c
 */
extern const ID	tmax_mbfid;

/*
 *  åХåե֥åΥꥢkernel_cfg.c
 */
extern const MBFINIB	mbfinib_table[];

/*
 *  åХåե֥åΥꥢkernel_cfg.c
 */
extern MBFCB	mbfcb_table[];

/*
 *  åХåե֥ååХåեIDФ
 *  Υޥ
 */
#define	MBFID(p_mbfcb)	((ID)(((p_mbfcb) - mbfcb_table) + TMIN_MBFID))

/*
 *  åХåեǽν
 */
extern void	initialize_messagebuf(void);

/*
 *  åХåեΰؤΥåγǼ
 */
extern bool_t	enqueue_message(MBFCB *p_mbfcb, const void *msg, uint_t msgsz);

/*
 *  åХåեΰ褫ΥåμФ
 */
extern uint_t	dequeue_message(MBFCB *p_mbfcb, void *msg);

/*
 *  åХåեؤΥå
 */
extern bool_t	send_message(MBFCB *p_mbfcb, const void *msg,
											uint_t msgsz, bool_t *p_dspreq);

/*
 *  åХåեԤΥå
 */
extern bool_t	messagebuf_signal(MBFCB *p_mbfcb);

/*
 *  åХåեΥå
 */
extern uint_t	receive_message(MBFCB *p_mbfcb, void *msg, bool_t *p_dspreq);

/*
 *  åХåեԤԤ
 */
extern bool_t	(*mbfhook_dequeue_wobj)(TCB *p_tcb);
extern bool_t	messagebuf_dequeue_wobj(TCB *p_tcb);

/*
 *  åХåեԤͥѹ
 */
extern bool_t	(*mbfhook_change_priority)(WOBJCB *p_wobjcb);
extern bool_t	messagebuf_change_priority(WOBJCB *p_wobjcb);

#endif /* TOPPERS_MESSAGEBUF_H */
