$ ======================================================================
$ 
$   TOPPERS/ASP Kernel
$       Toyohashi Open Platform for Embedded Real-Time Systems/
$       Advanced Standard Profile Kernel
$ 
$   Copyright (C) 2007 by TAKAGI Nobuhisa
$   Copyright (C) 2007-2015 by Embedded and Real-Time Systems Laboratory
$               Graduate School of Information Science, Nagoya Univ., JAPAN
$  
$   嵭Ԥϡʲ(1)(4)ξ˸¤ꡤܥեȥ
$   ܥեȥѤΤޤࡥʲƱˤѡʣ
$   ѡۡʰʲѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
$   (1) ܥեȥ򥽡ɤηѤˤϡ嵭
$       ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
$       ˴ޤޤƤ뤳ȡ
$   (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
$       ѤǤǺۤˤϡۤȼɥȡ
$       ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
$       ̵ݾڵǺܤ뤳ȡ
$   (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
$       ѤǤʤǺۤˤϡΤ줫ξ
$       ȡ
$     (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
$         ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
$     (b) ۤη֤̤ˡˤäơTOPPERSץȤ
$         𤹤뤳ȡ
$   (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
$       ⡤嵭ԤTOPPERSץȤդ뤳ȡ
$       ޤܥեȥΥ桼ޤϥɥ桼Τʤ
$       ͳ˴Ťᤫ⡤嵭ԤTOPPERSץȤ
$       դ뤳ȡ
$  
$   ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
$   TOPPERSץȤϡܥեȥ˴ؤơλŪ
$   ФŬޤơʤݾڤԤʤޤܥեȥ
$   ѤˤľŪޤϴŪʤ»˴ؤƤ⡤
$   Ǥʤ
$ 
$   $Id$
$  
$ =====================================================================

$ =====================================================================
$ AID_YYYν
$ =====================================================================

$num_atskid = 0$
$FOREACH i ATSK.ORDER_LIST$
$	// notskξE_PAR
	$IF ATSK.NOTSK[i] < 0$
		$ERROR ATSK.TEXT_LINE[i]$E_PAR: $FORMAT(_("illegal %1% `%2%\' in %3%"), "notsk", ATSK.NOTSK[i], "AID_TSK")$$END$
	$END$
	$num_atskid = num_atskid + ATSK.NOTSK[i]$
$END$
$num_tskid = LENGTH(TSK.ID_LIST) + num_atskid$

$num_asemid = 0$
$FOREACH i ASEM.ORDER_LIST$
$	// nosemξE_PAR
	$IF ASEM.NOSEM[i] < 0$
		$ERROR ASEM.TEXT_LINE[i]$E_PAR: $FORMAT(_("illegal %1% `%2%\' in %3%"), "nosem", ASEM.NOSEM[i], "AID_SEM")$$END$
	$END$
	$num_asemid = num_asemid + ASEM.NOSEM[i]$
$END$
$num_semid = LENGTH(SEM.ID_LIST) + num_asemid$

$num_aflgid = 0$
$FOREACH i AFLG.ORDER_LIST$
$	// noflgξE_PAR
	$IF AFLG.NOFLG[i] < 0$
		$ERROR AFLG.TEXT_LINE[i]$E_PAR: $FORMAT(_("illegal %1% `%2%\' in %3%"), "noflg", AFLG.NOFLG[i], "AID_FLG")$$END$
	$END$
	$num_aflgid = num_aflgid + AFLG.NOFLG[i]$
$END$
$num_flgid = LENGTH(FLG.ID_LIST) + num_aflgid$

$num_adtqid = 0$
$FOREACH i ADTQ.ORDER_LIST$
$	// nodtqξE_PAR
	$IF ADTQ.NODTQ[i] < 0$
		$ERROR ADTQ.TEXT_LINE[i]$E_PAR: $FORMAT(_("illegal %1% `%2%\' in %3%"), "nodtq", ADTQ.NODTQ[i], "AID_DTQ")$$END$
	$END$
	$num_adtqid = num_adtqid + ADTQ.NODTQ[i]$
$END$
$num_dtqid = LENGTH(DTQ.ID_LIST) + num_adtqid$

$num_apdqid = 0$
$FOREACH i APDQ.ORDER_LIST$
$	// nopdqξE_PAR
	$IF APDQ.NOPDQ[i] < 0$
		$ERROR APDQ.TEXT_LINE[i]$E_PAR: $FORMAT(_("illegal %1% `%2%\' in %3%"), "nopdq", APDQ.NOPDQ[i], "AID_PDQ")$$END$
	$END$
	$num_apdqid = num_apdqid + APDQ.NOPDQ[i]$
$END$
$num_pdqid = LENGTH(PDQ.ID_LIST) + num_apdqid$

$num_ambxid = 0$
$FOREACH i AMBX.ORDER_LIST$
$	// nombxξE_PAR
	$IF AMBX.NOMBX[i] < 0$
		$ERROR AMBX.TEXT_LINE[i]$E_PAR: $FORMAT(_("illegal %1% `%2%\' in %3%"), "nombx", AMBX.NOMBX[i], "AID_MBX")$$END$
	$END$
	$num_ambxid = num_ambxid + AMBX.NOMBX[i]$
$END$
$num_mbxid = LENGTH(MBX.ID_LIST) + num_ambxid$

$num_ampfid = 0$
$FOREACH i AMPF.ORDER_LIST$
$	// nompfξE_PAR
	$IF AMPF.NOMPF[i] < 0$
		$ERROR AMPF.TEXT_LINE[i]$E_PAR: $FORMAT(_("illegal %1% `%2%\' in %3%"), "nompf", AMPF.NOMPF[i], "AID_MPF")$$END$
	$END$
	$num_ampfid = num_ampfid + AMPF.NOMPF[i]$
$END$
$num_mpfid = LENGTH(MPF.ID_LIST) + num_ampfid$

$num_acycid = 0$
$FOREACH i ACYC.ORDER_LIST$
$	// nocycξE_PAR
	$IF ACYC.NOCYC[i] < 0$
		$ERROR ACYC.TEXT_LINE[i]$E_PAR: $FORMAT(_("illegal %1% `%2%\' in %3%"), "nocyc", ACYC.NOCYC[i], "AID_CYC")$$END$
	$END$
	$num_acycid = num_acycid + ACYC.NOCYC[i]$
$END$
$num_cycid = LENGTH(CYC.ID_LIST) + num_acycid$

$num_aalmid = 0$
$FOREACH i AALM.ORDER_LIST$
$	// noalmξE_PAR
	$IF AALM.NOALM[i] < 0$
		$ERROR AALM.TEXT_LINE[i]$E_PAR: $FORMAT(_("illegal %1% `%2%\' in %3%"), "noalm", AALM.NOALM[i], "AID_ALM")$$END$
	$END$
	$num_aalmid = num_aalmid + AALM.NOALM[i]$
$END$
$num_almid = LENGTH(ALM.ID_LIST) + num_aalmid$

$num_aisrid = 0$
$FOREACH i AISR.ORDER_LIST$
$	// noisrξE_PAR
	$IF AISR.NOISR[i] < 0$
		$ERROR AISR.TEXT_LINE[i]$E_PAR: $FORMAT(_("illegal %1% `%2%\' in %3%"), "noisr", AISR.NOISR[i], "AID_ISR")$$END$
	$END$
	$num_aisrid = num_aisrid + AISR.NOISR[i]$
$END$
$num_isrid = num_aisrid$
$num_isr = LENGTH(ISR.ORDER_LIST) + num_aisrid$

$ =====================================================================
$ kernel_cfg.h
$ =====================================================================

$FILE "kernel_cfg.h"$
/* kernel_cfg.h */$NL$
#ifndef TOPPERS_KERNEL_CFG_H$NL$
#define TOPPERS_KERNEL_CFG_H$NL$
$NL$
#define TNUM_TSKID	$num_tskid$$NL$
#define TNUM_SEMID	$num_semid$$NL$
#define TNUM_FLGID	$num_flgid$$NL$
#define TNUM_DTQID	$num_dtqid$$NL$
#define TNUM_PDQID	$num_pdqid$$NL$
#define TNUM_MBXID	$num_mbxid$$NL$
#define TNUM_MPFID	$num_mpfid$$NL$
#define TNUM_CYCID	$num_cycid$$NL$
#define TNUM_ALMID	$num_almid$$NL$
#define TNUM_ISRID	$num_isrid$$NL$
$NL$
$FOREACH id TSK.ID_LIST$
	#define $id$	$+id$$NL$
$END$
$FOREACH id SEM.ID_LIST$
	#define $id$	$+id$$NL$
$END$
$FOREACH id FLG.ID_LIST$
	#define $id$	$+id$$NL$
$END$
$FOREACH id DTQ.ID_LIST$
	#define $id$	$+id$$NL$
$END$
$FOREACH id PDQ.ID_LIST$
	#define $id$	$+id$$NL$
$END$
$FOREACH id MBX.ID_LIST$
	#define $id$	$+id$$NL$
$END$
$FOREACH id MPF.ID_LIST$
	#define $id$	$+id$$NL$
$END$
$FOREACH id CYC.ID_LIST$
	#define $id$	$+id$$NL$
$END$
$FOREACH id ALM.ID_LIST$
	#define $id$	$+id$$NL$
$END$
$NL$
#endif /* TOPPERS_KERNEL_CFG_H */$NL$

$ =====================================================================
$ kernel_cfg.c
$ =====================================================================

$FILE "kernel_cfg.c"$
/* kernel_cfg.c */$NL$
#include "kernel/kernel_int.h"$NL$
#include "kernel_cfg.h"$NL$
$NL$
#if TKERNEL_PRID != 0x07u$NL$
#error The kernel does not match this configuration file.$NL$
#endif$NL$
$NL$

$ 
$  󥯥롼ɥǥ쥯ƥ֡#include
$ 
/*$NL$
$SPC$*  Include Directives (#include)$NL$
$SPC$*/$NL$
$NL$
$INCLUDES$
$NL$

$ 
$  ֥ȤIDֹݻѿ
$ 
$IF USE_EXTERNAL_ID$
	/*$NL$
	$SPC$*  Variables for Object ID$NL$
	$SPC$*/$NL$
	$NL$
	$FOREACH id TSK.ID_LIST$
		const ID $id$_id$SPC$=$SPC$$+id$;$NL$
	$END$
	$FOREACH id SEM.ID_LIST$
		const ID $id$_id$SPC$=$SPC$$+id$;$NL$
	$END$
	$FOREACH id FLG.ID_LIST$
		const ID $id$_id$SPC$=$SPC$$+id$;$NL$
	$END$
	$FOREACH id DTQ.ID_LIST$
		const ID $id$_id$SPC$=$SPC$$+id$;$NL$
	$END$
	$FOREACH id PDQ.ID_LIST$
		const ID $id$_id$SPC$=$SPC$$+id$;$NL$
	$END$
	$FOREACH id MBX.ID_LIST$
		const ID $id$_id$SPC$=$SPC$$+id$;$NL$
	$END$
	$FOREACH id MPF.ID_LIST$
		const ID $id$_id$SPC$=$SPC$$+id$;$NL$
	$END$
	$FOREACH id CYC.ID_LIST$
		const ID $id$_id$SPC$=$SPC$$+id$;$NL$
	$END$
	$FOREACH id ALM.ID_LIST$
		const ID $id$_id$SPC$=$SPC$$+id$;$NL$
	$END$
$END$

$
$  åΰγݴؿ
$
$IF !ISFUNCTION("ALLOC_STACK")$
$FUNCTION ALLOC_STACK$
$	// 礭˴ݤ᤿ǳݤ
	static STK_T $ARGV[1]$[COUNT_STK_T($ARGV[2]$)];$NL$
	$RESULT = FORMAT("ROUND_STK_T(%1%)", ARGV[2])$
$END$
$END$

$ 
$  
$ 
/*$NL$
$SPC$*  Task Management Functions$NL$
$SPC$*/$NL$
$NL$

$ Ū줿1İʾ¸ߤ뤳ȤΥå
$IF !LENGTH(TSK.ID_LIST)$
	$ERROR$$FORMAT(_("no task is registered"))$$END$
$END$

$ Ū줿ο
#define TNUM_STSKID	$LENGTH(TSK.ID_LIST)$$NL$
$NL$

$ IDֹκ
const ID _kernel_tmax_tskid = (TMIN_TSKID + TNUM_TSKID - 1);$NL$
const ID _kernel_tmax_stskid = (TMIN_TSKID + TNUM_STSKID - 1);$NL$
$NL$

$ 顼å
$FOREACH tskid TSK.ID_LIST$
$	// tskatrʡTA_ACTϡˤǤʤE_RSATR
	$IF (TSK.TSKATR[tskid] & ~(TA_ACT|TARGET_TSKATR)) != 0$
		$ERROR TSK.TEXT_LINE[tskid]$E_RSATR: $FORMAT(_("illegal %1% `%2%\' of `%3%\' in %4%"), "tskatr", TSK.TSKATR[tskid], tskid, "CRE_TSK")$$END$
	$END$

$	// (TMIN_TPRI <= itskpri && itskpri <= TMAX_TPRI)ǤʤE_PAR
	$IF !(TMIN_TPRI <= TSK.ITSKPRI[tskid] && TSK.ITSKPRI[tskid] <= TMAX_TPRI)$
		$ERROR TSK.TEXT_LINE[tskid]$E_PAR: $FORMAT(_("illegal %1% `%2%\' of `%3%\' in %4%"), "itskpri", TSK.ITSKPRI[tskid], tskid, "CRE_TSK")$$END$
	$END$

$ 	// texatrTA_NULLˤǤʤE_RSATR
	$IF LENGTH(TSK.TEXATR[tskid]) && TSK.TEXATR[tskid] != 0$
		$ERROR DEF_TEX.TEXT_LINE[tskid]$E_RSATR: $FORMAT(_("illegal %1% `%2%\' of `%3%\' in %4%"), "texatr", TSK.TEXATR[tskid], tskid, "DEF_TEX")$$END$
	$END$
$END$

$ åΰȤ˴ؤ륨顼å
$FOREACH tskid TSK.ID_LIST$
$	// stksz0ʲåκǾ͡TARGET_MIN_STKSZˤ
$	// E_PAR
	$IF TSK.STKSZ[tskid] <= 0 || (TARGET_MIN_STKSZ
									&& TSK.STKSZ[tskid] < TARGET_MIN_STKSZ)$
		$ERROR TSK.TEXT_LINE[tskid]$E_PAR: $FORMAT(_("too small %1% `%2%\' of `%3%\' in %4%"), "stksz", TSK.STKSZ[tskid], tskid, "CRE_TSK")$$END$
	$END$

$ 	// stkszåΰΥȤʤE_PAR
	$IF !EQ(TSK.STK[tskid], "NULL") && CHECK_STKSZ_ALIGN
							&& (TSK.STKSZ[tskid] & (CHECK_STKSZ_ALIGN - 1))$
		$ERROR TSK.TEXT_LINE[tskid]$E_PAR: $FORMAT(_("%1% `%2%\' of `%3%\' in %4% is not aligned"), "stksz", TSK.STKSZ[tskid], tskid, "CRE_TSK")$$END$
	$END$

	$IF EQ(TSK.STK[tskid],"NULL")$
		$TSK.TINIB_STKSZ[tskid] = ALLOC_STACK(CONCAT("_kernel_stack_",
												tskid), TSK.STKSZ[tskid])$
		$TSK.TINIB_STK[tskid] = CONCAT("_kernel_stack_", tskid)$
	$ELSE$
		$TSK.TINIB_STKSZ[tskid] = FORMAT("(%1%)", TSK.STKSZ[tskid])$
		$TSK.TINIB_STK[tskid] = FORMAT("(void *)(%1%)", TSK.STK[tskid])$
	$END$
$END$
$NL$

$ ֥åʥ1İʾ¸ߤ
const TINIB _kernel_tinib_table[TNUM_STSKID] = {$NL$
$JOINEACH tskid TSK.ID_LIST ",\n"$
$	// °ĥ󡤵ưϡưͥ
	$TAB${
	$SPC$($TSK.TSKATR[tskid]$), (intptr_t)($TSK.EXINF[tskid]$),
	$SPC$((TASK)($TSK.TASK[tskid]$)), INT_PRIORITY($TSK.ITSKPRI[tskid]$),

$	// ƥȥ֥ååΰ
	$IF USE_TSKINICTXB$
		$GENERATE_TSKINICTXB(tskid)$
	$ELSE$
		$SPC$$TSK.TINIB_STKSZ[tskid]$, $TSK.TINIB_STK[tskid]$,
	$END$

$	// 㳰롼°ȵư
	$SPC$($ALT(TSK.TEXATR[tskid],"TA_NULL")$), ($ALT(TSK.TEXRTN[tskid],"NULL")$) }
$END$$NL$
};$NL$
$NL$

$ ưŪѤΥ֥å
$IF num_atskid > 0$
	TINIB _kernel_atinib_table[$num_atskid$];$NL$
$ELSE$
	TOPPERS_EMPTY_LABEL(TINIB, _kernel_atinib_table);$NL$
$END$$NL$

$ ֥å
TCB _kernel_tcb_table[TNUM_TSKID];$NL$
$NL$

$ ơ֥
const ID _kernel_torder_table[TNUM_STSKID] = {$NL$
$TAB$$JOINEACH tskid TSK.ORDER_LIST ", "$$tskid$$END$$NL$
};$NL$
$NL$

$ 
$  ޥե
$ 
/*$NL$
$SPC$*  Semaphore Functions$NL$
$SPC$*/$NL$
$NL$

$ Ū줿ޥեο
#define TNUM_SSEMID	$LENGTH(SEM.ID_LIST)$$NL$
$NL$

$ ޥեIDֹκ
const ID _kernel_tmax_semid = (TMIN_SEMID + TNUM_SEMID - 1);$NL$
const ID _kernel_tmax_ssemid = (TMIN_SEMID + TNUM_SSEMID - 1);$NL$
$NL$

$ ޥե֥å
$IF LENGTH(SEM.ID_LIST)$
	const SEMINIB _kernel_seminib_table[TNUM_SSEMID] = {$NL$
	$JOINEACH semid SEM.ID_LIST ",\n"$
$		// sematrʡTA_TPRIϡˤǤʤE_RSATR
		$IF (SEM.SEMATR[semid] & ~TA_TPRI) != 0$
			$ERROR SEM.TEXT_LINE[semid]$E_RSATR: $FORMAT(_("illegal %1% `%2%\' of `%3%\' in %4%"), "sematr", SEM.SEMATR[semid], semid, "CRE_SEM")$$END$
		$END$

$		// (0 <= isemcnt && isemcnt <= maxsem)ǤʤE_PAR
		$IF !(0 <= SEM.ISEMCNT[semid] && SEM.ISEMCNT[semid] <= SEM.MAXSEM[semid])$
			$ERROR SEM.TEXT_LINE[semid]$E_PAR: $FORMAT(_("too large %1% `%2%\' of `%3%\' in %4%"), "isemcnt", SEM.ISEMCNT[semid], semid, "CRE_SEM")$$END$
		$END$

$		// (1 <= maxsem && maxsem <= TMAX_MAXSEM)ǤʤE_PAR
		$IF !(1 <= SEM.MAXSEM[semid] && SEM.MAXSEM[semid] <= TMAX_MAXSEM)$
			$ERROR SEM.TEXT_LINE[semid]$E_PAR: $FORMAT(_("illegal %1% `%2%\' of `%3%\' in %4%"), "maxsem", SEM.MAXSEM[semid], semid, "CRE_SEM")$$END$
		$END$

$		// ޥե֥å
		$TAB${ ($SEM.SEMATR[semid]$), ($SEM.ISEMCNT[semid]$), ($SEM.MAXSEM[semid]$) }
	$END$$NL$
	};$NL$
$ELSE$
	TOPPERS_EMPTY_LABEL(const SEMINIB, _kernel_seminib_table);$NL$
$END$$NL$

$ ưŪޥեѤΥޥե֥å
$IF num_asemid > 0$
	SEMINIB _kernel_aseminib_table[$num_asemid$];$NL$
$ELSE$
	TOPPERS_EMPTY_LABEL(SEMINIB, _kernel_aseminib_table);$NL$
$END$$NL$

$ ޥե֥å
$IF num_semid > 0$
	SEMCB _kernel_semcb_table[TNUM_SEMID];$NL$
$ELSE$
	TOPPERS_EMPTY_LABEL(SEMCB, _kernel_semcb_table);$NL$
$END$$NL$

$ 
$  ٥ȥե饰
$ 
/*$NL$
$SPC$*  Eventflag Functions$NL$
$SPC$*/$NL$
$NL$

$ Ū줿٥ȥե饰ο
#define TNUM_SFLGID	$LENGTH(FLG.ID_LIST)$$NL$
$NL$

$ ٥ȥե饰IDֹκ
const ID _kernel_tmax_flgid = (TMIN_FLGID + TNUM_FLGID - 1);$NL$
const ID _kernel_tmax_sflgid = (TMIN_FLGID + TNUM_SFLGID - 1);$NL$
$NL$

$ ٥ȥե饰֥å
$IF LENGTH(FLG.ID_LIST)$
	const FLGINIB _kernel_flginib_table[TNUM_SFLGID] = {$NL$
	$JOINEACH flgid FLG.ID_LIST ",\n"$
$		// flgatrʡTA_TPRIϡáTA_WMULϡáTA_CLRϡˤǤʤE_RSATR
		$IF (FLG.FLGATR[flgid] & ~(TA_TPRI|TA_WMUL|TA_CLR)) != 0$
			$ERROR FLG.TEXT_LINE[flgid]$E_RSATR: $FORMAT(_("illegal %1% `%2%\' of `%3%\' in %4%"), "flgatr", FLG.FLGATR[flgid], flgid, "CRE_FLG")$$END$
		$END$

$		// iflgptnFLGPTN˳ǼǤʤE_PAR
		$IF (FLG.IFLGPTN[flgid] & ~((1 << TBIT_FLGPTN) - 1)) != 0$
			$ERROR FLG.TEXT_LINE[flgid]$E_PAR: $FORMAT(_("too large %1% `%2%\' of `%3%\' in %4%"), "iflgptn", FLG.IFLGPTN[flgid], flgid, "CRE_FLG")$$END$
		$END$

$		// ٥ȥե饰֥å
		$TAB${ ($FLG.FLGATR[flgid]$), ($FLG.IFLGPTN[flgid]$) }
	$END$$NL$
	};$NL$
$ELSE$
	TOPPERS_EMPTY_LABEL(const FLGINIB, _kernel_flginib_table);$NL$
$END$$NL$

$ ưŪ٥ȥե饰ѤΥ٥ȥե饰֥å
$IF num_aflgid > 0$
	FLGINIB _kernel_aflginib_table[$num_aflgid$];$NL$
$ELSE$
	TOPPERS_EMPTY_LABEL(FLGINIB, _kernel_aflginib_table);$NL$
$END$$NL$

$ ٥ȥե饰֥å
$IF num_flgid > 0$
	FLGCB _kernel_flgcb_table[TNUM_FLGID];$NL$
$ELSE$
	TOPPERS_EMPTY_LABEL(FLGCB, _kernel_flgcb_table);$NL$
$END$$NL$

$ 
$  ǡ塼
$ 
/*$NL$
$SPC$*  Dataqueue Functions$NL$
$SPC$*/$NL$
$NL$

$ Ū줿ǡ塼ο
#define TNUM_SDTQID	$LENGTH(DTQ.ID_LIST)$$NL$
$NL$

$ ǡ塼IDֹκ
const ID _kernel_tmax_dtqid = (TMIN_DTQID + TNUM_DTQID - 1);$NL$
const ID _kernel_tmax_sdtqid = (TMIN_DTQID + TNUM_SDTQID - 1);$NL$
$NL$

$IF LENGTH(DTQ.ID_LIST)$
	$FOREACH dtqid DTQ.ID_LIST$
$		// dtqatrʡTA_TPRIϡˤǤʤE_RSATR
		$IF (DTQ.DTQATR[dtqid] & ~TA_TPRI) != 0$
			$ERROR DTQ.TEXT_LINE[dtqid]$E_RSATR: $FORMAT(_("illegal %1% `%2%\' of `%3%\' in %4%"), "dtqatr", DTQ.DTQATR[dtqid], dtqid, "CRE_DTQ")$$END$
		$END$

$		// dtqcntξE_PAR
		$IF DTQ.DTQCNT[dtqid] < 0$
			$ERROR DTQ.TEXT_LINE[dtqid]$E_PAR: $FORMAT(_("illegal %1% `%2%\' of `%3%\' in %4%"), "dtqcnt", DTQ.DTQCNT[dtqid], dtqid, "CRE_DTQ")$$END$
		$END$

$		// dtqmbNULLǤʤE_NOSPT
		$IF !EQ(DTQ.DTQMB[dtqid], "NULL")$
			$ERROR DTQ.TEXT_LINE[dtqid]$E_NOSPT: $FORMAT(_("illegal %1% `%2%\' of `%3%\' in %4%"), "dtqmb", DTQ.DTQMB[dtqid], dtqid, "CRE_DTQ")$$END$
		$END$

$		// ǡ塼ΰ
		$IF DTQ.DTQCNT[dtqid]$
			static DTQMB _kernel_dtqmb_$dtqid$[$DTQ.DTQCNT[dtqid]$];$NL$
		$END$
	$END$

$	// ǡ塼֥å
	const DTQINIB _kernel_dtqinib_table[TNUM_SDTQID] = {$NL$
	$JOINEACH dtqid DTQ.ID_LIST ",\n"$
		$TAB${ ($DTQ.DTQATR[dtqid]$), ($DTQ.DTQCNT[dtqid]$), $IF DTQ.DTQCNT[dtqid]$(_kernel_dtqmb_$dtqid$)$ELSE$NULL$END$ }
	$END$$NL$
	};$NL$
$ELSE$
	TOPPERS_EMPTY_LABEL(const DTQINIB, _kernel_dtqinib_table);$NL$
$END$$NL$

$ ưŪǡ塼ѤΥǡ塼֥å
$IF num_adtqid > 0$
	DTQINIB _kernel_adtqinib_table[$num_adtqid$];$NL$
$ELSE$
	TOPPERS_EMPTY_LABEL(DTQINIB, _kernel_adtqinib_table);$NL$
$END$$NL$

$ ǡ塼֥å
$IF num_dtqid > 0$
	DTQCB _kernel_dtqcb_table[TNUM_DTQID];$NL$
$ELSE$
	TOPPERS_EMPTY_LABEL(DTQCB, _kernel_dtqcb_table);$NL$
$END$$NL$

$ 
$  ͥ٥ǡ塼
$ 
/*$NL$
$SPC$*  Priority Dataqueue Functions$NL$
$SPC$*/$NL$
$NL$

$ Ū줿ͥ٥ǡ塼ο
#define TNUM_SPDQID	$LENGTH(PDQ.ID_LIST)$$NL$
$NL$

$ ͥ٥ǡ塼IDֹκ
const ID _kernel_tmax_pdqid = (TMIN_PDQID + TNUM_PDQID - 1);$NL$
const ID _kernel_tmax_spdqid = (TMIN_PDQID + TNUM_SPDQID - 1);$NL$
$NL$

$IF LENGTH(PDQ.ID_LIST)$
	$FOREACH pdqid PDQ.ID_LIST$
$		// pdqatrʡTA_TPRIϡˤǤʤE_RSATR
		$IF (PDQ.PDQATR[pdqid] & ~TA_TPRI) != 0$
			$ERROR PDQ.TEXT_LINE[pdqid]$E_RSATR: $FORMAT(_("illegal %1% `%2%\' of `%3%\' in %4%"), "pdqatr", PDQ.PDQATR[pdqid], pdqid, "CRE_PDQ")$$END$
		$END$

$		// pdqcntξE_PAR
		$IF PDQ.PDQCNT[pdqid] < 0$
			$ERROR PDQ.TEXT_LINE[pdqid]$E_PAR: $FORMAT(_("illegal %1% `%2%\' of `%3%\' in %4%"), "pdqcnt", PDQ.PDQCNT[pdqid], pdqid, "CRE_PDQ")$$END$
		$END$

$		// (TMIN_DPRI <= maxdpri && maxdpri <= TMAX_DPRI)ǤʤE_PAR
		$IF !(TMIN_DPRI <= PDQ.MAXDPRI[pdqid] && PDQ.MAXDPRI[pdqid] <= TMAX_DPRI)$
			$ERROR PDQ.TEXT_LINE[pdqid]$E_PAR: $FORMAT(_("illegal %1% `%2%\' of `%3%\' in %4%"), "maxdpri", PDQ.MAXDPRI[pdqid], pdqid, "CRE_PDQ")$$END$
		$END$

$		// pdqmbNULLǤʤE_NOSPT
		$IF !EQ(PDQ.PDQMB[pdqid], "NULL")$
			$ERROR PDQ.TEXT_LINE[pdqid]$E_NOSPT: $FORMAT(_("illegal %1% `%2%\' of `%3%\' in %4%"), "pdqmb", PDQ.PDQMB[pdqid], pdqid, "CRE_PDQ")$$END$
		$END$

$		// ͥ٥ǡ塼ΰ
		$IF PDQ.PDQCNT[pdqid]$
			static PDQMB _kernel_pdqmb_$pdqid$[$PDQ.PDQCNT[pdqid]$];$NL$
		$END$
	$END$

$	// ͥ٥ǡ塼֥å
	const PDQINIB _kernel_pdqinib_table[TNUM_SPDQID] = {$NL$
	$JOINEACH pdqid PDQ.ID_LIST ",\n"$
		$TAB${ ($PDQ.PDQATR[pdqid]$), ($PDQ.PDQCNT[pdqid]$), ($PDQ.MAXDPRI[pdqid]$), $IF PDQ.PDQCNT[pdqid]$(_kernel_pdqmb_$pdqid$)$ELSE$NULL$END$ }
	$END$$NL$
	};$NL$
$ELSE$
	TOPPERS_EMPTY_LABEL(const PDQINIB, _kernel_pdqinib_table);$NL$
$END$$NL$

$ ưŪͥ٥ǡ塼Ѥͥ٥ǡ塼֥å
$IF num_apdqid > 0$
	PDQINIB _kernel_apdqinib_table[$num_apdqid$];$NL$
$ELSE$
	TOPPERS_EMPTY_LABEL(PDQINIB, _kernel_apdqinib_table);$NL$
$END$$NL$

$ ͥ٥ǡ塼֥å
$IF num_pdqid > 0$
	PDQCB _kernel_pdqcb_table[TNUM_PDQID];$NL$
$ELSE$
	TOPPERS_EMPTY_LABEL(PDQCB, _kernel_pdqcb_table);$NL$
$END$$NL$

$ 
$  ᡼ܥå
$ 
/*$NL$
$SPC$*  Mailbox Functions$NL$
$SPC$*/$NL$
$NL$

$ Ū줿᡼ܥåο
#define TNUM_SMBXID	$LENGTH(MBX.ID_LIST)$$NL$
$NL$

$ ᡼ܥåIDֹκ
const ID _kernel_tmax_mbxid = (TMIN_MBXID + TNUM_MBXID - 1);$NL$
const ID _kernel_tmax_smbxid = (TMIN_MBXID + TNUM_SMBXID - 1);$NL$
$NL$

$ ᡼ܥå֥å
$IF LENGTH(MBX.ID_LIST)$
	const MBXINIB _kernel_mbxinib_table[TNUM_SMBXID] = {$NL$
	$JOINEACH mbxid MBX.ID_LIST ",\n"$
$		// mbxatrʡTA_TPRIϡáTA_MPRIϡˤǤʤE_RSATR
		$IF (MBX.MBXATR[mbxid] & ~(TA_TPRI|TA_MPRI)) != 0$
			$ERROR MBX.TEXT_LINE[mbxid]$E_RSATR: $FORMAT(_("illegal %1% `%2%\' of `%3%\' in %4%"), "mbxatr", MBX.MBXATR[mbxid], mbxid, "CRE_MBX")$$END$
		$END$

$		// (TMIN_MPRI <= maxmpri && maxmpri <= TMAX_MPRI)ǤʤE_PAR
		$IF !(TMIN_MPRI <= MBX.MAXMPRI[mbxid] && MBX.MAXMPRI[mbxid] <= TMAX_MPRI)$
			$ERROR MBX.TEXT_LINE[mbxid]$E_PAR: $FORMAT(_("illegal %1% `%2%\' of `%3%\' in %4%"), "maxmpri", MBX.MAXMPRI[mbxid], mbxid, "CRE_MBX")$$END$
		$END$

$		// mprihdNULLǤʤE_NOSPT
		$IF !EQ(MBX.MPRIHD[mbxid], "NULL")$
			$ERROR MBX.TEXT_LINE[mbxid]$E_NOSPT: $FORMAT(_("illegal %1% `%2%\' of `%3%\' in %4%"), "mprihd", MBX.MPRIHD[mbxid], mbxid, "CRE_MBX")$$END$
		$END$

$		// ᡼ܥå֥å
		$TAB${ ($MBX.MBXATR[mbxid]$), ($MBX.MAXMPRI[mbxid]$) }
	$END$$NL$
	};$NL$
$ELSE$
	TOPPERS_EMPTY_LABEL(const MBXINIB, _kernel_mbxinib_table);$NL$
$END$$NL$

$ ưŪ᡼ܥåѤΥ᡼ܥå֥å
$IF num_ambxid > 0$
	MBXINIB _kernel_ambxinib_table[$num_ambxid$];$NL$
$ELSE$
	TOPPERS_EMPTY_LABEL(MBXINIB, _kernel_ambxinib_table);$NL$
$END$$NL$

$ ᡼ܥå֥å
$IF num_mbxid > 0$
	MBXCB _kernel_mbxcb_table[TNUM_MBXID];$NL$
$ELSE$
	TOPPERS_EMPTY_LABEL(MBXCB, _kernel_mbxcb_table);$NL$
$END$$NL$

$ 
$  Ĺס
$ 
/*$NL$
$SPC$*  Fixed-sized Memorypool Functions$NL$
$SPC$*/$NL$
$NL$

$ Ū줿Ĺסο
#define TNUM_SMPFID	$LENGTH(MPF.ID_LIST)$$NL$
$NL$

$ ĹסIDֹκ
const ID _kernel_tmax_mpfid = (TMIN_MPFID + TNUM_MPFID - 1);$NL$
const ID _kernel_tmax_smpfid = (TMIN_MPFID + TNUM_SMPFID - 1);$NL$
$NL$

$IF LENGTH(MPF.ID_LIST)$
	$FOREACH mpfid MPF.ID_LIST$
$		// mpfatrʡTA_TPRIϡˤǤʤE_RSATR
		$IF (MPF.MPFATR[mpfid] & ~TA_TPRI) != 0$
			$ERROR MPF.TEXT_LINE[mpfid]$E_RSATR: $FORMAT(_("illegal %1% `%2%\' of `%3%\' in %4%"), "mpfatr", MPF.MPFATR[mpfid], mpfid, "CRE_MPF")$$END$
		$END$

$		// blkcnt0ʲξE_PAR
		$IF MPF.BLKCNT[mpfid] <= 0$
			$ERROR MPF.TEXT_LINE[mpfid]$E_PAR: $FORMAT(_("illegal %1% `%2%\' of `%3%\' in %4%"), "blkcnt", MPF.BLKCNT[mpfid], mpfid, "CRE_MPF")$$END$
		$END$

$		// blksz0ʲξE_PAR
		$IF MPF.BLKSZ[mpfid] <= 0$
			$ERROR MPF.TEXT_LINE[mpfid]$E_PAR: $FORMAT(_("illegal %1% `%2%\' of `%3%\' in %4%"), "blksz", MPF.BLKSZ[mpfid], mpfid, "CRE_MPF")$$END$
		$END$

$		// Ĺסΰ
		$IF EQ(MPF.MPF[mpfid], "NULL")$
			static MPF_T _kernel_mpf_$mpfid$[($MPF.BLKCNT[mpfid]$) * COUNT_MPF_T($MPF.BLKSZ[mpfid]$)];$NL$
		$END$

$		// mpfmbNULLǤʤE_NOSPT
		$IF !EQ(MPF.MPFMB[mpfid], "NULL")$
			$ERROR MPF.TEXT_LINE[mpfid]$E_NOSPT: $FORMAT(_("illegal %1% `%2%\' of `%3%\' in %4%"), "mpfmb", MPF.MPFMB[mpfid], mpfid, "CRE_MPF")$$END$
		$END$

$		// Ĺסΰ
		static MPFMB _kernel_mpfmb_$mpfid$[$MPF.BLKCNT[mpfid]$];$NL$
	$END$

$	// Ĺס֥å
	const MPFINIB _kernel_mpfinib_table[TNUM_SMPFID] = {$NL$
	$JOINEACH mpfid MPF.ID_LIST ",\n"$
		$TAB${ ($MPF.MPFATR[mpfid]$), ($MPF.BLKCNT[mpfid]$), ROUND_MPF_T($MPF.BLKSZ[mpfid]$), $IF EQ(MPF.MPF[mpfid],"NULL")$(_kernel_mpf_$mpfid$)$ELSE$(void *)($MPF.MPF[mpfid]$)$END$, (_kernel_mpfmb_$mpfid$) }
	$END$$NL$
	};$NL$
$ELSE$
	TOPPERS_EMPTY_LABEL(const MPFINIB, _kernel_mpfinib_table);$NL$
$END$$NL$

$ ưŪĹסѤθĹס֥å
$IF num_ampfid > 0$
	MPFINIB _kernel_ampfinib_table[$num_ampfid$];$NL$
$ELSE$
	TOPPERS_EMPTY_LABEL(MPFINIB, _kernel_ampfinib_table);$NL$
$END$$NL$

$ Ĺס֥å
$IF num_mpfid > 0$
	MPFCB _kernel_mpfcb_table[TNUM_MPFID];$NL$
$ELSE$
	TOPPERS_EMPTY_LABEL(MPFCB, _kernel_mpfcb_table);$NL$
$END$$NL$

$ 
$  ϥɥ
$ 
/*$NL$
$SPC$*  Cyclic Handler Functions$NL$
$SPC$*/$NL$
$NL$

$ Ū줿ϥɥο
#define TNUM_SCYCID	$LENGTH(CYC.ID_LIST)$$NL$
$NL$

$ ϥɥIDֹκ
const ID _kernel_tmax_cycid = (TMIN_CYCID + TNUM_CYCID - 1);$NL$
const ID _kernel_tmax_scycid = (TMIN_CYCID + TNUM_SCYCID - 1);$NL$
$NL$

$ ϥɥ֥å
$IF LENGTH(CYC.ID_LIST)$
	const CYCINIB _kernel_cycinib_table[TNUM_SCYCID] = {$NL$
	$JOINEACH cycid CYC.ID_LIST ",\n"$
$		// cycatrʡTA_STAϡˤǤʤE_RSATR
		$IF (CYC.CYCATR[cycid] & ~TA_STA) != 0$
			$ERROR CYC.TEXT_LINE[cycid]$E_RSATR: $FORMAT(_("illegal %1% `%2%\' of `%3%\' in %4%"), "cycatr", CYC.CYCATR[cycid], cycid, "CRE_CYC")$$END$
		$END$

$		// (0 < cyctim && cyctim <= TMAX_RELTIM)ǤʤE_PAR
		$IF !(0 < CYC.CYCTIM[cycid] && CYC.CYCTIM[cycid] <= TMAX_RELTIM)$
			$ERROR CYC.TEXT_LINE[cycid]$E_PAR: $FORMAT(_("illegal %1% `%2%\' of `%3%\' in %4%"), "cyctim", CYC.CYCTIM[cycid], cycid, "CRE_CYC")$$END$
		$END$

$		// (0 <= cycphs && cycphs <= TMAX_RELTIM)ǤʤE_PAR
		$IF !(0 <= CYC.CYCPHS[cycid] && CYC.CYCPHS[cycid] <= TMAX_RELTIM)$
			$ERROR CYC.TEXT_LINE[cycid]$E_PAR: $FORMAT(_("illegal %1% `%2%\' of `%3%\' in %4%"), "cycphs", CYC.CYCPHS[cycid], cycid, "CRE_CYC")$$END$
		$END$

$		// ٹcycatrTA_STAꤵƤơ(cycphs == 0)ξ
		$IF (CYC.CYCATR[cycid] & TA_STA) != 0 && CYC.CYCPHS[cycid] == 0$
			$WARNING CYC.TEXT_LINE[cycid]$$FORMAT(_("%1% is not recommended when %2% is set to %3% in %4%"), "cycphs==0", "TA_STA", "cycatr", "CRE_CYC")$$END$
		$END$

$		// ϥɥ֥å
		$TAB${ ($CYC.CYCATR[cycid]$), (intptr_t)($CYC.EXINF[cycid]$), ($CYC.CYCHDR[cycid]$), ($CYC.CYCTIM[cycid]$), ($CYC.CYCPHS[cycid]$) }
	$END$$NL$
	};$NL$
$ELSE$
	TOPPERS_EMPTY_LABEL(const CYCINIB, _kernel_cycinib_table);$NL$
$END$$NL$

$ ưŪϥɥѤμϥɥ֥å
$IF num_acycid > 0$
	CYCINIB _kernel_acycinib_table[$num_acycid$];$NL$
$ELSE$
	TOPPERS_EMPTY_LABEL(CYCINIB, _kernel_acycinib_table);$NL$
$END$$NL$

$ ϥɥ֥å
$IF num_cycid > 0$
	CYCCB _kernel_cyccb_table[TNUM_CYCID];$NL$
$ELSE$
	TOPPERS_EMPTY_LABEL(CYCCB, _kernel_cyccb_table);$NL$
$END$$NL$

$ 
$  顼ϥɥ
$ 
/*$NL$
$SPC$*  Alarm Handler Functions$NL$
$SPC$*/$NL$
$NL$

$ Ū줿顼ϥɥο
#define TNUM_SALMID	$LENGTH(ALM.ID_LIST)$$NL$
$NL$

$ 顼ϥɥIDֹκ
const ID _kernel_tmax_almid = (TMIN_ALMID + TNUM_ALMID - 1);$NL$
const ID _kernel_tmax_salmid = (TMIN_ALMID + TNUM_SALMID - 1);$NL$
$NL$

$ 顼ϥɥ֥å
$IF LENGTH(ALM.ID_LIST)$
	const ALMINIB _kernel_alminib_table[TNUM_SALMID] = {$NL$
	$JOINEACH almid ALM.ID_LIST ",\n"$
$		// almatrTA_NULLˤǤʤE_RSATR
		$IF ALM.ALMATR[almid] != 0$
			$ERROR ALM.TEXT_LINE[almid]$E_RSATR: $FORMAT(_("illegal %1% `%2%\' of `%3%\' in %4%"), "almatr", ALM.ALMATR[almid], almid, "CRE_ALM")$$END$
		$END$

$		// 顼ϥɥ֥å
		$TAB${ ($ALM.ALMATR[almid]$), (intptr_t)($ALM.EXINF[almid]$), ($ALM.ALMHDR[almid]$) }
	$END$$NL$
	};$NL$
$ELSE$
	TOPPERS_EMPTY_LABEL(const ALMINIB, _kernel_alminib_table);$NL$
$END$$NL$

$ ưŪ顼ϥɥѤΥ顼ϥɥ֥å
$IF num_aalmid > 0$
	ALMINIB _kernel_aalminib_table[$num_aalmid$];$NL$
$ELSE$
	TOPPERS_EMPTY_LABEL(ALMINIB, _kernel_aalminib_table);$NL$
$END$$NL$

$ 顼ϥɥ֥å
$IF num_almid > 0$
	ALMCB _kernel_almcb_table[TNUM_ALMID];$NL$
$ELSE$
	TOPPERS_EMPTY_LABEL(ALMCB, _kernel_almcb_table);$NL$
$END$$NL$

$ 
$  ߴǽ
$ 
/*$NL$
$SPC$*  Interrupt Management Functions$NL$
$SPC$*/$NL$
$NL$

$ ֹȳߥϥɥֹѴơ֥κ
$IF LENGTH(INTNO_ATTISR_VALID) != LENGTH(INHNO_ATTISR_VALID)$
	$ERROR$length of `INTNO_ATTISR_VALID' is different from length of `INHNO_ATTISR_VALID'$END$
$END$
$i = 0$
$FOREACH intno INTNO_ATTISR_VALID$
	$inhno = AT(INHNO_ATTISR_VALID, i)$
	$INHNO[intno] = inhno$
	$INTNO[inhno] = intno$
	$i = i + 1$
$END$

$ ׵饤˴ؤ륨顼å
$i = 0$
$FOREACH intno INT.ORDER_LIST$
$	// intnoCFG_INTФֹȤʤE_PAR
	$IF !LENGTH(FIND(INTNO_CFGINT_VALID, INT.INTNO[intno]))$
		$ERROR INT.TEXT_LINE[intno]$E_PAR: $FORMAT(_("illegal %1% `%2%\' in %3%"), "intno", INT.INTNO[intno], "CFG_INT")$$END$
	$END$

$	// intnoCFG_INTˤäѤߤξE_OBJ
	$j = 0$
	$FOREACH intno2 INT.ORDER_LIST$
		$IF j < i && INT.INTNO[intno] == INT.INTNO[intno2]$
			$ERROR INT.TEXT_LINE[intno]$E_OBJ: $FORMAT(_("%1% `%2%\' in %3% is duplicated"), "intno", INT.INTNO[intno], "CFG_INT")$$END$
		$END$
		$j = j + 1$
	$END$

$	// intatrʡTA_ENAINTϡáTA_EDGEϡˤǤʤE_RSATR
	$IF (INT.INTATR[intno] & ~(TA_ENAINT|TA_EDGE|TARGET_INTATR)) != 0$
		$ERROR INT.TEXT_LINE[intno]$E_RSATR: $FORMAT(_("illegal %1% `%2%\' of %3% `%4%\' in %5%"), "intatr", INT.INTATR[intno], "intno", INT.INTNO[intno], "CFG_INT")$$END$
	$END$

$	// intpriCFG_INTФͥ٤ȤʤE_PAR
	$IF !LENGTH(FIND(INTPRI_CFGINT_VALID, INT.INTPRI[intno]))$
		$ERROR INT.TEXT_LINE[intno]$E_PAR: $FORMAT(_("illegal %1% `%2%\' in %3%"), "intpri", INT.INTPRI[intno], "CFG_INT")$$END$
	$END$

$	// ͥ˸ꤵƤintnoФơintpriTMIN_INTPRI
$	// ⾮ͤꤵ줿E_OBJ
	$IF LENGTH(FIND(INTNO_FIX_KERNEL, intno))$
		$IF INT.INTPRI[intno] < TMIN_INTPRI$
			$ERROR INT.TEXT_LINE[intno]$E_OBJ: $FORMAT(_("%1% `%2%\' must not have higher priority than %3%"), "intno", INT.INTNO[intno], "TMIN_INTPRI")$$END$
		$END$
	$END$

$	// ͥ˸ꤵƤintnoФơintpriTMIN_INTPRI
$	// ⾮ͤꤵʤäE_OBJ
	$IF LENGTH(FIND(INTNO_FIX_NONKERNEL, intno))$
		$IF INT.INTPRI[intno] >= TMIN_INTPRI$
			$ERROR INT.TEXT_LINE[intno]$E_OBJ: $FORMAT(_("%1% `%2%\' must have higher priority than %3%"), "intno", INT.INTNO[intno], "TMIN_INTPRI")$$END$
		$END$
	$END$
	$i = i + 1$
$END$

$ ߥϥɥ˴ؤ륨顼å
$i = 0$
$FOREACH inhno INH.ORDER_LIST$
$	// inhnoDEF_INHФߥϥɥֹȤʤE_PAR
	$IF !LENGTH(FIND(INHNO_DEFINH_VALID, INH.INHNO[inhno]))$
		$ERROR INH.TEXT_LINE[inhno]$E_PAR: $FORMAT(_("illegal %1% `%2%\' in %3%"), "inhno", INH.INHNO[inhno], "DEF_INH")$$END$
	$END$

$	// inhnoDEF_INHˤäѤߤξE_OBJ
	$j = 0$
	$FOREACH inhno2 INH.ORDER_LIST$
		$IF j < i && INH.INHNO[inhno] == INH.INHNO[inhno2]$
			$ERROR INH.TEXT_LINE[inhno]$E_OBJ: $FORMAT(_("%1% `%2%\' in %3% is duplicated"), "inhno", INH.INHNO[inhno], "DEF_INH")$$END$
		$END$
		$j = j + 1$
	$END$

$	// inhatrTA_NULLˤǤʤE_RSATR
	$IF (INH.INHATR[inhno] & ~TARGET_INHATR) != 0$
		$ERROR INH.TEXT_LINE[inhno]$E_RSATR: $FORMAT(_("illegal %1% `%2%\' of %3% `%4%\' in %5%"), "inhatr", INH.INHATR[inhno], "inhno", INH.INHNO[inhno], "DEF_INH")$$END$
	$END$

$	// ͥ˸ꤵƤinhnoФơinhatrTA_NONKERNEL
$	//ꤵƤE_RSATR
	$IF LENGTH(FIND(INHNO_FIX_KERNEL, inhno))$
		$IF (INH.INHATR[inhno] & TA_NONKERNEL) != 0$
			$ERROR INH.TEXT_LINE[inhno]$E_RSATR: $FORMAT(_("%1% `%2%\' must not be non-kernel interrupt"), "inhno", INH.INHNO[inhno])$$END$
		$END$
	$END$

$	// ͥ˸ꤵƤinhnoФơinhatrTA_NONKERNEL
$	// ꤵƤʤE_RSATR
	$IF LENGTH(FIND(INHNO_FIX_NONKERNEL, inhno))$
		$IF (INH.INHATR[inhno] & TA_NONKERNEL) == 0$
			$ERROR INH.TEXT_LINE[inhno]$E_RSATR: $FORMAT(_("%1% `%2%\' must be non-kernel interrupt"), "inhno", INH.INHNO[inhno])$$END$
		$END$
	$END$

	$IF LENGTH(INTNO[INH.INHNO[inhno]])$
		$intno = INTNO[INH.INHNO[inhno]]$
$		// inhnoбintnoФCFG_INTʤE_OBJ
		$IF !LENGTH(INT.INTNO[intno])$
			$ERROR INH.TEXT_LINE[inhno]$E_OBJ: $FORMAT(_("%1% `%2%\' corresponding to %3% `%4%\' is not configured with %5%"), "intno", intno, "inhno", INH.INHNO[inhno], "CFG_INT")$$END$
		$ELSE$
			$IF (INH.INHATR[inhno] & TA_NONKERNEL) == 0$
$				// inhatrTA_NONKERNELꤵƤ餺inhnoб
$				// intnoФCFG_INTꤵ줿ͥ٤
$				// TMIN_INTPRI⾮E_OBJ
				$IF INT.INTPRI[intno] < TMIN_INTPRI$
					$ERROR INT.TEXT_LINE[intno]$E_OBJ: $FORMAT(_("%1% `%2%\' configured for %3% `%4%\' is higher than %5%"), "intpri", INT.INTPRI[intno], "inhno", INH.INHNO[inhno], "TMIN_INTPRI")$$END$
				$END$
			$ELSE$
$				// inhatrTA_NONKERNELꤵƤꡤinhnoб
$				// intnoФCFG_INTꤵ줿ͥ٤
$				// TMIN_INTPRIʾǤE_OBJ
				$IF INT.INTPRI[intno] >= TMIN_INTPRI$
					$ERROR INT.TEXT_LINE[intno]$E_OBJ: $FORMAT(_("%1% `%2%\' configured for %3% `%4%\' is lower than or equal to %5%"), "intpri", INT.INTPRI[intno], "inhno", INH.INHNO[inhno], "TMIN_INTPRI")$$END$
				$END$
			$END$
		$END$
	$END$
	$i = i + 1$
$END$

$ ߥӥ롼ISRˤ˴ؤ륨顼å
$FOREACH order ISR.ORDER_LIST$
$	// isratrTA_NULLˤǤʤE_RSATR
	$IF (ISR.ISRATR[order] & ~TARGET_ISRATR) != 0$
		$ERROR ISR.TEXT_LINE[order]$E_RSATR: $FORMAT(_("illegal %1% `%2%\' in %3%"), "isratr", ISR.ISRATR[order], "ATT_ISR")$$END$
	$END$

$	// intnoATT_ISRФֹȤʤE_PAR
	$IF !LENGTH(FIND(INTNO_ATTISR_VALID, ISR.INTNO[order]))$
		$ERROR ISR.TEXT_LINE[order]$E_PAR: $FORMAT(_("illegal %1% `%2%\' in %3%"), "intno", ISR.INTNO[order], "ATT_ISR")$$END$
	$END$

$	// (TMIN_ISRPRI <= isrpri && isrpri <= TMAX_ISRPRI)ǤʤE_PAR
	$IF !(TMIN_ISRPRI <= ISR.ISRPRI[order] && ISR.ISRPRI[order] <= TMAX_ISRPRI)$
		$ERROR ISR.TEXT_LINE[order]$E_PAR: $FORMAT(_("illegal %1% `%2%\' in %3%"), "isrpri", ISR.ISRPRI[order], "ATT_ISR")$$END$
	$END$
$END$

$FOREACH intno INTNO_ATTISR_VALID$
	$inhno = INHNO[intno]$

$	// ֹintnoФϿ줿ISRΥꥹȤκ
	$isr_order_list = {}$
	$FOREACH order ISR.ORDER_LIST$
		$IF ISR.INTNO[order] == intno$
			$isr_order_list = APPEND(isr_order_list, order)$
			$order_for_error = order$
		$END$
	$END$

$	// ֹintnoФϿ줿ISR¸ߤ
	$IF LENGTH(isr_order_list) > 0$
$		// intnoбinhnoФDEF_INHE_OBJ
		$IF LENGTH(INH.INHNO[inhno])$
			$ERROR ISR.TEXT_LINE[order_for_error]$E_OBJ: $FORMAT(_("%1% `%2%\' in %3% is duplicated with %4% `%5%\'"), "intno", ISR.INTNO[order_for_error], "ATT_ISR", "inhno", INH.INHNO[inhno])$$END$
		$END$

$		// intnoФCFG_INTʤE_OBJ
		$IF !LENGTH(INT.INTNO[intno])$
			$ERROR ISR.TEXT_LINE[order_for_error]$E_OBJ: $FORMAT(_("%1% `%2%\' is not configured with %3%"), "intno", ISR.INTNO[order_for_error], "CFG_INT")$$END$
		$ELSE$
$			// intnoФCFG_INTꤵ줿ͥ٤TMIN_INTPRI
$			// ⾮E_OBJ
			$IF INT.INTPRI[intno] < TMIN_INTPRI$
				$ERROR INT.TEXT_LINE[intno]$E_OBJ: $FORMAT(_("%1% `%2%\' configured for %3% `%4%\' is higher than %5%"), "intpri", INT.INTPRI[intno], "intno", ISR.INTNO[order_for_error], "TMIN_INTPRI")$$END$
			$END$
		$END$
	$END$
$END$

$ ߥӥ롼ISR˴Υǡ¤
$intno_isr_list = {}$
$FOREACH intno INTNO_ATTISR_VALID$
	$inhno = INHNO[intno]$
	$IF LENGTH(INT.INTNO[intno]) && !LENGTH(INH.INHNO[inhno])$
		$intno_isr_list = APPEND(intno_isr_list, intno)$
	$END$
$END$

$INTNO_ISR = {}$
$i = 0$
$FOREACH intno SORT(intno_isr_list, "INT.INTNO")$
	$INTNO_ISR = APPEND(INTNO_ISR, intno)$
	$ISR_QUEUE_HEADER[intno] = FORMAT("&(_kernel_isr_queue_table[%d])", i)$
	$i = i + 1$
$END$

const uint_t _kernel_tnum_isr_queue = $LENGTH(INTNO_ISR)$;$NL$
$NL$

$IF LENGTH(INTNO_ISR)$
	const ISR_ENTRY _kernel_isr_queue_list[$LENGTH(INTNO_ISR)$] = {$NL$
	$JOINEACH intno INTNO_ISR ",\n"$
		$TAB${ $intno$, $ISR_QUEUE_HEADER[intno]$ }
	$END$$NL$
	};$NL$
$ELSE$
	TOPPERS_EMPTY_LABEL(QUEUE, _kernel_isr_queue_table);$NL$
$END$$NL$

$IF LENGTH(INTNO_ISR)$
	QUEUE _kernel_isr_queue_table[$LENGTH(INTNO_ISR)$];$NL$
$ELSE$
	TOPPERS_EMPTY_LABEL(QUEUE, _kernel_isr_queue_table);$NL$
$END$$NL$

$ ߥӥ롼ISR˸ƽФΤγߥϥɥ
$FOREACH intno INTNO_ISR$
	$inhno = INHNO[intno]$

$	// DEF_INH(inhno, { TA_NULL, _kernel_inthdr_<intno> } );
	$INH.INHNO[inhno] = inhno$
	$INH.INHATR[inhno] = VALUE("TA_NULL", 0)$
	$INH.INTHDR[inhno] = CONCAT("_kernel_inthdr_", intno)$
	$INH.ORDER_LIST = APPEND(INH.ORDER_LIST, inhno)$

$	// ISRѤγߥϥɥ
	void$NL$
	_kernel_inthdr_$intno$(void)$NL$
	{$NL$
	$TAB$i_begin_int($intno$);$NL$
	$TAB$_kernel_call_isr($ISR_QUEUE_HEADER[intno]$);$NL$
	$TAB$i_end_int($intno$);$NL$
	}$NL$
	$NL$
$END$

$ ߥӥ롼ο
#define TNUM_SISR	$LENGTH(ISR.ORDER_LIST)$$NL$
#define TNUM_ISR	$LENGTH(ISR.ORDER_LIST) + num_aisrid$$NL$
$NL$

$ ߥӥ롼IDֹκ
const ID _kernel_tmax_isrid = (TMIN_ISRID + TNUM_ISRID - 1);$NL$
const uint_t _kernel_tnum_sisr = TNUM_SISR;$NL$
$NL$

$ ߥӥ롼֥å
$IF LENGTH(ISR.ORDER_LIST)$
	const ISRINIB _kernel_sisrinib_table[TNUM_SISR] = {$NL$
	$JOINEACH order ISR.ORDER_LIST ",\n"$
		$TAB${ ($ISR.ISRATR[order]$), ($ISR.EXINF[order]$), ($ISR.INTNO[order]$), ($ISR_QUEUE_HEADER[ISR.INTNO[order]]$), ($ISR.ISR[order]$), ($ISR.ISRPRI[order]$) }
	$END$$NL$
	};$NL$
$ELSE$
	TOPPERS_EMPTY_LABEL(const ISRINIB, _kernel_sisrinib_table);$NL$
$END$
$NL$

$ ưŪߥӥ롼Ѥγߥӥ롼֥
$ 
$IF num_aisrid > 0$
	ISRINIB _kernel_aisrinib_table[$num_aisrid$];$NL$
$ELSE$
	TOPPERS_EMPTY_LABEL(ISRINIB, _kernel_aisrinib_table);$NL$
$END$
$NL$

$ ߥӥ롼֥å
$IF num_isr > 0$
	ISRCB _kernel_isrcb_table[TNUM_ISR];$NL$
$ELSE$
	TOPPERS_EMPTY_LABEL(ISRCB, _kernel_isrcb_table);$NL$
$END$
$NL$

$ 
$  ߴǽΤɸŪʽ
$ 
$ ߥϥɥνɬפʾ
$IF !OMIT_INITIALIZE_INTERRUPT || ALT(USE_INHINIB_TABLE,0)$

$ ߥϥɥ
#define TNUM_INHNO	$LENGTH(INH.ORDER_LIST)$$NL$
const uint_t _kernel_tnum_inhno = TNUM_INHNO;$NL$
$NL$
$FOREACH inhno INH.ORDER_LIST$
	$IF (INH.INHATR[inhno] & TA_NONKERNEL) == 0$
		INTHDR_ENTRY($INH.INHNO[inhno]$, $+INH.INHNO[inhno]$, $INH.INTHDR[inhno]$)$NL$
	$END$
$END$
$NL$

$ ߥϥɥ֥å
$IF LENGTH(INH.ORDER_LIST)$
	const INHINIB _kernel_inhinib_table[TNUM_INHNO] = {$NL$
	$JOINEACH inhno INH.ORDER_LIST ",\n"$
		$IF (INH.INHATR[inhno] & TA_NONKERNEL) == 0$
			$TAB${ ($INH.INHNO[inhno]$), ($INH.INHATR[inhno]$), (FP)(INT_ENTRY($INH.INHNO[inhno]$, $INH.INTHDR[inhno]$)) }
		$ELSE$
			$TAB${ ($INH.INHNO[inhno]$), ($INH.INHATR[inhno]$), (FP)($INH.INTHDR[inhno]$) }
		$END$
	$END$$NL$
	};$NL$
$ELSE$
	TOPPERS_EMPTY_LABEL(const INHINIB, _kernel_inhinib_table);$NL$
$END$$NL$
$END$

$ ׵饤νɬפʾ
$IF !OMIT_INITIALIZE_INTERRUPT || ALT(USE_INTINIB_TABLE,0)$

$ ׵饤
#define TNUM_INTNO	$LENGTH(INT.ORDER_LIST)$$NL$
const uint_t _kernel_tnum_intno = TNUM_INTNO;$NL$
$NL$

$ ׵饤֥å
$IF LENGTH(INT.ORDER_LIST)$
	const INTINIB _kernel_intinib_table[TNUM_INTNO] = {$NL$
	$JOINEACH intno INT.ORDER_LIST ",\n"$
		$TAB${ ($INT.INTNO[intno]$), ($INT.INTATR[intno]$), ($INT.INTPRI[intno]$) }
	$END$$NL$
	};$NL$
$ELSE$
	TOPPERS_EMPTY_LABEL(const INTINIB, _kernel_intinib_table);$NL$
$END$$NL$
$END$

$ 
$  CPU㳰ǽ
$ 
/*$NL$
$SPC$*  CPU Exception Management Functions$NL$
$SPC$*/$NL$
$NL$

$ CPU㳰ϥɥ˴ؤ륨顼å
$i = 0$
$FOREACH excno EXC.ORDER_LIST$
$	// excnoDEF_EXCФCPU㳰ϥɥֹȤʤE_PAR
	$IF !LENGTH(FIND(EXCNO_DEFEXC_VALID, EXC.EXCNO[excno]))$
		$ERROR EXC.TEXT_LINE[excno]$E_PAR: $FORMAT(_("illegal %1% `%2%\' in %3%"), "excno", EXC.EXCNO[excno], "DEF_EXC")$$END$
	$END$

$	// excnoDEF_EXCˤäѤߤξE_OBJ
	$j = 0$
	$FOREACH excno2 EXC.ORDER_LIST$
		$IF j < i && EXC.EXCNO[excno] == EXC.EXCNO[excno2]$
			$ERROR EXC.TEXT_LINE[excno]$E_OBJ: $FORMAT(_("%1% `%2%\' in %3% is duplicated"), "excno", EXC.EXCNO[excno], "DEF_EXC")$$END$
		$END$
		$j = j + 1$
	$END$

$	// excatrTA_NULLˤǤʤE_RSATR
	$IF (EXC.EXCATR[excno] & ~TARGET_EXCATR) != 0$
		$ERROR EXC.TEXT_LINE[excno]$E_RSATR: $FORMAT(_("illegal %1% `%2%\' of %3% `%4%\' in %5%"), "excatr", EXC.EXCATR[excno], "excno", EXC.EXCNO[excno], "DEF_EXC")$$END$
	$END$
	$i = i + 1$
$END$

$ CPU㳰ϥɥΤɸŪʽ
$IF !OMIT_INITIALIZE_EXCEPTION$

$ CPU㳰ϥɥ
#define TNUM_EXCNO	$LENGTH(EXC.ORDER_LIST)$$NL$
const uint_t _kernel_tnum_excno = TNUM_EXCNO;$NL$
$NL$
$FOREACH excno EXC.ORDER_LIST$
	EXCHDR_ENTRY($EXC.EXCNO[excno]$, $+EXC.EXCNO[excno]$, $EXC.EXCHDR[excno]$)$NL$
$END$
$NL$

$ CPU㳰ϥɥ֥å
$IF LENGTH(EXC.ORDER_LIST)$
	const EXCINIB _kernel_excinib_table[TNUM_EXCNO] = {$NL$
	$JOINEACH excno EXC.ORDER_LIST ",\n"$
		$TAB${ ($EXC.EXCNO[excno]$), ($EXC.EXCATR[excno]$), (FP)(EXC_ENTRY($EXC.EXCNO[excno]$, $EXC.EXCHDR[excno]$)) }
	$END$$NL$
	};$NL$
$ELSE$
	TOPPERS_EMPTY_LABEL(const EXCINIB, _kernel_excinib_table);$NL$
$END$$NL$
$END$

$ 
$  󥿥ƥѤΥåΰ
$ 
/*$NL$
$SPC$*  Stack Area for Non-task Context$NL$
$SPC$*/$NL$
$NL$

$IF !LENGTH(ICS.ORDER_LIST)$
$	// DEF_ICSʤΥǥեͤ
	#ifdef DEFAULT_ISTK$NL$
	$NL$
	#define TOPPERS_ISTKSZ		DEFAULT_ISTKSZ$NL$
	#define TOPPERS_ISTK		DEFAULT_ISTK$NL$
	$NL$
	#else /* DEAULT_ISTK */$NL$
	$NL$
	$istksz = ALLOC_STACK("_kernel_istack", "DEFAULT_ISTKSZ")$$NL$
	#define TOPPERS_ISTKSZ		$istksz$$NL$
	#define TOPPERS_ISTK		_kernel_istack$NL$
	$NL$
	#endif /* DEAULT_ISTK */$NL$
$ELSE$

$	// ŪAPIDEF_ICSפʣE_OBJ
	$IF LENGTH(ICS.ORDER_LIST) > 1$
		$ERROR$E_OBJ: $FORMAT(_("too many %1%"), "DEF_ICS")$$END$
	$END$

$	// istksz0ʲåκǾ͡TARGET_MIN_ISTKSZˤ
$	// E_PAR
	$IF ICS.ISTKSZ[1] <= 0 || (TARGET_MIN_ISTKSZ
									&& ICS.ISTKSZ[1] < TARGET_MIN_ISTKSZ)$
		$ERROR ICS.TEXT_LINE[1]$E_PAR: $FORMAT(_("too small %1% `%2%\' in %3%"), "istksz", ICS.ISTKSZ[1], "DEF_ICS")$$END$
	$END$

$ 	// istkszåΰΥȤʤE_PAR
	$IF !EQ(ICS.ISTK[1], "NULL") && CHECK_STKSZ_ALIGN
							&& (ICS.ISTKSZ[1] & (CHECK_STKSZ_ALIGN - 1))$
		$ERROR ICS.TEXT_LINE[1]$E_PAR: $FORMAT(_("%1% `%2%\' in %3% is not aligned"), "istksz", ICS.ISTKSZ[1], "DEF_ICS")$$END$
	$END$

	$IF EQ(ICS.ISTK[1], "NULL")$
$		// åΰμưդ
		$istksz = ALLOC_STACK("_kernel_istack", ICS.ISTKSZ[1])$$NL$
		#define TOPPERS_ISTKSZ		$istksz$$NL$
		#define TOPPERS_ISTK		_kernel_istack$NL$
	$ELSE$
		#define TOPPERS_ISTKSZ		($ICS.ISTKSZ[1]$)$NL$
		#define TOPPERS_ISTK		(void *)($ICS.ISTK[1]$)$NL$
	$END$
$END$
$NL$

$ 󥿥ƥѤΥåΰ
const SIZE		_kernel_istksz = TOPPERS_ISTKSZ;$NL$
STK_T *const	_kernel_istk = TOPPERS_ISTK;$NL$
$NL$
#ifdef TOPPERS_ISTKPT$NL$
STK_T *const	_kernel_istkpt = TOPPERS_ISTKPT(TOPPERS_ISTK, TOPPERS_ISTKSZ);$NL$
#endif /* TOPPERS_ISTKPT */$NL$
$NL$

$ 
$  ͥ뤬դΰ
$ 
/*$NL$
$SPC$*  Memory Area Allocated by Kernel$NL$
$SPC$*/$NL$
$NL$

$IF !LENGTH(KMM.ORDER_LIST)$
$	// DEF_KMMʤΥǥեͤ
	#define TOPPERS_KMMSZ		0$NL$
	#define TOPPERS_KMM			NULL$NL$
$ELSE$
$	// ŪAPIDEF_KMMפʣE_OBJ
	$IF LENGTH(KMM.ORDER_LIST) > 1$
		$ERROR$E_OBJ: $FORMAT(_("too many %1%"), "DEF_KMM")$$END$
	$END$

$	// kmmsz0ʲξE_PAR
	$IF KMM.KMMSZ[1] <= 0$
		$ERROR KMM.TEXT_LINE[1]$E_PAR: $FORMAT(_("%1% `%2%\' is zero in %3%"), "kmmsz", KMM.KMMSZ[1], "DEF_KMM")$$END$
	$END$

$ 	// kmmszͥ뤬դΰΥȤʤE_PAR
	$IF !EQ(KMM.KMM[1], "NULL") && CHECK_MB_ALIGN
							&& (KMM.KMMSZ[1] & (CHECK_MB_ALIGN - 1))$
		$ERROR KMM.TEXT_LINE[1]$E_PAR: $FORMAT(_("%1% `%2%\' in %3% is not aligned"), "kmmsz", KMM.KMMSZ[1], "DEF_KMM")$$END$
	$END$

	$IF EQ(KMM.KMM[1], "NULL")$
$		// ͥ뤬դΰμưդ
		static MB_T					_kernel_memory[TOPPERS_COUNT_SZ($KMM.KMMSZ[1]$, sizeof(MB_T))];$NL$
		#define TOPPERS_KMMSZ		TOPPERS_ROUND_SZ($KMM.KMMSZ[1]$, sizeof(MB_T))$NL$
		#define TOPPERS_KMM			_kernel_memory$NL$
	$ELSE$
		#define TOPPERS_KMMSZ		($KMM.KMMSZ[1]$)$NL$
		#define TOPPERS_KMM			(void *)($KMM.KMM[1]$)$NL$
	$END$
$END$
$NL$

$ ͥ뤬դΰ
const SIZE		_kernel_kmmsz = TOPPERS_KMMSZ;$NL$
MB_T *const		_kernel_kmm = TOPPERS_KMM;$NL$
$NL$

$ 
$  ।٥ȴ
$ 
/*$NL$
$SPC$*  Time Event Management$NL$
$SPC$*/$NL$
$NL$
TMEVTN   _kernel_tmevt_heap[TNUM_TSKID + TNUM_CYCID + TNUM_ALMID];$NL$
$NL$

$ 
$  ƥ⥸塼νؿ
$ 
/*$NL$
$SPC$*  Module Initialization Function$NL$
$SPC$*/$NL$
$NL$
void$NL$
_kernel_initialize_object(void)$NL$
{$NL$
$TAB$_kernel_initialize_task();$NL$
$IF num_semid$$TAB$_kernel_initialize_semaphore();$NL$$END$
$IF num_flgid$$TAB$_kernel_initialize_eventflag();$NL$$END$
$IF num_dtqid$$TAB$_kernel_initialize_dataqueue();$NL$$END$
$IF num_pdqid$$TAB$_kernel_initialize_pridataq();$NL$$END$
$IF num_mbxid$$TAB$_kernel_initialize_mailbox();$NL$$END$
$IF num_mpfid$$TAB$_kernel_initialize_mempfix();$NL$$END$
$IF num_cycid$$TAB$_kernel_initialize_cyclic();$NL$$END$
$IF num_almid$$TAB$_kernel_initialize_alarm();$NL$$END$
$TAB$_kernel_initialize_interrupt();$NL$
$IF num_isr$$TAB$_kernel_initialize_isr();$NL$$END$
$TAB$_kernel_initialize_exception();$NL$
}$NL$
$NL$

$ 
$  롼μ¹Դؿ
$ 
/*$NL$
$SPC$*  Initialization Routine$NL$
$SPC$*/$NL$
$NL$
void$NL$
_kernel_call_inirtn(void)$NL$
{$NL$
$FOREACH order INI.ORDER_LIST$
$ 	// iniatrTA_NULLˤǤʤE_RSATR
	$IF INI.INIATR[order] != 0$
		$ERROR INI.TEXT_LINE[order]$E_RSATR: $FORMAT(_("illegal %1% `%2%\' of %3% `%4%\' in %5%"), "iniatr", INI.INIATR[order], "inirtn", INI.INIRTN[order], "ATT_INI")$$END$
	$END$
	$TAB$((INIRTN)($INI.INIRTN[order]$))((intptr_t)($INI.EXINF[order]$));$NL$
$END$
}$NL$
$NL$

$ 
$  λ롼μ¹Դؿ
$ 
/*$NL$
$SPC$*  Termination Routine$NL$
$SPC$*/$NL$
$NL$
void$NL$
_kernel_call_terrtn(void)$NL$
{$NL$
$FOREACH rorder TER.RORDER_LIST$
$ 	// teratrTA_NULLˤǤʤE_RSATR
	$IF TER.TERATR[rorder] != 0$
		$ERROR TER.TEXT_LINE[rorder]$E_RSATR: $FORMAT(_("illegal %1% `%2%\' of %3% `%4%\' in %5%"), "teratr", TER.TERATR[rorder], "terrtn", TER.TERRTN[rorder], "ATT_TER")$$END$
	$END$
	$TAB$((TERRTN)($TER.TERRTN[rorder]$))((intptr_t)($TER.EXINF[rorder]$));$NL$
$END$
}$NL$
$NL$
