/*
 *  TOPPERS Software
 *      Toyohashi Open Platform for Embedded Real-Time Systems
 * 
 *  Copyright (C) 2008-2014 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ(1)(4)ξ˸¤ꡤܥեȥ
 *  ܥեȥѤΤޤࡥʲƱˤѡʣ
 *  ѡۡʰʲѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *      ޤܥեȥΥ桼ޤϥɥ桼Τʤ
 *      ͳ˴Ťᤫ⡤嵭ԤTOPPERSץȤ
 *      դ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơλŪ
 *  ФŬޤơʤݾڤԤʤޤܥեȥ
 *  ѤˤľŪޤϴŪʤ»˴ؤƤ⡤
 *  Ǥʤ
 * 
 *  $Id$
 */

/* 
 *		ޥեǽΥƥ(1)
 *
 * ڥƥȤŪ
 *
 *  sig_semwai_semCRE_SEMŪ˥ƥȤ롥
 *  CRE_SEMΥ顼ΥƥȤϽ
 *
 * ڥƥȹܡ
 *
 *	(A) sig_semŪ顼Υƥ
 *		(A-1) 󥿥ƥȤθƽФ
 *		(A-2) CPUå֤θƽФ
 *		(A-3) semidʾ
 *		(A-4) semid礭
 *	(B) sig_semˤꥻޥեԤ֤ΥԤ
 *		(B-1) Ԥ줿ڤ괹
 *		(B-2) ǥѥåα֤ǡڤ괹ʤ
 *		(B-3) Ԥ줿Ԥ֤ǡڤ괹ʤ
 *		(B-4) Ԥ줿ͥ٤㤯ڤ괹ʤ
 *	(C) sig_semˤꥻޥեλ񸻿1
 *		(C-1) ޥեλ񸻿01ˤʤ
 *		(C-2) ޥեλ񸻿12ˤʤ
 *	(D) sig_semE_QOVR顼Ȥʤ
 *		(D-1) ޥեκ񸻿1λ
 *		(D-2) ޥեκ񸻿2λ
 *	(E) wai_semŪ顼Υƥ
 *		(E-1) 󥿥ƥȤθƽФ
 *		(E-2) CPUå֤θƽФ
 *		(E-3) ǥѥåػ߾֤θƽФ
 *		(E-4) ͥ٥ޥǤʤ֤θƽФ
 *		(E-5) semidʾ
 *		(E-6) semid礭
 *	(F) wai_semˤꥻޥեλ񸻿1
 *		(F-1) ޥեλ񸻿10ˤʤ
 *		(F-2) ޥեλ񸻿21ˤʤ
 *	(G) wai_semˤꥻޥեԤ֤ˤʤ
 *		(G-1) TA_TNULL°ΥޥեǡԤäƤ륿ʤä
 *		(G-2) TA_TNULL°ΥޥեǡԤäƤ륿ä
 *		(G-3) TA_TPRI°ΥޥեǡԤäƤ륿ʤä
 *		(G-4) TA_TPRI°Υޥեǡͥ٤⤤ԤäƤ
 *		(G-5) TA_TPRI°Υޥեǡͥ٤ƱԤäƤ
 *		(G-6) TA_TPRI°Υޥեǡͥ٤㤤ԤäƤ
 *	(H) ޥեԤ֤
 *	(I) ޥեԤ֤δ֤˥ޥե
 *	(J) ޥեλ񸻿νͤꤵ
 *		(J-1) ޥեλ񸻿νͤ0
 *		(J-2) ޥեλ񸻿νͤ1
 *		(J-3) ޥեλ񸻿νͤ2
 *
 * ڻѥ꥽
 *
 *	TASK1: ͥ٥TA_ACT°
 *	TASK2: ͥ٥
 *	TASK3: ͥ٥
 *	TASK4: ͥ٥
 *	TASK5: ͥ٥
 *	ALM1:  顼ϥɥ
 *  SEM1:  TA_NULL°񸻿1񸻿1
 *  SEM2:  TA_NULL°񸻿2񸻿2
 *  SEM3:  TA_TPRI°񸻿0񸻿1
 *
 * ڥƥȥ󥹡
 *
 *	== TASK1ͥ١==
 *  1:	ref_sem(SEM1, &rsem)
 *		assert(rsem.wtskid == TSK_NONE)
 *		assert(rsem.semcnt == 1)			... (J-2)
 *  	ref_sem(SEM2, &rsem)
 *		assert(rsem.wtskid == TSK_NONE)
 *		assert(rsem.semcnt == 2)			... (J-3)
 *  	ref_sem(SEM3, &rsem)
 *		assert(rsem.wtskid == TSK_NONE)
 *		assert(rsem.semcnt == 0)			... (J-1)
 *	2:	loc_cpu()
 *		sig_sem(SEM1) -> E_CTX				... (A-2)
 *		wai_sem(SEM1) -> E_CTX				... (E-2)
 *		unl_cpu()
 *		dis_dsp()
 *		wai_sem(SEM1) -> E_CTX				... (E-3)
 *		ena_dsp()
 *		chg_ipm(TMAX_INTPRI)
 *		wai_sem(SEM1) -> E_CTX				... (E-4)
 *		chg_ipm(TIPM_ENAALL)
 *		sig_sem(0) -> E_ID					... (A-3)
 *		wai_sem(0) -> E_ID					... (E-5)
 *		sig_sem(TNUM_SEMID+1) -> E_ID		... (A-4)
 *		wai_sem(TNUM_SEMID+1) -> E_ID		... (E-6)
 *	3:	act_tsk(TASK3)
 *	4:	slp_tsk()
 *	== TASK3ͥ١==
 *	5:	wai_sem(SEM1)						... (F-1)
 *  6:	ref_sem(SEM1, &rsem)
 *		assert(rsem.wtskid == TSK_NONE)
 *		assert(rsem.semcnt == 0)
 *	7:	sta_alm(ALM1, 10)
 *	8:	wai_sem(SEM1)						... (G-1)
 *	== ALM1 ==
 *	9:	sig_sem(SEM1) -> E_CTX				... (A-1)
 *		wai_sem(SEM1) -> E_CTX				... (E-1)
 *	10:	iwup_tsk(TASK1)
 *	11:	RETURN
 *	== TASK1³==
 *	12:	act_tsk(TASK2)
 *	== TASK2ͥ١==
 *	13:	wai_sem(SEM1)						... (G-2)
 *	== TASK1³==
 *  14:	ref_sem(SEM1, &rsem)
 *		assert(rsem.wtskid == TASK3)
 *		assert(rsem.semcnt == 0)
 *	15:	sig_sem(SEM1)						... (B-4)
 *	16:	sig_sem(SEM1)						... (B-1)
 *	== TASK2³==
 *	17:	wai_sem(SEM1)						... (G-1)
 *	== TASK1³==
 *	18: dis_dsp()
 *	19:	sig_sem(SEM1)						... (B-2)
 *	20:	ena_dsp()
 *	== TASK2³==
 *	21:	wai_sem(SEM1)						... (G-1)
 *	== TASK1³==
 *	22: sus_tsk(TASK2)
 *	23:	sig_sem(SEM1)						... (B-3)
 *	24: sig_sem(SEM1)						... (C-1)
 *	25: sig_sem(SEM1) -> E_QOVR				... (D-1)
 *  26:	ref_sem(SEM1, &rsem)
 *		assert(rsem.wtskid == TSK_NONE)
 *		assert(rsem.semcnt == 1)
 *	27:	rsm_tsk(TASK2)
 *	== TASK2³==
 *	28:	wai_sem(SEM2)						... (F-2)
 *  29:	ref_sem(SEM2, &rsem)
 *		assert(rsem.wtskid == TSK_NONE)
 *		assert(rsem.semcnt == 1)
 *	30:	wai_sem(SEM2)						... (F-1)
 *	31: wai_sem(SEM2)						... (G-1)
 *	== TASK1³==
 *	32:	sig_sem(SEM2)						... (B-1)
 *	== TASK2³==
 *	33:	wai_sem(SEM3)						... (G-3)
 *	== TASK1³==
 *	34:	sig_sem(SEM2)						... (C-1)
 *	35:	sig_sem(SEM2)						... (C-2)
 *  36:	ref_sem(SEM2, &rsem)
 *		assert(rsem.wtskid == TSK_NONE)
 *		assert(rsem.semcnt == 2)
 *	37:	sig_sem(SEM2) -> E_QOVR				... (D-2)
 *  38:	ref_sem(SEM2, &rsem)
 *		assert(rsem.wtskid == TSK_NONE)
 *		assert(rsem.semcnt == 2)
 *	39:	tslp_tsk(10) -> E_TMOUT
 *	== TASK3³==
 *	40:	wai_sem(SEM3)						... (G-4)
 *	== TASK1³==
 *	41:	act_tsk(TASK4)
 *	42:	act_tsk(TASK5)
 *	43:	rot_rdq(TPRI_SELF)
 *	== TASK4ͥ١==
 *	44:	wai_sem(SEM3)						... (G-6)
 *	== TASK5ͥ١==
 *	45:	wai_sem(SEM3)						... (G-5)
 *	== TASK1³==
 *	46:	sig_sem(SEM3)						... (B-1)
 *	== TASK2³==
 *	47:	wai_sem(SEM1)
 *		wai_sem(SEM1) -> E_RLWAI
 *	== TASK1³==
 *	48:	sig_sem(SEM3)						... (B-4)
 *	49:	tslp_tsk(10) -> E_TMOUT
 *	== TASK4³==
 *	50:	ext_tsk() -> noreturn
 *	== TASK1³==
 *	51:	sig_sem(SEM3)						... (B-4)
 *	52:	tslp_tsk(10) -> E_TMOUT
 *	== TASK5³==
 *	53:	ext_tsk() -> noreturn
 *	== TASK1³==
 *	54:	sig_sem(SEM3)						... (B-4)
 *	55:	tslp_tsk(10) -> E_TMOUT
 *	== TASK3³==
 *	56:	ext_tsk() -> noreturn
 *	== TASK1³==
 *	57: rel_wai(TASK2)						... (H)
 *	== TASK2³==
 *	58:	wai_sem(SEM1) -> E_DLT
 *	== TASK1³==
 *	59: ini_sem(SEM1)						... (I)
 *	== TASK2³==
 *	60: ext_tsk() -> noreturn
 *	== TASK1³==
 *	61: END
 */

#include <kernel.h>
#include <test_lib.h>
#include <t_syslog.h>
#include "kernel_cfg.h"
#include "test_sem1.h"

/* DO NOT DELETE THIS LINE -- gentest depends on it. */

void
alarm1_handler(intptr_t exinf)
{
	ER_UINT	ercd;

	check_point(9);
	ercd = sig_sem(SEM1);
	check_ercd(ercd, E_CTX);

	ercd = wai_sem(SEM1);
	check_ercd(ercd, E_CTX);

	check_point(10);
	ercd = iwup_tsk(TASK1);
	check_ercd(ercd, E_OK);

	check_point(11);
	return;

	check_point(0);
}

void
task1(intptr_t exinf)
{
	ER_UINT	ercd;
	T_RSEM	rsem;

	test_start(__FILE__);

	check_point(1);
	ercd = ref_sem(SEM1, &rsem);
	check_ercd(ercd, E_OK);

	check_assert(rsem.wtskid == TSK_NONE);

	check_assert(rsem.semcnt == 1);

	ercd = ref_sem(SEM2, &rsem);
	check_ercd(ercd, E_OK);

	check_assert(rsem.wtskid == TSK_NONE);

	check_assert(rsem.semcnt == 2);

	ercd = ref_sem(SEM3, &rsem);
	check_ercd(ercd, E_OK);

	check_assert(rsem.wtskid == TSK_NONE);

	check_assert(rsem.semcnt == 0);

	check_point(2);
	ercd = loc_cpu();
	check_ercd(ercd, E_OK);

	ercd = sig_sem(SEM1);
	check_ercd(ercd, E_CTX);

	ercd = wai_sem(SEM1);
	check_ercd(ercd, E_CTX);

	ercd = unl_cpu();
	check_ercd(ercd, E_OK);

	ercd = dis_dsp();
	check_ercd(ercd, E_OK);

	ercd = wai_sem(SEM1);
	check_ercd(ercd, E_CTX);

	ercd = ena_dsp();
	check_ercd(ercd, E_OK);

	ercd = chg_ipm(TMAX_INTPRI);
	check_ercd(ercd, E_OK);

	ercd = wai_sem(SEM1);
	check_ercd(ercd, E_CTX);

	ercd = chg_ipm(TIPM_ENAALL);
	check_ercd(ercd, E_OK);

	ercd = sig_sem(0);
	check_ercd(ercd, E_ID);

	ercd = wai_sem(0);
	check_ercd(ercd, E_ID);

	ercd = sig_sem(TNUM_SEMID+1);
	check_ercd(ercd, E_ID);

	ercd = wai_sem(TNUM_SEMID+1);
	check_ercd(ercd, E_ID);

	check_point(3);
	ercd = act_tsk(TASK3);
	check_ercd(ercd, E_OK);

	check_point(4);
	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(12);
	ercd = act_tsk(TASK2);
	check_ercd(ercd, E_OK);

	check_point(14);
	ercd = ref_sem(SEM1, &rsem);
	check_ercd(ercd, E_OK);

	check_assert(rsem.wtskid == TASK3);

	check_assert(rsem.semcnt == 0);

	check_point(15);
	ercd = sig_sem(SEM1);
	check_ercd(ercd, E_OK);

	check_point(16);
	ercd = sig_sem(SEM1);
	check_ercd(ercd, E_OK);

	check_point(18);
	ercd = dis_dsp();
	check_ercd(ercd, E_OK);

	check_point(19);
	ercd = sig_sem(SEM1);
	check_ercd(ercd, E_OK);

	check_point(20);
	ercd = ena_dsp();
	check_ercd(ercd, E_OK);

	check_point(22);
	ercd = sus_tsk(TASK2);
	check_ercd(ercd, E_OK);

	check_point(23);
	ercd = sig_sem(SEM1);
	check_ercd(ercd, E_OK);

	check_point(24);
	ercd = sig_sem(SEM1);
	check_ercd(ercd, E_OK);

	check_point(25);
	ercd = sig_sem(SEM1);
	check_ercd(ercd, E_QOVR);

	check_point(26);
	ercd = ref_sem(SEM1, &rsem);
	check_ercd(ercd, E_OK);

	check_assert(rsem.wtskid == TSK_NONE);

	check_assert(rsem.semcnt == 1);

	check_point(27);
	ercd = rsm_tsk(TASK2);
	check_ercd(ercd, E_OK);

	check_point(32);
	ercd = sig_sem(SEM2);
	check_ercd(ercd, E_OK);

	check_point(34);
	ercd = sig_sem(SEM2);
	check_ercd(ercd, E_OK);

	check_point(35);
	ercd = sig_sem(SEM2);
	check_ercd(ercd, E_OK);

	check_point(36);
	ercd = ref_sem(SEM2, &rsem);
	check_ercd(ercd, E_OK);

	check_assert(rsem.wtskid == TSK_NONE);

	check_assert(rsem.semcnt == 2);

	check_point(37);
	ercd = sig_sem(SEM2);
	check_ercd(ercd, E_QOVR);

	check_point(38);
	ercd = ref_sem(SEM2, &rsem);
	check_ercd(ercd, E_OK);

	check_assert(rsem.wtskid == TSK_NONE);

	check_assert(rsem.semcnt == 2);

	check_point(39);
	ercd = tslp_tsk(10);
	check_ercd(ercd, E_TMOUT);

	check_point(41);
	ercd = act_tsk(TASK4);
	check_ercd(ercd, E_OK);

	check_point(42);
	ercd = act_tsk(TASK5);
	check_ercd(ercd, E_OK);

	check_point(43);
	ercd = rot_rdq(TPRI_SELF);
	check_ercd(ercd, E_OK);

	check_point(46);
	ercd = sig_sem(SEM3);
	check_ercd(ercd, E_OK);

	check_point(48);
	ercd = sig_sem(SEM3);
	check_ercd(ercd, E_OK);

	check_point(49);
	ercd = tslp_tsk(10);
	check_ercd(ercd, E_TMOUT);

	check_point(51);
	ercd = sig_sem(SEM3);
	check_ercd(ercd, E_OK);

	check_point(52);
	ercd = tslp_tsk(10);
	check_ercd(ercd, E_TMOUT);

	check_point(54);
	ercd = sig_sem(SEM3);
	check_ercd(ercd, E_OK);

	check_point(55);
	ercd = tslp_tsk(10);
	check_ercd(ercd, E_TMOUT);

	check_point(57);
	ercd = rel_wai(TASK2);
	check_ercd(ercd, E_OK);

	check_point(59);
	ercd = ini_sem(SEM1);
	check_ercd(ercd, E_OK);

	check_finish(61);
	check_point(0);
}

void
task2(intptr_t exinf)
{
	ER_UINT	ercd;
	T_RSEM	rsem;

	check_point(13);
	ercd = wai_sem(SEM1);
	check_ercd(ercd, E_OK);

	check_point(17);
	ercd = wai_sem(SEM1);
	check_ercd(ercd, E_OK);

	check_point(21);
	ercd = wai_sem(SEM1);
	check_ercd(ercd, E_OK);

	check_point(28);
	ercd = wai_sem(SEM2);
	check_ercd(ercd, E_OK);

	check_point(29);
	ercd = ref_sem(SEM2, &rsem);
	check_ercd(ercd, E_OK);

	check_assert(rsem.wtskid == TSK_NONE);

	check_assert(rsem.semcnt == 1);

	check_point(30);
	ercd = wai_sem(SEM2);
	check_ercd(ercd, E_OK);

	check_point(31);
	ercd = wai_sem(SEM2);
	check_ercd(ercd, E_OK);

	check_point(33);
	ercd = wai_sem(SEM3);
	check_ercd(ercd, E_OK);

	check_point(47);
	ercd = wai_sem(SEM1);
	check_ercd(ercd, E_OK);

	ercd = wai_sem(SEM1);
	check_ercd(ercd, E_RLWAI);

	check_point(58);
	ercd = wai_sem(SEM1);
	check_ercd(ercd, E_DLT);

	check_point(60);
	ercd = ext_tsk();

	check_point(0);
}

void
task3(intptr_t exinf)
{
	ER_UINT	ercd;
	T_RSEM	rsem;

	check_point(5);
	ercd = wai_sem(SEM1);
	check_ercd(ercd, E_OK);

	check_point(6);
	ercd = ref_sem(SEM1, &rsem);
	check_ercd(ercd, E_OK);

	check_assert(rsem.wtskid == TSK_NONE);

	check_assert(rsem.semcnt == 0);

	check_point(7);
	ercd = sta_alm(ALM1, 10);
	check_ercd(ercd, E_OK);

	check_point(8);
	ercd = wai_sem(SEM1);
	check_ercd(ercd, E_OK);

	check_point(40);
	ercd = wai_sem(SEM3);
	check_ercd(ercd, E_OK);

	check_point(56);
	ercd = ext_tsk();

	check_point(0);
}

void
task4(intptr_t exinf)
{
	ER_UINT	ercd;

	check_point(44);
	ercd = wai_sem(SEM3);
	check_ercd(ercd, E_OK);

	check_point(50);
	ercd = ext_tsk();

	check_point(0);
}

void
task5(intptr_t exinf)
{
	ER_UINT	ercd;

	check_point(45);
	ercd = wai_sem(SEM3);
	check_ercd(ercd, E_OK);

	check_point(53);
	ercd = ext_tsk();

	check_point(0);
}
