/*
 *  TOPPERS Software
 *      Toyohashi Open Platform for Embedded Real-Time Systems
 * 
 *  Copyright (C) 2007-2013 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ(1)(4)ξ˸¤ꡤܥեȥ
 *  ܥեȥѤΤޤࡥʲƱˤѡʣ
 *  ѡۡʰʲѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *      ޤܥեȥΥ桼ޤϥɥ桼Τʤ
 *      ͳ˴Ťᤫ⡤嵭ԤTOPPERSץȤ
 *      դ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơλŪ
 *  ФŬޤơʤݾڤԤʤޤܥեȥ
 *  ѤˤľŪޤϴŪʤ»˴ؤƤ⡤
 *  Ǥʤ
 * 
 *  $Id$
 */

/* 
 *		CPU㳰Υƥ(7)
 *
 * ڥƥȤŪ
 *
 *  ͥ٥ޥTIPM_ENAALLǥѥåػ߾֡㳰
 *  ľ֤ȯCPU㳰ˤ륷ƥ֤Υƥȡ㳰ˤ
 *  ꥫХ꡼Ǥ뤳ȤƥȤ롥
 *
 * ڥƥȹܡ
 *
 *  ⡤ͥ٥ޥTIPM_ENAALLǥѥåػ߾֡
 *  㳰ľ֤ȯCPU㳰ˤơ
 *
 *	(A) CPU㳰ϥɥ¹ԳϻCPUåե饰Ѳʤ
 *	(B) CPU㳰ϥɥ¹Գϻ˳ͥ٥ޥѲʤ
 *		CPU㳰ϥɥǳͥ٥ޥɤʤᡤƥȤ
 *		ʤ
 *	(C) CPU㳰ϥɥ¹Գϻ˥ǥѥåػߥե饰Ѳʤ
 *	(D) CPU㳰ϥɥ¹Գϻ˥㳰ػߥե饰Ѳʤ
 *	(E) CPU㳰ϥɥ꥿CPUåե饰뤳
 *	(F) CPU㳰ϥɥ꥿˳ͥ٥ޥ뤳
 *	(G) CPU㳰ϥɥ꥿˥ǥѥåػߥե饰Ѳʤ
 *	(H) CPU㳰ϥɥ꥿˥㳰ػߥե饰Ѳʤ
 *	(I) xsns_xpnfalse֤
 *	(J) xsns_dpntrue֤
 *	(L) 㳰ˤꥫХ꡼Ǥ뤳
 *
 * ڻѥ꥽
 *
 *	TASK1: TA_ACTͥ١㳰롼Ͽ
 *	CPUEXC1: TA_NULL
 *
 * ڥƥȥ󥹡
 *
 *	== TASK1ͥ١1ܡ==
 *	1:	֤Υå
 *		dis_dsp()
 *		ena_tex()
 *	2:	֤Υå
 *		RAISE_CPU_EXCEPTION
 *	== CPUEXC1 ==
 *	3:	֤Υå				... (A),(C),(D)
 *		xsns_xpn() == false			... (I)
 *		xsns_dpn() == true			... (J)
 *	4:	iras_tex(TASK1, 1U)
 *		iloc_cpu()
 *		꥿
 *	== TASK1Υ㳰롼 ==
 *	5:	֤Υå				... (E),(F),(G),(H)
 *	6:	act_tsk(TASK1)				... (L)
 *	7:	ext_tsk()					... (L)
 *	== TASK1ͥ١2ܡ==
 *	8:	֤Υå				... (L)
 *	9:	ƥȽλ
 */

#include <kernel.h>
#include <test_lib.h>
#include <t_syslog.h>
#include "kernel_cfg.h"
#include "test_cpuexc.h"

int_t	task1_count = 0;

void
task1(intptr_t exinf)
{
	ER		ercd;

	switch (++task1_count) {
	case 1:
		test_start(__FILE__);

		check_point(1);
		check_state(false, false, TIPM_ENAALL, false, false, true);
		ercd = dis_dsp();
		check_ercd(ercd, E_OK);
		ercd = ena_tex();
		check_ercd(ercd, E_OK);

		check_point(2);
		check_state(false, false, TIPM_ENAALL, true, true, false);
		RAISE_CPU_EXCEPTION;

		check_point(0);
		break;

	case 2:
		check_point(8);
		check_state(false, false, TIPM_ENAALL, false, false, true);

		check_finish(9);
		break;

	default:
		check_point(0);
		break;
	}
}

void
tex_task1(TEXPTN texptn, intptr_t exinf)
{
	ER		ercd;

	check_point(5);
	check_state(false, false, TIPM_ENAALL, true, true, true);

	check_point(6);
	ercd = act_tsk(TASK1);
	check_ercd(ercd, E_OK);

	check_point(7);
	ercd = ext_tsk();
	check_ercd(ercd, E_OK);

	check_point(0);
}

void
task2(intptr_t exinf)
{
	check_point(0);
}

void
alarm1_handler(intptr_t exinf)
{
	check_point(0);
}

void
cpuexc_handler(void *p_excinf)
{
	ER		ercd;

	check_point(3);
	check_state_i(true, false, true, true, false);
	check_assert(xsns_xpn(p_excinf) == false);
	check_assert(xsns_dpn(p_excinf) == true);

	check_point(4);
	ercd = iras_tex(TASK1, 1U);
	check_ercd(ercd, E_OK);
	ercd = iloc_cpu();
	check_ercd(ercd, E_OK);
}
