/*
 *  TOPPERS Software
 *      Toyohashi Open Platform for Embedded Real-Time Systems
 * 
 *  Copyright (C) 2007-2013 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ(1)(4)ξ˸¤ꡤܥեȥ
 *  ܥեȥѤΤޤࡥʲƱˤѡʣ
 *  ѡۡʰʲѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *      ޤܥեȥΥ桼ޤϥɥ桼Τʤ
 *      ͳ˴Ťᤫ⡤嵭ԤTOPPERSץȤ
 *      դ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơλŪ
 *  ФŬޤơʤݾڤԤʤޤܥեȥ
 *  ѤˤľŪޤϴŪʤ»˴ؤƤ⡤
 *  Ǥʤ
 * 
 *  $Id$
 */

/* 
 *		CPU㳰Υƥ(5)
 *
 * ڥƥȤŪ
 *
 *  ƥȡåCPUå֤ȯCPU㳰
 *  ˤ륷ƥ֤Υƥȡͥ٥ޥTIPM_ENAALLǥ
 *  ѥåػ߾֡㳰ľ֤ǥƥȤ롥
 *
 * ڥƥȹܡ
 *
 *  ⡤ƥȡåCPUå֤ȯ
 *  CPU㳰ˤơ
 *
 *	(A) CPU㳰ϥɥ¹ԳϻCPUåե饰Ѳʤ
 *	(B) CPU㳰ϥɥ¹Գϻ˳ͥ٥ޥѲʤ
 *		CPU㳰ϥɥǳͥ٥ޥɤʤᡤƥȤ
 *		ʤ
 *	(C) CPU㳰ϥɥ¹Գϻ˥ǥѥåػߥե饰Ѳʤ
 *	(D) CPU㳰ϥɥ¹Գϻ˥㳰ػߥե饰Ѳʤ
 *	(E) CPU㳰ϥɥ꥿CPUåե饰뤳
 *		CPU㳰ϥɥ餫꥿ǤΤߥƥȤ롥
 *	(F) CPU㳰ϥɥ꥿˳ͥ٥ޥ뤳
 *		CPU㳰ϥɥ餫꥿ǤΤߥƥȤ롥
 *	(G) CPU㳰ϥɥ꥿˥ǥѥåػߥե饰Ѳʤ
 *		CPU㳰ϥɥ餫꥿ǤΤߥƥȤ롥
 *	(H) CPU㳰ϥɥ꥿˥㳰ػߥե饰Ѳʤ
 *		CPU㳰ϥɥ餫꥿ǤΤߥƥȤ롥
 *	(I) xsns_xpntrue֤
 *	(J) xsns_dpntrue֤
 *
 * ڻѥ꥽
 *
 *	TASK1: TA_ACTͥ١㳰롼Ͽ
 *	CPUEXC1: TA_NULL
 *
 * ڥƥȥ󥹡
 *
 *	== TASK1ͥ١==
 *	1:	֤Υå
 *		dis_dsp()
 *		ena_tex()
 *		loc_cpu()
 *	2:	֤Υå
 *		RAISE_CPU_EXCEPTION
 *	== CPUEXC1 ==
 *	3:	֤Υå				... (A)(C)(D)
 *		xsns_xpn() == true			... (I)
 *		xsns_dpn() == true			... (J)
 *	4:	CPU㳰ϥɥ餫꥿Ǥʤϡǽλ
 *	4:	꥿
 *	== TASK1³==
 *	5:	֤Υå				... (E)(F)(G)(H)
 *	6:	ƥȽλ
 */

#include <kernel.h>
#include <test_lib.h>
#include <t_syslog.h>
#include "kernel_cfg.h"
#include "test_cpuexc.h"

void
task1(intptr_t exinf)
{
	ER		ercd;

	test_start(__FILE__);

	check_point(1);
	check_state(false, false, TIPM_ENAALL, false, false, true);
	ercd = dis_dsp();
	check_ercd(ercd, E_OK);
	ercd = ena_tex();
	check_ercd(ercd, E_OK);
	ercd = loc_cpu();
	check_ercd(ercd, E_OK);

	check_point(2);
	check_state(false, true, TIPM_ENAALL, true, true, false);
	RAISE_CPU_EXCEPTION;

	check_point(5);
	check_state(false, true, TIPM_ENAALL, true, true, false);

	check_finish(6);
}

void
tex_task1(TEXPTN texptn, intptr_t exinf)
{
	check_point(0);
}

void
task2(intptr_t exinf)
{
	check_point(0);
}

void
alarm1_handler(intptr_t exinf)
{
	check_point(0);
}

void
cpuexc_handler(void *p_excinf)
{
	check_point(3);
	check_state_i(true, true, true, true, false);
	check_assert(xsns_xpn(p_excinf) == true);
	check_assert(xsns_dpn(p_excinf) == true);

#ifdef CANNOT_RETURN_CPUEXC
	check_finish(4);
#endif /* CANNOT_RETURN_CPUEXC */

	check_point(4);
}
