/*
 *  TOPPERS Software
 *      Toyohashi Open Platform for Embedded Real-Time Systems
 * 
 *  Copyright (C) 2007-2009 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ(1)(4)ξ˸¤ꡤܥեȥ
 *  ܥեȥѤΤޤࡥʲƱˤѡʣ
 *  ѡۡʰʲѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *      ޤܥեȥΥ桼ޤϥɥ桼Τʤ
 *      ͳ˴Ťᤫ⡤嵭ԤTOPPERSץȤ
 *      դ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơλŪ
 *  ФŬޤơʤݾڤԤʤޤܥեȥ
 *  ѤˤľŪޤϴŪʤ»˴ؤƤ⡤
 *  Ǥʤ
 * 
 *  @(#) $Id$
 */

/*
 *		ͥǽɾץ(3)
 *
 *  Ԥ륿οˤꡤset_flgν֤ɤΤ褦Ѳ
 *  ¬뤿Υץࡥ
 */

#include <kernel.h>
#include <t_syslog.h>
#include <test_lib.h>
#include <histogram.h>
#include "kernel_cfg.h"
#include "perf3.h"

/*
 *  ¬ȼ¹ԻʬۤϿ
 */
#define NO_MEASURE	10000U			/* ¬ */
#define MAX_TIME	1000U			/* ¹ԻʬۤϿ */

/*
 *  ¹ԻʬۤϿΰ
 */
static uint_t	histarea1[MAX_TIME + 1];

/*
 *  ¬Υꥹ
 */
static ID task_list[20] = {
	TASK1, TASK2, TASK3, TASK4, TASK5,
	TASK6, TASK7, TASK8, TASK9, TASK10,
	TASK11, TASK12, TASK13, TASK14, TASK15,
	TASK16, TASK17, TASK18, TASK19, TASK20
};

/*
 *  ¬ͥ١
 */
void task(intptr_t exinf)
{
	FLGPTN	flgptn;

	wai_flg(FLG1, 0x01U, TWF_ORW, &flgptn);
}

/*
 *  ¬롼
 */
void
perf_eval(uint_t n)
{
	uint_t		i, j;

	init_hist(1, MAX_TIME, histarea1);

	for (i = 0; i < NO_MEASURE; i++) {
		ini_flg(FLG1);
		for (j = 0; j < n; j++) {
			act_tsk(task_list[j]);
		}
		chg_pri(TSK_SELF, MAIN_PRIORITY_LOW);
		/* Ԥ֤ΤԤ */
		chg_pri(TSK_SELF, TPRI_INI);

		begin_measure(1);
		set_flg(FLG1, 0x01U);
		end_measure(1);

		chg_pri(TSK_SELF, MAIN_PRIORITY_LOW);
		/* λΤԤ */
		chg_pri(TSK_SELF, TPRI_INI);
	}

	syslog_1(LOG_NOTICE, "Execution times of set_flg"
							" when %d tasks are released from waiting.", n);
	print_hist(1);
	syslog_flush();
}

/*
 *  ᥤ󥿥ʹͥ١
 */
void main_task(intptr_t exinf)
{
	syslog_0(LOG_NOTICE, "Performance evaluation program (3)");
	syslog_flush();

	perf_eval(0);
	perf_eval(1);
	perf_eval(2);
	perf_eval(3);
	perf_eval(4);
	perf_eval(5);
	perf_eval(10);
	perf_eval(20);
	test_finish();
}
