/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2005-2010 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ(1)(4)ξ˸¤ꡤܥեȥ
 *  ܥեȥѤΤޤࡥʲƱˤѡʣ
 *  ѡۡʰʲѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *      ޤܥեȥΥ桼ޤϥɥ桼Τʤ
 *      ͳ˴Ťᤫ⡤嵭ԤTOPPERSץȤ
 *      դ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơλŪ
 *  ФŬޤơʤݾڤԤʤޤܥեȥ
 *  ѤˤľŪޤϴŪʤ»˴ؤƤ⡤
 *  Ǥʤ
 * 
 *  $Id$
 */

/*
 *		ޥɥ饤СMac OS Xѡ
 */

#include "kernel_impl.h"
#include "time_event.h"
#include "target_timer.h"
#include <sys/time.h>

#ifndef TOPPERS_SUPPORT_OVRHDR

/*
 *		Хϥɥ鵡ǽ򥵥ݡȤʤ
 */

#if 0
/*
 *		󥿡Х륿ޤޤȤƻѤˡ
 *
 *  󥿡Х륿ޤޤȤƻѤΤľǤ뤬
 *  Mac OS XǤϡSIGALRMٱ䤹뤳Ȥ뤿ᤫޤ
 *  μ˿ʤˤ⤫餺SIGALRMsigpendingǸФǤ
 *  礬롥ˤꡤǽɾѥƥλȤư
 *  ʤᡤΥɤϻѤƤʤ
 */

/*
 *  ޤεư
 */
void
target_timer_initialize(intptr_t exinf)
{
	CLOCK	cyc = TO_CLOCK(TIC_NUME, TIC_DENO);
	struct itimerval	val;

	/*
	 *  ޼ꤷޤư򳫻Ϥ롥
	 */
	assert(cyc <= MAX_CLOCK);
	val.it_interval.tv_sec = 0;
	val.it_interval.tv_usec = cyc;
	val.it_value = val.it_interval;
	setitimer(ITIMER_REAL, &val, NULL);
}

/*
 *  ޤ߽
 */
void
target_timer_terminate(intptr_t exinf)
{
	struct itimerval	val;

	/*
	 *  ޤưߤ롥
	 */
	val.it_interval.tv_sec = 0;
	val.it_interval.tv_usec = 0;
	val.it_value = val.it_interval;
	setitimer(ITIMER_REAL, &val, NULL);
}

/*
 *  ޤθͤɽФ
 */
CLOCK
target_timer_get_current(void)
{
	struct itimerval	val;

	getitimer(ITIMER_REAL, &val);
	return(TO_CLOCK(TIC_NUME, TIC_DENO) - val.it_value.tv_usec);
}

/*
 *  ޳׵Υå
 */
bool_t
target_timer_probe_int(void)
{
	return(x_probe_int(INTNO_TIMER));
}

/*
 *  ޳ߥϥɥ
 */
void
target_timer_handler(void)
{
	i_begin_int(INTNO_TIMER);
	signal_time();					/* ƥåζ */
	i_end_int(INTNO_TIMER);
}

#else /* 0 */
/*
 *		󥿡Х륿ޤ󥷥åȥޤȤƻѤˡ
 */

/*
 *  ޤư
 */
Inline void
itimer_start(void)
{
	CLOCK	cyc = TO_CLOCK(TIC_NUME, TIC_DENO);
	struct itimerval	val;

	/*
	 *  ޼ꤷޤư򳫻Ϥ롥
	 */
	assert(cyc <= MAX_CLOCK);
	val.it_interval.tv_sec = 0;
	val.it_interval.tv_usec = 0;
	val.it_value.tv_sec = 0;
	val.it_value.tv_usec = cyc;
	setitimer(ITIMER_REAL, &val, NULL);
}

/*
 *  ޤεư
 */
void
target_timer_initialize(intptr_t exinf)
{
	itimer_start();
}

/*
 *  ޤ߽
 */
void
target_timer_terminate(intptr_t exinf)
{
	struct itimerval	val;

	/*
	 *  ޤưߤ롥
	 */
	val.it_interval.tv_sec = 0;
	val.it_interval.tv_usec = 0;
	val.it_value = val.it_interval;
	setitimer(ITIMER_REAL, &val, NULL);
}

/*
 *  ޤθͤɽФ
 */
CLOCK
target_timer_get_current(void)
{
	struct itimerval	val;

	getitimer(ITIMER_REAL, &val);
	return(TO_CLOCK(TIC_NUME, TIC_DENO) - val.it_value.tv_usec);
}

/*
 *  ޳׵Υå
 */
bool_t
target_timer_probe_int(void)
{
	return(false);
}

/*
 *  ޳ߥϥɥ
 */
void
target_timer_handler(void)
{
	i_begin_int(INTNO_TIMER);
	i_lock_cpu();
	itimer_start();
	i_unlock_cpu();
	signal_time();					/* ƥåζ */
	i_end_int(INTNO_TIMER);
}

#endif /* 0 */
#else /* TOPPERS_SUPPORT_OVRHDR */

/*
 *		Хϥɥ鵡ǽ򥵥ݡȤ
 *
 *  ƥåΤΥޡʥƥåޡˤȥХϥ
 *  ɥ鵡ǽΤΥޡʥХ󥿥ޡˤ1ĤΥ󥿡Х륿
 *  ޤ¿ŲƼ¸Ƥ롥ˡϡƥåμ뤿
 *  ˿侩Ǥʤޥ٤Υޤ1Ĥʤߥ졼
 *  ĶǥƥåΤ礭ǤϤʤᡤˡ
 *  Ƥ롥
 */
#include "task.h"
#include "overrun.h"

static CLOCK	ticktimer_cyc;		/* ƥåޤμ */

static bool_t	itimer_ticktimer;	/* 󥿡Х륿ޤ
											ƥåޤꤵƤ */
static CLOCK	ticktimer_left;		/* ƥåޤλĤ */
static bool_t	ovrtimer_active;	/* Х󥿥ޤͭ */
static OVRTIM	ovrtimer_left;		/* Х󥿥ޤλĤ */

#define CLOCK_TO_OVRTIM(clock)		((OVRTIM) clock)
#define OVRTIM_TO_CLOCK(ovrtim)		((CLOCK) ovrtim)

static const struct itimerval		itimerval_stop = {{ 0, 0 }, { 0, 0 }};

/*
 *  ޤư
 */
Inline void
itimer_start(void)
{
	struct itimerval	val;

	/*
	 *  ޤꤷޤư򳫻Ϥ롥
	 */
	if (!ovrtimer_active || CLOCK_TO_OVRTIM(ticktimer_left) <= ovrtimer_left) {
		val.it_value.tv_sec = 0;
		val.it_value.tv_usec = ticktimer_left;
		itimer_ticktimer = true;
	}
	else {
		val.it_value.tv_sec = 0;
		val.it_value.tv_usec = OVRTIM_TO_CLOCK(ovrtimer_left);
		itimer_ticktimer = false;
	}
	val.it_interval.tv_sec = 0;
	val.it_interval.tv_usec = 0;
	setitimer(ITIMER_REAL, &val, NULL);
}

/*
 *  ޤư
 */
Inline void
itimer_stop(void)
{
	struct itimerval	val;
	CLOCK				left;

	/*
	 *  ޤưߤλλĤ֤left˼ФĤ
	 *  ֤0ˤʤäƤ1ɤߴ롥λˡץꥢ
	 *  ȯǽ롥
	 */
	setitimer(ITIMER_REAL, &itimerval_stop, &val);
	left = val.it_value.tv_usec;
	if (left == 0) {
		left = 1;
	}

	/*
	 *  ޤλĤ֤顤ƥåޤȥХ󥿥ޤλĤ
	 *  ֤ꤷľ
	 */
	if (itimer_ticktimer) {
		if (ovrtimer_active) {
			ovrtimer_left -= CLOCK_TO_OVRTIM(ticktimer_left - left);
		}
		ticktimer_left = left;
	}
	else {
		ticktimer_left -= (OVRTIM_TO_CLOCK(ovrtimer_left) - left);
		ovrtimer_left = CLOCK_TO_OVRTIM(left);
	}
}

/*
 *  ޤεư
 */
void
target_timer_initialize(intptr_t exinf)
{
	ticktimer_cyc = TO_CLOCK(TIC_NUME, TIC_DENO);
	assert(ticktimer_cyc <= MAX_CLOCK);

	ticktimer_left = ticktimer_cyc;
	ovrtimer_active = false;
	itimer_start();
}

/*
 *  ޤ߽
 */
void
target_timer_terminate(intptr_t exinf)
{
	/*
	 *  ޤưߤ롥
	 */
	setitimer(ITIMER_REAL, &itimerval_stop, NULL);
}

/*
 *  ޤθͤɽФ
 */
CLOCK
target_timer_get_current(void)
{
	struct itimerval	val;

	if (itimer_ticktimer) {
		getitimer(ITIMER_REAL, &val);
		if (val.it_value.tv_usec == 0) {
			return(0);
		}
		else {
			return(TO_CLOCK(TIC_NUME, TIC_DENO) - val.it_value.tv_usec);
		}
	}
	else {
		getitimer(ITIMER_REAL, &val);
		return(ticktimer_left - (OVRTIM_TO_CLOCK(ovrtimer_left)
												- val.it_value.tv_usec));
	}
}

/*
 *  ޳׵Υå
 */
bool_t
target_timer_probe_int(void)
{
	struct itimerval	val;

	if (itimer_ticktimer) {
		getitimer(ITIMER_REAL, &val);
		return(val.it_value.tv_usec == 0);
	}
	else {
		return(false);
	}
}

/*
 *  Х󥿥ޤν
 *
 *  ɬפʽ򤹤٤target_timer_initializeǹԤäƤΤǡ
 *  ϲ⤷ʤ
 */
void
target_ovrtimer_initialize(intptr_t exinf)
{
}

/*
 *  Х󥿥ޤ߽
 *
 *  ɬפʽ򤹤٤target_timer_terminateǹԤäƤΤǡ
 *  ϲ⤷ʤ
 */
void
target_ovrtimer_terminate(intptr_t exinf)
{
}

/*
 *  Х󥿥ޤư
 */
void
target_ovrtimer_start(OVRTIM ovrtim)
{
	assert(!ovrtimer_active);
	itimer_stop();
	ovrtimer_active = true;
	ovrtimer_left = ovrtim;
	itimer_start();
}

/*
 *  Х󥿥ޤ
 */
OVRTIM
target_ovrtimer_stop(void)
{
	struct itimerval	val;

	assert(ovrtimer_active);
	if (itimer_ticktimer) {
		getitimer(ITIMER_REAL, &val);
		ovrtimer_left -= CLOCK_TO_OVRTIM(ticktimer_left
												- val.it_value.tv_usec);
		if (ovrtimer_left == 0) {
			ovrtimer_left = 1;
		}
		ovrtimer_active = false;
	}
	else {
		itimer_stop();
		ovrtimer_active = false;
		itimer_start();
	}
	return(ovrtimer_left);
}

/*
 *  Х󥿥ޤθͤɽФ
 */
OVRTIM
target_ovrtimer_get_current(void)
{
	struct itimerval	val;
	OVRTIM				ovrtimer_current;

	assert(ovrtimer_active);
	if (itimer_ticktimer) {
		getitimer(ITIMER_REAL, &val);
		ovrtimer_current = ovrtimer_left
					- CLOCK_TO_OVRTIM(ticktimer_left - val.it_value.tv_usec);
	}
	else {
		getitimer(ITIMER_REAL, &val);
		ovrtimer_current = CLOCK_TO_OVRTIM(val.it_value.tv_usec);
	}
	return(ovrtimer_current);
}

/*
 *  ޳ߥϥɥ
 *
 *  ޳ߥϥɥǡovrtimer_stopƤӽФ롥
 *  Х󥿥ޤưƤˤϡtarget_ovrtimer_stop
 *  ƤӽФ롥󥿡Х륿ޤ˥Х󥿥ޤꤵƤ
 *  ˤϡitimer_stopitimer_startƤӽФơ󥿡
 *  Х륿ޤ˥ƥåޤꤵ졤󥿡Х륿ޤư
 *  롥դˡ󥿡Х륿ޤ˥ƥåޤꤵƤ
 *  ˤϡ󥿡Х륿ޤߤޤޤȤʤäƤ롥
 */
void
target_timer_handler(void)
{
	struct itimerval			val;

	i_begin_int(INTNO_TIMER);
	i_lock_cpu();
	getitimer(ITIMER_REAL, &val);
	if (val.it_value.tv_usec == 0) {
		/*
		 *  󥿡Х륿ޤߤƤΤϡ󥿡Х륿ޤ
		 *  ƥåޤꤵƤǤ롥
		 */
		ticktimer_left = ticktimer_cyc;

		val.it_value.tv_sec = 0;
		val.it_value.tv_usec = ticktimer_left;
		val.it_interval.tv_sec = 0;
		val.it_interval.tv_usec = 0;
		setitimer(ITIMER_REAL, &val, NULL);

		i_unlock_cpu();
		signal_time();				/* ƥåζ */
	}
	else {
		/*
		 *  󥿡Х륿ޤưƤΤϡ󥿡Х륿ޤ
		 *  Х󥿥ޤꤵƤǤ롥
		 */
		if (p_runtsk->leftotm == 1) {
			/*
			 *  ץꥢߤǤʤˡХ󥿥ޤư
			 *  롥
			 */
			i_unlock_cpu();
			call_ovrhdr();			/* Хϥɥεư */
		}
		else {
			i_unlock_cpu();
		}
	}
	i_end_int(INTNO_TIMER);
}

#endif /* TOPPERS_SUPPORT_OVRHDR */
