/*
 *  TOPPERS Software
 *      Toyohashi Open Platform for Embedded Real-Time Systems
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2004-2010 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ(1)(4)ξ˸¤ꡤܥեȥ
 *  ܥեȥѤΤޤࡥʲƱˤѡʣ
 *  ѡۡʰʲѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *      ޤܥեȥΥ桼ޤϥɥ桼Τʤ
 *      ͳ˴Ťᤫ⡤嵭ԤTOPPERSץȤ
 *      դ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơλŪ
 *  ФŬޤơʤݾڤԤʤޤܥեȥ
 *  ѤˤľŪޤϴŪʤ»˴ؤƤ⡤
 *  Ǥʤ
 * 
 *  @(#) $Id$
 */

/*
 *		sil.hΥåȰ¸Mac OS Xѡ
 *
 *  Υ󥯥롼ɥեϡsil.hƬǥ󥯥롼ɤ롥¾Υե
 *  뤫ľܥ󥯥롼ɤ뤳ȤϤʤΥե򥤥󥯥롼
 *  ɤˡt_stddef.h󥯥롼ɤΤǡ˰¸Ƥ
 *  褤
 */

#ifndef TOPPERS_TARGET_SIL_H
#define TOPPERS_TARGET_SIL_H

#ifndef TOPPERS_MACRO_ONLY

/*
 *  ɸΥ󥯥롼ɥե
 */
#include <signal.h>

/*
 *  NMI٤Ƥγߤζػ
 */
Inline void
TOPPERS_dissig(sigset_t *p_sigmask)
{
	extern sigset_t	_kernel_sigmask_intlock;

	sigprocmask(SIG_BLOCK, &_kernel_sigmask_intlock, p_sigmask);
}

/*
 *  ͥ٥ޥɽˤθͤ
 */
Inline void
TOPPERS_setsig(sigset_t *p_sigmask)
{
	sigprocmask(SIG_SETMASK, p_sigmask, NULL);
}

/*
 *  ߥå֤
 */
#define SIL_PRE_LOC		sigset_t TOPPERS_sigmask
#define SIL_LOC_INT()	(TOPPERS_dissig(&TOPPERS_sigmask))
#define SIL_UNL_INT()	(TOPPERS_setsig(&TOPPERS_sigmask))

/*
 *  Ԥ
 */
Inline void
sil_dly_nse(ulong_t dlytim)
{
	/*
	 *  ߥ졼ĶǤϰ̣ʤᡤ⤷ʤ
	 */
}

#endif /* TOPPERS_MACRO_ONLY */

/*
 *  ץåΥǥ
 */
#if defined(__ppc__)
#define SIL_ENDIAN_BIG				/* ӥåǥ */
#elif defined(__i386__) || defined(__x86_64__)
#define SIL_ENDIAN_LITTLE			/* ȥ륨ǥ */
#endif

#endif /* TOPPERS_TARGET_SIL_H */
