/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2006-2011 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ(1)(4)ξ˸¤ꡤܥեȥ
 *  ܥեȥѤΤޤࡥʲƱˤѡʣ
 *  ѡۡʰʲѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *      ޤܥեȥΥ桼ޤϥɥ桼Τʤ
 *      ͳ˴Ťᤫ⡤嵭ԤTOPPERSץȤ
 *      դ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơλŪ
 *  ФŬޤơʤݾڤԤʤޤܥեȥ
 *  ѤˤľŪޤϴŪʤ»˴ؤƤ⡤
 *  Ǥʤ
 * 
 *  @(#) $Id$
 */

/*
 *		ꥢI/OǥХSIO˥ɥ饤СMac OS Xѡ
 */

#include "macosx.h"
#include <t_stddef.h>
#include <t_syslog.h>
#include <errno.h>
#include <unistd.h>
#include <fcntl.h>
#include <termios.h>
#include "target_serial.h"

/*
 *  ꥢI/OݡȽ֥å
 */
typedef struct sio_port_initialization_block {
	char		*path;			/* եΥѥ̾ */
} SIOPINIB;

/*
 *  ꥢI/Oݡȴ֥å
 */
struct sio_port_control_block {
	const SIOPINIB *p_siopinib;	/* ꥢI/OݡȽ֥å */
	intptr_t	exinf;			/* ĥ */
	bool_t		openflag;		/* ץѤߥե饰 */
	struct termios saved_term;	/* ü */

	int_t		read_fd;		/* ɽФѥեǥץ */
	bool_t		rcv_flag;		/* ʸХåեͭե饰 */
	char		rcv_buf;		/* ʸХåե */
	bool_t		rcv_rdy;		/* ΥХåĥե饰 */

	int_t		write_fd;		/* ѥեǥץ */
	bool_t		snd_flag;		/* ʸХåեͭե饰 */
	char		snd_buf;		/* ʸХåե */
	bool_t		snd_rdy;		/* ΥХåĥե饰 */
};

/*
 *  ꥢI/OݡȽ֥å
 */
const SIOPINIB siopinib_table[TNUM_SIOP] = {
	{ NULL }
};

/*
 *  ꥢI/Oݡȴ֥åΥꥢ
 */
SIOPCB	siopcb_table[TNUM_SIOP];

/*
 *  ꥢI/OݡID֥åФΥޥ
 */
#define INDEX_SIOP(siopid)	((uint_t)((siopid) - 1))
#define get_siopcb(siopid)	(&(siopcb_table[INDEX_SIOP(siopid)]))

/*
 *  SIOɥ饤Фν
 */
void
sio_initialize(intptr_t exinf)
{
	SIOPCB	*p_siopcb;
	uint_t	i;

	/*
	 *  ꥢI/Oݡȴ֥åν
	 */
	for (i = 0; i < TNUM_SIOP; i++) {
		p_siopcb = &(siopcb_table[i]);
		p_siopcb->p_siopinib = &(siopinib_table[i]);
		p_siopcb->openflag = false;
	}
}

/*
 *  SIOɥ饤Фνλ
 */
void
sio_terminate(intptr_t exinf)
{
	SIOPCB	*p_siopcb;
	uint_t	i;

	/*
	 *  ץ󤵤Ƥ륷ꥢI/OݡȤΥ
	 */
	for (i = 0; i < TNUM_SIOP; i++) {
		p_siopcb = &(siopcb_table[i]);
		if (p_siopcb->openflag) {
			sio_cls_por(p_siopcb);
		}
	}
}

/*
 *  ꥢI/OݡȤΥץ
 */
SIOPCB *
sio_opn_por(ID siopid, intptr_t exinf)
{
	SIOPCB			*p_siopcb;
	const SIOPINIB	*p_siopinib;
	int_t			fd;
	struct termios	term;

	p_siopcb = get_siopcb(siopid);
	p_siopinib = p_siopcb->p_siopinib;

	if (p_siopinib->path != NULL) {
		fd = open(p_siopinib->path, O_RDWR, 0777);
		assert(fd >= 0);
		p_siopcb->read_fd = fd;
		p_siopcb->write_fd = fd;
	}
	else {
		fd = STDIN_FILENO;					/* ɸϤȤ */
		p_siopcb->read_fd = STDIN_FILENO;
		p_siopcb->write_fd = STDOUT_FILENO;
	}
	fcntl(fd, F_SETOWN, getpid());
	fcntl(fd, F_SETFL, (O_NONBLOCK | O_ASYNC));

	tcgetattr(fd, &(p_siopcb->saved_term));
	term = p_siopcb->saved_term;
	term.c_lflag &= ~(ECHO | ICANON);
	tcsetattr(fd, TCSAFLUSH, &term);

	p_siopcb->exinf = exinf;
	p_siopcb->rcv_flag = false;
	p_siopcb->rcv_rdy = false;
	p_siopcb->snd_flag = false;
	p_siopcb->snd_rdy = false;
	p_siopcb->openflag = true;
	return(p_siopcb);
}

/*
 *  ꥢI/OݡȤΥ
 */
void
sio_cls_por(SIOPCB *p_siopcb)
{
	int_t	fd;

	fd = p_siopcb->read_fd;
	tcsetattr(fd, TCSAFLUSH, &(p_siopcb->saved_term));
	fcntl(fd, F_SETFL, 0);

	if (p_siopcb->p_siopinib->path != NULL) {
		close(p_siopcb->read_fd);
	}
	p_siopcb->openflag = false;
}

/*
 *  SIOγߥӥ롼
 */
void
sio_isr(intptr_t exinf)
{
	SIOPCB	*p_siopcb = &(siopcb_table[0]);
	int_t	n;

	if (p_siopcb->snd_flag) {
		if ((n = write(p_siopcb->write_fd, &(p_siopcb->snd_buf), 1)) > 0) {
			p_siopcb->snd_flag = false;
			if (p_siopcb->snd_rdy) {
				sio_irdy_snd(p_siopcb->exinf);
			}
		}
	}
	if (!p_siopcb->rcv_flag) {
		if ((n = read(p_siopcb->read_fd, &(p_siopcb->rcv_buf), 1)) > 0) {
			p_siopcb->rcv_flag = true;
			if (p_siopcb->rcv_rdy) {
				sio_irdy_rcv(p_siopcb->exinf);
			}
		}
	}
}

/*
 *  ꥢI/OݡȤؤʸ
 */
bool_t
sio_snd_chr(SIOPCB *p_siopcb, char c)
{
	int_t	n;

	if (!p_siopcb->snd_flag) {
		if ((n = write(p_siopcb->write_fd, &c, 1)) > 0) {
			return(true);
		}
		else {
			assert(n < 0 && errno == EAGAIN);
			p_siopcb->snd_flag = true;
			p_siopcb->snd_buf = c;
			return(true);
		}
	}
	else {
		return(false);
	}
}

/*
 *  ꥢI/OݡȤʸ
 */
int_t
sio_rcv_chr(SIOPCB *p_siopcb)
{
	char	c;
	int_t	n;

	if (p_siopcb->rcv_flag) {
		p_siopcb->rcv_flag = false;
		return((int_t)(uint8_t)(p_siopcb->rcv_buf));
	}
	else if ((n = read(p_siopcb->read_fd, &c, 1)) > 0) {
		return((int_t)(uint8_t) c);
	}
	else {
		assert(n < 0 && errno == EAGAIN);
		return(-1);
	}
}

/*
 *  ꥢI/OݡȤΥХåε
 */
void
sio_ena_cbr(SIOPCB *p_siopcb, uint_t cbrtn)
{
	switch (cbrtn) {
	case SIO_RDY_SND:
		p_siopcb->snd_rdy = true;
		break;
	case SIO_RDY_RCV:
		p_siopcb->rcv_rdy = true;
		break;
	}
}

/*
 *  ꥢI/OݡȤΥХåζػ
 */
void
sio_dis_cbr(SIOPCB *p_siopcb, uint_t cbrtn)
{
	switch (cbrtn) {
	case SIO_RDY_SND:
		p_siopcb->snd_rdy = false;
		break;
	case SIO_RDY_RCV:
		p_siopcb->rcv_rdy = false;
		break;
	}
}
