/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2006-2014 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ(1)(4)ξ˸¤ꡤܥեȥ
 *  ܥեȥѤΤޤࡥʲƱˤѡʣ
 *  ѡۡʰʲѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *      ޤܥեȥΥ桼ޤϥɥ桼Τʤ
 *      ͳ˴Ťᤫ⡤嵭ԤTOPPERSץȤ
 *      դ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơλŪ
 *  ФŬޤơʤݾڤԤʤޤܥեȥ
 *  ѤˤľŪޤϴŪʤ»˴ؤƤ⡤
 *  Ǥʤ
 * 
 *  $Id$
 */

/*
 *		åȰ¸⥸塼Mac OS Xѡ
 *
 *  ͥΥåȰ¸Υ󥯥롼ɥե롥kernel_impl.hΥ
 *  åȰ¸ΰդȤʤ롥
 */

#ifndef TOPPERS_TARGET_CONFIG_H
#define TOPPERS_TARGET_CONFIG_H

/*
 *  ɸΥ󥯥롼ɥե
 */
#ifndef TOPPERS_MACRO_ONLY
#include <sys/types.h>
#include <unistd.h>
#include <stdlib.h>
#include <setjmp.h>
#include <signal.h>
#include <stdio.h>

#ifdef TOPPERS_SUPPORT_OVRHDR
#include "overrun.h"
#endif /* TOPPERS_SUPPORT_OVRHDR */
#endif /* TOPPERS_MACRO_ONLY */

/*
 *  åȥƥOS¸
 */
#include "macosx.h"

/*
 *  åΥ֥°
 */
#define TARGET_INHATR	TA_NONKERNEL	/* ͥγ */

/*
 *  顼åˡλ
 */
#define CHECK_STKSZ_ALIGN	16	/* åΥ饤ñ */
#define CHECK_FUNC_ALIGN	4	/* ؿΥ饤ñ */
#define CHECK_FUNC_NONNULL		/* ؿNULLå */
#define CHECK_STACK_ALIGN	16	/* åΰΥ饤ñ */
#define CHECK_STACK_NONNULL		/* åΰNULLå */
#define CHECK_MPF_ALIGN		4	/* ĹסΰΥ饤ñ */
#define CHECK_MPF_NONNULL		/* ĹסΰNULLå */
#define CHECK_MB_ALIGN		4	/* ΰΥ饤ñ */

/*
 *  ȥ졼˴ؤ
 */
#ifdef TOPPERS_ENABLE_TRACE
#include "logtrace/trace_config.h"
#endif /* TOPPERS_ENABLE_TRACE */

/*
 *  ȥ졼ޥΥǥե
 */
#ifndef LOG_INH_ENTER
#define LOG_INH_ENTER(inhno)
#endif /* LOG_INH_ENTER */

#ifndef LOG_INH_LEAVE
#define LOG_INH_LEAVE(inhno)
#endif /* LOG_INH_LEAVE */

#ifndef LOG_EXC_ENTER
#define LOG_EXC_ENTER(excno)
#endif /* LOG_EXC_ENTER */

#ifndef LOG_EXC_LEAVE
#define LOG_EXC_LEAVE(excno)
#endif /* LOG_EXC_LEAVE */

/*
 *  ƥʥץå˰¸
 */
#if defined(__ppc__)

#define JMPBUF_PC				21			/* jmp_bufǤPCΰ */
#define JMPBUF_SP				0			/* jmp_bufǤSPΰ */
#define TASK_STACK_MERGIN		4U
#define DEFAULT_ISTKSZ			SIGSTKSZ	/* ʥ륹åΥ */

#elif defined(__i386__)

#define JMPBUF_PC				12			/* jmp_bufǤPCΰ */
#define JMPBUF_SP				9			/* jmp_bufǤSPΰ */
#define TASK_STACK_MERGIN		4U 
#define DEFAULT_ISTKSZ			SIGSTKSZ	/* ʥ륹åΥ */

#elif defined(__x86_64__)

#error architecture not supported
#define JMPBUF_PC				7			/* jmp_bufǤPCΰ */
#define JMPBUF_SP				2			/* jmp_bufǤSPΰ */
#define TASK_STACK_MERGIN		8U 
#define DEFAULT_ISTKSZ			SIGSTKSZ	/* ʥ륹åΥ */

#else
#error architecture not supported
#endif

/* 
 *  ɸγߴǽνԤʤ
 */
#define OMIT_INITIALIZE_INTERRUPT

#ifndef TOPPERS_MACRO_ONLY

/*
 *  ƥȥ֥å
 */
typedef struct task_context_block {
	jmp_buf		env;			/* ƥȾ */
} TSKCTXB;

/*
 *  ߥϥɥ֥å
 *
 *  ɸγߥϥɥ֥åˡͥ٤ɲäΡ
 */
typedef struct interrupt_handler_initialization_block {
	INHNO		inhno;			/* ߥϥɥֹ */
	ATR			inhatr;			/* ߥϥɥ° */
	FP			int_entry;		/* ߥϥɥν */
	PRI			intpri;			/* ͥ */
} INHINIB;

/*
 *  ߥϥɥֹοkernel_cfg.c
 */
extern const uint_t	tnum_inhno;

/*
 *  ߥϥɥ֥åΥꥢkernel_cfg.c
 */
extern const INHINIB	inhinib_table[];

/*
 *  ʥ륻åޥ
 */
#define sigequalset(set1, set2)		(*(set1) == *(set2))
#define sigassignset(set1, set2)	(*(set1) = *(set2))
#define sigjoinset(set1, set2)		(*(set1) |= *(set2))

/*
 *  ͥ٥ޥˤ륷ʥޥkernel_cfg.c
 *
 *  ͥ٥ޥˤäƥޥƤߤȡ°
 *  ꤵƤʤߤб륷ʥޥ뤿Υʥ
 *  ݻΥǥåϡͥ٥ޥ
 *  ȿžΡ
 *
 *  sigmask_table[0]°ꤵƤʤߤб륷
 *                    ʥΤߤޥ륷ʥޥ
 *  sigmask_table[-TMIN_INTPRI]ͥγߤ٤Ƥȡ°
 *                    ꤵƤʤߤб륷ʥ
 *                    륷ʥޥ
 *  sigmask_table[6]NMISIGUSR2٤Ƥγߤȡ°
 *                    ꤵƤʤߤб륷ʥޥ
 *                    ʥޥ
 *  sigmask_table[7]sigmask_table[6]Ʊ
 */
extern const sigset_t sigmask_table[8];

/*
 *  ׵ػߥե饰¸Τѿν͡kernel_cfg.c
 */
extern const sigset_t sigmask_disint_init;

/*
 *  ߥåCPUåؤΰܹԤǥޥ륷ʥݻѿ
 */
extern sigset_t	sigmask_intlock;	/* ߥåǥޥ륷ʥ */
extern sigset_t	sigmask_cpulock;	/* CPUåǥޥ륷ʥ */

/*
 *  ƥȤλ
 */
Inline bool_t
sense_context(void)
{
	stack_t	ss;

	sigaltstack(NULL, &ss);
	return((ss.ss_flags & SA_ONSTACK) != 0);
}

/*
 *  CPUåե饰¸Τѿ
 */
extern volatile bool_t		lock_flag;		/* CPUåե饰ɽѿ */
extern volatile sigset_t	saved_sigmask;	/* ʥޥ¸ѿ */

/*
 *  ͥ٥ޥ¸Τѿ
 */
extern volatile PRI			ipm_value;		/* ͥ٥ޥɽѿ */

/*
 *  ׵ػߥե饰¸Τѿ
 */
extern volatile sigset_t	sigmask_disint;	/* ̤˥ޥƤ륷ʥ */

/*
 *  ʥޥ
 *
 *  ߤξ֡ʥƥȡCPUåե饰ͥ٥ޥ
 *  ߶ػߥե饰ˤ򻲾ȤơߤΥʥޥsaved_sigmaskŬ
 *  ͤꤹ롥
 */
Inline void
set_sigmask(void)
{
	sigset_t	sigmask;

	sigassignset(&sigmask, &(sigmask_table[-ipm_value]));
	sigjoinset(&sigmask, &sigmask_disint);
	if (sense_context()) {
		sigaddset(&sigmask, SIGUSR2);
	}
	if (lock_flag) {
		sigassignset(&saved_sigmask, &sigmask);
		sigjoinset(&sigmask, &sigmask_cpulock);
	}
	sigprocmask(SIG_SETMASK, &sigmask, NULL);
}

/*
 *  CPUå֤ؤΰܹ
 */
Inline void
x_lock_cpu(void)
{
	assert(!lock_flag);
	sigprocmask(SIG_BLOCK, &sigmask_cpulock, (sigset_t *) &saved_sigmask);
	lock_flag = true;
}

#define t_lock_cpu()	x_lock_cpu()
#define i_lock_cpu()	x_lock_cpu()

/*
 *  CPUå֤β
 */
Inline void
x_unlock_cpu(void)
{
	assert(lock_flag);
	lock_flag = false;
	sigprocmask(SIG_SETMASK, (sigset_t *) &saved_sigmask, NULL);
}

#define t_unlock_cpu()	x_unlock_cpu()
#define i_unlock_cpu()	x_unlock_cpu()

/*
 *  CPUå֤λ
 */
Inline bool_t
x_sense_lock(void)
{
	return(lock_flag);
}

#define t_sense_lock()	x_sense_lock()
#define i_sense_lock()	x_sense_lock()

/*
 *  ͥ٥ޥ
 */
Inline void
x_set_ipm(PRI intpri)
{
	ipm_value = intpri;
	set_sigmask();
}

#define t_set_ipm(intpri)	x_set_ipm(intpri)
#define i_set_ipm(intpri)	x_set_ipm(intpri)

/*
 *  ͥ٥ޥλ
 */
Inline PRI
x_get_ipm(void)
{
	return(ipm_value);
}

#define t_get_ipm()	x_get_ipm()
#define i_get_ipm()	x_get_ipm()

/*
 *  ֹϰϤȽ
 */
#define	VALID_INTNO(intno)	(1 <= (intno) && (intno) <= 30 \
								&& (intno) != SIGKILL && (intno) != SIGSTOP)
#define	VALID_INTNO_CREISR(intno)	VALID_INTNO(intno)
#define	VALID_INTNO_DISINT(intno)	VALID_INTNO(intno)

/*
 *  ׵ػߥե饰Υå
 *
 *  °ꤵƤʤ׵饤ФƳ׵ػ
 *  ե饰򥻥åȤ褦Ȥˤϡfalse֤
 */
Inline bool_t
x_disable_int(INTNO intno)
{
	if (sigismember(&(sigmask_table[0]), intno)
				|| !sigismember(&(sigmask_table[7]), intno)) {
		return(false);
	}
	sigaddset(&sigmask_disint, intno);
	set_sigmask();
	return(true);
}

#define t_disable_int(intno)	x_disable_int(intno)
#define i_disable_int(intno)	x_disable_int(intno)

/*
 *  ׵ػߥե饰Υꥢ
 *
 *  °ꤵƤʤ׵饤ФƳ׵ػ
 *  ե饰򥯥ꥢ褦Ȥˤϡfalse֤
 */
Inline bool_t
x_enable_int(INTNO intno)
{
	if (sigismember(&(sigmask_table[0]), intno)
				|| !sigismember(&(sigmask_table[7]), intno)) {
		return(false);
	}
	sigdelset(&sigmask_disint, intno);
	set_sigmask();
	return(true);
}

#define t_enable_int(intno)		x_enable_int(intno)
#define i_enable_int(intno)		x_enable_int(intno)

/*
 *  ׵Υꥢ
 */
Inline void
x_clear_int(INTNO intno)
{
}

#define t_clear_int(intno)		x_clear_int(intno)
#define i_clear_int(intno)		x_clear_int(intno)

/*
 *  ׵Υå
 */
Inline bool_t
x_probe_int(INTNO intno)
{
	sigset_t	sigmask;

	sigpending(&sigmask);
	return(sigismember(&sigmask, intno));
}

#define t_probe_int(intno)		x_probe_int(intno)
#define i_probe_int(intno)		x_probe_int(intno)

/*
 *  ߥϥɥɬפIRC
 */
Inline void
i_begin_int(INTNO intno)
{
}

/*
 *  ߥϥɥνиɬפIRC
 */
Inline void
i_end_int(INTNO intno)
{
}

/*
 *  ǹ̥ͥؤΥǥѥå
 *
 *  dispatchϡƥȤƤӽФ줿ӥ
 *  ƤӽФ٤ΤǡƥȡCPUå֡ǥѥ
 *  ľ֡ʥǥΡ˳ͥ٥ޥ֤ǸƤӽФ
 *  Фʤʤ
 */
extern void	dispatch(void);

/*
 *  ǥѥåư
 *
 *  start_dispatchreturn˥ޥ뤳Ȥǡͥνλ
 *  sta_kermain˥꥿󤵤ʥ륹å鸵Υå
 *  ᤹
 */
#define start_dispatch()	return

/*
 *  ߤΥƥȤΤƤƥǥѥå
 *
 *  exit_and_dispatchϡext_tskƤӽФ٤Τǡƥ
 *  ȡCPUå֡ǥѥåľ֡ʥǥΡ˳ͥ
 *  ٥ޥ֤ǸƤӽФʤФʤʤ
 */
extern void	exit_and_dispatch(void);

/*
 *  ߥϥɥи
 */
extern void	ret_int(void);

/*
 *  CPU㳰ϥɥи
 */
extern void	ret_exc(void);

/*
 *  ͥνλθƽФ
 *
 *  call_exit_kernelϡͥνλ˸ƤӽФ٤Τǡ󥿥
 *  ƥȤڤ괹ơͥνλexit_kernelˤƤӽ
 *  
 */
extern void call_exit_kernel(void) NoReturn;

/*
 *  ƥȤν
 *
 *  ٻ߾֤¹ԤǤ֤˰ܹԤ˸ƤФ롥λ
 *  ǥåΰȤäƤϤʤʤ
 *
 *  activate_context򡤥饤ؿǤϤʤޥȤƤΤϡ
 *  λǤTCBƤʤǤ롥
 *
 *  IntelץåǤϡå16ӥåȶ˥饤󤷤Ƥʤ
 *  ʤʤ
 */
extern void	start_r(void);

#define activate_context(p_tcb)											\
{																		\
	((intptr_t *) &((p_tcb)->tskctxb.env))[JMPBUF_PC]					\
											= (intptr_t) start_r;		\
	((intptr_t *) &((p_tcb)->tskctxb.env))[JMPBUF_SP]					\
						= ((((intptr_t)((char *)((p_tcb)->p_tinib->stk)	\
								+ (p_tcb)->p_tinib->stksz)) & ~0x0f)	\
								- TASK_STACK_MERGIN);					\
}

/*
 *  ߥϥɥֹCPU㳰ϥɥֹϰϤȽ
 */
#define VALID_INHNO_DEFINH(inhno)		VALID_INTNO((INTNO)(inhno))
#define VALID_EXCNO_DEFEXC(excno)		VALID_INTNO((INTNO)(excno))

/*
 *  ߥϥɥ
 *
 *  ٥ȥֹinhnoγߥϥɥνϤint_entryˡ
 *  ͥ٤intpriꤹ롥
 */
Inline void
x_define_inh(INHNO inhno, FP int_entry, PRI intpri)
{
	struct sigaction	sigact;

	assert(VALID_INHNO_DEFINH(inhno));
	sigact.sa_handler = (void (*)(int))(int_entry);
	sigact.sa_flags = SA_ONSTACK;
	sigassignset(&(sigact.sa_mask), &(sigmask_table[-intpri]));
	sigaddset(&(sigact.sa_mask), SIGUSR2);
	sigaction(inhno, &sigact, NULL);
}

/*
 *  CPU㳰ϥɥ
 *
 *  ٥ȥֹexcnoCPU㳰ϥɥνϤexc_entry
 *  ꤹ롥
 *
 *  SA_NODEFERˤꡤʥϥɥεưˡΥʥޥ
 *  Τ޻ߤƤ롥
 */
Inline void
x_define_exc(EXCNO excno, FP exc_entry)
{
	struct sigaction	sigact;

	assert(VALID_EXCNO_DEFEXC(excno));
	sigact.sa_sigaction =
				(void (*)(int, struct __siginfo *, void *))(exc_entry);
	sigact.sa_flags = (SA_ONSTACK | SA_SIGINFO | SA_NODEFER);
	sigemptyset(&(sigact.sa_mask));
	sigaddset(&(sigact.sa_mask), SIGUSR2);
	sigaction(excno, &sigact, NULL);
}

/*
 *  ХϥɥߤΤΥޥ
 */
#ifdef TOPPERS_SUPPORT_OVRHDR
#define OVRTIMER_STOP()	{				\
			i_lock_cpu();				\
			_kernel_ovrtimer_stop();	\
			i_unlock_cpu();				\
		}
#else /* TOPPERS_SUPPORT_OVRHDR */
#define OVRTIMER_STOP()
#endif /* TOPPERS_SUPPORT_OVRHDR */

/*
 *  ߥϥɥޥ
 */
#define INT_ENTRY(inhno, inthdr)	_kernel_##inthdr##_##inhno

#define INTHDR_ENTRY(inhno, inthdr, intpri)						\
void _kernel_##inthdr##_##inhno(void)							\
{																\
	PRI		saved_ipm;											\
																\
	saved_ipm = _kernel_ipm_value;								\
	_kernel_ipm_value = intpri;									\
	OVRTIMER_STOP();											\
	LOG_INH_ENTER(inhno);										\
	inthdr();			/* ߥϥɥƤӽФ */			\
	LOG_INH_LEAVE(inhno);										\
	_kernel_ret_int();	/* ߥϥɥиƤӽФ */	\
	_kernel_ipm_value = saved_ipm;								\
	_kernel_lock_flag = false;									\
}

/*
 *  CPU㳰ϥɥޥ
 */
#define EXC_ENTRY(excno, exchdr)	_kernel_##exchdr##_##excno

#define EXCHDR_ENTRY(excno, excno_num, exchdr)							\
void _kernel_##exchdr##_##excno(int sig,								\
						struct __siginfo *p_info, void *p_ctx)			\
{																		\
	bool_t		saved_lock_flag;										\
																		\
	saved_lock_flag = _kernel_lock_flag;								\
	if (exc_sense_nonkernel(p_ctx)) {									\
		/* ͥCPU㳰ϥɥξ */						\
		exchdr(p_ctx);			/* CPU㳰ϥɥƤӽФ */			\
	}																	\
	else {																\
		/* ͥCPU㳰ϥɥξ */						\
		OVRTIMER_STOP();												\
		LOG_EXC_ENTER(excno);											\
		exchdr(p_ctx);			/* CPU㳰ϥɥƤӽФ */			\
		LOG_EXC_LEAVE(excno);											\
		_kernel_ret_exc();		/* CPU㳰ϥɥиƤӽФ */	\
	}																	\
	_kernel_lock_flag = saved_lock_flag;								\
}

/*
 *  CPU㳰ȯΥƥȤλ
 *
 *  CPU㳰ȯΥƥȤƥȤλfalse
 *  Ǥʤtrue֤
 */
Inline bool_t
exc_sense_context(void *p_excinf)
{
	return(((ucontext_t *) p_excinf)->uc_onstack != 0);
}

/*
 *  ͥCPU㳰Ƚ
 *
 *  ͥCPU㳰λtrueǤʤfalse֤
 */
Inline bool_t
exc_sense_nonkernel(void *p_excinf)
{
	sigset_t	sigmask;

	sigassignset(&sigmask, &(((ucontext_t *) p_excinf)->uc_sigmask));
	return(sigismember(&sigmask, SIGUSR2));
}

/*
 *  CPU㳰ȯΥƥȤȳߤΥޥ֤λ
 *
 *  CPU㳰ȯΥƥ֤ͥ¹Ǥʤ
 *  ƥȤǤꡤߥå֤ǤʤCPUå֤Ǥʤ
 *  ͥ٥ޥ֤ǤtrueǤʤfalse֤
 *  CPU㳰ͥγ߽ȯˤfalse
 *  ˡ
 */
Inline bool_t
exc_sense_intmask(void *p_excinf)
{
	return(!exc_sense_context(p_excinf) && !exc_sense_nonkernel(p_excinf)
												&& ipm_value == TIPM_ENAALL);
}

/*
 *  åȥƥ¸ν
 */
extern void	target_initialize(void);

/*
 *  åȥƥνλ
 *
 *  ƥλ˻Ȥ
 */
extern void	target_exit(void) NoReturn;

#endif /* TOPPERS_MACRO_ONLY */

/*
 *  ͥγդΰδ
 *
 *  target_config.cˡTLSFʥץ󥽡Υ饤֥ˤ
 *  롼ޤƤ롥
 */
#define OMIT_KMM_ALLOCONLY

#endif /* TOPPERS_TARGET_CONFIG_H */
