/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2006-2011 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ(1)(4)ξ˸¤ꡤܥեȥ
 *  ܥեȥѤΤޤࡥʲƱˤѡʣ
 *  ѡۡʰʲѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *      ޤܥեȥΥ桼ޤϥɥ桼Τʤ
 *      ͳ˴Ťᤫ⡤嵭ԤTOPPERSץȤ
 *      դ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơλŪ
 *  ФŬޤơʤݾڤԤʤޤܥեȥ
 *  ѤˤľŪޤϴŪʤ»˴ؤƤ⡤
 *  Ǥʤ
 * 
 *  @(#) $Id$
 */

/*
 *		åȰ¸⥸塼Mac OS Xѡ
 */

#include "kernel_impl.h"
#include "task.h"

/*
 *  ȥ졼ޥΥǥե
 */
#ifndef LOG_DSP_ENTER
#define LOG_DSP_ENTER(p_tcb)
#endif /* LOG_DSP_ENTER */

#ifndef LOG_DSP_LEAVE
#define LOG_DSP_LEAVE(p_tcb)
#endif /* LOG_DSP_LEAVE */

/*
 *  TMIN_INTPRIϰϤΥå
 */
#if (TMIN_INTPRI > -1) || (-6 > TMIN_INTPRI)
#error TMIN_INTPRI out of range.
#endif /* (TMIN_INTPRI > -1) || (-6 > TMIN_INTPRI) */

/*
 *  ߥåCPUåؤΰܹԤǥޥ륷ʥݻѿ
 */
sigset_t	sigmask_intlock;	/* ߥåǥޥ륷ʥ */
sigset_t	sigmask_cpulock;	/* CPUåǥޥ륷ʥ */

/*
 *  CPUåե饰¸Τѿ
 */
volatile bool_t		lock_flag;		/* CPUåե饰ɽѿ */
volatile sigset_t	saved_sigmask;	/* ʥޥ¸ѿ */

/*
 *  ͥ٥ޥ¸Τѿ
 */
volatile PRI		ipm_value;		/* ͥ٥ޥɽѿ */

/*
 *  ׵ػߥե饰¸Τѿ
 */
volatile sigset_t	sigmask_disint;	/* ̤˥ޥƤ륷ʥ */

/*
 *  ǥѥåΤγԤǤ뤳Ȥ򼨤ѿ
 */
static bool_t	dispatcher_idle;	/* ԤǤ */

/*
 *  ǥѥå
 *
 *  LOG_DSP_ENTERLOG_DSP_LEAVEdispatcher줺ƤӽФ
 *  ؿ¦Ƥͳϼ̤ꡥLOG_DSP_ENTERϡǥѥå
 *  ưϻmainƤФ줿ˤˤϡƤӽФƤϤʤʤᡤ
 *  dispatcher뤳ȤǤʤLOG_DSP_LEAVEϡڴΥ
 *  ΥåǸƤӽФʤФʤʤᡤ_longjmp¹Ԥ˸
 *  ӽФɬפꡤdispatcherƤӽФؿ¦ʤФʤ
 *  
 */
static void
dispatcher(void)
{
	sigset_t	sigmask;

	while ((p_runtsk = p_schedtsk) == NULL) {
		/*
		 *  CPUå֤򤹤롥sigmaskˤϡCPUå
		 *  ֤˰ܹԤΥʥޥФ
		 */
		lock_flag = false;
		sigassignset(&sigmask, &saved_sigmask);
		do {
			/*
			 *  Ԥδ֤ȯߥϥɥǤSIGUSR2
			 *  raiseʤ褦ˡdispatcher_idletrueˤ롥
			 */
			dispatcher_idle = true;
			sigsuspend(&sigmask);			/* Ԥ */
			dispatcher_idle = false;
		} while (!reqflg);
		reqflg = false;

		/*
		 *  CPUå֤᤹Ԥδ֤˼¹Ԥߥϥɥ
		 *  ˤꡤsaved_sigmaskϽ񤭴ǽ뤿ᡤͤ
		 *  ᤹ɬפ롥
		 */
		sigassignset(&saved_sigmask, &sigmask);
		lock_flag = true;
	}
	_longjmp(p_runtsk->tskctxb.env, 1);
}

/*
 *  ǹ̥ͥؤΥǥѥå
 */
void
dispatch(void)
{
#ifdef TOPPERS_SUPPORT_OVRHDR
	ovrtimer_stop();					/* Х󥿥ޤ */
#endif /* TOPPERS_SUPPORT_OVRHDR */
	if (_setjmp(p_runtsk->tskctxb.env) == 0) {
		LOG_DSP_ENTER(p_runtsk);
		dispatcher();
		assert(0);
	}
	LOG_DSP_LEAVE(p_runtsk);
#ifdef TOPPERS_SUPPORT_OVRHDR
	ovrtimer_start();					/* Х󥿥ޤư */
#endif /* TOPPERS_SUPPORT_OVRHDR */
	calltex();
}

/*
 *  ǹ̥ͥؤΥǥѥåʥʥϥɥѡ
 */
static void
dispatch_handler(int sig, struct __siginfo *p_info, void *p_ctx)
{
#ifdef TOPPERS_SUPPORT_OVRHDR
	/*
	 *  Хϥɥ鵡ǽ򥵥ݡȤˤϡdispatch_handler
	 *  ɬư롥ǥѥåɬפʤˤϡХ
	 *  ɥưϤΤߤԤ
	 */
	if (!(!dispatcher_idle && reqflg)) {
		ovrtimer_start();				/* Х󥿥ޤư */
		return;
	}
	reqflg = false;
#endif /* TOPPERS_SUPPORT_OVRHDR */

	/*
	 *  ʥϥɥμ¹ԳΥʥޥsaved_sigmask
	 *  CPUå֤˰ܹԤ롥
	 */
	sigassignset(&saved_sigmask, &(((ucontext_t *) p_ctx)->uc_sigmask));
	lock_flag = true;

	if (dspflg && p_runtsk != p_schedtsk) {
		if (_setjmp(p_runtsk->tskctxb.env) == 0) {
			LOG_DSP_ENTER(p_runtsk);
			dispatcher();
			assert(0);
		}
		LOG_DSP_LEAVE(p_runtsk);
	}
#ifdef TOPPERS_SUPPORT_OVRHDR
	ovrtimer_start();					/* Х󥿥ޤư */
#endif /* TOPPERS_SUPPORT_OVRHDR */
	calltex();

	/*
	 *  ʥϥɥ餫Υ꥿Υʥޥsaved_sigmask
	 *  ˤʤ褦ꤷCPUå֤롥
	 */
	lock_flag = false;
	sigassignset(&(((ucontext_t *) p_ctx)->uc_sigmask), &saved_sigmask);
}

/*
 *  ߤΥƥȤΤƤƥǥѥå
 */
void
exit_and_dispatch(void)
{
	LOG_DSP_ENTER(p_runtsk);
	dispatcher();
	assert(0);
}

/*
 *  ߥϥɥи
 *
 *  ߥϥɥǤϡͥγߤػߤƤ뤿ᡤи
 *  ǳߤػߤɬפϤʤ
 */
void
ret_int(void)
{
#ifndef TOPPERS_SUPPORT_OVRHDR
	/*
	 *  ǥѥåεư׵᤹롥
	 *
	 *  reqflgåľ˳ߤäƤ⡤ä¦γߤ
	 *  ǥѥåεư׵᤹뤿ᡤreqflgå
	 *  ˳ߤػߤɬפʤ
	 */
	if (!dispatcher_idle && reqflg) {
		reqflg = false;
		raise(SIGUSR2);
	}
#else /* TOPPERS_SUPPORT_OVRHDR */
	/*
	 *  Хϥɥ鵡ǽ򥵥ݡȤˤϡХ󥿥
	 *  ưϤ뤿ˡdispatch_handlerɬư롥
	 */
	raise(SIGUSR2);
#endif /* TOPPERS_SUPPORT_OVRHDR */
}

/*
 *  CPU㳰ϥɥи
 */
void
ret_exc(void)
{
#ifndef TOPPERS_SUPPORT_OVRHDR
	/*
	 *  ǥѥåεư׵᤹롥
	 *
	 *  reqflgåľ˳ߤäƤ⡤ä¦γߤ
	 *  ǥѥåεư׵᤹뤿ᡤreqflgå
	 *  ˳ߤػߤɬפʤ
	 */
	if (!dispatcher_idle && reqflg) {
		reqflg = false;
		raise(SIGUSR2);
	}
#else /* TOPPERS_SUPPORT_OVRHDR */
	/*
	 *  Хϥɥ鵡ǽ򥵥ݡȤˤϡХ󥿥
	 *  ưϤ뤿ˡdispatch_handlerɬư롥
	 */
	raise(SIGUSR2);
#endif /* TOPPERS_SUPPORT_OVRHDR */
}

/*
 *  ͥνλθƽФ
 */
void
call_exit_kernel(void)
{
	sigset_t			sigmask;
	struct sigaction	sigact;

	/*
	 *  SIGUSR2Υʥϥɥexit_kernelϿ
	 */
	sigact.sa_handler = (void (*)(int)) exit_kernel;
	sigact.sa_flags = SA_ONSTACK;
	sigemptyset(&(sigact.sa_mask));
	sigaction(SIGUSR2, &sigact, NULL);

	/*
	 *  SIGUSR2Υޥ
	 */
	sigemptyset(&sigmask);
	sigaddset(&sigmask, SIGUSR2);
	sigprocmask(SIG_UNBLOCK, &sigmask, NULL);

	/*
	 *  exit_kernelθƽФ
	 */
	raise(SIGUSR2);
	assert(0);
	while (true);
}

/*
 *  ϻ
 */
void
start_r(void)
{
#ifdef TOPPERS_SUPPORT_OVRHDR
	ovrtimer_start();					/* Х󥿥ޤư */
#endif /* TOPPERS_SUPPORT_OVRHDR */
	t_unlock_cpu();
	(*(p_runtsk->p_tinib->task))(p_runtsk->p_tinib->exinf);
	(void) ext_tsk();
	assert(0);
}

/*
 *  åȰ¸ν
 */
void
target_initialize(void)
{
	struct sigaction	sigact;

	/*
	 *  ߥåؤΰܹԤǥޥ륷ʥݻѿν
	 */
	sigassignset(&sigmask_intlock, &(sigmask_table[6]));
	sigaddset(&sigmask_intlock, SIGUSR2);

	/*
	 *  CPUåؤΰܹԤǥޥ륷ʥݻѿν
	 */
	sigassignset(&sigmask_cpulock, &(sigmask_table[-TMIN_INTPRI]));
	sigaddset(&sigmask_cpulock, SIGUSR2);

	/*
	 *  CPUåե饰¸Τѿν
	 *
	 *  saved_sigmaskϡͥ뵯ư˸ƤӽФset_sigmaskǽ
	 *  롥
	 */
	lock_flag = true;

	/*
	 *  ͥ٥ޥ¸Τѿν
	 */
	ipm_value = TIPM_ENAALL;

	/*
	 *  ׵ػߥե饰¸Τѿν
	 */
	sigassignset(&sigmask_disint, &sigmask_disint_init);

	/*
	 *  ǥѥåΤΥɥ롼Ǥ뤳Ȥ򼨤ѿν
	 */
	dispatcher_idle = false;

	/*
	 *  SIGUSR2Υʥϥɥ˥ǥѥåϿ
	 */
	sigact.sa_sigaction = dispatch_handler;
	sigact.sa_flags = SA_SIGINFO;
	sigassignset(&(sigact.sa_mask), &sigmask_cpulock);
	sigaction(SIGUSR2, &sigact, NULL);
}

/*
 *  åȰ¸νλ
 */
void
target_exit(void)
{
	/*
	 *  ץνλ
	 */
	exit(0);
}

/*
 *  ƥ٥ϤΤʸ
 */
void
target_fput_log(char c)
{
	write(STDERR_FILENO, &c, 1);
}

/*
 *  ߴǽν
 */
void
initialize_interrupt(void)
{
	uint_t			i;
	const INHINIB	*p_inhinib;

	for (i = 0; i < tnum_inhno; i++) {
		p_inhinib = &(inhinib_table[i]);
		x_define_inh(p_inhinib->inhno, p_inhinib->int_entry,
												p_inhinib->intpri);
	}
}

/*
 *  ᥤؿ
 */
int
main()
{
	sigset_t			sigmask;
	stack_t				ss;
	struct sigaction	sigact;

	/*
	 *  SIGUSR2ʳΤ٤ƤΥʥޥ
	 */
	sigfillset(&sigmask);
	sigdelset(&sigmask, SIGUSR2);
	sigprocmask(SIG_BLOCK, &sigmask, NULL);

	/*
	 *  ʥ륹å󥿥ƥѤΥåˤ
	 */
	ss.ss_sp = (char *)(istk);
	ss.ss_size = (int)(istksz);
	ss.ss_flags = 0;
	sigaltstack(&ss, NULL);

	/*
	 *  SIGUSR2Υʥϥɥsta_kerϿ
	 */
	sigact.sa_handler = (void (*)(int)) sta_ker;
	sigact.sa_flags = SA_ONSTACK;
	sigemptyset(&(sigact.sa_mask));
	sigaction(SIGUSR2, &sigact, NULL);

	/*
	 *  sta_kerθƽФ
	 */
	raise(SIGUSR2);

	/*
	 *  ǥѥåư
	 *
	 *  target_initializeǡlock_flagtrueˡipm_valueTIPM_ENAALL
	 *  ˽Ƥ뤿ᡤset_sigmaskƤӽФƥʥޥ
	 *  saved_sigmaskꤹ뤳ȤǡCPUå֡ʥǥΡ˳
	 *  ͥ٥ޥTIPM_ENAALLξ֤ˤʤ롥
	 *
	 *  ޤinitialize_taskdisdspfalse˽Ƥ뤿ᡤǥ
	 *  ѥåľ֤ˤʤäƤ롥
	 */
	set_sigmask();
	dispatcher();
	assert(0);
	return(0);
}

/*
 *  ͥγդΰδ
 *
 *  TLSFʥץ󥽡Υ饤֥ˤѤƼ¸
 */
#ifdef TOPPERS_SUPPORT_DYNAMIC_CRE

#include "tlsf.h"

static bool_t	tlsf_initialized = false;

void
initialize_kmm(void)
{
	if (init_memory_pool(kmmsz, kmm) >= 0) {
		tlsf_initialized = true;
	}
}

void *
kernel_malloc(SIZE size)
{
	if (tlsf_initialized) {
		return(malloc_ex(size, kmm));
	}
	else {
		return(NULL);
	}
}

void
kernel_free(void *ptr)
{
	if (tlsf_initialized) {
		free_ex(ptr, kmm);
	}
}

#endif /* TOPPERS_SUPPORT_DYNAMIC_CRE */
