/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005-2008 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ(1)(4)ξ˸¤ꡤܥեȥ
 *  ܥեȥѤΤޤࡥʲƱˤѡʣ
 *  ѡۡʰʲѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *      ޤܥեȥΥ桼ޤϥɥ桼Τʤ
 *      ͳ˴Ťᤫ⡤嵭ԤTOPPERSץȤ
 *      դ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơλŪ
 *  ФŬޤơʤݾڤԤʤޤܥեȥ
 *  ѤˤľŪޤϴŪʤ»˴ؤƤ⡤
 *  Ǥʤ
 * 
 *  @(#) $Id$
 */

/*
 *		ޥɥ饤СDVE68K/40ѡ
 */

#ifndef TOPPERS_TARGET_TIMER_H
#define TOPPERS_TARGET_TIMER_H

#include <sil.h>
#include "dve68k.h"

/*
 *  ޳ߥϥɥϿΤ
 */
#define INHNO_TIMER		TINHNO_TT0		/* ߥϥɥֹ */
#define INTNO_TIMER		TINTNO_TT0		/* ֹ */
#define INTPRI_TIMER	TIRQ_LEVEL4		/* ͥ */
#define INTATR_TIMER	TA_EDGE			/* ° */

#ifndef TOPPERS_MACRO_ONLY

/*
 *  ͤɽη
 */
typedef uint32_t	CLOCK;

/*
 *  ͤɽȥߥáñ̤ȤѴ
 *
 *  DVE68K/40Ǥϡޤ1˥ȥåפ롥
 */
#define TIMER_CLOCK				1000U
#define TO_CLOCK(nume, deno)	((CLOCK)(TIMER_CLOCK * (nume) / (deno)))
#define TO_USEC(clock)			(((SYSUTM) clock) * 1000U / TIMER_CLOCK)

/*
 *  ǤΥ޼ñ̤ɽ
 */
#define MAX_CLOCK		((CLOCK) 0xffffffU)

/*
 *  ߤޤǤλ֡nsecñ̡
 *
 *  ͤ˺Ϥʤ
 */
#define TIMER_STOP_DELAY	200U

/*
 *  쥸
 */
#define CSR12_START		0x80000000U		/* ư */
#define CSR12_STOP		0x00000000U		/*  */

/*
 *  ޤεư
 *
 *  ޤŪʥ޳׵ȯ롥
 */
extern void	target_timer_initialize(intptr_t exinf);

/*
 *  ޤ߽
 *
 *  ޤưߤ롥
 */
extern void	target_timer_terminate(intptr_t exinf);

/*
 *  ޤθͤɽФ
 */
Inline CLOCK
target_timer_get_current(void)
{
	CLOCK		clk;
	uint32_t	saved_csr12;
	SIL_PRE_LOC;

	/*
	 *  ޤưŪߤͤɤ߽Фޤư
	 *  Ūߤȡƥ郎뤿˾ޤʤ
	 *  DVE68K/40ΥϡɥŪǤꡤ򤨤ʤ
	 *  Ǿޤ뤿ˡߥå֤Ȥ롥
	 */
	SIL_LOC_INT();
	saved_csr12 = dga_read((void *) TADR_DGA_CSR12);
	dga_write((void *) TADR_DGA_CSR12, CSR12_STOP);
	sil_dly_nse(TIMER_STOP_DELAY);
	clk = dga_read((void *) TADR_DGA_CSR13) & 0x00ffffffU;
	dga_write((void *) TADR_DGA_CSR12, saved_csr12);
	SIL_UNL_INT();
	return(clk);
}

/*
 *  ޳׵Υå
 */
Inline bool_t
target_timer_probe_int(void)
{
	return(x_probe_int(INTNO_TIMER));
}

/*
 *  ޳ߥϥɥ
 */
extern void	target_timer_handler(void);

#endif /* TOPPERS_MACRO_ONLY */
#endif /* TOPPERS_TARGET_TIMER_H */
