/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005-2011 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ(1)(4)ξ˸¤ꡤܥեȥ
 *  ܥեȥѤΤޤࡥʲƱˤѡʣ
 *  ѡۡʰʲѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *      ޤܥեȥΥ桼ޤϥɥ桼Τʤ
 *      ͳ˴Ťᤫ⡤嵭ԤTOPPERSץȤ
 *      դ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơλŪ
 *  ФŬޤơʤݾڤԤʤޤܥեȥ
 *  ѤˤľŪޤϴŪʤ»˴ؤƤ⡤
 *  Ǥʤ
 * 
 *  @(#) $Id$
 */

/*
 *		DVE-68K/40 CPUܡɤΥϡɥ񸻤
 */

#ifndef TOPPERS_DVE68K_H
#define TOPPERS_DVE68K_H

#include <sil.h>

/*
 *  ֹintnoˤ
 */
#define TINTNO_ACF		1U			/* ACFAIL */
#define TINTNO_ABT		2U			/* ܡȳ */
#define TINTNO_SF		3U			/* SYSFAIL */
#define TINTNO_BER		4U			/* Х顼 */
#define TINTNO_IAK		5U			/* IAK */
#define TINTNO_SRQ		6U			/* SRQ */
#define TINTNO_SAK		7U			/* SAK */
#define TINTNO_GP7		9U			/* GP7 */
#define TINTNO_DMA		10U			/* DMA */
#define TINTNO_TT1		11U			/* 1 */
#define TINTNO_TT0		12U			/* 0 */
#define TINTNO_GP3		13U			/* եå */
#define TINTNO_GP2		14U			/* SCSI */
#define TINTNO_GP1		15U			/* Ethernet */
#define TINTNO_GP0		16U			/* ꥢI/O */
#define TINTNO_SWI7		17U			/* եȥ7 */
#define TINTNO_SWI6		18U			/* եȥ6 */
#define TINTNO_SWI5		19U			/* եȥ5 */
#define TINTNO_SWI4		20U			/* եȥ4 */
#define TINTNO_SWI3		21U			/* եȥ3 */
#define TINTNO_SWI2		22U			/* եȥ2 */
#define TINTNO_SWI1		23U			/* եȥ1 */
#define TINTNO_SWI0		24U			/* եȥ0 */
#define TINTNO_VM7		25U			/* VME7 */
#define TINTNO_VM6		26U			/* VME6 */
#define TINTNO_VM5		27U			/* VME5 */
#define TINTNO_VM4		28U			/* VME4 */
#define TINTNO_VM3		29U			/* VME3 */
#define TINTNO_VM2		30U			/* VME2 */
#define TINTNO_VM1		31U			/* VME1 */

/*
 *  ߥ٥ȥͤ
 */
#define TVEC_G0I		0x40U		/* 롼0ߥ٥ȥ */
#define TVEC_G1I		0x48U		/* 롼1ߥ٥ȥ */
#define TVEC_SWI		0x50U		/* եȥߥ٥ȥ */
#define TVEC_SPRI		0x40U		/* ץꥢߥ٥ȥ */

/*
 *  ߥϥɥֹinhnoˤ
 */
#define TINHNO_ACF		0x47U		/* ACFAIL */
#define TINHNO_ABT		0x46U		/* ܡȳ */
#define TINHNO_SF		0x45U		/* SYSFAIL */
#define TINHNO_BER		0x44U		/* Х顼 */
#define TINHNO_IAK		0x43U		/* IAK */
#define TINHNO_SRQ		0x42U		/* SRQ */
#define TINHNO_SAK		0x41U		/* SAK */
#define TINHNO_GP7		0x4fU		/* GP7 */
#define TINHNO_DMA		0x4eU		/* DMA */
#define TINHNO_TT1		0x4dU		/* 1 */
#define TINHNO_TT0		0x4cU		/* 0 */
#define TINHNO_GP3		0x4bU		/* եå */
#define TINHNO_GP2		0x4aU		/* SCSI */
#define TINHNO_GP1		0x49U		/* Ethernet */
#define TINHNO_GP0		0x48U		/* ꥢI/O */
#define TINHNO_SWI7		0x57U		/* եȥ7 */
#define TINHNO_SWI6		0x56U		/* եȥ6 */
#define TINHNO_SWI5		0x55U		/* եȥ5 */
#define TINHNO_SWI4		0x54U		/* եȥ4 */
#define TINHNO_SWI3		0x53U		/* եȥ3 */
#define TINHNO_SWI2		0x52U		/* եȥ2 */
#define TINHNO_SWI1		0x51U		/* եȥ1 */
#define TINHNO_SWI0		0x50U		/* եȥ0 */
#define TINHNO_SPRI		0x40U		/* ץꥢ */

/*
 *  CPUܡɾΥ쥸
 */
#define TADR_BOARD_REG0		0xfff48000
#define TADR_BOARD_REG1		0xfff48004
#define TADR_BOARD_REG2		0xfff48008

/*
 *  DGA-001Υ쥸Υɥ쥹
 */
#define TADR_DGA_CSR0		0xfff44000
#define TADR_DGA_CSR1		0xfff44004
#define TADR_DGA_CSR3		0xfff4400c
#define TADR_DGA_CSR4		0xfff44010
#define TADR_DGA_CSR5		0xfff44014
#define TADR_DGA_CSR12		0xfff44030
#define TADR_DGA_CSR13		0xfff44034
#define TADR_DGA_CSR14		0xfff44038
#define TADR_DGA_CSR15		0xfff4403c
#define TADR_DGA_CSR18		0xfff44048
#define TADR_DGA_CSR19		0xfff4404c
#define TADR_DGA_CSR20		0xfff44050
#define TADR_DGA_CSR21		0xfff44054
#define TADR_DGA_CSR23		0xfff4405c
#define TADR_DGA_CSR24		0xfff44060
#define TADR_DGA_IFR0		0xfff44070
#define TADR_DGA_IFR3		0xfff4407c

/*
 *  DGA-001γͥΤ
 */
#define TIRQ_NMI		(-7)		/* Υޥ֥ */
#define TIRQ_LEVEL6		(-6)		/* ߥ٥6 */
#define TIRQ_LEVEL5		(-5)		/* ߥ٥5 */
#define TIRQ_LEVEL4		(-4)		/* ߥ٥4 */
#define TIRQ_LEVEL3		(-3)		/* ߥ٥3 */
#define TIRQ_LEVEL2		(-2)		/* ߥ٥2 */
#define TIRQ_LEVEL1		(-1)		/* ߥ٥1 */

/*
 *  DGAؤΥؿ
 */
#define dga_rew_reg(addr)			sil_rew_mem(((uint32_t *) addr))
#define dga_wrw_reg(addr, val)		sil_wrw_mem(((uint32_t *) addr), val)

/*
 *  DGAΥ쥸ؤΥؿ
 */
#ifndef TOPPERS_MACRO_ONLY

Inline uint32_t
dga_read(void *addr)
{
	return(dga_rew_reg(addr));
}

Inline void
dga_write(void *addr, uint32_t val)
{
	dga_wrw_reg(addr, val);
}

Inline void
dga_bit_or(void *addr, uint32_t bitpat)
{
	dga_write(addr, dga_read(addr) | bitpat);
}

Inline void
dga_bit_and(void *addr, uint32_t bitpat)
{
	dga_write(addr, dga_read(addr) & bitpat);
}

Inline void
dga_set_ilv(void *addr, uint_t shift, uint_t level)
{
	dga_write(addr, (dga_read(addr) & ~(0x07 << shift)) | (level << shift));
} 

#endif /* TOPPERS_MACRO_ONLY */

/*
 *  PD72001MPSCˤΥ쥸Υɥ쥹
 */
#define TADR_UPD72001_DATAA		0xfff45003U
#define TADR_UPD72001_CTRLA		0xfff45007U
#define TADR_UPD72001_DATAB		0xfff4500bU
#define TADR_UPD72001_CTRLB		0xfff4500fU

/*
 *  PD72001ؤΥؿ
 */
#define upd72001_reb_reg(addr)			sil_reb_mem(((uint8_t *) addr))
#define upd72001_wrb_reg(addr, val)		sil_wrb_mem(((uint8_t *) addr), val)

/*
 *  ȯĶ¸ν
 */
#ifndef TOPPERS_MACRO_ONLY
#ifdef TOPPERS_GDB_STUB				/* GDB */

Inline void
dve68k_exit(void)
{
	Asm("trap #2");
}

Inline void
dve68k_putc(char c)
{
	Asm("move.l %0, %%d1; trap #3"
	  : /* no output */
	  : "g"(c)
	  : "d0", "d1", "d2", "d6", "d7");
}

#else /* TOPPERS_GDB_STUB */		/* ¾γȯĶ */

extern void		dve68k_exit(void) NoReturn;
extern void		dve68k_putc(char c);

#endif /* TOPPERS_GDB_STUB */
#endif /* TOPPERS_MACRO_ONLY */
#endif /* TOPPERS_DVE68K_H */
