/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2013-2014 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ(1)(4)ξ˸¤ꡤܥեȥ
 *  ܥեȥѤΤޤࡥʲƱˤѡʣ
 *  ѡۡʰʲѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *      ޤܥեȥΥ桼ޤϥɥ桼Τʤ
 *      ͳ˴Ťᤫ⡤嵭ԤTOPPERSץȤ
 *      դ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơλŪ
 *  ФŬޤơʤݾڤԤʤޤܥեȥ
 *  ѤˤľŪޤϴŪʤ»˴ؤƤ⡤
 *  Ǥʤ
 * 
 *  $Id$
 */

/*
 *		ꥢI/OǥХSIO˥ɥ饤Сʥߡåѡ
 */

#include "target_serial.h"

/*
 *  ꥢI/OݡȽ֥å
 */
typedef struct sio_port_initialization_block {
	int_t		dummy;			/* ߡե */
	/* SIOΥ쥸Ϥʤ */
} SIOPINIB;

/*
 *  ꥢI/Oݡȴ֥å
 */
struct sio_port_control_block {
	const SIOPINIB *p_siopinib;	/* ꥢI/OݡȽ֥å */
	intptr_t	exinf;			/* ĥ */
	bool_t		openflag;		/* ץѤߥե饰 */
	/* SIOξ֤ʤ */
};

/*
 *  ꥢI/OݡȽ֥å
 */
const SIOPINIB siopinib_table[TNUM_SIOP] = {
	{ 0 }
};

/*
 *  ꥢI/Oݡȴ֥åΥꥢ
 */
SIOPCB	siopcb_table[TNUM_SIOP];

/*
 *  ꥢI/OݡID֥åФΥޥ
 */
#define INDEX_SIOP(siopid)	((uint_t)((siopid) - 1))
#define get_siopcb(siopid)	(&(siopcb_table[INDEX_SIOP(siopid)]))

/*
 *  SIOɥ饤Фν
 */
void
sio_initialize(intptr_t exinf)
{
	SIOPCB	*p_siopcb;
	uint_t	i;

	/*
	 *  ꥢI/Oݡȴ֥åν
	 */
	for (i = 0; i < TNUM_SIOP; i++) {
		p_siopcb = &(siopcb_table[i]);
		p_siopcb->p_siopinib = &(siopinib_table[i]);
		p_siopcb->openflag = false;
		/* ¾Υեɤν */
	}
}

/*
 *  SIOɥ饤Фνλ
 */
void
sio_terminate(intptr_t exinf)
{
	SIOPCB	*p_siopcb;
	uint_t	i;

	/*
	 *  ץ󤵤Ƥ륷ꥢI/OݡȤΥ
	 */
	for (i = 0; i < TNUM_SIOP; i++) {
		p_siopcb = &(siopcb_table[i]);
		if (p_siopcb->openflag) {
			/* SIOΥ */
		}
	}
}

/*
 *  ꥢI/OݡȤΥץ
 */
SIOPCB *
sio_opn_por(ID siopid, intptr_t exinf)
{
	SIOPCB			*p_siopcb;
	const SIOPINIB	*p_siopinib;

	p_siopcb = get_siopcb(siopid);
	p_siopinib = p_siopcb->p_siopinib;

	/* SIOΥץ */

	p_siopcb->exinf = exinf;
	p_siopcb->openflag = true;
	return(p_siopcb);
}

/*
 *  ꥢI/OݡȤΥ
 */
void
sio_cls_por(SIOPCB *p_siopcb)
{
	/* SIOΥ */

	p_siopcb->openflag = false;
}

/*
 *  SIOγߥӥ롼
 */
void
sio_isr(intptr_t exinf)
{
	SIOPCB	*p_siopcb = &(siopcb_table[(int_t) exinf]);
	
	if (1/* λߤξ */) {
		sio_irdy_snd(p_siopcb->exinf);
	}
	if (1/* λߤξ */) {
		sio_irdy_rcv(p_siopcb->exinf);
	}
}

/*
 *  ꥢI/OݡȤؤʸ
 */
bool_t
sio_snd_chr(SIOPCB *p_siopcb, char c)
{
	if (1/* 쥸˶ */) {
		/* 쥸ʸc */
		return(true);
	}
	else {
		return(false);
	}
}

/*
 *  ꥢI/OݡȤʸ
 */
int_t
sio_rcv_chr(SIOPCB *p_siopcb)
{
	char	c;

	if (1/* 쥸ʸ */) {
		/* 쥸ʸc */
		return((int_t) c);
	}
	else {
		return(-1);
	}
}

/*
 *  ꥢI/OݡȤΥХåε
 */
void
sio_ena_cbr(SIOPCB *p_siopcb, uint_t cbrtn)
{
	switch (cbrtn) {
	case SIO_RDY_SND:
		/* λߤ */
		break;
	case SIO_RDY_RCV:
		/* λߤ */
		break;
	}
}

/*
 *  ꥢI/OݡȤΥХåζػ
 */
void
sio_dis_cbr(SIOPCB *p_siopcb, uint_t cbrtn)
{
	switch (cbrtn) {
	case SIO_RDY_SND:
		/* λߤػ */
		break;
	case SIO_RDY_RCV:
		/* λߤػ */
		break;
	}
}
