/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2013-2014 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ(1)(4)ξ˸¤ꡤܥեȥ
 *  ܥեȥѤΤޤࡥʲƱˤѡʣ
 *  ѡۡʰʲѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *      ޤܥեȥΥ桼ޤϥɥ桼Τʤ
 *      ͳ˴Ťᤫ⡤嵭ԤTOPPERSץȤ
 *      դ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơλŪ
 *  ФŬޤơʤݾڤԤʤޤܥեȥ
 *  ѤˤľŪޤϴŪʤ»˴ؤƤ⡤
 *  Ǥʤ
 * 
 *  $Id$
 */

/*
 *		åȰ¸⥸塼ʥߡåѡ
 *
 *  ͥΥåȰ¸Υ󥯥롼ɥե롥kernel_impl.hΥ
 *  åȰ¸ΰդȤʤ롥
 */

#ifndef TOPPERS_TARGET_CONFIG_H
#define TOPPERS_TARGET_CONFIG_H

#ifndef TOPPERS_MACRO_ONLY
#ifdef TOPPERS_SUPPORT_OVRHDR
#include "overrun.h"
#endif /* TOPPERS_SUPPORT_OVRHDR */
#endif /* TOPPERS_MACRO_ONLY */

/*
 *  åȥƥΥϡɥ񸻤
 */
#include "dummy.h"

/*
 *  顼åˡλ
 */
#define CHECK_STKSZ_ALIGN	4	/* åΥ饤ñ */
#define CHECK_FUNC_ALIGN	4	/* ؿΥ饤ñ */
#define CHECK_FUNC_NONNULL		/* ؿNULLå */
#define CHECK_STACK_ALIGN	4	/* åΰΥ饤ñ */
#define CHECK_STACK_NONNULL		/* åΰNULLå */
#define CHECK_MPF_ALIGN		4	/* ĹסΰΥ饤ñ */
#define CHECK_MPF_NONNULL		/* ĹסΰNULLå */
#define CHECK_MB_ALIGN		4	/* ΰΥ饤ñ */

/*
 *  ȥ졼˴ؤ
 */
#ifdef TOPPERS_ENABLE_TRACE
#include "logtrace/trace_config.h"
#endif /* TOPPERS_ENABLE_TRACE */

/*
 *  ȥ졼ޥΥǥե
 */
#ifndef LOG_INH_ENTER
#define LOG_INH_ENTER(inhno)
#endif /* LOG_INH_ENTER */

#ifndef LOG_INH_LEAVE
#define LOG_INH_LEAVE(inhno)
#endif /* LOG_INH_LEAVE */

#ifndef LOG_EXC_ENTER
#define LOG_EXC_ENTER(excno)
#endif /* LOG_EXC_ENTER */

#ifndef LOG_EXC_LEAVE
#define LOG_EXC_LEAVE(excno)
#endif /* LOG_EXC_LEAVE */

/*
 *  󥿥ƥѥåΥǥեȤΥ
 */
#define DEFAULT_ISTKSZ			4096

#ifndef TOPPERS_MACRO_ONLY

/*
 *  ƥȥ֥å
 */
typedef struct task_context_block {
	void		*sp;			/* åݥ */
	void		*pc;			/* ¹ԺƳ */
} TSKCTXB;

/*
 *  ƥȤλ
 */
Inline bool_t
sense_context(void)
{
	return(false);
}

/*
 *  CPUå֤ؤΰܹ
 */
Inline void
x_lock_cpu(void)
{
}

#define t_lock_cpu()	x_lock_cpu()
#define i_lock_cpu()	x_lock_cpu()

/*
 *  CPUå֤β
 */
Inline void
x_unlock_cpu(void)
{
}

#define t_unlock_cpu()	x_unlock_cpu()
#define i_unlock_cpu()	x_unlock_cpu()

/*
 *  CPUå֤λ
 */
Inline bool_t
x_sense_lock(void)
{
	return(false);
}

#define t_sense_lock()	x_sense_lock()
#define i_sense_lock()	x_sense_lock()

/*
 *  ͥ٥ޥ
 */
Inline void
x_set_ipm(PRI intpri)
{
}

#define t_set_ipm(intpri)	x_set_ipm(intpri)
#define i_set_ipm(intpri)	x_set_ipm(intpri)

/*
 *  ͥ٥ޥλ
 */
Inline PRI
x_get_ipm(void)
{
	return(TIPM_ENAALL);
}

#define t_get_ipm()	x_get_ipm()
#define i_get_ipm()	x_get_ipm()

/*
 *  ֹϰϤȽ
 */
#define	VALID_INTNO(intno)	(0 <= (intno) && (intno) <= 31)
#define	VALID_INTNO_CREISR(intno)	VALID_INTNO(intno)
#define	VALID_INTNO_DISINT(intno)	VALID_INTNO(intno)

/*
 *  ׵ػߥե饰Υå
 *
 *  °ꤵƤʤ׵饤ФƳ׵ػ
 *  ե饰򥻥åȤ褦Ȥˤϡfalse֤
 */
Inline bool_t
x_disable_int(INTNO intno)
{
	return(true);
}

#define t_disable_int(intno)	x_disable_int(intno)
#define i_disable_int(intno)	x_disable_int(intno)

/*
 *  ׵ػߥե饰Υꥢ
 *
 *  °ꤵƤʤ׵饤ФƳ׵ػ
 *  ե饰򥯥ꥢ褦Ȥˤϡfalse֤
 */
Inline bool_t
x_enable_int(INTNO intno)
{
	return(true);
}

#define t_enable_int(intno)		x_enable_int(intno)
#define i_enable_int(intno)		x_enable_int(intno)

/*
 *  ׵Υꥢ
 */
Inline void
x_clear_int(INTNO intno)
{
}

#define t_clear_int(intno)		x_clear_int(intno)
#define i_clear_int(intno)		x_clear_int(intno)

/*
 *  ׵Υå
 */
Inline bool_t
x_probe_int(INTNO intno)
{
	return(true);
}

#define t_probe_int(intno)		x_probe_int(intno)
#define i_probe_int(intno)		x_probe_int(intno)

/*
 *  ߥϥɥɬפIRC
 */
Inline void
i_begin_int(INTNO intno)
{
}

/*
 *  ߥϥɥνиɬפIRC
 */
Inline void
i_end_int(INTNO intno)
{
}

/*
 *  ǹ̥ͥؤΥǥѥå
 */
extern void	dispatch(void);

/*
 *  ǥѥåư
 */
extern void start_dispatch(void);

/*
 *  ߤΥƥȤΤƤƥǥѥå
 */
extern void	exit_and_dispatch(void);

/*
 *  ߥϥɥи
 */
extern void	ret_int(void);

/*
 *  CPU㳰ϥɥи
 */
extern void	ret_exc(void);

/*
 *  ͥνλθƽФ
 */
extern void call_exit_kernel(void) NoReturn;

/*
 *  ƥȤν
 */
extern void	start_r(void);

#define activate_context(p_tcb)

/*
 *  ߥϥɥֹCPU㳰ϥɥֹϰϤȽ
 */
#define VALID_INHNO_DEFINH(inhno)		VALID_INTNO((INTNO)(inhno))
#define VALID_EXCNO_DEFEXC(excno)		VALID_INTNO((INTNO)(excno))

/*
 *  ߥϥɥ
 *
 *  ٥ȥֹinhnoγߥϥɥνϤint_entry
 *  ꤹ롥
 */
Inline void
x_define_inh(INHNO inhno, FP int_entry)
{
}

/*
 *  ׵饤°
 */
Inline void
x_config_int(INTNO intno, ATR intatr, PRI intpri)
{
}

/*
 *  CPU㳰ϥɥ
 *
 *  ٥ȥֹexcnoCPU㳰ϥɥνϤexc_entry
 *  ꤹ롥
 */
Inline void
x_define_exc(EXCNO excno, FP exc_entry)
{
}

/*
 *  ХϥɥߤΤΥޥ
 */
#ifdef TOPPERS_SUPPORT_OVRHDR
#define OVRTIMER_STOP()	{				\
			i_lock_cpu();				\
			_kernel_ovrtimer_stop();	\
			i_unlock_cpu();				\
		}
#else /* TOPPERS_SUPPORT_OVRHDR */
#define OVRTIMER_STOP()
#endif /* TOPPERS_SUPPORT_OVRHDR */

/*
 *  ߥϥɥޥ
 */
#define INT_ENTRY(inhno, inthdr)	inthdr
#define INTHDR_ENTRY(inhno, inthdr, intpri)

/*
 *  CPU㳰ϥɥޥ
 */
#define EXC_ENTRY(excno, exchdr)	exchdr
#define EXCHDR_ENTRY(excno, excno_num, exchdr)

/*
 *  CPU㳰ȯΥƥȤλ
 *
 *  CPU㳰ȯΥƥȤƥȤλfalse
 *  Ǥʤtrue֤
 */
Inline bool_t
exc_sense_context(void *p_excinf)
{
	return(true);
}

/*
 *  ͥCPU㳰Ƚ
 *
 *  ͥCPU㳰λtrueǤʤfalse֤
 */
Inline bool_t
exc_sense_nonkernel(void *p_excinf)
{
	return(true);
}

/*
 *  CPU㳰ȯΥƥȤȳߤΥޥ֤λ
 *
 *  CPU㳰ȯΥƥ֤ͥ¹Ǥʤ
 *  ƥȤǤꡤߥå֤ǤʤCPUå֤Ǥʤ
 *  ͥ٥ޥ֤ǤtrueǤʤfalse֤
 *  CPU㳰ͥγ߽ȯˤfalse
 *  ˡ
 */
Inline bool_t
exc_sense_intmask(void *p_excinf)
{
	return(true);
}

/*
 *  åȥƥ¸ν
 */
extern void	target_initialize(void);

/*
 *  åȥƥνλ
 *
 *  ƥλ˻Ȥ
 */
extern void	target_exit(void) NoReturn;

#endif /* TOPPERS_MACRO_ONLY */

/*
 *  ͥγդΰδ
 *
 *  target_config.cˡTLSFʥץ󥽡Υ饤֥ˤ
 *  롼ޤƤ롥
 */
#define OMIT_KMM_ALLOCONLY

#endif /* TOPPERS_TARGET_CONFIG_H */
