/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2004-2011 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ(1)(4)ξ˸¤ꡤܥեȥ
 *  ܥեȥѤΤޤࡥʲƱˤѡʣ
 *  ѡۡʰʲѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *      ޤܥեȥΥ桼ޤϥɥ桼Τʤ
 *      ͳ˴Ťᤫ⡤嵭ԤTOPPERSץȤ
 *      դ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơλŪ
 *  ФŬޤơʤݾڤԤʤޤܥեȥ
 *  ѤˤľŪޤϴŪʤ»˴ؤƤ⡤
 *  Ǥʤ
 * 
 *  @(#) $Id$
 */

/*
 *		ꥢ륤󥿥եɥ饤
 */

#ifndef TOPPERS_SERIAL_H
#define TOPPERS_SERIAL_H

#ifdef __cplusplus
extern "C" {
#endif

/*
 *  ꥢ륤󥿥եɥ饤ФѤѥå
 */
typedef struct {
	uint_t		reacnt;			/* Хåեʸ */
	uint_t		wricnt;			/* Хåեʸ */
} T_SERIAL_RPOR;

/*
 *  ꥢ륤󥿥եɥ饤Фν롼
 */
extern void		serial_initialize(intptr_t exinf) throw();

/*
 *  ꥢ륤󥿥եɥ饤Ф̤ʸμФ
 */
extern bool_t	serial_get_chr(ID portid, char *p_c) throw();

/*
 *  ꥢ륤󥿥եɥ饤ФΥӥ
 */
extern ER		serial_opn_por(ID portid) throw();
extern ER		serial_cls_por(ID portid) throw();
extern ER_UINT	serial_rea_dat(ID portid, char *buf, uint_t len) throw();
extern ER_UINT	serial_wri_dat(ID portid, const char *buf, uint_t len) throw();
extern ER		serial_ctl_por(ID portid, uint_t ioctl) throw();
extern ER		serial_ref_por(ID portid, T_SERIAL_RPOR *pk_rpor) throw();

/*
 *  ꥢ륤󥿥եɥ饤ФưѤΤ
 *
 *  ʲϡӥå¤ȤäѤ롥
 */
#define	IOCTL_NULL	0U			/* ʤ */
#define	IOCTL_ECHO	0x0001U		/* ʸ򥨥Хå */
#define	IOCTL_CRLF	0x0010U		/* LFCRղ */
#define	IOCTL_FCSND	0x0100U		/* ФƥեԤ */
#define	IOCTL_FCANY	0x0200U		/* ɤΤ褦ʸǤƳ */
#define	IOCTL_FCRCV	0x0400U		/* ФƥեԤ */

#ifdef __cplusplus
}
#endif

#endif /* TOPPERS_SERIAL_H */
