/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2004-2012 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ(1)(4)ξ˸¤ꡤܥեȥ
 *  ܥեȥѤΤޤࡥʲƱˤѡʣ
 *  ѡۡʰʲѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *      ޤܥեȥΥ桼ޤϥɥ桼Τʤ
 *      ͳ˴Ťᤫ⡤嵭ԤTOPPERSץȤ
 *      դ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơλŪ
 *  ФŬޤơʤݾڤԤʤޤܥեȥ
 *  ѤˤľŪޤϴŪʤ»˴ؤƤ⡤
 *  Ǥʤ
 * 
 *  $Id$
 */

/* 
 *  ץץ(1)
 *
 *  ASPͥδŪưǧ뤿Υץץࡥ
 *
 *  ץγ:
 *
 *  桼󥿥եĥᥤ󥿥ʥID: MAIN_TASKͥ
 *  : MAIN_PRIORITYˤȡ3Ĥ¹Լ¹Ԥ륿ʥID:
 *  TASK1TASK3ͥ: MID_PRIORITYˤǹ롥ޤư
 *  2äμϥɥʼϥɥID: CYCHDR1ˤѤ롥
 *
 *  ¹Լ¹Ԥ륿ϡtask_loop롼פ¹Ԥ٤ˡ
 *  ¹Ǥ뤳Ȥ򤢤魯åɽ롥롼פ¹Ԥ
 *  Τϡ롼פʤǥåϤȡ¿̤Υå
 *  졤ץưǧ餯ʤ뤿Ǥ롥ޤ®ʥ
 *  ꥢݡȤѤƥåϤˡ٤ƤΥå
 *  ϤǤ褦ˡå̤¤Ȥͳ⤢롥
 *
 *  ϥɥϡĤͥ١HIGH_PRIORITYMID_PRIORITY
 *  LOW_PRIORITYˤΥǥ塼ž롥ץεưľϡ
 *  ϥɥ߾֤ˤʤäƤ롥
 *
 *  ᥤ󥿥ϡꥢI/OݡȤʸϤԤʸϤ
 *  ԤäƤ֤ϡ¹Լ¹Ԥ륿¹ԤƤˡϤ줿
 *  ʸб¹Ԥ롥Ϥ줿ʸȽδطϼ̤ꡥ
 *  Control-Cޤ'Q'Ϥȡץλ롥
 *
 *  '1' : оݥTASK1ڤ괹ʽˡ
 *  '2' : оݥTASK2ڤ괹롥
 *  '3' : оݥTASK3ڤ괹롥
 *  'a' : оݥact_tskˤ굯ư롥
 *  'A' : оݥФ뵯ư׵can_actˤꥭ󥻥뤹롥
 *  'e' : оݥext_tskƤӽФλ롥
 *  't' : оݥter_tskˤ궯λ롥
 *  '>' : оݥͥ٤HIGH_PRIORITYˤ롥
 *  '=' : оݥͥ٤MID_PRIORITYˤ롥
 *  '<' : оݥͥ٤LOW_PRIORITYˤ롥
 *  'G' : оݥͥ٤get_priɤ߽Ф
 *  's' : оݥslp_tskƤӽФԤˤ롥
 *  'S' : оݥtslp_tsk(10)ƤӽФԤˤ롥
 *  'w' : оݥwup_tskˤ굯롥
 *  'W' : оݥФ뵯׵can_wupˤꥭ󥻥뤹롥
 *  'l' : оݥrel_waiˤ궯ŪԤˤ롥
 *  'u' : оݥsus_tskˤ궯Ԥ֤ˤ롥
 *  'm' : оݥζԤ֤rsm_tskˤ롥
 *  'd' : оݥdly_tsk(10)ƤӽФַвԤˤ롥
 *  'x' : оݥ㳰ѥ0x0001㳰׵᤹롥
 *  'X' : оݥ㳰ѥ0x0002㳰׵᤹롥
 *  'y' : оݥdis_texƤӽФ㳰ػߤ롥
 *  'Y' : оݥena_texƤӽФ㳰Ĥ롥
 *  'r' : 3Ĥͥ١HIGH_PRIORITYMID_PRIORITYLOW_PRIORITYˤΥ
 *        ǥ塼ž롥
 *  'c' : ϥɥưϤ롥
 *  'C' : ϥɥưߤ롥
 *  'b' : 顼ϥɥ5ø˵ư褦ưϤ롥
 *  'B' : 顼ϥɥưߤ롥
 *  'z' : оݥCPU㳰ȯʥλˡ
 *  'Z' : оݥCPUå֤CPU㳰ȯʥץ
 *        λˡ
 *  'V' : get_utmǽɾѥƥ2ɤࡥ
 *  'v' : ȯԤƥॳɽʥǥեȡˡ
 *  'q' : ȯԤƥॳɽʤ
 */

#include <kernel.h>
#include <t_syslog.h>
#include <t_stdlib.h>
#include "syssvc/serial.h"
#include "syssvc/syslog.h"
#include "kernel_cfg.h"
#include "sample1.h"

/*
 *  ӥΥ顼Υ
 */
Inline void
svc_perror(const char *file, int_t line, const char *expr, ER ercd)
{
	if (ercd < 0) {
		t_perror(LOG_ERROR, file, line, expr, ercd);
	}
}

#define	SVC_PERROR(expr)	svc_perror(__FILE__, __LINE__, #expr, (expr))

/*
 *  ¹Լ¹Ԥ륿ؤΥåΰ
 */
char	message[3];

/*
 *  롼ײ
 */
ulong_t	task_loop;		/* ǤΥ롼ײ */
ulong_t	tex_loop;		/* 㳰롼ǤΥ롼ײ */

/*
 *  ¹Լ¹Ԥ륿
 */
void task(intptr_t exinf)
{
	volatile ulong_t	i;
	int_t		n = 0;
	int_t		tskno = (int_t) exinf;
	const char	*graph[] = { "|", "  +", "    *" };
	char		c;

	SVC_PERROR(ena_tex());
	while (true) {
		syslog(LOG_NOTICE, "task%d is running (%03d).   %s",
										tskno, ++n, graph[tskno-1]);
		for (i = 0; i < task_loop; i++);
		c = message[tskno-1];
		message[tskno-1] = 0;
		switch (c) {
		case 'e':
			syslog(LOG_INFO, "#%d#ext_tsk()", tskno);
			SVC_PERROR(ext_tsk());
			assert(0);
		case 's':
			syslog(LOG_INFO, "#%d#slp_tsk()", tskno);
			SVC_PERROR(slp_tsk());
			break;
		case 'S':
			syslog(LOG_INFO, "#%d#tslp_tsk(10000)", tskno);
			SVC_PERROR(tslp_tsk(10000));
			break;
		case 'd':
			syslog(LOG_INFO, "#%d#dly_tsk(10000)", tskno);
			SVC_PERROR(dly_tsk(10000));
			break;
		case 'y':
			syslog(LOG_INFO, "#%d#dis_tex()", tskno);
			SVC_PERROR(dis_tex());
			break;
		case 'Y':
			syslog(LOG_INFO, "#%d#ena_tex()", tskno);
			SVC_PERROR(ena_tex());
			break;
#ifdef CPUEXC1
		case 'z':
			syslog(LOG_NOTICE, "#%d#raise CPU exception", tskno);
			RAISE_CPU_EXCEPTION;
			break;
		case 'Z':
			SVC_PERROR(loc_cpu());
			syslog(LOG_NOTICE, "#%d#raise CPU exception", tskno);
			RAISE_CPU_EXCEPTION;
			SVC_PERROR(unl_cpu());
			break;
#endif /* CPUEXC1 */
		default:
			break;
		}
	}
}

/*
 *  ¹ԤƼ¹Ԥ륿ѤΥ㳰롼
 */
void tex_routine(TEXPTN texptn, intptr_t exinf)
{
	volatile ulong_t	i;
	int_t	tskno = (int_t) exinf;

	syslog(LOG_NOTICE, "task%d receives exception 0x%04x.", tskno, texptn);
	for (i = 0; i < tex_loop; i++);

	if ((texptn & 0x8000U) != 0U) {
		syslog(LOG_INFO, "#%d#ext_tsk()", tskno);
		SVC_PERROR(ext_tsk());
		assert(0);
	}
}

/*
 *  CPU㳰ϥɥ
 */
#ifdef CPUEXC1

void
cpuexc_handler(void *p_excinf)
{
	ID		tskid;

	syslog(LOG_NOTICE, "CPU exception handler (p_excinf = %08p).", p_excinf);
	if (sns_ctx() != true) {
		syslog(LOG_WARNING,
					"sns_ctx() is not true in CPU exception handler.");
	}
	if (sns_dpn() != true) {
		syslog(LOG_WARNING,
					"sns_dpn() is not true in CPU exception handler.");
	}
	syslog(LOG_INFO, "sns_loc = %d sns_dsp = %d sns_tex = %d",
									sns_loc(), sns_dsp(), sns_tex());
	syslog(LOG_INFO, "xsns_dpn = %d xsns_xpn = %d",
									xsns_dpn(p_excinf), xsns_xpn(p_excinf));

	if (xsns_xpn(p_excinf)) {
		syslog(LOG_NOTICE, "Sample program ends with exception.");
		SVC_PERROR(ext_ker());
		assert(0);
	}

	SVC_PERROR(iget_tid(&tskid));
	SVC_PERROR(iras_tex(tskid, 0x8000U));
}

#endif /* CPUEXC1 */

/*
 *  ϥɥ
 *
 *  HIGH_PRIORITYMID_PRIORITYLOW_PRIORITY γͥ٤Υǥ塼
 *  ž롥
 */
void cyclic_handler(intptr_t exinf)
{
	SVC_PERROR(irot_rdq(HIGH_PRIORITY));
	SVC_PERROR(irot_rdq(MID_PRIORITY));
	SVC_PERROR(irot_rdq(LOW_PRIORITY));
}

/*
 *  顼ϥɥ
 *
 *  HIGH_PRIORITYMID_PRIORITYLOW_PRIORITY γͥ٤Υǥ塼
 *  ž롥
 */
void alarm_handler(intptr_t exinf)
{
	SVC_PERROR(irot_rdq(HIGH_PRIORITY));
	SVC_PERROR(irot_rdq(MID_PRIORITY));
	SVC_PERROR(irot_rdq(LOW_PRIORITY));
}

/*
 *  ᥤ󥿥
 */
void main_task(intptr_t exinf)
{
	char	c;
	ID		tskid = TASK1;
	int_t	tskno = 1;
	ER_UINT	ercd;
	PRI		tskpri;
#ifndef TASK_LOOP
	volatile ulong_t	i;
	SYSTIM	stime1, stime2;
#endif /* TASK_LOOP */
#ifdef TOPPERS_SUPPORT_GET_UTM
	SYSUTM	utime1, utime2;
#endif /* TOPPERS_SUPPORT_GET_UTM */

	SVC_PERROR(syslog_msk_log(LOG_UPTO(LOG_INFO), LOG_UPTO(LOG_EMERG)));
	syslog(LOG_NOTICE, "Sample program starts (exinf = %d).", (int_t) exinf);

	/*
	 *  ꥢݡȤν
	 *
	 *  ƥƱꥢݡȤȤʤɡꥢ
	 *  ݡȤץѤߤξˤϤE_OBJ顼ˤʤ뤬پ
	 *  ʤ
	 */
	ercd = serial_opn_por(TASK_PORTID);
	if (ercd < 0 && MERCD(ercd) != E_OBJ) {
		syslog(LOG_ERROR, "%s (%d) reported by `serial_opn_por'.",
									itron_strerror(ercd), SERCD(ercd));
	}
	SVC_PERROR(serial_ctl_por(TASK_PORTID,
							(IOCTL_CRLF | IOCTL_FCSND | IOCTL_FCRCV)));

	/*
 	 *  롼ײ
	 *
	 *  ¹Լ¹Ԥ륿Ǥζ롼פβtask_loopˤϡ롼
	 *  פμ¹Ի֤0.4äˤʤ褦ꤹ롥Τˡ
	 *  LOOP_REFζ롼פμ¹Ի֤򡤤get_timƤ֤Ȥ
	 *  ¬ꤷ¬̤롼פμ¹Ի֤0.4äˤʤ롼ײ
	 *  ᡤtask_loopꤹ롥
	 *
	 *  LOOP_REFϡǥեȤǤ1,000,000ꤷƤ뤬ꤷ
	 *  ٤ץåǤϡץץμ¹ԳϤ˻֤
	 *  ꤹȤ롥դꤷ®ץåǤϡ
	 *  LOOP_REFζ롼פμ¹Ի֤ûʤꡤtask_loopꤹ
	 *  θ礭ʤȤ꤬롥
	 *
	 *  ǡΤ褦ʥåȤǤϡtarget_test.hǡLOOP_REFŬ
	 *  ڤͤΤ˾ޤ
	 *
	 *  ޤtask_loopͤꤷˤϡͤTASK_LOOP˥
	 *  롥TASK_LOOPޥƤ硤嵭¬
	 *  Ԥ鷺ˡTASK_LOOP줿ͤ롼פβȤ롥
	 *
	 * åȤˤäƤϡ롼פμ¹Ի֤1ܤ¬ǡ
	 * ĹˤʤΤ롥Τ褦ʥåȤǤϡMEASURE_TWICE
	 * ޥ뤳Ȥǡ1ܤ¬̤ΤƤơ2ܤ¬
	 * Ȥ
	 *
	 *  㳰롼Ǥζ롼פβtex_loopˤϡ
	 *  task_loop4ʬ1͡ʶ롼פμ¹Ի֤0.1äˤʤ롼ײ
	 *  ˤꤹ롥
	 */
#ifdef TASK_LOOP
	task_loop = TASK_LOOP;
#else /* TASK_LOOP */

#ifdef MEASURE_TWICE
	task_loop = LOOP_REF;
	SVC_PERROR(get_tim(&stime1));
	for (i = 0; i < task_loop; i++);
	SVC_PERROR(get_tim(&stime2));
#endif /* MEASURE_TWICE */

	task_loop = LOOP_REF;
	SVC_PERROR(get_tim(&stime1));
	for (i = 0; i < task_loop; i++);
	SVC_PERROR(get_tim(&stime2));
	task_loop = LOOP_REF * 400UL / (stime2 - stime1);

#endif /* TASK_LOOP */
	tex_loop = task_loop / 4;

	/*
 	 *  εư
	 */
	SVC_PERROR(act_tsk(TASK1));
	SVC_PERROR(act_tsk(TASK2));
	SVC_PERROR(act_tsk(TASK3));

	/*
 	 *  ᥤ롼
	 */
	do {
		SVC_PERROR(serial_rea_dat(TASK_PORTID, &c, 1));
		switch (c) {
		case 'e':
		case 's':
		case 'S':
		case 'd':
		case 'y':
		case 'Y':
		case 'z':
		case 'Z':
			message[tskno-1] = c;
			break;
		case '1':
			tskno = 1;
			tskid = TASK1;
			break;
		case '2':
			tskno = 2;
			tskid = TASK2;
			break;
		case '3':
			tskno = 3;
			tskid = TASK3;
			break;
		case 'a':
			syslog(LOG_INFO, "#act_tsk(%d)", tskno);
			SVC_PERROR(act_tsk(tskid));
			break;
		case 'A':
			syslog(LOG_INFO, "#can_act(%d)", tskno);
			SVC_PERROR(ercd = can_act(tskid));
			if (ercd >= 0) {
				syslog(LOG_NOTICE, "can_act(%d) returns %d", tskno, ercd);
			}
			break;
		case 't':
			syslog(LOG_INFO, "#ter_tsk(%d)", tskno);
			SVC_PERROR(ter_tsk(tskid));
			break;
		case '>':
			syslog(LOG_INFO, "#chg_pri(%d, HIGH_PRIORITY)", tskno);
			SVC_PERROR(chg_pri(tskid, HIGH_PRIORITY));
			break;
		case '=':
			syslog(LOG_INFO, "#chg_pri(%d, MID_PRIORITY)", tskno);
			SVC_PERROR(chg_pri(tskid, MID_PRIORITY));
			break;
		case '<':
			syslog(LOG_INFO, "#chg_pri(%d, LOW_PRIORITY)", tskno);
			SVC_PERROR(chg_pri(tskid, LOW_PRIORITY));
			break;
		case 'G':
			syslog(LOG_INFO, "#get_pri(%d, &tskpri)", tskno);
			SVC_PERROR(ercd = get_pri(tskid, &tskpri));
			if (ercd >= 0) {
				syslog(LOG_NOTICE, "priority of task %d is %d", tskno, tskpri);
			}
			break;
		case 'w':
			syslog(LOG_INFO, "#wup_tsk(%d)", tskno);
			SVC_PERROR(wup_tsk(tskid));
			break;
		case 'W':
			syslog(LOG_INFO, "#can_wup(%d)", tskno);
			SVC_PERROR(ercd = can_wup(tskid));
			if (ercd >= 0) {
				syslog(LOG_NOTICE, "can_wup(%d) returns %d", tskno, ercd);
			}
			break;
		case 'l':
			syslog(LOG_INFO, "#rel_wai(%d)", tskno);
			SVC_PERROR(rel_wai(tskid));
			break;
		case 'u':
			syslog(LOG_INFO, "#sus_tsk(%d)", tskno);
			SVC_PERROR(sus_tsk(tskid));
			break;
		case 'm':
			syslog(LOG_INFO, "#rsm_tsk(%d)", tskno);
			SVC_PERROR(rsm_tsk(tskid));
			break;
		case 'x':
			syslog(LOG_INFO, "#ras_tex(%d, 0x0001U)", tskno);
			SVC_PERROR(ras_tex(tskid, 0x0001U));
			break;
		case 'X':
			syslog(LOG_INFO, "#ras_tex(%d, 0x0002U)", tskno);
			SVC_PERROR(ras_tex(tskid, 0x0002U));
			break;
		case 'r':
			syslog(LOG_INFO, "#rot_rdq(three priorities)");
			SVC_PERROR(rot_rdq(HIGH_PRIORITY));
			SVC_PERROR(rot_rdq(MID_PRIORITY));
			SVC_PERROR(rot_rdq(LOW_PRIORITY));
			break;
		case 'c':
			syslog(LOG_INFO, "#sta_cyc(1)");
			SVC_PERROR(sta_cyc(CYCHDR1));
			break;
		case 'C':
			syslog(LOG_INFO, "#stp_cyc(1)");
			SVC_PERROR(stp_cyc(CYCHDR1));
			break;
		case 'b':
			syslog(LOG_INFO, "#sta_alm(1, 5000)");
			SVC_PERROR(sta_alm(ALMHDR1, 5000));
			break;
		case 'B':
			syslog(LOG_INFO, "#stp_alm(1)");
			SVC_PERROR(stp_alm(ALMHDR1));
			break;

		case 'V':
#ifdef TOPPERS_SUPPORT_GET_UTM
			SVC_PERROR(get_utm(&utime1));
			SVC_PERROR(get_utm(&utime2));
			syslog(LOG_NOTICE, "utime1 = %ld, utime2 = %ld",
										(ulong_t) utime1, (ulong_t) utime2);
#else /* TOPPERS_SUPPORT_GET_UTM */
			syslog(LOG_NOTICE, "get_utm is not supported.");
#endif /* TOPPERS_SUPPORT_GET_UTM */
			break;

		case 'v':
			SVC_PERROR(syslog_msk_log(LOG_UPTO(LOG_INFO),
										LOG_UPTO(LOG_EMERG)));
			break;
		case 'q':
			SVC_PERROR(syslog_msk_log(LOG_UPTO(LOG_NOTICE),
										LOG_UPTO(LOG_EMERG)));
			break;

#ifdef BIT_KERNEL
		case ' ':
			SVC_PERROR(loc_cpu());
			{
				extern ER	bit_kernel(void);

				SVC_PERROR(ercd = bit_kernel());
				if (ercd >= 0) {
					syslog(LOG_NOTICE, "bit_kernel passed.");
				}
			}
			SVC_PERROR(unl_cpu());
			break;
#endif /* BIT_KERNEL */

		default:
			break;
		}
	} while (c != '\003' && c != 'Q');

	syslog(LOG_NOTICE, "Sample program ends.");
	SVC_PERROR(ext_ker());
	assert(0);
}
