/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2006-2011 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ(1)(4)ξ˸¤ꡤܥեȥ
 *  ܥեȥѤΤޤࡥʲƱˤѡʣ
 *  ѡۡʰʲѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *      ޤܥեȥΥ桼ޤϥɥ桼Τʤ
 *      ͳ˴Ťᤫ⡤嵭ԤTOPPERSץȤ
 *      դ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơλŪ
 *  ФŬޤơʤݾڤԤʤޤܥեȥ
 *  ѤˤľŪޤϴŪʤ»˴ؤƤ⡤
 *  Ǥʤ
 * 
 *  @(#) $Id$
 */

/*
 *		PD72001 ʰSIOɥ饤
 */

#ifndef TOPPERS_UPD72001_H
#define TOPPERS_UPD72001_H

/*
 *  ꥢI/Oݡȿ
 */
#define TNUM_SIOP		2		/* ݡȤ륷ꥢI/OݡȤο */

#ifndef TOPPERS_MACRO_ONLY

/*
 *  ꥢI/Oݡȴ֥å
 */
typedef struct sio_port_control_block	SIOPCB;

/*
 *  Хå롼μֹ
 */
#define SIO_RDY_SND		1U		/* ǽХå */
#define SIO_RDY_RCV		2U		/* ΥХå */

/*
 *  SIOɥ饤Фν롼
 */
extern void		upd72001_initialize(void);

/*
 *  ץ󤷤ƤݡȤ뤫
 */
extern bool_t	upd72001_openflag(void);

/*
 *  ꥢI/OݡȤΥץ
 */
extern SIOPCB	*upd72001_opn_por(ID siopid, intptr_t exinf);

/*
 *  ꥢI/OݡȤΥ
 */
extern void		upd72001_cls_por(SIOPCB *p_siopcb);

/*
 *  ꥢI/OݡȤؤʸ
 */
extern bool_t	upd72001_snd_chr(SIOPCB *p_siopcb, char c);

/*
 *  ꥢI/OݡȤʸ
 */
extern int_t	upd72001_rcv_chr(SIOPCB *p_siopcb);

/*
 *  ꥢI/OݡȤΥХåε
 */
extern void		upd72001_ena_cbr(SIOPCB *p_siopcb, uint_t cbrtn);

/*
 *  ꥢI/OݡȤΥХåζػ
 */
extern void		upd72001_dis_cbr(SIOPCB *p_siopcb, uint_t cbrtn);

/*
 *  SIOγߥӥ롼
 */
extern void		upd72001_isr(void);

/*
 *  ꥢI/OݡȤǽХå
 */
extern void		upd72001_irdy_snd(intptr_t exinf);

/*
 *  ꥢI/OݡȤμΥХå
 */
extern void		upd72001_irdy_rcv(intptr_t exinf);

#endif /* TOPPERS_MACRO_ONLY */
#endif /* TOPPERS_UPD72001_H */
