/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005-2010 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ(1)(4)ξ˸¤ꡤܥեȥ
 *  ܥեȥѤΤޤࡥʲƱˤѡʣ
 *  ѡۡʰʲѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *      ޤܥեȥΥ桼ޤϥɥ桼Τʤ
 *      ͳ˴Ťᤫ⡤嵭ԤTOPPERSץȤ
 *      դ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơλŪ
 *  ФŬޤơʤݾڤԤʤޤܥեȥ
 *  ѤˤľŪޤϴŪʤ»˴ؤƤ⡤
 *  Ǥʤ
 * 
 *  $Id$
 */

/*
 *		।٥ȴ⥸塼
 */

#ifndef TOPPERS_TIME_EVENT_H
#define TOPPERS_TIME_EVENT_H

/*
 *  ٥ȯΥǡ
 *
 *  EVTTIMϡRELTIMȤƻǤϰϤ⹭ϰϤɽǤɬ
 *  롥ITRON4.0ͤΥɥץեǤϡRELTIM16ӥ
 *  ȰʾǤʤФʤʤᡤEVTTIM17ӥåȰʾǤ뤳Ȥɬ
 *  Ǥ롥Τᡤ16ӥåȤˤʤ礬uint_tǤϤʤulong_t
 *  Ƥ롥
 */
typedef ulong_t	EVTTIM;

/* 
 *  ।٥ȥ֥åΥǡ
 */
typedef void	(*CBACK)(void *);	/* Хåؿη */

typedef struct time_event_block {
	uint_t	index;			/* ।٥ȥҡǤΰ */
	CBACK	callback;		/* Хåؿ */
	void	*arg;			/* ХåؿϤ */
} TMEVTB;

/*
 *  ।٥ȥҡΥΡɤΥǡ
 */
typedef struct time_event_node {
	EVTTIM	time;			/* ٥ȯ */
	TMEVTB	*p_tmevtb;		/* б륿।٥ȥ֥å */
} TMEVTN;

/*
 *  ।٥ȥҡסkernel_cfg.c
 */
extern TMEVTN	tmevt_heap[];

/*
 *  ߤΥƥñ: 1ߥá
 *
 *  ƥ൯ư0˽졤ʹߡƥå뤵٤
 *  ñĴä롥
 */
extern EVTTIM	current_time;

/*
 *  ।٥ȥҡͭʺǾΥƥñ: 1ߥá
 */
extern EVTTIM	min_time;

/*
 *  ΥƥåΥƥñ: 1ߥá
 */
extern EVTTIM	next_time;

/*
 *  ƥѻѿñ: 1/TIC_DENOߥá
 *
 *  ΥƥåΥƥβ̷򼨤ʾ̷next_timeˡ
 *  TIC_DENO1λϡ̷Ͼ0Ǥ뤿ᡤѿɬפʤ
 */
#if TIC_DENO != 1U
extern uint_t	next_subtime;
#endif /* TIC_DENO != 1U */

/*
 *  л֤δñ: 1ߥá
 *
 *  ΥƥåΥƥڤ夲TIC_DENO1λ
 *  ϡnext_time˰פ롥
 */
#if TIC_DENO == 1U
#define	base_time	(next_time)
#else /* TIC_DENO == 1U */
#define	base_time	(next_time + (next_subtime > 0U ? 1U : 0U))
#endif /* TIC_DENO == 1U */

/*
 *  ।٥ȥҡפκǸλΰΥǥå
 *
 *  ।٥ȥҡפϿƤ륿।٥Ȥο˰פ롥
 */
extern uint_t	last_index;

/*
 *  ।٥ȴ⥸塼ν
 */
extern void	initialize_tmevt(void);

/*
 *  ।٥Ȥ֤õ
 */
extern uint_t	tmevt_up(uint_t index, EVTTIM time);
extern uint_t	tmevt_down(uint_t index, EVTTIM time);

/*
 *  ।٥ȥҡפؤϿȺ
 */
extern void	tmevtb_insert(TMEVTB *p_tmevtb, EVTTIM time);
extern void	tmevtb_delete(TMEVTB *p_tmevtb);

/*
 *  ।٥ȥ֥åϿлֻ
 *
 *  timeǻꤷл֤вᤷˡargȤcallback
 *  ӽФ褦ˡp_tmevtbǻꤷ।٥ȥ֥åϿ
 *  롥
 *  
 */
Inline void
tmevtb_enqueue(TMEVTB *p_tmevtb, RELTIM time, CBACK callback, void *arg)
{
	assert(time <= TMAX_RELTIM);

	p_tmevtb->callback = callback;
	p_tmevtb->arg = arg;
	tmevtb_insert(p_tmevtb, base_time + time);
}

/*
 *  ।٥ȥ֥åϿʥ٥ȯ
 *
 *  timeǻꤷ٥ȯˡargȤcallbackƤӽ
 *  褦ˡp_tmevtbǻꤷ।٥ȥ֥åϿ롥
 */
Inline void
tmevtb_enqueue_evttim(TMEVTB *p_tmevtb, EVTTIM time, CBACK callback, void *arg)
{
	p_tmevtb->callback = callback;
	p_tmevtb->arg = arg;
	tmevtb_insert(p_tmevtb, time);
}

/*
 *  ।٥ȥ֥åϿ
 */
Inline void
tmevtb_dequeue(TMEVTB *p_tmevtb)
{
	tmevtb_delete(p_tmevtb);
}

/*
 *  ।٥ȤޤǤλĤ֤η׻
 */
extern RELTIM	tmevt_lefttim(TMEVTB *p_tmevtb);

/*
 *  ƥåζ
 */
extern void	signal_time(void);

#endif /* TOPPERS_TIME_EVENT_H */
