/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005-2013 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ(1)(4)ξ˸¤ꡤܥեȥ
 *  ܥեȥѤΤޤࡥʲƱˤѡʣ
 *  ѡۡʰʲѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *      ޤܥեȥΥ桼ޤϥɥ桼Τʤ
 *      ͳ˴Ťᤫ⡤嵭ԤTOPPERSץȤ
 *      դ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơλŪ
 *  ФŬޤơʤݾڤԤʤޤܥեȥ
 *  ѤˤľŪޤϴŪʤ»˴ؤƤ⡤
 *  Ǥʤ
 * 
 *  $Id$
 */

/*
 *		।٥ȴ⥸塼
 */

#include "kernel_impl.h"
#include "time_event.h"

/*
 *  ।٥ȥҡޥ
 */
#define	PARENT(index)		((index) >> 1)		/* ƥΡɤ */
#define	LCHILD(index)		((index) << 1)		/* λҥΡɤ */
#define	TMEVT_NODE(index)	(tmevt_heap[(index) - 1])

/*
 *  ٥ȯӥޥ
 *
 *  ٥ȯϡmin_timeͤӤ롥ʤ
 *  min_timeǾ͡ʺǤᤤˡmit_time-1͡ʺǤ󤤻
 *  ȤߤʤӤ롥
 */
#define	EVTTIM_LT(t1, t2) (((t1) - min_time) < ((t2) - min_time))
#define	EVTTIM_LE(t1, t2) (((t1) - min_time) <= ((t2) - min_time))

#ifdef TOPPERS_tmeini

/*
 *  ߤΥƥñ: 1ߥá
 *
 *  ̩ˤϡΥƥåΥƥ
 */
EVTTIM	current_time;

/*
 *  ।٥ȥҡͭʺǾΥƥñ: 1ߥá
 */
EVTTIM	min_time;

/*
 *  ΥƥåΥƥñ: 1ߥá
 */
EVTTIM	next_time;

/*
 *  ƥѻѿñ: 1/TIC_DENOߥá
 */
#if TIC_DENO != 1U
uint_t	next_subtime;
#endif /* TIC_DENO != 1U */

/*
 *  ।٥ȥҡפκǸλΰΥǥå
 */
uint_t	last_index;

/*
 *  ޥ⥸塼ν
 */
void
initialize_tmevt(void)
{
	current_time = 0U;
	min_time = 0U;
	next_time = current_time + TIC_NUME / TIC_DENO;
#if TIC_DENO != 1U
	next_subtime = TIC_NUME % TIC_DENO;
#endif /* TIC_DENO != 1U */
	last_index = 0U;
}

#endif /* TOPPERS_tmeini */

/*
 *  ।٥Ȥ֤õ
 *
 *  timeȯ륿।٥ȤΡɤ뤿ˡ
 *  ҡפξ˸äƶΡɤư롥ưζΡɤΰ֤
 *  indexϤȡưζΡɤΰ֡ʤʤ֡ˤ֤
 */
#ifdef TOPPERS_tmeup

uint_t
tmevt_up(uint_t index, EVTTIM time)
{
	uint_t	parent;

	while (index > 1) {
		/*
		 *  ƥΡɤΥ٥ȯᤤʤޤƱˤʤС
		 *  index֤ʤΤǥ롼פȴ롥
		 */
		parent = PARENT(index);
		if (EVTTIM_LE(TMEVT_NODE(parent).time, time)) {
			break;
		}

		/*
		 *  ƥΡɤindexΰ֤˰ư롥
		 */
		TMEVT_NODE(index) = TMEVT_NODE(parent);
		TMEVT_NODE(index).p_tmevtb->index = index;

		/*
		 *  indexƥΡɤΰ֤˹
		 */
		index = parent;
	}
	return(index);
}

#endif /* TOPPERS_tmeup */

/*
 *  ।٥Ȥ֤򲼸õ
 *
 *  timeȯ륿।٥ȤΡɤ뤿ˡ
 *  ҡפβ˸äƶΡɤư롥ưζΡɤΰ֤ 
 *  indexϤȡưζΡɤΰ֡ʤʤ֡ˤ֤
 */
#ifdef TOPPERS_tmedown

uint_t
tmevt_down(uint_t index, EVTTIM time)
{
	uint_t	child;

	while ((child = LCHILD(index)) <= last_index) {
		/*
		 *  λҥΡɤΥ٥ȯӤᤤλҥΡ
		 *  ΰ֤childꤹ롥ʲλҥΡɤϡФ줿
		 *  λҥΡɤΤȡ
		 */
		if (child + 1 <= last_index
						&& EVTTIM_LT(TMEVT_NODE(child + 1).time,
										TMEVT_NODE(child).time)) {
			child = child + 1;
		}

		/*
		 *  ҥΡɤΥ٥ȯ٤ʤޤƱˤʤС
		 *  index֤ʤΤǥ롼פȴ롥
		 */
		if (EVTTIM_LE(time, TMEVT_NODE(child).time)) {
			break;
		}

		/*
		 *  ҥΡɤindexΰ֤˰ư롥
		 */
		TMEVT_NODE(index) = TMEVT_NODE(child);
		TMEVT_NODE(index).p_tmevtb->index = index;

		/*
		 *  indexҥΡɤΰ֤˹
		 */
		index = child;
	}
	return(index);
}

#endif /* TOPPERS_tmedown */

/*
 *  ।٥ȥҡפؤϿ
 *
 *  p_tmevtbǻꤷ।٥ȥ֥åtimeǻꤷ֤
 *  ˥٥Ȥȯ褦ˡ।٥ȥҡפϿ롥
 */
#ifdef TOPPERS_tmeins

void
tmevtb_insert(TMEVTB *p_tmevtb, EVTTIM time)
{
	uint_t	index;

	/*
	 *  last_index򥤥󥯥Ȥ֤õ
	 */
	index = tmevt_up(++last_index, time);

	/*
	 *  ।٥Ȥindexΰ֤롥
	 */ 
	TMEVT_NODE(index).time = time;
	TMEVT_NODE(index).p_tmevtb = p_tmevtb;
	p_tmevtb->index = index;
}

#endif /* TOPPERS_tmeins */

/*
 *  ।٥ȥҡפκ
 */
#ifdef TOPPERS_tmedel

void
tmevtb_delete(TMEVTB *p_tmevtb)
{
	uint_t	index = p_tmevtb->index;
	uint_t	parent;
	EVTTIM	event_time = TMEVT_NODE(last_index).time;

	/*
	 *  ˤ꥿।٥ȥҡפˤʤϲ⤷ʤ
	 */
	if (--last_index == 0) {
		return;
	}

	/*
	 *  Ρɤΰ֤˺ǸΥΡɡlast_index+1ΰ֤ΥΡɡ
	 *  Ŭڤʰ֤ذư롥ºݤˤϡǸΥΡ
	 *  ºݤΤǤϤʤΡɤΰ֤Ρɤˤ
	 *  ΤǡǸΥΡɤ٤֤ظƶΡɤư
	 *  롥
	 *  ǸΥΡɤΥ٥ȯ郎ΡɤοƥΡɤΥ
	 *  ٥ȯξˤϡ˸ä֤õ
	 *  Ǥʤˤϡ˸äõ
	 */
	if (index > 1 && EVTTIM_LT(event_time,
								TMEVT_NODE(parent = PARENT(index)).time)) {
		/*
		 *  ƥΡɤindexΰ֤˰ư롥
		 */
		TMEVT_NODE(index) = TMEVT_NODE(parent);
		TMEVT_NODE(index).p_tmevtb->index = index;

		/*
		 *  ΡɤοƥΡɤ˸ä֤õ
		 */
		index = tmevt_up(parent, event_time);
	}
	else {
		/*
		 *  Ρɤ鲼˸ä֤õ
		 */
		index = tmevt_down(index, event_time);
	}

	/*
	 *  ǸΥΡɤindexΰ֤롥
	 */ 
	TMEVT_NODE(index) = TMEVT_NODE(last_index + 1);
	TMEVT_NODE(index).p_tmevtb->index = index;
}

#endif /* TOPPERS_tmedel */

/*
 *  ।٥ȥҡפƬΥΡɤκ
 */
Inline void
tmevtb_delete_top(void)
{
	uint_t	index;
	EVTTIM	event_time = TMEVT_NODE(last_index).time;

	/*
	 *  ˤ꥿।٥ȥҡפˤʤϲ⤷ʤ
	 */
	if (--last_index == 0) {
		return;
	}

	/*
	 *  롼ȥΡɤ˺ǸΥΡɡlast_index + 1 ΰ֤ΥΡɡˤ
	 *  Ŭڤʰ֤ذư롥ºݤˤϡǸΥΡɤ
	 *  ºݤΤǤϤʤ롼ȥΡɤΡɤˤʤΤǡ
	 *  ΥΡɤ٤֤ظƶΡɤư롥
	 */
	index = tmevt_down(1, event_time);

	/*
	 *  ǸΥΡɤindexΰ֤롥
	 */ 
	TMEVT_NODE(index) = TMEVT_NODE(last_index + 1);
	TMEVT_NODE(index).p_tmevtb->index = index;
}

/*
 *  ।٥ȤޤǤλĤ֤η׻
 */
#ifdef TOPPERS_tmeltim

RELTIM
tmevt_lefttim(TMEVTB *p_tmevtb)
{
	EVTTIM	time;

	time = TMEVT_NODE(p_tmevtb->index).time;
	if (EVTTIM_LE(time, next_time)) {
		/*
		 *  Υƥåǽˤ0֤
		 */
		return(0U);
	}
	else {
		return((RELTIM)(time - base_time));
	}
}

#endif /* TOPPERS_tmeltim */

/*
 *  ƥåζ
 */
#ifdef TOPPERS_sigtim

void
signal_time(void)
{
	TMEVTB	*p_tmevtb;

	assert(sense_context());
	assert(!i_sense_lock());

	i_lock_cpu();

	/*
	 *  current_time򹹿롥
	 */
	current_time = next_time;

	/*
	 *  next_timenext_subtime򹹿롥
	 */
#if TIC_DENO == 1U
	next_time = current_time + TIC_NUME;
#else /* TIC_DENO == 1U */
	next_subtime += TIC_NUME % TIC_DENO;
	next_time = current_time + TIC_NUME / TIC_DENO;
	if (next_subtime >= TIC_DENO) {
		next_subtime -= TIC_DENO;
		next_time += 1U;
	}
#endif /* TIC_DENO == 1U */

	/*
	 *  current_timeꥤ٥ȯᤤʤޤƱ˥।
	 *  Ȥ򡤥।٥ȥҡפХåؿƤ
	 *  Ф
	 */
	while (last_index > 0 && EVTTIM_LE(TMEVT_NODE(1).time, current_time)) {
		p_tmevtb = TMEVT_NODE(1).p_tmevtb;
		tmevtb_delete_top();
		(*(p_tmevtb->callback))(p_tmevtb->arg);
	}

	/*
	 *  min_time򹹿롥
	 */
	min_time = current_time;

	i_unlock_cpu();
}

#endif /* TOPPERS_sigtim */
