/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005-2013 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ(1)(4)ξ˸¤ꡤܥեȥ
 *  ܥեȥѤΤޤࡥʲƱˤѡʣ
 *  ѡۡʰʲѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *      ޤܥեȥΥ桼ޤϥɥ桼Τʤ
 *      ͳ˴Ťᤫ⡤嵭ԤTOPPERSץȤ
 *      դ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơλŪ
 *  ФŬޤơʤݾڤԤʤޤܥեȥ
 *  ѤˤľŪޤϴŪʤ»˴ؤƤ⡤
 *  Ǥʤ
 * 
 *  @(#) $Id$
 */

/*
 *		ͥ٥ǡ塼ǽ
 */

#ifndef TOPPERS_PRIDATAQ_H
#define TOPPERS_PRIDATAQ_H

#include "wait.h"

/*
 *  ͥ٥ǡ֥å
 */
typedef struct pridata_management_block PDQMB;

struct pridata_management_block {
	PDQMB		*p_next;		/* Υǡ */
	intptr_t	data;			/* ǡ */
	PRI			datapri;		/* ǡͥ */
};

/*
 *  ͥ٥ǡ塼֥å
 *
 *  ι¤ΤϡƱ֥̿Ȥν֥åζʬ
 *  WOBJINIBˤĥʥ֥ȻظηѾˤΤǡ
 *  ǽΥեɤ̤ˤʤäƤ롥
 */
typedef struct pridataq_initialization_block {
	ATR			pdqatr;			/* ͥ٥ǡ塼° */
	uint_t		pdqcnt;			/* ͥ٥ǡ塼 */
	PRI			maxdpri;		/* ǡͥ٤κ */
	PDQMB		*p_pdqmb;		/* ͥ٥ǡ塼ΰƬ */
} PDQINIB;

/*
 *  ͥ٥ǡ塼֥å
 *
 *  ι¤ΤϡƱ֥̿Ȥδ֥åζʬWOBJCB
 *  ĥʥ֥ȻظηѾˤΤǡǽ2Ĥ
 *  եɤ̤ˤʤäƤ롥
 */
typedef struct pridataq_control_block {
	QUEUE		swait_queue;	/* ͥ٥ǡ塼Ԥ塼 */
	const PDQINIB *p_pdqinib;	/* ֥åؤΥݥ */
	QUEUE		rwait_queue;	/* ͥ٥ǡ塼Ԥ塼 */
	uint_t		count;			/* ͥ٥ǡ塼Υǡο */
	PDQMB		*p_head;		/* ǽΥǡ */
	uint_t		unused;			/* ̤ѥǡ֥åƬ */
	PDQMB		*p_freelist;	/* ̤ƥǡ֥åΥꥹ */
} PDQCB;

/*
 *  ͥ٥ǡ塼Ԥ֥å
 *
 *  ι¤ΤϡƱ֥̿ȤԤ֥åζʬ
 *  WINFO_WOBJˤĥʥ֥ȻظηѾˤΤǡ
 *  ǽ2ĤΥեɤ̤ˤʤäƤ롥
 *  ͥ٥ǡ塼ؤԤͥ٥ǡ塼μԤǡ
 *  ƱԤ֥åȤ
 */
typedef struct pridataq_waiting_information {
	WINFO		winfo;			/* ɸԤ֥å */
	PDQCB		*p_pdqcb;		/* ԤäƤͥ٥ǡ塼δ֥å*/
	intptr_t	data;			/* ǡ */
	PRI			datapri;		/* ǡͥ */
} WINFO_PDQ;

/*
 *  ͥ٥ǡ塼IDκ͡kernel_cfg.c
 */
extern const ID	tmax_pdqid;

/*
 *  ͥ٥ǡ塼֥åΥꥢkernel_cfg.c
 */
extern const PDQINIB	pdqinib_table[];

/*
 *  ͥ٥ǡ塼֥åΥꥢkernel_cfg.c
 */
extern PDQCB	pdqcb_table[];

/*
 *  ͥ٥ǡ塼֥åͥ٥ǡ塼IDФ
 *  Υޥ
 */
#define	PDQID(p_pdqcb)	((ID)(((p_pdqcb) - pdqcb_table) + TMIN_PDQID))

/*
 *  ͥ٥ǡ塼ǽν
 */
extern void	initialize_pridataq(void);

/*
 *  ͥ٥ǡ塼ΰؤΥǡγǼ
 */
extern void	enqueue_pridata(PDQCB *p_pdqcb, intptr_t data, PRI datapri);

/*
 *  ͥ٥ǡ塼ΰ褫ΥǡμФ
 */
extern void	dequeue_pridata(PDQCB *p_pdqcb, intptr_t *p_data, PRI *p_datapri);

/*
 *  ͥ٥ǡ塼ؤΥǡ
 */
extern bool_t	send_pridata(PDQCB *p_pdqcb, intptr_t data,
											PRI datapri, bool_t *p_dspreq);

/*
 *  ͥ٥ǡ塼Υǡ
 */
extern bool_t	receive_pridata(PDQCB *p_pdqcb, intptr_t *p_data,
											PRI *p_datapri, bool_t *p_dspreq);

#endif /* TOPPERS_PRIDATAQ_H */
