/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005,2006 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ(1)(4)ξ˸¤ꡤܥեȥ
 *  ܥեȥѤΤޤࡥʲƱˤѡʣ
 *  ѡۡʰʲѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *      ޤܥեȥΥ桼ޤϥɥ桼Τʤ
 *      ͳ˴Ťᤫ⡤嵭ԤTOPPERSץȤ
 *      դ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơλŪ
 *  ФŬޤơʤݾڤԤʤޤܥեȥ
 *  ѤˤľŪޤϴŪʤ»˴ؤƤ⡤
 *  Ǥʤ
 * 
 *  @(#) $Id$
 */

/*
 *		顼ϥɥ鵡ǽ
 */

#ifndef TOPPERS_ALARM_H
#define TOPPERS_ALARM_H

#include "time_event.h"

/*
 *  顼ϥɥ֥å
 */
typedef struct alarm_handler_initialization_block {
	ATR			almatr;			/* 顼ϥɥ° */
	intptr_t	exinf;			/* 顼ϥɥγĥ */
	ALMHDR		almhdr;			/* 顼ϥɥεư */
} ALMINIB;

/*
 *  顼ϥɥ֥å
 */
typedef struct alarm_handler_control_block {
	const ALMINIB *p_alminib;	/* ֥åؤΥݥ */
	bool_t		almsta;			/* 顼ϥɥư */
	TMEVTB		tmevtb;			/* ।٥ȥ֥å */
} ALMCB;

/*
 *  顼ϥɥIDκ͡kernel_cfg.c
 */
extern const ID	tmax_almid;

/*
 *  顼ϥɥ֥åΥꥢkernel_cfg.c
 */
extern const ALMINIB	alminib_table[];

/*
 *  顼ϥɥ֥åΥꥢkernel_cfg.c
 */
extern ALMCB	almcb_table[];

/*
 *  顼ϥɥ鵡ǽν
 */
extern void	initialize_alarm(void);

/*
 *  顼ϥɥ鵯ư롼
 */
extern void	call_almhdr(ALMCB *p_almcb);

#endif /* TOPPERS_ALARM_H */
