/*
 *  TOPPERS Software
 *      Toyohashi Open Platform for Embedded Real-Time Systems
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2004-2012 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ(1)(4)ξ˸¤ꡤܥեȥ
 *  ܥեȥѤΤޤࡥʲƱˤѡʣ
 *  ѡۡʰʲѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *      ޤܥեȥΥ桼ޤϥɥ桼Τʤ
 *      ͳ˴Ťᤫ⡤嵭ԤTOPPERSץȤ
 *      դ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơλŪ
 *  ФŬޤơʤݾڤԤʤޤܥեȥ
 *  ѤˤľŪޤϴŪʤ»˴ؤƤ⡤
 *  Ǥʤ
 * 
 *  @(#) $Id$
 */

/*
 *		TOPPERS̥إåե
 *
 *  TOPPERSϢΤ٤ƤΥեǥ󥯥롼ɤ٤إåե
 *  롥ƼΥͥ䥽եȥʤǶ̤Ѥ뤳ȤꤷƤ
 *  롥TOPPERSγƼΥͥ䥽եȥʤǶ̤Ѥǡ
 *  ޥʤɤޤࡥ
 *
 *  ֥Υե뤫餳Υե򥤥󥯥롼ɤ
 *  ϡTOPPERS_MACRO_ONLYƤˤꡤޥʳ
 *  褦ˤʤäƤ롥
 *
 *  Υե򥤥󥯥롼ɤ˥󥯥롼ɤƤ٤ե
 *  Ϥʤ
 */

#ifndef TOPPERS_T_STDDEF_H
#define TOPPERS_T_STDDEF_H

#ifdef __cplusplus
extern "C" {
#endif

/*
 *  åȰ¸
 */
#include "target_stddef.h"

/*
 *  C/EC++throw()н褹뤿
 */
#if !defined(__cplusplus) || defined(__embedded_cplusplus)
#define throw()
#endif

#ifndef TOPPERS_MACRO_ONLY

/*
 *  åȰ¸ΥǡΥޥΥǥե
 */
#ifndef TOPPERS_bool
#define TOPPERS_bool	int				/* ֡뷿 */
#endif /* TOPPERS_bool */

#ifndef TOPPERS_size
#define TOPPERS_size	uintptr_t		/*  */
#endif /* TOPPERS_size */

#ifndef TOPPERS_fp
struct TOPPERS_dummy_t { int TOPPERS_dummy_field; };
typedef	void			(*TOPPERS_fp_t)(struct TOPPERS_dummy_t);
#define TOPPERS_fp		TOPPERS_fp_t	/* ץεư */
#endif /* TOPPERS_fp */

/*
 *  ̥ǡ
 */
typedef TOPPERS_bool	bool_t;		/*  */

typedef signed int		int_t;		/* ʥդ */
typedef unsigned int	uint_t;		/* ʥ̵ */

typedef signed long		long_t;		/* ĹΥդ */
typedef unsigned long	ulong_t;	/* ĹΥ̵ */

typedef int_t			FN;			/* ǽ */
typedef	int_t			ER;			/* 顼 */
typedef	int_t			ID;			/* ֥ȤIDֹ */
typedef	uint_t			ATR;		/* ֥Ȥ° */
typedef	uint_t			STAT;		/* ֥Ȥξ */
typedef	uint_t			MODE;		/* ӥư⡼ */
typedef	int_t			PRI;		/* ͥ */
typedef	TOPPERS_size	SIZE;		/* ΰΥ */

typedef	int_t			TMO;		/* ॢȻ */
typedef	uint_t			RELTIM;		/* л */
typedef	ulong_t			SYSTIM;		/* ƥ */
typedef	ulong_t			SYSUTM;		/* ǽɾѥƥ */

typedef	TOPPERS_fp		FP;			/* ץεư */

typedef	int_t			ER_BOOL;	/* 顼ɤޤϿ */
typedef	int_t			ER_ID;		/* 顼ɤޤIDֹ */
typedef	int_t			ER_UINT;	/* 顼ɤޤ̵ */

typedef uintptr_t		MB_T;		/* ΰݤ뤿Υǡ */

typedef	uint32_t		ACPTN;		/* ĥѥ */
typedef	struct acvct {				/* ĥ٥ */
	ACPTN		acptn1;				/* ̾1Υĥѥ */
	ACPTN		acptn2;				/* ̾2Υĥѥ */
	ACPTN		acptn3;				/* Υĥѥ */
	ACPTN		acptn4;				/* Υĥѥ */
} ACVCT;

#endif /* TOPPERS_MACRO_ONLY */

/*
 *  ޥ
 */
#ifndef UINT_C
#define UINT_C(val)		(val ## U)		/* uint_tޥ */
#endif /* UINT_C */

#ifndef ULONG_C
#define ULONG_C(val)	(val ## UL)		/* ulong_tޥ */
#endif /* ULONG_C */

/*
 *  
 */
#ifndef NULL
#define NULL		0			/* ̵ݥ */
#endif /* NULL */

#ifndef true
#define true		1			/*  */
#endif /* true */

#ifndef false
#define false		0			/*  */
#endif /* false */

#define E_OK		0			/* ｪλ */

/*
 *  ᥤ󥨥顼
 */
#define E_SYS		(-5)		/* ƥ२顼 */
#define E_NOSPT		(-9)		/* ̤ݡȵǽ */
#define E_RSFN		(-10)		/* ͽǽ */
#define E_RSATR		(-11)		/* ͽ° */
#define E_PAR		(-17)		/* ѥ᡼顼 */
#define E_ID		(-18)		/* IDֹ */
#define E_CTX		(-25)		/* ƥȥ顼 */
#define E_MACV		(-26)		/* ꥢȿ */
#define E_OACV		(-27)		/* ֥ȥȿ */
#define E_ILUSE		(-28)		/* ӥ */
#define E_NOMEM		(-33)		/* ­ */
#define E_NOID		(-34)		/* IDֹ­ */
#define E_NORES		(-35)		/* ­ */
#define E_OBJ		(-41)		/* ֥Ⱦ֥顼 */
#define E_NOEXS		(-42)		/* ֥̤ */
#define E_QOVR		(-43)		/* 塼󥰥Сե */
#define E_RLWAI		(-49)		/* Ԥ֤ζ */
#define E_TMOUT		(-50)		/* ݡ󥰼Ԥޤϥॢ */
#define E_DLT		(-51)		/* Ԥ֥Ȥκ */
#define E_CLS		(-52)		/* Ԥ֥ȤξѲ */
#define E_WBLK		(-57)		/* Υ֥å󥰼դ */
#define E_BOVR		(-58)		/* ХåեСե */

/*
 *  ֥°
 */
#define TA_NULL		UINT_C(0)	/* ֥°ꤷʤ */

/*
 *  ॢȻ
 */
#define TMO_POL		0			/* ݡ */
#define TMO_FEVR	(-1)		/* ʵԤ */
#define TMO_NBLK	(-2)		/* Υ֥å */

/*
 *  ĥѥ
 */
#define TACP_KERNEL		(0U)	/* ͥɥᥤ˥ */
#define TACP_SHARED		(~0U)	/* ٤ƤΥɥᥤ󤫤饢 */

/*
 *  ˴ؤФΥޥ
 *
 *  ʲALIGN_TYPEϡ饤Ȥñ̤2ζҾǤ뤳Ȥ
 *  ꤷƤ롥
 */
#ifndef offsetof
#define	offsetof(structure, field)	((uintptr_t) &(((structure *) 0)->field))
#endif /* offsetof */

#ifndef alignof
#define alignof(type)	offsetof(struct { char field1; type field2; }, field2)
#endif /* alignof */

#ifndef ALIGN_TYPE				/* 饤ȤΥå */
#define ALIGN_TYPE(addr, type) \
						((((uintptr_t)(addr)) & (alignof(type) - 1)) == 0U)
#endif /* ALIGN_TYPE */

/*
 *  assertޥ
 */
#undef assert
#ifndef NDEBUG
#define assert(exp)		((void)((exp) ? 0 : (TOPPERS_assert_fail(#exp, \
							__FILE__, __LINE__), TOPPERS_assert_abort(), 0)))
#else /* NDEBUG */
#define assert(exp)		((void) 0)
#endif /* NDEBUG */

#ifdef __cplusplus
}
#endif

/*
 *  顼ʬޥ
 *
 *  ʲΥޥϡդ2ɽƤꡤե
 *  黻ҡ>>ˤѥեȤ뤳ȤꤷƤ롥Ǥʤȯ
 *  Ǥϡtarget_stddef.hǤ񤭤ʤФʤʤ
 *
 *  MERCDޥϡᥤ󥨥顼ɤǤ뤳ȤꤷƤ롥
 *  Ǥʤ硤2Ĥפʤʤ롥
 */
#ifndef ERCD
#define ERCD(mercd, sercd) \
				((ER)((((uint_t)(sercd)) << 8) | (((uint_t)(mercd)) & 0xffU)))
#endif /* ERCD */

#ifndef MERCD
#ifdef INT8_MAX
#define MERCD(ercd)		((ER)((int8_t)(ercd)))
#else /* INT8_MAX */
#define MERCD(ercd)		((ER)(((uint_t) ercd) | ~0xffU))
#endif /* INT8_MAX */
#endif /* MERCD */

#ifndef SERCD
#define SERCD(ercd)		((ER)((ercd) >> 8))
#endif /* SERCD */

/*
 *  ĥѥޥ
 */
#define TACP(domid)		(1U << ((domid) - 1))	/* domid˥ */

/*
 *  л֡RELTIMˤ˻Ǥ
 */
#if UINT_MAX < LONG_MAX
#define TMAX_RELTIM		((RELTIM) UINT_MAX)
#else /* UINT_MAX < LONG_MAX */
#define TMAX_RELTIM		((RELTIM) LONG_MAX)
#endif /* UINT_MAX < LONG_MAX */

#endif /* TOPPERS_T_STDDEF_H */
