/*
 *  TOPPERS Software
 *      Toyohashi Open Platform for Embedded Real-Time Systems
 * 
 *  Copyright (C) 2009-2013 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ(1)(4)ξ˸¤ꡤܥեȥ
 *  ܥեȥѤΤޤࡥʲƱˤѡʣ
 *  ѡۡʰʲѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *      ޤܥեȥΥ桼ޤϥɥ桼Τʤ
 *      ͳ˴Ťᤫ⡤嵭ԤTOPPERSץȤ
 *      դ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơλŪ
 *  ФŬޤơʤݾڤԤʤޤܥեȥ
 *  ѤˤľŪޤϴŪʤ»˴ؤƤ⡤
 *  Ǥʤ
 * 
 *  $Id$
 */

/* 
 *		ߥ塼ƥåΥƥ(8)
 *
 * ڥƥȤŪ
 *
 *  ͥپ¥ߥ塼ƥåФơchg_priȼߥ塼ƥåϢ
 *  ͥѹŪ˥ƥȤ롥change_priority
 *  mutex_calc_priorityƤˤƧ߹ޤʤ
 *
 * ڥƥȹܡ
 *
 *	(A) Υ١ͥ٤ѹchg_pri
 *		(A-1) оݥ¹ԤǤ֤ǡߥ塼ƥåå
 *			  ʤˡƱͥǤ̤ͥˤʤ뤳
 *		(A-2) оݥ¹ԤǤ֤ǡͥپ¥ߥ塼ƥå
 *			  Υߥ塼ƥåΤߤåƤˡƱͥ
 *			  Ǥ̤ͥˤʤ뤳
 *		(A-3) оݥ¹ԤǤ֤ǡͥپ¥ߥ塼ƥå
 *			  åƤˡƱͥǤ̤ͥѤ
 *			  
 *		(A-4) оݥԤ֤ǡͥٽԤˤĤʤƤ
 *			  ꡤߥ塼ƥååƤʤˡͥ٤
 *			  ѹ졤ƱͥǤνǸˤʤ뤳
 *		(A-5) оݥԤ֤ǡͥٽԤˤĤʤƤ
 *			  ꡤͥپ¥ߥ塼ƥåʳΥߥ塼ƥåΤߤ
 *			  Ƥˡͥ٤ѹ졤Ʊͥ
 *			  νǸˤʤ뤳
 *		(A-6) оݥԤ֤ǡͥٽԤˤĤʤƤ
 *			  ꡤͥپ¥ߥ塼ƥååƤˡƱ
 *			  ͥǤνѤʤ
 *	(B) Υ١ͥ٤ѹchg_priˤE_ILUSE顼
 *		(B-1) оݥåƤߥ塼ƥåξͥ٤
 *			  ⡤١ͥ٤⤯褦ȤE_ILUSE顼ˤʤ
 *			  
 *		(B-2) оݥͥپ¥ߥ塼ƥååƤƤ⡤
 *			  åƤߥ塼ƥåξͥ٤⡤١ͥ
 *			  ٤⤯褦ȤʤˤϡE_ILUSE顼ˤʤʤ
 *			  
 *		(B-3) оݥåԤäƤߥ塼ƥåξͥ
 *			  ⡤١ͥ٤⤯褦ȤE_ILUSE顼
 *			  ʤ뤳
 *		(B-4) оݥͥپ¥ߥ塼ƥåԤǤäƤ⡤
 *			  ԤäƤߥ塼ƥåξͥ٤⡤١ͥ
 *			  ٤⤯褦ȤʤˤϡE_ILUSE顼ˤʤʤ
 *			  
 *
 * ڥƥȹܤμ¸ˡ
 *
 *	(A-1)
 *		ͥ٥TASK1ˤ¹Բǽ֤λˡͥ٥
 *		TASK5ˤTASK1ͥ٤chg_priȡ¹Բǽ֤¾
 *		ͥ٥TASK4ˤ⡤̤ͥ㤯ʤ뤳Ȥǧ롥
 *	(A-2)
 *		ͥ٥TASK1ˤͥٽߥ塼ƥåMTX3ˤå
 *		¹Բǽ֤λˡͥ٥TASK5ˤTASK1ͥ
 *		٤chg_priȡ¹Բǽ֤¾ͥ٥TASK4
 *		⡤̤ͥ㤯ʤ뤳Ȥǧ롥
 *	(A-3)
 *		ͥ٥TASK1ˤͥپ¥ߥ塼ƥåMTX1ˤ
 *		¹Բǽ֤λˡͥ٥TASK5ˤTASK1
 *		ͥ٤chg_priȡTASK1ͥ٤ѲʤȤǧ롥
 *		ޤ¹Բǽ֤ͥ٥2ġTASK2TASK3ˤѰդ
 *		Ƥ̤ͥѤʤȤǧ롥
 *	(A-4)
 *		ͥ٥TASK1ˤͥپ¥ߥ塼ƥåMTX2ˤԤ
 *		Ƥˡͥ٥TASK5ˤTASK1ͥ٤
 *		chg_priȡMTX2ԤäƤ¾ͥ٥TASK4ˤ
 *		⡤ԤǤνˤʤ뤳Ȥǧ롥
 *	(A-5)
 *		ͥ٥TASK1ˤͥٽߥ塼ƥåMTX3ˤå
 *		ͥپ¥ߥ塼ƥåMTX2ˤԤäƤˡͥ٥
 *		TASK5ˤTASK1ͥ٤chg_priȡMTX2ԤäƤ
 *		¾ͥ٥TASK4ˤ⡤ԤǤνѤ
 *		ʤȤǧ롥
 *	(A-6)
 *		ͥ٥TASK1ˤͥپ¥ߥ塼ƥåMTX1ˤ
 *		ͥپ¥ߥ塼ƥåMTX2ˤԤäƤˡͥ
 *		٥TASK5ˤTASK1ͥ٤chg_priȡTASK1
 *		ͥ٤ѲʤȤǧ롥ޤMTX2ԤäƤͥ
 *		٥2ġTASK2TASK3ˤѰդƤԤǤν
 *		ѤʤȤǧ롥
 *	(B-1)
 *		ͥ٥TASK1ˤͥپ¥ߥ塼ƥåMTX1ˤ
 *		¹Բǽ֤λˡͥ٥TASK5ˤTASK1
 *		ͥ٤chg_priȡE_ILUSE顼ˤʤ뤳Ȥǧ롥
 *	(B-2)
 *		(A-3)Υƥȹܤǡchg_priE_ILUSE顼ˤʤʤȤǳǧ
 *		ǤƤ롥
 *	(B-3)
 *		ͥ٥TASK2ˤͥپ¥ߥ塼ƥåMTX1ˤΥ
 *		ԤäƤˡͥ٥TASK5ˤTASK2ͥ
 *		chg_priȡE_ILUSE顼ˤʤ뤳Ȥǧ롥
 *	(B-4)
 *		(A-6)Υƥȹܤǡchg_priE_ILUSE顼ˤʤʤȤǳǧ
 *		ǤƤ롥
 *
 * ڻѥ꥽
 *
 *	TASK1: ͥ٥ᥤ󥿥ǽ餫鵯ư
 *	TASK2: ͥ٥
 *	TASK3: ͥ٥
 *	TASK4: ͥ٥
 *	TASK5: ͥ٥
 *	MTX1: ߥ塼ƥåTA_CEILING°¤ͥ١
 *	MTX2: ߥ塼ƥåTA_CEILING°¤Ϲͥ١
 *	MTX3: ߥ塼ƥåTA_TPRI°
 *
 * ڥƥȥ󥹡
 *
 *	== TASK1ͥ١==
 *		call(set_bit_func(bit_mutex))
 *	1:	act_tsk(TASK4)
 *	2:	act_tsk(TASK5)
 *	//		⡧TASK5桧TASK1㡧TASK4
 *	== TASK5ͥ١==
 *	3:	chg_pri(TASK1, LOW_PRIORITY)		... (A-1)
 *	//		⡧TASK5㡧TASK4TASK1
 *	4:	slp_tsk()
 *	== TASK4ͥ١==
 *	5:	slp_tsk()
 *	== TASK1³==
 *	6:	chg_pri(TSK_SELF, TPRI_INI)
 *
 *	7:	loc_mtx(MTX3)
 *	8:	wup_tsk(TASK4)
 *	9:	wup_tsk(TASK5)
 *	//		⡧TASK5桧TASK1㡧TASK4MTX3TASK1
 *	== TASK5³==
 *	10:	chg_pri(TASK1, LOW_PRIORITY)		... (A-2)
 *	//		⡧TASK5㡧TASK4TASK1MTX3TASK1
 *	11:	slp_tsk()
 *	== TASK4³==
 *	12:	slp_tsk()
 *	== TASK1³==
 *	13:	unl_mtx(MTX3)
 *		chg_pri(TSK_SELF, TPRI_INI)
 *
 *	14:	loc_mtx(MTX1)
 *	15:	act_tsk(TASK2)
 *	16:	dis_dsp()
 *	17:	rot_rdq(MID_PRIORITY)
 *	18:	act_tsk(TASK3)
 *	//		桧TASK2TASK1TASK3MTX1TASK1
 *	19:	wup_tsk(TASK5)
 *	//		⡧TASK5桧TASK2TASK1TASK3MTX1TASK1
 *	20:	ena_dsp()
 *	== TASK5³==
 *	21:	chg_pri(TASK1, LOW_PRIORITY)		... (A-3)(B-2)
 *	//		⡧TASK5桧TASK2TASK1TASK3MTX1TASK1
 *		get_pri(TASK1, &tskpri)
 *		assert(tskpri == MID_PRIORITY)
 *	22:	slp_tsk()
 *	//		桧TASK2TASK1TASK3MTX1TASK1
 *	== TASK2³==
 *	23:	slp_tsk()
 *	//		桧TASK1TASK3MTX1TASK1
 *	== TASK1³==
 *	24:	unl_mtx(MTX1)
 *	//		桧TASK3㡧TASK1
 *	== TASK3³==
 *	25:	slp_tsk()
 *	== TASK1³==
 *	26:	chg_pri(TSK_SELF, TPRI_INI)
 *
 *	27:	wup_tsk(TASK5)
 *	== TASK5³==
 *	28:	loc_mtx(MTX2)
 *	29:	tslp_tsk(10) -> E_TMOUT
 *	== TASK1³==
 *	30:	wup_tsk(TASK4)
 *	31:	loc_mtx(MTX2)
 *	== TASK4³==
 *	32:	loc_mtx(MTX2)
 *	//		MTX2TASK5TASK1TASK4
 *	//		ॢԤ
 *	//		⡧TASK5MTX2TASK5TASK1TASK4
 *	== TASK5³==
 *	33:	chg_pri(TASK1, LOW_PRIORITY)		... (A-4)
 *	//		⡧TASK5MTX2TASK5TASK4TASK1
 *	34:	unl_mtx(MTX2)
 *	//		⡧TASK5TASK4MTX2TASK4TASK1
 *	35:	slp_tsk()
 *	//		⡧TASK4MTX2TASK4TASK1
 *	== TASK4³==
 *	36:	unl_mtx(MTX2)
 *	//		⡧TASK1㡧TASK4MTX2TASK1
 *	== TASK1³==
 *	37:	unl_mtx(MTX2)
 *	//		㡧TASK1TASK4
 *	38:	chg_pri(TSK_SELF, TPRI_INI)
 *
 *	39:	loc_mtx(MTX3)
 *	40:	wup_tsk(TASK5)
 *	//		⡧TASK5桧TASK1㡧TASK4MTX3TASK1
 *	== TASK5³==
 *	41:	loc_mtx(MTX2)
 *	42:	tslp_tsk(10) -> E_TMOUT
 *	== TASK1³==
 *	43:	loc_mtx(MTX2)
 *	== TASK4³==
 *	44:	loc_mtx(MTX2)
 *	//		MTX2TASK5TASK1TASK4MTX3TASK1
 *	//		ॢԤ
 *	//		⡧TASK5MTX2TASK5TASK1TASK4MTX3TASK1
 *	== TASK5³==
 *	45:	chg_pri(TASK1, LOW_PRIORITY)		... (A-5)
 *	//		⡧TASK5MTX2TASK5TASK4TASK1MTX3TASK1
 *	46:	unl_mtx(MTX2)
 *	//		⡧TASK5TASK4MTX2TASK4TASK1MTX3TASK1
 *	47:	slp_tsk()
 *	//		⡧TASK4MTX2TASK4TASK1MTX3TASK1
 *	== TASK4³==
 *	48:	unl_mtx(MTX2)
 *	//		⡧TASK1㡧TASK4MTX2TASK1MTX3TASK1
 *	== TASK1³==
 *	49:	unl_mtx(MTX2)
 *	//		㡧TASK1TASK4MTX3TASK1
 *	50:	unl_mtx(MTX3)
 *	//		㡧TASK1TASK4
 *	51:	ter_tsk(TASK4)
 *	52:	chg_pri(TSK_SELF, TPRI_INI)
 *
 *	53:	loc_mtx(MTX1)
 *	54:	wup_tsk(TASK5)
 *	//		⡧TASK5桧TASK1MTX1TASK1
 *	== TASK5³==
 *	55:	loc_mtx(MTX2)
 *	56:	tslp_tsk(10) -> E_TMOUT
 *	//		桧TASK1MTX1TASK1MTX2TASK5
 *	== TASK1³==
 *	57:	wup_tsk(TASK2)
 *	58:	rot_rdq(MID_PRIORITY)
 *	== TASK2³==
 *	59:	loc_mtx(MTX2)
 *	//		桧TASK1MTX1TASK1MTX2TASK5TASK2
 *	== TASK1³==
 *	60:	wup_tsk(TASK3)
 *	61:	loc_mtx(MTX2)
 *	//		桧TASK3MTX1TASK1MTX2TASK5TASK2TASK1
 *	== TASK3³==
 *	62:	loc_mtx(MTX2)
 *	//		MTX1TASK1MTX2TASK5TASK2TASK1TASK3
 *	//		ॢԤ
 *	//		⡧TASK5MTX1TASK1MTX2TASK5TASK2TASK1TASK3
 *	== TASK5³==
 *	63:	chg_pri(TASK1, LOW_PRIORITY)		... (A-6)(B-4)
 *	//		⡧TASK5MTX1TASK1MTX2TASK5TASK2TASK1TASK3
 *		get_pri(TASK1, &tskpri)
 *		assert(tskpri == MID_PRIORITY)
 *	64:	unl_mtx(MTX2)
 *	//		⡧TASK5TASK2MTX1TASK1MTX2TASK2TASK1TASK3
 *	65:	slp_tsk()
 *	//		⡧TASK2MTX1TASK1MTX2TASK2TASK1TASK3
 *	== TASK2³==
 *	66:	unl_mtx(MTX2)
 *	//		⡧TASK1桧TASK2MTX1TASK1MTX2TASK1TASK3
 *	== TASK1³==
 *	67:	unl_mtx(MTX2)
 *	//		⡧TASK3桧TASK1TASK2MTX1TASK1MTX2TASK3
 *	== TASK3³==
 *	68:	unl_mtx(MTX2)
 *	//		桧TASK3TASK1TASK2MTX1TASK1
 *	69:	ext_tsk() -> noreturn
 *	//		桧TASK1TASK2MTX1TASK1
 *	== TASK1³==
 *	70:	chg_pri(TSK_SELF, TPRI_INI)
 *	//		桧TASK1TASK2MTX1TASK1
 *
 *	71:	rot_rdq(MID_PRIORITY)
 *	//		桧TASK2TASK1MTX1TASK1
 *	== TASK2³==
 *	72:	loc_mtx(MTX1)
 *	//		桧TASK1MTX1TASK1TASK2
 *	== TASK1³==
 *	73:	wup_tsk(TASK5)
 *	//		⡧TASK5桧TASK1MTX1TASK1TASK2
 *	== TASK5³==
 *	74:	chg_pri(TASK1, HIGH_PRIORITY) -> E_ILUSE	... (B-1)
 *	75:	chg_pri(TASK2, HIGH_PRIORITY) -> E_ILUSE	... (B-3)
 *	76:	ext_tsk() -> noreturn
 *	//		桧TASK1MTX1TASK1TASK2
 *	== TASK1³==
 *	77:	unl_mtx(MTX1)
 *	//		桧TASK1TASK2MTX1TASK2
 *	78:	ext_tsk() -> noreturn
 *	== TASK2³==
 *	79:	unl_mtx(MTX1)
 *	80:	END
 */

#include <kernel.h>
#include <t_syslog.h>
#include "kernel_cfg.h"
#include "test_lib.h"
#include "test_mutex8.h"

extern ER	bit_mutex(void);

/* DO NOT DELETE THIS LINE -- gentest depends on it. */

void
task1(intptr_t exinf)
{
	ER_UINT	ercd;

	test_start(__FILE__);

	set_bit_func(bit_mutex);

	check_point(1);
	ercd = act_tsk(TASK4);
	check_ercd(ercd, E_OK);

	check_point(2);
	ercd = act_tsk(TASK5);
	check_ercd(ercd, E_OK);

	check_point(6);
	ercd = chg_pri(TSK_SELF, TPRI_INI);
	check_ercd(ercd, E_OK);

	check_point(7);
	ercd = loc_mtx(MTX3);
	check_ercd(ercd, E_OK);

	check_point(8);
	ercd = wup_tsk(TASK4);
	check_ercd(ercd, E_OK);

	check_point(9);
	ercd = wup_tsk(TASK5);
	check_ercd(ercd, E_OK);

	check_point(13);
	ercd = unl_mtx(MTX3);
	check_ercd(ercd, E_OK);

	ercd = chg_pri(TSK_SELF, TPRI_INI);
	check_ercd(ercd, E_OK);

	check_point(14);
	ercd = loc_mtx(MTX1);
	check_ercd(ercd, E_OK);

	check_point(15);
	ercd = act_tsk(TASK2);
	check_ercd(ercd, E_OK);

	check_point(16);
	ercd = dis_dsp();
	check_ercd(ercd, E_OK);

	check_point(17);
	ercd = rot_rdq(MID_PRIORITY);
	check_ercd(ercd, E_OK);

	check_point(18);
	ercd = act_tsk(TASK3);
	check_ercd(ercd, E_OK);

	check_point(19);
	ercd = wup_tsk(TASK5);
	check_ercd(ercd, E_OK);

	check_point(20);
	ercd = ena_dsp();
	check_ercd(ercd, E_OK);

	check_point(24);
	ercd = unl_mtx(MTX1);
	check_ercd(ercd, E_OK);

	check_point(26);
	ercd = chg_pri(TSK_SELF, TPRI_INI);
	check_ercd(ercd, E_OK);

	check_point(27);
	ercd = wup_tsk(TASK5);
	check_ercd(ercd, E_OK);

	check_point(30);
	ercd = wup_tsk(TASK4);
	check_ercd(ercd, E_OK);

	check_point(31);
	ercd = loc_mtx(MTX2);
	check_ercd(ercd, E_OK);

	check_point(37);
	ercd = unl_mtx(MTX2);
	check_ercd(ercd, E_OK);

	check_point(38);
	ercd = chg_pri(TSK_SELF, TPRI_INI);
	check_ercd(ercd, E_OK);

	check_point(39);
	ercd = loc_mtx(MTX3);
	check_ercd(ercd, E_OK);

	check_point(40);
	ercd = wup_tsk(TASK5);
	check_ercd(ercd, E_OK);

	check_point(43);
	ercd = loc_mtx(MTX2);
	check_ercd(ercd, E_OK);

	check_point(49);
	ercd = unl_mtx(MTX2);
	check_ercd(ercd, E_OK);

	check_point(50);
	ercd = unl_mtx(MTX3);
	check_ercd(ercd, E_OK);

	check_point(51);
	ercd = ter_tsk(TASK4);
	check_ercd(ercd, E_OK);

	check_point(52);
	ercd = chg_pri(TSK_SELF, TPRI_INI);
	check_ercd(ercd, E_OK);

	check_point(53);
	ercd = loc_mtx(MTX1);
	check_ercd(ercd, E_OK);

	check_point(54);
	ercd = wup_tsk(TASK5);
	check_ercd(ercd, E_OK);

	check_point(57);
	ercd = wup_tsk(TASK2);
	check_ercd(ercd, E_OK);

	check_point(58);
	ercd = rot_rdq(MID_PRIORITY);
	check_ercd(ercd, E_OK);

	check_point(60);
	ercd = wup_tsk(TASK3);
	check_ercd(ercd, E_OK);

	check_point(61);
	ercd = loc_mtx(MTX2);
	check_ercd(ercd, E_OK);

	check_point(67);
	ercd = unl_mtx(MTX2);
	check_ercd(ercd, E_OK);

	check_point(70);
	ercd = chg_pri(TSK_SELF, TPRI_INI);
	check_ercd(ercd, E_OK);

	check_point(71);
	ercd = rot_rdq(MID_PRIORITY);
	check_ercd(ercd, E_OK);

	check_point(73);
	ercd = wup_tsk(TASK5);
	check_ercd(ercd, E_OK);

	check_point(77);
	ercd = unl_mtx(MTX1);
	check_ercd(ercd, E_OK);

	check_point(78);
	ercd = ext_tsk();

	check_point(0);
}

void
task2(intptr_t exinf)
{
	ER_UINT	ercd;

	check_point(23);
	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(59);
	ercd = loc_mtx(MTX2);
	check_ercd(ercd, E_OK);

	check_point(66);
	ercd = unl_mtx(MTX2);
	check_ercd(ercd, E_OK);

	check_point(72);
	ercd = loc_mtx(MTX1);
	check_ercd(ercd, E_OK);

	check_point(79);
	ercd = unl_mtx(MTX1);
	check_ercd(ercd, E_OK);

	check_finish(80);
	check_point(0);
}

void
task3(intptr_t exinf)
{
	ER_UINT	ercd;

	check_point(25);
	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(62);
	ercd = loc_mtx(MTX2);
	check_ercd(ercd, E_OK);

	check_point(68);
	ercd = unl_mtx(MTX2);
	check_ercd(ercd, E_OK);

	check_point(69);
	ercd = ext_tsk();

	check_point(0);
}

void
task4(intptr_t exinf)
{
	ER_UINT	ercd;

	check_point(5);
	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(12);
	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(32);
	ercd = loc_mtx(MTX2);
	check_ercd(ercd, E_OK);

	check_point(36);
	ercd = unl_mtx(MTX2);
	check_ercd(ercd, E_OK);

	check_point(44);
	ercd = loc_mtx(MTX2);
	check_ercd(ercd, E_OK);

	check_point(48);
	ercd = unl_mtx(MTX2);
	check_ercd(ercd, E_OK);

	check_point(0);
}

void
task5(intptr_t exinf)
{
	ER_UINT	ercd;
	PRI		tskpri;

	check_point(3);
	ercd = chg_pri(TASK1, LOW_PRIORITY);
	check_ercd(ercd, E_OK);

	check_point(4);
	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(10);
	ercd = chg_pri(TASK1, LOW_PRIORITY);
	check_ercd(ercd, E_OK);

	check_point(11);
	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(21);
	ercd = chg_pri(TASK1, LOW_PRIORITY);
	check_ercd(ercd, E_OK);

	ercd = get_pri(TASK1, &tskpri);
	check_ercd(ercd, E_OK);

	check_assert(tskpri == MID_PRIORITY);

	check_point(22);
	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(28);
	ercd = loc_mtx(MTX2);
	check_ercd(ercd, E_OK);

	check_point(29);
	ercd = tslp_tsk(10);
	check_ercd(ercd, E_TMOUT);

	check_point(33);
	ercd = chg_pri(TASK1, LOW_PRIORITY);
	check_ercd(ercd, E_OK);

	check_point(34);
	ercd = unl_mtx(MTX2);
	check_ercd(ercd, E_OK);

	check_point(35);
	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(41);
	ercd = loc_mtx(MTX2);
	check_ercd(ercd, E_OK);

	check_point(42);
	ercd = tslp_tsk(10);
	check_ercd(ercd, E_TMOUT);

	check_point(45);
	ercd = chg_pri(TASK1, LOW_PRIORITY);
	check_ercd(ercd, E_OK);

	check_point(46);
	ercd = unl_mtx(MTX2);
	check_ercd(ercd, E_OK);

	check_point(47);
	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(55);
	ercd = loc_mtx(MTX2);
	check_ercd(ercd, E_OK);

	check_point(56);
	ercd = tslp_tsk(10);
	check_ercd(ercd, E_TMOUT);

	check_point(63);
	ercd = chg_pri(TASK1, LOW_PRIORITY);
	check_ercd(ercd, E_OK);

	ercd = get_pri(TASK1, &tskpri);
	check_ercd(ercd, E_OK);

	check_assert(tskpri == MID_PRIORITY);

	check_point(64);
	ercd = unl_mtx(MTX2);
	check_ercd(ercd, E_OK);

	check_point(65);
	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(74);
	ercd = chg_pri(TASK1, HIGH_PRIORITY);
	check_ercd(ercd, E_ILUSE);

	check_point(75);
	ercd = chg_pri(TASK2, HIGH_PRIORITY);
	check_ercd(ercd, E_ILUSE);

	check_point(76);
	ercd = ext_tsk();

	check_point(0);
}
