/*
 *  TOPPERS Software
 *      Toyohashi Open Platform for Embedded Real-Time Systems
 * 
 *  Copyright (C) 2008-2014 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ(1)(4)ξ˸¤ꡤܥեȥ
 *  ܥեȥѤΤޤࡥʲƱˤѡʣ
 *  ѡۡʰʲѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *      ޤܥեȥΥ桼ޤϥɥ桼Τʤ
 *      ͳ˴Ťᤫ⡤嵭ԤTOPPERSץȤ
 *      դ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơλŪ
 *  ФŬޤơʤݾڤԤʤޤܥեȥ
 *  ѤˤľŪޤϴŪʤ»˴ؤƤ⡤
 *  Ǥʤ
 * 
 *  $Id$
 */

/* 
 *		ߥ塼ƥåΥƥ(7)
 *
 * ڥƥȤŪ
 *
 *  ͥپ¥ߥ塼ƥåФơζλΥߥ塼ƥå
 *  ϢνŪ˥ƥȤ롥
 *
 * ڥƥȹܡ
 *
 *	(A) ζλter_tsk
 *		(A-1) åƤߥ塼ƥå1ġˤå뤳ȡ
 *		(A-2) åƤߥ塼ƥå1ġˤå졤
 *			  ԤäƤåͥ٤Ѳ
 *			  뤳ȡ
 *		(A-3) (A-2)η̡ǥѥå뤳ȡ
 *		(A-4) åƤߥ塼ƥåʣˤ٤ƥå
 *			  뤳ȡ
 *		(A-5) åƤߥ塼ƥåʣˤå졤
 *			  ԤäƤʣˤåͥ٤
 *			  Ԥ뤳ȡλˡǥߥ塼ƥå
 *			  å˥åƤߥ塼ƥåԤ
 *			  Ƥˤ̤ͥ⤯ʤ뤳ȡ
 *		(A-6) (A-5)η̡ǥѥå뤳ȡ
 *
 * ڥƥȹܤμ¸ˡ
 *
 *	(A-1)
 *		ͥ٥TASK2ˤ˥ߥ塼ƥåMTX1ˤå
 *		ΥTASK1ˤTASK2ter_tskȡå뤳
 *		Ȥǧ롥
 *	(A-2)
 *		ͥ٥TASK2ˤͥپ¥ߥ塼ƥåMTX1ˤ
 *		̤ͥ٥TASK3ˤMTX1Ԥ֤ǡͥ
 *		٥TASK1ˤTASK2ter_tskȡTASK3ͥ٤
 *		ʤäԤ뤳Ȥǧ롥
 *	(A-3)
 *		ͥ٥TASK2ˤͥپ¥ߥ塼ƥåMTX1ˤ
 *		̤ͥ٥TASK3ˤMTX1Ԥ֤ǡ̤
 *		ͥ٥TASK1ˤTASK2ter_tskȡTASK3ͥ
 *		٤ˤʤäԤ졤TASK3ڤ괹뤳Ȥǧ롥
 *	(A-4)
 *		ͥ٥TASK2ˤ˥ߥ塼ƥå2ġMTX1MTX2˥
 *		̤ΥTASK1ˤTASK2ter_tskȡξΥ
 *		뤳Ȥǧ롥
 *	(A-5)
 *		ͥ٥TASK2ˤ˹ͥپ¥ߥ塼ƥå2ġMTX1
 *		MTX2ˤ򤳤νǥå̤ͥ٥2ġTASK3
 *		TASK4ˤˤ줾ΥåԤ֤ǡͥ٥
 *		TASK1ˤTASK2ter_tskȡTASK3TASK4ͥ٤ˤʤ
 *		Ԥ뤳Ȥǧ롥ޤ˥åƤߥ塼
 *		ƥåMTX1ˤԤäƤTASK3ˤTASK4ͥ
 *		̤⤯ʤ뤳Ȥǧ롥
 *	(A-6)
 *		ͥ٥TASK2ˤ˹ͥپ¥ߥ塼ƥå2ġMTX1
 *		MTX2ˤ򤳤νǥå̤ͥ٥2ġTASK3
 *		TASK4ˤˤ줾ΥåԤ֤ǡ̤ͥ٥
 *		TASK1ˤTASK2 ter_tskȡTASK3TASK4ͥ٤ˤʤ
 *		Ԥ졤TASK3ڤ괹뤳Ȥǧ롥
 *
 * ڻѥ꥽
 *
 *	TASK1: ͥ٥ᥤ󥿥ǽ餫鵯ư
 *	TASK2: ͥ٥
 *	TASK3: ͥ٥
 *	TASK4: ͥ٥
 *	MTX1: ߥ塼ƥåTA_CEILING°¤ͥ١
 *	MTX2: ߥ塼ƥåTA_CEILING°¤ͥ١
 *
 * ڥƥȥ󥹡
 *
 *	== TASK1ͥ١==
 *		call(set_bit_func(bit_mutex))
 *	1:	act_tsk(TASK2)
 *	2:	slp_tsk()
 *	//		㡧TASK2
 *	== TASK2-1ͥ١==
 *	3:	loc_mtx(MTX1)
 *	//		桧TASK2MTX1TASK2
 *	4:	wup_tsk(TASK1)
 *	//		⡧TASK1桧TASK2MTX1TASK2
 *	== TASK1³==
 *	5:	ter_tsk(TASK2)			... (A-1)
 *	//		⡧TASK1
 *	6:	ref_mtx(MTX1, &rmtx)
 *		assert(rmtx.htskid == TSK_NONE)
 *		assert(rmtx.wtskid == TSK_NONE)
 *
 *	7:	act_tsk(TASK2)
 *		act_tsk(TASK3)
 *	8:	slp_tsk()
 *	//		㡧TASK2TASK3
 *	== TASK2-2ͥ١==
 *	9:	loc_mtx(MTX1)
 *	//		桧TASK2㡧TASK3MTX1TASK2
 *	10:	tslp_tsk(10) -> E_TMOUT
 *	//		㡧TASK3MTX1TASK2
 *	== TASK3-1ͥ١==
 *	11:	loc_mtx(MTX1)
 *	//		MTX1TASK2TASK3
 *	//		ॢȸ
 *	//		桧TASK2MTX1TASK2TASK3
 *	== TASK2-2³==
 *	12:	wup_tsk(TASK1)
 *	//		⡧TASK1桧TASK2MTX1TASK2TASK3
 *	== TASK1³==
 *	13:	ter_tsk(TASK2)			... (A-2)
 *	//		⡧TASK1桧TASK3MTX1TASK3
 *	14:	ref_mtx(MTX1, &rmtx)
 *		assert(rmtx.htskid == TASK3)
 *		assert(rmtx.wtskid == TSK_NONE)
 *		get_pri(TASK3, &tskpri)
 *		assert(tskpri == MID_PRIORITY)
 *	15:	ter_tsk(TASK3)
 *	//		⡧TASK1
 *
 *	16:	act_tsk(TASK2)
 *		act_tsk(TASK3)
 *	17:	chg_pri(TSK_SELF, LOW_PRIORITY)
 *	//		㡧TASK2TASK3TASK1
 *	== TASK2-3ͥ١==
 *	18:	loc_mtx(MTX1)
 *	//		桧TASK2㡧TASK3TASK1MTX1TASK2
 *	19:	slp_tsk()
 *	//		㡧TASK3TASK1MTX1TASK2
 *	== TASK3-2ͥ١==
 *	20:	loc_mtx(MTX1)
 *	//		㡧TASK1MTX1TASK2TASK3
 *	== TASK1³==
 *	21:	ter_tsk(TASK2)			... (A-3)
 *	//		桧TASK3㡧TASK1MTX1TASK3
 *	== TASK3-2³==
 *	22:	ref_mtx(MTX1, &rmtx)
 *		assert(rmtx.htskid == TASK3)
 *		assert(rmtx.wtskid == TSK_NONE)
 *		get_pri(TASK3, &tskpri)
 *		assert(tskpri == MID_PRIORITY)
 *	23:	ext_tsk() -> noreturn
 *	//		㡧TASK1
 *	== TASK1³==
 *	24:	chg_pri(TSK_SELF, HIGH_PRIORITY)
 *	//		⡧TASK1
 *
 *	25:	act_tsk(TASK2)
 *	26:	slp_tsk()
 *	//		㡧TASK2
 *	== TASK2-4ͥ١==
 *	27:	loc_mtx(MTX1)
 *		loc_mtx(MTX2)
 *	//		桧TASK2MTX1TASK2MTX2TASK2
 *	28:	wup_tsk(TASK1)
 *	//		⡧TASK1桧TASK2MTX1TASK2MTX2TASK2
 *	== TASK1³==
 *	29:	ter_tsk(TASK2)			... (A-4)
 *	//		⡧TASK1
 *	30:	ref_mtx(MTX1, &rmtx)
 *		assert(rmtx.htskid == TSK_NONE)
 *		assert(rmtx.wtskid == TSK_NONE)
 *		ref_mtx(MTX2, &rmtx)
 *		assert(rmtx.htskid == TSK_NONE)
 *		assert(rmtx.wtskid == TSK_NONE)
 *
 *	31:	act_tsk(TASK2)
 *		act_tsk(TASK3)
 *		act_tsk(TASK4)
 *	32:	slp_tsk()
 *	//		㡧TASK2TASK3TASK4
 *	== TASK2-5ͥ١==
 *	33:	loc_mtx(MTX1)
 *		loc_mtx(MTX2)
 *	//		桧TASK2㡧TASK3TASK4MTX1TASK2MTX2TASK2
 *	34:	tslp_tsk(10) -> E_TMOUT
 *	//		㡧TASK3TASK4MTX1TASK2MTX2TASK2
 *	== TASK3-3ͥ١==
 *	35:	loc_mtx(MTX1)
 *	//		㡧TASK4MTX1TASK2TASK3MTX2TASK2
 *	== TASK4-1ͥ١==
 *	36:	loc_mtx(MTX2)
 *	//		MTX1TASK2TASK3MTX2TASK2TASK4
 *	//		ॢȸ
 *	//		桧TASK2MTX1TASK2TASK3MTX2TASK2TASK4
 *	== TASK2-5³==
 *	37:	wup_tsk(TASK1)
 *	//		⡧TASK1桧TASK2MTX1TASK2TASK3MTX2TASK2TASK4
 *	== TASK1³==
 *	38:	ter_tsk(TASK2)			... (A-5)
 *	//		⡧TASK1桧TASK4TASK3MTX1TASK3MTX2TASK4
 *	39:	ref_mtx(MTX1, &rmtx)
 *		assert(rmtx.htskid == TASK3)
 *		assert(rmtx.wtskid == TSK_NONE)
 *		ref_mtx(MTX2, &rmtx)
 *		assert(rmtx.htskid == TASK4)
 *		assert(rmtx.wtskid == TSK_NONE)
 *		get_pri(TASK3, &tskpri)
 *		assert(tskpri == MID_PRIORITY)
 *		get_pri(TASK4, &tskpri)
 *		assert(tskpri == MID_PRIORITY)
 *	40:	chg_pri(TSK_SELF, LOW_PRIORITY)
 *	//		桧TASK4TASK3㡧TASK1MTX1TASK3MTX2TASK4
 *	== TASK4-1³==
 *	41:	ext_tsk() -> noreturn
 *	//		桧TASK3㡧TASK1MTX1TASK3
 *	== TASK3-3³==
 *	42:	ext_tsk() -> noreturn
 *	//		㡧TASK1
 *	== TASK1³==
 *	43:	act_tsk(TASK2)
 *		act_tsk(TASK3)
 *		act_tsk(TASK4)
 *	//		㡧TASK1TASK2TASK3TASK4
 *	44:	chg_pri(TSK_SELF, LOW_PRIORITY)
 *	//		㡧TASK2TASK3TASK4TASK1
 *	== TASK2-6ͥ١==
 *	45:	loc_mtx(MTX1)
 *		loc_mtx(MTX2)
 *	//		桧TASK2㡧TASK3TASK4TASK1MTX1TASK2MTX2TASK2
 *	46:	slp_tsk()
 *	//		㡧TASK3TASK4TASK1MTX1TASK2MTX2TASK2
 *	== TASK3-4ͥ١==
 *	47:	loc_mtx(MTX1)
 *	//		㡧TASK4TASK1MTX1TASK2TASK3MTX2TASK2
 *	== TASK4-2ͥ١==
 *	48:	loc_mtx(MTX2)
 *	//		㡧TASK1MTX1TASK2TASK3MTX2TASK2TASK4
 *	== TASK1³==
 *	49:	ter_tsk(TASK2)			... (A-6)
 *	//		桧TASK4TASK3㡧TASK1MTX1TASK3MTX2TASK4
 *	== TASK4-2³==
 *	50:	ref_mtx(MTX1, &rmtx)
 *		assert(rmtx.htskid == TASK3)
 *		assert(rmtx.wtskid == TSK_NONE)
 *		ref_mtx(MTX2, &rmtx)
 *		assert(rmtx.htskid == TASK4)
 *		assert(rmtx.wtskid == TSK_NONE)
 *		get_pri(TASK3, &tskpri)
 *		assert(tskpri == MID_PRIORITY)
 *		get_pri(TASK4, &tskpri)
 *		assert(tskpri == MID_PRIORITY)
 *	51:	ext_tsk() -> noreturn
 *	//		桧TASK3㡧TASK1MTX1TASK3
 *	== TASK3-4³==
 *	52:	ext_tsk() -> noreturn
 *	//		㡧TASK1
 *	== TASK1³==
 *	53:	END
 */

#include <kernel.h>
#include <t_syslog.h>
#include "kernel_cfg.h"
#include "test_lib.h"
#include "test_mutex7.h"

extern ER	bit_mutex(void);

/* DO NOT DELETE THIS LINE -- gentest depends on it. */

void
task1(intptr_t exinf)
{
	ER_UINT	ercd;
	PRI		tskpri;
	T_RMTX	rmtx;

	test_start(__FILE__);

	set_bit_func(bit_mutex);

	check_point(1);
	ercd = act_tsk(TASK2);
	check_ercd(ercd, E_OK);

	check_point(2);
	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(5);
	ercd = ter_tsk(TASK2);
	check_ercd(ercd, E_OK);

	check_point(6);
	ercd = ref_mtx(MTX1, &rmtx);
	check_ercd(ercd, E_OK);

	check_assert(rmtx.htskid == TSK_NONE);

	check_assert(rmtx.wtskid == TSK_NONE);

	check_point(7);
	ercd = act_tsk(TASK2);
	check_ercd(ercd, E_OK);

	ercd = act_tsk(TASK3);
	check_ercd(ercd, E_OK);

	check_point(8);
	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(13);
	ercd = ter_tsk(TASK2);
	check_ercd(ercd, E_OK);

	check_point(14);
	ercd = ref_mtx(MTX1, &rmtx);
	check_ercd(ercd, E_OK);

	check_assert(rmtx.htskid == TASK3);

	check_assert(rmtx.wtskid == TSK_NONE);

	ercd = get_pri(TASK3, &tskpri);
	check_ercd(ercd, E_OK);

	check_assert(tskpri == MID_PRIORITY);

	check_point(15);
	ercd = ter_tsk(TASK3);
	check_ercd(ercd, E_OK);

	check_point(16);
	ercd = act_tsk(TASK2);
	check_ercd(ercd, E_OK);

	ercd = act_tsk(TASK3);
	check_ercd(ercd, E_OK);

	check_point(17);
	ercd = chg_pri(TSK_SELF, LOW_PRIORITY);
	check_ercd(ercd, E_OK);

	check_point(21);
	ercd = ter_tsk(TASK2);
	check_ercd(ercd, E_OK);

	check_point(24);
	ercd = chg_pri(TSK_SELF, HIGH_PRIORITY);
	check_ercd(ercd, E_OK);

	check_point(25);
	ercd = act_tsk(TASK2);
	check_ercd(ercd, E_OK);

	check_point(26);
	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(29);
	ercd = ter_tsk(TASK2);
	check_ercd(ercd, E_OK);

	check_point(30);
	ercd = ref_mtx(MTX1, &rmtx);
	check_ercd(ercd, E_OK);

	check_assert(rmtx.htskid == TSK_NONE);

	check_assert(rmtx.wtskid == TSK_NONE);

	ercd = ref_mtx(MTX2, &rmtx);
	check_ercd(ercd, E_OK);

	check_assert(rmtx.htskid == TSK_NONE);

	check_assert(rmtx.wtskid == TSK_NONE);

	check_point(31);
	ercd = act_tsk(TASK2);
	check_ercd(ercd, E_OK);

	ercd = act_tsk(TASK3);
	check_ercd(ercd, E_OK);

	ercd = act_tsk(TASK4);
	check_ercd(ercd, E_OK);

	check_point(32);
	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(38);
	ercd = ter_tsk(TASK2);
	check_ercd(ercd, E_OK);

	check_point(39);
	ercd = ref_mtx(MTX1, &rmtx);
	check_ercd(ercd, E_OK);

	check_assert(rmtx.htskid == TASK3);

	check_assert(rmtx.wtskid == TSK_NONE);

	ercd = ref_mtx(MTX2, &rmtx);
	check_ercd(ercd, E_OK);

	check_assert(rmtx.htskid == TASK4);

	check_assert(rmtx.wtskid == TSK_NONE);

	ercd = get_pri(TASK3, &tskpri);
	check_ercd(ercd, E_OK);

	check_assert(tskpri == MID_PRIORITY);

	ercd = get_pri(TASK4, &tskpri);
	check_ercd(ercd, E_OK);

	check_assert(tskpri == MID_PRIORITY);

	check_point(40);
	ercd = chg_pri(TSK_SELF, LOW_PRIORITY);
	check_ercd(ercd, E_OK);

	check_point(43);
	ercd = act_tsk(TASK2);
	check_ercd(ercd, E_OK);

	ercd = act_tsk(TASK3);
	check_ercd(ercd, E_OK);

	ercd = act_tsk(TASK4);
	check_ercd(ercd, E_OK);

	check_point(44);
	ercd = chg_pri(TSK_SELF, LOW_PRIORITY);
	check_ercd(ercd, E_OK);

	check_point(49);
	ercd = ter_tsk(TASK2);
	check_ercd(ercd, E_OK);

	check_finish(53);
	check_point(0);
}

static uint_t	task2_count = 0;

void
task2(intptr_t exinf)
{
	ER_UINT	ercd;

	switch (++task2_count) {
	case 1:
		check_point(3);
		ercd = loc_mtx(MTX1);
		check_ercd(ercd, E_OK);

		check_point(4);
		ercd = wup_tsk(TASK1);
		check_ercd(ercd, E_OK);

		check_point(0);

	case 2:
		check_point(9);
		ercd = loc_mtx(MTX1);
		check_ercd(ercd, E_OK);

		check_point(10);
		ercd = tslp_tsk(10);
		check_ercd(ercd, E_TMOUT);

		check_point(12);
		ercd = wup_tsk(TASK1);
		check_ercd(ercd, E_OK);

		check_point(0);

	case 3:
		check_point(18);
		ercd = loc_mtx(MTX1);
		check_ercd(ercd, E_OK);

		check_point(19);
		ercd = slp_tsk();
		check_ercd(ercd, E_OK);

		check_point(0);

	case 4:
		check_point(27);
		ercd = loc_mtx(MTX1);
		check_ercd(ercd, E_OK);

		ercd = loc_mtx(MTX2);
		check_ercd(ercd, E_OK);

		check_point(28);
		ercd = wup_tsk(TASK1);
		check_ercd(ercd, E_OK);

		check_point(0);

	case 5:
		check_point(33);
		ercd = loc_mtx(MTX1);
		check_ercd(ercd, E_OK);

		ercd = loc_mtx(MTX2);
		check_ercd(ercd, E_OK);

		check_point(34);
		ercd = tslp_tsk(10);
		check_ercd(ercd, E_TMOUT);

		check_point(37);
		ercd = wup_tsk(TASK1);
		check_ercd(ercd, E_OK);

		check_point(0);

	case 6:
		check_point(45);
		ercd = loc_mtx(MTX1);
		check_ercd(ercd, E_OK);

		ercd = loc_mtx(MTX2);
		check_ercd(ercd, E_OK);

		check_point(46);
		ercd = slp_tsk();
		check_ercd(ercd, E_OK);

		check_point(0);

	default:
		check_point(0);
	}
	check_point(0);
}

static uint_t	task3_count = 0;

void
task3(intptr_t exinf)
{
	ER_UINT	ercd;
	PRI		tskpri;
	T_RMTX	rmtx;

	switch (++task3_count) {
	case 1:
		check_point(11);
		ercd = loc_mtx(MTX1);
		check_ercd(ercd, E_OK);

		check_point(0);

	case 2:
		check_point(20);
		ercd = loc_mtx(MTX1);
		check_ercd(ercd, E_OK);

		check_point(22);
		ercd = ref_mtx(MTX1, &rmtx);
		check_ercd(ercd, E_OK);

		check_assert(rmtx.htskid == TASK3);

		check_assert(rmtx.wtskid == TSK_NONE);

		ercd = get_pri(TASK3, &tskpri);
		check_ercd(ercd, E_OK);

		check_assert(tskpri == MID_PRIORITY);

		check_point(23);
		ercd = ext_tsk();

		check_point(0);

	case 3:
		check_point(35);
		ercd = loc_mtx(MTX1);
		check_ercd(ercd, E_OK);

		check_point(42);
		ercd = ext_tsk();

		check_point(0);

	case 4:
		check_point(47);
		ercd = loc_mtx(MTX1);
		check_ercd(ercd, E_OK);

		check_point(52);
		ercd = ext_tsk();

		check_point(0);

	default:
		check_point(0);
	}
	check_point(0);
}

static uint_t	task4_count = 0;

void
task4(intptr_t exinf)
{
	ER_UINT	ercd;
	PRI		tskpri;
	T_RMTX	rmtx;

	switch (++task4_count) {
	case 1:
		check_point(36);
		ercd = loc_mtx(MTX2);
		check_ercd(ercd, E_OK);

		check_point(41);
		ercd = ext_tsk();

		check_point(0);

	case 2:
		check_point(48);
		ercd = loc_mtx(MTX2);
		check_ercd(ercd, E_OK);

		check_point(50);
		ercd = ref_mtx(MTX1, &rmtx);
		check_ercd(ercd, E_OK);

		check_assert(rmtx.htskid == TASK3);

		check_assert(rmtx.wtskid == TSK_NONE);

		ercd = ref_mtx(MTX2, &rmtx);
		check_ercd(ercd, E_OK);

		check_assert(rmtx.htskid == TASK4);

		check_assert(rmtx.wtskid == TSK_NONE);

		ercd = get_pri(TASK3, &tskpri);
		check_ercd(ercd, E_OK);

		check_assert(tskpri == MID_PRIORITY);

		ercd = get_pri(TASK4, &tskpri);
		check_ercd(ercd, E_OK);

		check_assert(tskpri == MID_PRIORITY);

		check_point(51);
		ercd = ext_tsk();

		check_point(0);

	default:
		check_point(0);
	}
	check_point(0);
}
