/*
 *  TOPPERS Software
 *      Toyohashi Open Platform for Embedded Real-Time Systems
 * 
 *  Copyright (C) 2007-2013 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ(1)(4)ξ˸¤ꡤܥեȥ
 *  ܥեȥѤΤޤࡥʲƱˤѡʣ
 *  ѡۡʰʲѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *      ޤܥեȥΥ桼ޤϥɥ桼Τʤ
 *      ͳ˴Ťᤫ⡤嵭ԤTOPPERSץȤ
 *      դ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơλŪ
 *  ФŬޤơʤݾڤԤʤޤܥեȥ
 *  ѤˤľŪޤϴŪʤ»˴ؤƤ⡤
 *  Ǥʤ
 * 
 *  $Id$
 */

/* 
 *		ߥ塼ƥåΥƥ(4)
 *
 * ڥƥȤŪ
 *
 *  ͥپ¥ߥ塼ƥåФơloc_mtxunl_mtxȼͥ٤
 *  Ū˥ƥȤ롥change_priority
 *  mutex_calc_priorityƤˤƧ߹ޤʤ
 *
 * ڥƥȹܡ
 *
 *	(A) ߥ塼ƥåΥåloc_mtxˤȼͥѹ
 *		(A-1) åߥ塼ƥåͥپ¤θͥ
 *			  ٤⤤ˡͥ٤ͥپ¤ޤ
 *			  夬뤳ȡޤƱͥǤ̤ͥǹˤʤ뤳
 *			  
 *		(A-2) åߥ塼ƥåͥپ¤θͥ
 *			  ٤Ʊˡͥ٤Ѥʤȡޤ
 *			  ƱͥǤ̤ͥѤʤ
 *		(A-3) åߥ塼ƥåͥپ¤θͥ
 *			  ٤㤤ˡͥ٤Ѥʤȡ
 *			  ƱͥǤ̤ͥѤʤ
 *	(B) ߥ塼ƥåΥåunl_mtxˤȼå
 * 		ͥѹ
 *		(B-1) åߥ塼ƥåξͥ٤θ
 *			  ͥ٤Ʊǡߥ塼ƥåΥåͥ٤
 *			  ٤ˡͥ٤Ŭڤ˲뤳ȡ
 *			  ƱͥǤ̤ͥǹˤʤ뤳
 *		(B-2) åߥ塼ƥåξͥ٤θ
 *			  ͥ٤Ʊǡߥ塼ƥåΥåͥ٤Ѥ
 *			  ٤Ǥʤˡͥ٤Ѥʤȡ
 *			  ƱͥǤ̤ͥѤʤ
 *		(B-3) åߥ塼ƥåξͥ٤θ
 *			  ͥ٤㤤ˡͥ٤Ѥʤȡ
 *			  ޤƱͥǤ̤ͥѤʤ
 *	(C) ߥ塼ƥåΥåunl_mtxˤȼߥ塼ƥå
 *		åͥѹ
 *		(C-1) ߥ塼ƥåͥپ¤˥ߥ塼ƥåå
 *			  θͥ٤⤤ˡͥ
 *			  ٤ͥپ¤ޤǾ夬뤳ȡޤƱͥǤ
 *			  ̤ͥˤʤ뤳
 *		(C-2) ߥ塼ƥåͥپ¤˥ߥ塼ƥåå
 *			  θͥ٤Ʊˡͥ٤
 *			  ѤʤȡޤƱͥǤ̤ͥˤ
 *			  뤳
 *		(C-3) ߥ塼ƥåͥپ¤˥ߥ塼ƥåå
 *			  θͥ٤㤤ˡͥ
 *			  ٤ѤʤȡޤƱͥǤ̤ͥ
 *			  ˤʤ뤳
 *	(D) ߥ塼ƥåΥåloc_mtxˤE_ILUSE顼
 *		(D-1) Υ١ͥ٤å褦Ȥߥ塼ƥå
 *			  ξͥ٤⤤E_ILUSE顼ˤʤ뤳
 *		(D-2) Υ١ͥ٤å褦Ȥߥ塼ƥå
 *			  ξͥ٤Ʊ㤱Сθͥ
 *			  ٤⤯Ƥ⡤E_ILUSE顼ˤʤʤ
 *
 * ڥƥȹܤμ¸ˡ
 *
 *	(A-1)
 *		ͥ٥TASK1ˤˡͥپ¥ߥ塼ƥåMTX2ˤ
 *		åͥ٤ˤʤ뤳Ȥǧ롥ޤ¹Բǽ֤
 *		ͥ٥TASK4ˤ⡤̤ͥ⤯ʤ뤳Ȥǧ롥
 *		ǥѥåػ߾֤Ǽ»ܤ롥
 *	(A-2)
 *		ͥ٥TASK1ˤˡͥپ¥ߥ塼ƥåMTX1ˤ
 *		åͥ٤ѤʤȤǧ롥ޤ¹Բǽ
 *		֤ͥ٥2ġTASK2TASK3ˤѰդƤͥ
 *		ѤʤȤǧ롥ǥѥåػ߾֤Ǽ»ܤ롥
 *	(A-3)
 *		ͥ٥TASK1ˤͥپ¥ߥ塼ƥåMTX2ˤ
 *		ƹͥ٤ˤʤäƤ֤ǡͥپ¥ߥ塼ƥå
 *		MTX1ˤåͥ٤ѤʤȤǧ롥ޤ
 *		¹Բǽ֤ιͥ٥2ġTASK4TASK5ˤѰդƤ
 *		̤ͥѤʤȤǧ롥ǥѥåػ߾֤Ǽ»
 *		롥
 *	(B-1)
 *		ͥ٥TASK1ˤ˹ͥپ¥ߥ塼ƥåMTX2ˤΤ
 *		åƤ֤ǡåͥ٤ˤʤ
 *		Ȥǧ롥ޤ¹Բǽ֤ͥ٥TASK2ˤ
 *		⡤̤ͥ⤯ʤ뤳Ȥǧ롥
 *	(B-2)
 *		ͥ٥TASK1ˤͥپ¥ߥ塼ƥåMTX1ˤΤ
 *		åƤ֤ǡåͥ٤Ѥ
 *		ʤȤǧ롥ޤ¹Բǽ֤ͥ٥2
 *		TASK2TASK3ˤѰդƤ̤ͥѤʤȤǧ
 *		롥ǥѥåػ߾֤Ǽ»ܤ롥
 *	(B-3)
 *		ͥ٥TASK1ˤ˹ͥپ¥ߥ塼ƥåMTX2ˤ
 *		ͥپ¥ߥ塼ƥåMTX1ˤåƤ֤ǡͥ
 *		پ¥ߥ塼ƥåMTX1ˤåͥ٤Ѥ
 *		ʤȤǧ롥ޤ¹Բǽ֤ιͥ٥2
 *		TASK4TASK5ˤѰդƤ̤ͥѤʤȤǧ
 *		롥ǥѥåػ߾֤Ǽ»ܤ롥
 *	(C-1)
 *		ͥ٥TASK1ˤ˹ͥپ¥ߥ塼ƥå2ġMTX2
 *		MTX3˥å̤ͥ٥TASK2ˤMTX2ԤäƤ
 *		֤ǡTASK1MTX2åTASK2ͥ٤ͥ٤
 *		ʤ뤳Ȥǧ롥ޤTASK2̤ͥTASK1㤯
 *		뤳Ȥǧ롥
 *	(C-2)
 *		ͥ٥TASK2ˤͥپ¥ߥ塼ƥåMTX1ˤ
 *		̤ͥ٥TASK1ˤMTX1ԤäƤ֤ǡ
 *		TASK2MTX1åTASK1ͥ٤ͥ٤ΤޤѲ
 *		ʤȤǧ롥ޤ¹Բǽ֤ͥ٥⤦
 *		1ġTASK3ѰդƤTASK1̤ͥTASK3㤯ʤ
 *		Ȥǧ롥
 *	(C-3)
 *		ͥ٥TASK1ˤͥپ¥ߥ塼ƥåMTX1ˤȹ
 *		ͥپ¥ߥ塼ƥåMTX3ˤå̤ͥ٥
 *		TASK2ˤ̤ιͥپ¥ߥ塼ƥåMTX2ˤå
 *		MTX1ԤäƤ֤ǡTASK1MTX1åTASK2ͥ
 *		٤ͥ٤ΤޤѲʤȤǧ롥ޤTASK2ͥ
 *		̤TASK1㤯ʤ뤳Ȥǧ롥
 *	(D-1)
 *		ͥ٥TASK4ˤˡͥپ¥ߥ塼ƥåMTX1ˤ
 *		åE_ILUSE顼ˤʤ뤳Ȥǧ롥
 *	(D-2)
 *		ͥ٥TASK1ˤͥپ¥ߥ塼ƥåMTX2ˤ
 *		ƹͥ٤ˤʤäƤ֤ǡͥپ¥ߥ塼ƥå
 *		MTX1ˤåE_ILUSE顼ˤʤʤȤǧ롥
 *
 * ڻѥ꥽
 *
 *	TASK1: ͥ٥ᥤ󥿥ǽ餫鵯ư
 *	TASK2: ͥ٥
 *	TASK3: ͥ٥
 *	TASK4: ͥ٥
 *	TASK5: ͥ٥
 *	MTX1: ߥ塼ƥåTA_CEILING°¤ͥ١
 *	MTX2: ߥ塼ƥåTA_CEILING°¤Ϲͥ١
 *	MTX3: ߥ塼ƥåTA_CEILING°¤Ϲͥ١
 *
 * ڥƥȥ󥹡
 *
 *	== TASK1ͥ١==
 *		call(set_bit_func(bit_mutex))
 *	1:	dis_dsp()
 *	2:	act_tsk(TASK2)
 *		act_tsk(TASK4)
 *	//		⡧TASK4桧TASK1TASK2
 *	3:	ploc_mtx(MTX2)								... (A-1)
 *	//		⡧TASK1TASK4桧TASK2MTX2TASK1
 *		get_pri(TSK_SELF, &tskpri)
 *		assert(tskpri == HIGH_PRIORITY)
 *	4:	ena_dsp()
 *	5:	unl_mtx(MTX2)								... (B-1)
 *	//		⡧TASK4桧TASK1TASK2
 *	== TASK4ͥ١==
 *	6:	loc_mtx(MTX1) -> E_ILUSE					... (D-1)
 *	7:	slp_tsk()
 *	//		桧TASK1TASK2
 *	== TASK1³==
 *	8:	get_pri(TSK_SELF, &tskpri)
 *		assert(tskpri == MID_PRIORITY)
 *
 *	9:	dis_dsp()
 *	10:	rot_rdq(MID_PRIORITY)
 *	//		桧TASK2TASK1
 *	11:	act_tsk(TASK3)
 *	//		桧TASK2TASK1TASK3
 *	12:	ploc_mtx(MTX1)								... (A-2)
 *	//		桧TASK2TASK1TASK3MTX1TASK1
 *		get_pri(TSK_SELF, &tskpri)
 *		assert(tskpri == MID_PRIORITY)
 *	13:	ena_dsp()
 *	== TASK2ͥ١==
 *	14:	slp_tsk()
 *	//		桧TASK1TASK3MTX1TASK1
 *	== TASK1³==
 *	15:	slp_tsk()
 *	//		桧TASK3MTX1TASK1
 *	== TASK3ͥ١==
 *	16:	wup_tsk(TASK1)
 *	//		桧TASK3TASK1MTX1TASK1
 *	17:	slp_tsk()
 *	//		桧TASK1MTX1TASK1
 *
 *	== TASK1³==
 *	18:	wup_tsk(TASK2)
 *	//		桧TASK1TASK2MTX1TASK1
 *	19:	dis_dsp()
 *	20:	rot_rdq(MID_PRIORITY)
 *	//		桧TASK2TASK1MTX1TASK1
 *	21:	wup_tsk(TASK3)
 *	//		桧TASK2TASK1TASK3MTX1TASK1
 *	22:	unl_mtx(MTX1)								... (B-2)
 *	//		桧TASK2TASK1TASK3
 *		get_pri(TSK_SELF, &tskpri)
 *		assert(tskpri == MID_PRIORITY)
 *	23:	ena_dsp()
 *	== TASK2ͥ١==
 *	24:	slp_tsk()
 *	//		桧TASK1TASK3
 *	== TASK1³==
 *	25:	slp_tsk()
 *	//		桧TASK3
 *	== TASK3ͥ١==
 *	26:	wup_tsk(TASK1)
 *	//		桧TASK3TASK1
 *	27:	slp_tsk()
 *	//		桧TASK1
 *
 *	== TASK1³==
 *	28:	dis_dsp()
 *	29:	wup_tsk(TASK4)
 *	//		⡧TASK4桧TASK1
 *	30:	ploc_mtx(MTX2)
 *	//		⡧TASK1TASK4MTX2TASK1
 *	31:	rot_rdq(HIGH_PRIORITY)
 *	//		⡧TASK4TASK1MTX2TASK1
 *	32:	act_tsk(TASK5)
 *	//		⡧TASK4TASK1TASK5MTX2TASK1
 *	33:	ploc_mtx(MTX1)								... (A-3)(D-2)
 *	//		⡧TASK4TASK1TASK5MTX2TASK1MTX1TASK1
 *		get_pri(TSK_SELF, &tskpri)
 *		assert(tskpri == HIGH_PRIORITY)
 *	34:	ena_dsp()
 *	== TASK4³==
 *	35:	slp_tsk()
 *	//		⡧TASK1TASK5MTX2TASK1MTX1TASK1
 *	== TASK1³==
 *	36:	slp_tsk()
 *	//		⡧TASK5MTX2TASK1MTX1TASK1
 *	== TASK5ͥ١==
 *	37:	wup_tsk(TASK1)
 *	//		⡧TASK5TASK1MTX2TASK1MTX1TASK1
 *	38:	slp_tsk()
 *	//		⡧TASK1MTX2TASK1MTX1TASK1
 *
 *	== TASK1³==
 *	39:	dis_dsp()
 *	40:	wup_tsk(TASK4)
 *	//		⡧TASK1TASK4MTX2TASK1MTX1TASK1
 *	41:	rot_rdq(HIGH_PRIORITY)
 *	//		⡧TASK4TASK1MTX2TASK1MTX1TASK1
 *	42:	wup_tsk(TASK5)
 *	//		⡧TASK4TASK1TASK5MTX2TASK1MTX1TASK1
 *	43:	unl_mtx(MTX1)								... (B-3)
 *	//		⡧TASK4TASK1TASK5MTX2TASK1
 *		get_pri(TSK_SELF, &tskpri)
 *		assert(tskpri == HIGH_PRIORITY)
 *	44:	ena_dsp()
 *	== TASK4³==
 *	45:	slp_tsk()
 *	//		⡧TASK1TASK5MTX2TASK1
 *	== TASK1³==
 *	46:	slp_tsk()
 *	//		⡧TASK5MTX2TASK1
 *	== TASK5³==
 *	47:	wup_tsk(TASK1)
 *	//		⡧TASK5TASK1MTX2TASK1
 *	48:	slp_tsk()
 *	//		⡧TASK1MTX2TASK1
 *
 *	== TASK1³==
 *	49:	wup_tsk(TASK2)
 *		wup_tsk(TASK3)
 *		slp_tsk()
 *	//		桧TASK2TASK3MTX2TASK1
 *	== TASK2³==
 *	50:	loc_mtx(MTX2)
 *	//		桧TASK3MTX2TASK1TASK2
 *	== TASK3³==
 *	51:	wup_tsk(TASK1)
 *	//		⡧TASK1桧TASK3MTX2TASK1TASK2
 *	== TASK1³==
 *	52:	loc_mtx(MTX3)
 *	//		⡧TASK1桧TASK3MTX2TASK1TASK2MTX3TASK1
 *	53:	unl_mtx(MTX2)								... (C-1)
 *	//		⡧TASK1TASK2桧TASK3MTX2TASK2MTX3TASK1
 *		get_pri(TASK2, &tskpri)
 *		assert(tskpri == HIGH_PRIORITY)
 *	54:	loc_mtx(MTX1)
 *	//		⡧TASK1TASK2桧TASK3MTX1TASK1MTX2TASK2MTX3TASK1
 *	55:	slp_tsk()
 *	//		⡧TASK2桧TASK3MTX1TASK1MTX2TASK2MTX3TASK1
 *
 *	== TASK2³==
 *	56:	wup_tsk(TASK1)
 *	//		⡧TASK2TASK1桧TASK3MTX1TASK1MTX2TASK2MTX3TASK1
 *	57:	loc_mtx(MTX1)
 *	//		⡧TASK1桧TASK3MTX1TASK1TASK2MTX2TASK2MTX3TASK1
 *	== TASK1³==
 *	58:	unl_mtx(MTX1)								... (C-3)
 *	//		⡧TASK1TASK2桧TASK3MTX1TASK2MTX2TASK2MTX3TASK1
 *		get_pri(TASK2, &tskpri)
 *		assert(tskpri == HIGH_PRIORITY)
 *	59:	unl_mtx(MTX3)
 *	//		⡧TASK2桧TASK1TASK3MTX1TASK2MTX2TASK2
 *	== TASK2³==
 *	60:	unl_mtx(MTX2)
 *	//		桧TASK2TASK1TASK3MTX1TASK2
 *
 *	61:	rot_rdq(MID_PRIORITY)
 *	//		桧TASK1TASK3TASK2MTX1TASK2
 *	== TASK1³==
 *	62:	loc_mtx(MTX1)
 *	//		桧TASK3TASK2MTX1TASK2TASK1
 *	== TASK3³==
 *	63:	rot_rdq(MID_PRIORITY)
 *	//		桧TASK2TASK3MTX1TASK2TASK1
 *	== TASK2³==
 *	64:	unl_mtx(MTX1)								... (C-2)
 *	//		桧TASK2TASK3TASK1MTX1TASK1
 *		get_pri(TASK1, &tskpri)
 *		assert(tskpri == MID_PRIORITY)
 *	== TASK2³==
 *	65:	ext_tsk() -> noreturn
 *	//		桧TASK3TASK1MTX1TASK1
 *	== TASK3³==
 *	66:	ext_tsk() -> noreturn
 *	//		桧TASK1MTX1TASK1
 *	== TASK1³==
 *	67:	END
 */

#include <kernel.h>
#include <t_syslog.h>
#include "kernel_cfg.h"
#include "test_lib.h"
#include "test_mutex4.h"

extern ER	bit_mutex(void);

/* DO NOT DELETE THIS LINE -- gentest depends on it. */

void
task1(intptr_t exinf)
{
	ER_UINT	ercd;
	PRI		tskpri;

	test_start(__FILE__);

	set_bit_func(bit_mutex);

	check_point(1);
	ercd = dis_dsp();
	check_ercd(ercd, E_OK);

	check_point(2);
	ercd = act_tsk(TASK2);
	check_ercd(ercd, E_OK);

	ercd = act_tsk(TASK4);
	check_ercd(ercd, E_OK);

	check_point(3);
	ercd = ploc_mtx(MTX2);
	check_ercd(ercd, E_OK);

	ercd = get_pri(TSK_SELF, &tskpri);
	check_ercd(ercd, E_OK);

	check_assert(tskpri == HIGH_PRIORITY);

	check_point(4);
	ercd = ena_dsp();
	check_ercd(ercd, E_OK);

	check_point(5);
	ercd = unl_mtx(MTX2);
	check_ercd(ercd, E_OK);

	check_point(8);
	ercd = get_pri(TSK_SELF, &tskpri);
	check_ercd(ercd, E_OK);

	check_assert(tskpri == MID_PRIORITY);

	check_point(9);
	ercd = dis_dsp();
	check_ercd(ercd, E_OK);

	check_point(10);
	ercd = rot_rdq(MID_PRIORITY);
	check_ercd(ercd, E_OK);

	check_point(11);
	ercd = act_tsk(TASK3);
	check_ercd(ercd, E_OK);

	check_point(12);
	ercd = ploc_mtx(MTX1);
	check_ercd(ercd, E_OK);

	ercd = get_pri(TSK_SELF, &tskpri);
	check_ercd(ercd, E_OK);

	check_assert(tskpri == MID_PRIORITY);

	check_point(13);
	ercd = ena_dsp();
	check_ercd(ercd, E_OK);

	check_point(15);
	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(18);
	ercd = wup_tsk(TASK2);
	check_ercd(ercd, E_OK);

	check_point(19);
	ercd = dis_dsp();
	check_ercd(ercd, E_OK);

	check_point(20);
	ercd = rot_rdq(MID_PRIORITY);
	check_ercd(ercd, E_OK);

	check_point(21);
	ercd = wup_tsk(TASK3);
	check_ercd(ercd, E_OK);

	check_point(22);
	ercd = unl_mtx(MTX1);
	check_ercd(ercd, E_OK);

	ercd = get_pri(TSK_SELF, &tskpri);
	check_ercd(ercd, E_OK);

	check_assert(tskpri == MID_PRIORITY);

	check_point(23);
	ercd = ena_dsp();
	check_ercd(ercd, E_OK);

	check_point(25);
	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(28);
	ercd = dis_dsp();
	check_ercd(ercd, E_OK);

	check_point(29);
	ercd = wup_tsk(TASK4);
	check_ercd(ercd, E_OK);

	check_point(30);
	ercd = ploc_mtx(MTX2);
	check_ercd(ercd, E_OK);

	check_point(31);
	ercd = rot_rdq(HIGH_PRIORITY);
	check_ercd(ercd, E_OK);

	check_point(32);
	ercd = act_tsk(TASK5);
	check_ercd(ercd, E_OK);

	check_point(33);
	ercd = ploc_mtx(MTX1);
	check_ercd(ercd, E_OK);

	ercd = get_pri(TSK_SELF, &tskpri);
	check_ercd(ercd, E_OK);

	check_assert(tskpri == HIGH_PRIORITY);

	check_point(34);
	ercd = ena_dsp();
	check_ercd(ercd, E_OK);

	check_point(36);
	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(39);
	ercd = dis_dsp();
	check_ercd(ercd, E_OK);

	check_point(40);
	ercd = wup_tsk(TASK4);
	check_ercd(ercd, E_OK);

	check_point(41);
	ercd = rot_rdq(HIGH_PRIORITY);
	check_ercd(ercd, E_OK);

	check_point(42);
	ercd = wup_tsk(TASK5);
	check_ercd(ercd, E_OK);

	check_point(43);
	ercd = unl_mtx(MTX1);
	check_ercd(ercd, E_OK);

	ercd = get_pri(TSK_SELF, &tskpri);
	check_ercd(ercd, E_OK);

	check_assert(tskpri == HIGH_PRIORITY);

	check_point(44);
	ercd = ena_dsp();
	check_ercd(ercd, E_OK);

	check_point(46);
	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(49);
	ercd = wup_tsk(TASK2);
	check_ercd(ercd, E_OK);

	ercd = wup_tsk(TASK3);
	check_ercd(ercd, E_OK);

	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(52);
	ercd = loc_mtx(MTX3);
	check_ercd(ercd, E_OK);

	check_point(53);
	ercd = unl_mtx(MTX2);
	check_ercd(ercd, E_OK);

	ercd = get_pri(TASK2, &tskpri);
	check_ercd(ercd, E_OK);

	check_assert(tskpri == HIGH_PRIORITY);

	check_point(54);
	ercd = loc_mtx(MTX1);
	check_ercd(ercd, E_OK);

	check_point(55);
	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(58);
	ercd = unl_mtx(MTX1);
	check_ercd(ercd, E_OK);

	ercd = get_pri(TASK2, &tskpri);
	check_ercd(ercd, E_OK);

	check_assert(tskpri == HIGH_PRIORITY);

	check_point(59);
	ercd = unl_mtx(MTX3);
	check_ercd(ercd, E_OK);

	check_point(62);
	ercd = loc_mtx(MTX1);
	check_ercd(ercd, E_OK);

	check_finish(67);
	check_point(0);
}

void
task2(intptr_t exinf)
{
	ER_UINT	ercd;
	PRI		tskpri;

	check_point(14);
	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(24);
	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(50);
	ercd = loc_mtx(MTX2);
	check_ercd(ercd, E_OK);

	check_point(56);
	ercd = wup_tsk(TASK1);
	check_ercd(ercd, E_OK);

	check_point(57);
	ercd = loc_mtx(MTX1);
	check_ercd(ercd, E_OK);

	check_point(60);
	ercd = unl_mtx(MTX2);
	check_ercd(ercd, E_OK);

	check_point(61);
	ercd = rot_rdq(MID_PRIORITY);
	check_ercd(ercd, E_OK);

	check_point(64);
	ercd = unl_mtx(MTX1);
	check_ercd(ercd, E_OK);

	ercd = get_pri(TASK1, &tskpri);
	check_ercd(ercd, E_OK);

	check_assert(tskpri == MID_PRIORITY);

	check_point(65);
	ercd = ext_tsk();

	check_point(0);
}

void
task3(intptr_t exinf)
{
	ER_UINT	ercd;

	check_point(16);
	ercd = wup_tsk(TASK1);
	check_ercd(ercd, E_OK);

	check_point(17);
	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(26);
	ercd = wup_tsk(TASK1);
	check_ercd(ercd, E_OK);

	check_point(27);
	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(51);
	ercd = wup_tsk(TASK1);
	check_ercd(ercd, E_OK);

	check_point(63);
	ercd = rot_rdq(MID_PRIORITY);
	check_ercd(ercd, E_OK);

	check_point(66);
	ercd = ext_tsk();

	check_point(0);
}

void
task4(intptr_t exinf)
{
	ER_UINT	ercd;

	check_point(6);
	ercd = loc_mtx(MTX1);
	check_ercd(ercd, E_ILUSE);

	check_point(7);
	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(35);
	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(45);
	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(0);
}

void
task5(intptr_t exinf)
{
	ER_UINT	ercd;

	check_point(37);
	ercd = wup_tsk(TASK1);
	check_ercd(ercd, E_OK);

	check_point(38);
	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(47);
	ercd = wup_tsk(TASK1);
	check_ercd(ercd, E_OK);

	check_point(48);
	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(0);
}
