/*
 *  TOPPERS Software
 *      Toyohashi Open Platform for Embedded Real-Time Systems
 * 
 *  Copyright (C) 2014 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ(1)(4)ξ˸¤ꡤܥեȥ
 *  ܥեȥѤΤޤࡥʲƱˤѡʣ
 *  ѡۡʰʲѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *      ޤܥեȥΥ桼ޤϥɥ桼Τʤ
 *      ͳ˴Ťᤫ⡤嵭ԤTOPPERSץȤ
 *      դ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơλŪ
 *  ФŬޤơʤݾڤԤʤޤܥեȥ
 *  ѤˤľŪޤϴŪʤ»˴ؤƤ⡤
 *  Ǥʤ
 * 
 *  $Id$
 */

/* 
 *		åХåեΥƥ(2)
 *
 * ڥƥȤŪ
 *
 *  FIFOåХåեԤŪԤ줿
 *  ̤ƥȤ롥
 *
 * ڥƥȹܡ
 *
 *	(A) Ԥλter_tsk
 *		(A-1) ԤԤʤ
 *		(A-2) Ԥ1ĤޤʣˤԤʥڴʤ
 *		(A-3) Ԥ1ĤޤʣˤԤʥڴ
 *	(B) ԤԤrel_wai
 *		(B-1) ԤԤʤ
 *		(B-2) Ԥ1ĤޤʣˤԤʥڴʤ
 *		(B-3) Ԥ1ĤޤʣˤԤʥڴ
 *	(C) ԤԤirel_wai
 *		(C-1) ԤԤʤ
 *		(C-2) Ԥ1ĤޤʣˤԤʥڴʤ
 *		(C-3) Ԥ1ĤޤʣˤԤʥڴ
 *	(D) ԤॢȤԤ
 *		(D-1) ԤԤʤ
 *		(D-2) Ԥ1ĤޤʣˤԤʥڴʤ
 *		(D-3) Ԥ1ĤޤʣˤԤʥڴ
 *
 * ڻѥ꥽
 *
 *	TASK1: ͥ٥ᥤ󥿥ǽ餫鵯ư
 *	TASK2: ͥ٥
 *	TASK3: ͥ٥
 *	MBF1: åХåեTA_NULL°å26
 *		  ХåեΰΥ26ºݤˤ28
 *
 * ڥƥȥ󥹡
 *
 *	== TASK1ͥ١==
 *		call(set_bit_func(bit_kernel))
 *	1:	act_tsk(TASK2)
 *		act_tsk(TASK3)
 *		tslp_tsk(1) -> E_TMOUT
 *	== TASK2-1ͥ١1 ==
 *	2:	snd_mbf(MBF1, string1, 26)
 *	== TASK3ͥ١==
 *	3:	snd_mbf(MBF1, string2, 26)
 *	== TASK1³==
 *	4:	ter_tsk(TASK2)									... (A-1)
 *		tslp_tsk(1) -> E_TMOUT
 *	== TASK1³==
 *	5:	rcv_mbf(MBF1, buf1) -> 26
 *		assert(strncmp(buf1, string2, 26) == 0)
 *		act_tsk(TASK2)
 *		tslp_tsk(1) -> E_TMOUT
 *	== TASK2-2ͥ١2 ==
 *	6:	snd_mbf(MBF1, string1, 26)
 *	== TASK3³==
 *	7:	snd_mbf(MBF1, string3, 10)
 *	== TASK1³==
 *	8:	ter_tsk(TASK2)									... (A-2)
 *		slp_tsk()
 *	== TASK3³==
 *	9:	rcv_mbf(MBF1, buf1) -> 10
 *		assert(strncmp(buf1, string3, 10) == 0)
 *	10:	act_tsk(TASK2)
 *	== TASK2-3ͥ١3 ==
 *	11:	snd_mbf(MBF1, string1, 26)
 *	== TASK3³==
 *	12:	wup_tsk(TASK1)
 *	== TASK1³==
 *	13:	snd_mbf(MBF1, string3, 10)
 *	== TASK3³==
 *	14:	ter_tsk(TASK2)									... (A-3)
 *	== TASK1³==
 *	15:	rcv_mbf(MBF1, buf1) -> 10
 *		assert(strncmp(buf1, string3, 10) == 0)
 *		act_tsk(TASK2)
 *		tslp_tsk(1) -> E_TMOUT
 *	== TASK2-4ͥ١4 ==
 *	16:	snd_mbf(MBF1, string1, 26) -> E_RLWAI
 *	== TASK3³==
 *	17:	snd_mbf(MBF1, string2, 26)
 *	== TASK1³==
 *	18:	rel_wai(TASK2)									... (B-1)
 *		tslp_tsk(1) -> E_TMOUT
 *	== TASK2-4³==
 *	19:	slp_tsk()
 *	== TASK1³==
 *	20:	rcv_mbf(MBF1, buf1) -> 26
 *		assert(strncmp(buf1, string2, 26) == 0)
 *		wup_tsk(TASK2)
 *		tslp_tsk(1) -> E_TMOUT
 *	== TASK2-4³==
 *	21:	snd_mbf(MBF1, string1, 26) -> E_RLWAI
 *	== TASK3³==
 *	22:	snd_mbf(MBF1, string3, 10)
 *	== TASK1³==
 *	23:	rel_wai(TASK2)									... (B-2)
 *		slp_tsk()
 *	== TASK2-4³==
 *	24:	slp_tsk()
 *	== TASK3³==
 *	25:	rcv_mbf(MBF1, buf1) -> 10
 *		assert(strncmp(buf1, string3, 10) == 0)
 *	26:	wup_tsk(TASK2)
 *	== TASK2-4³==
 *	27:	snd_mbf(MBF1, string1, 26) -> E_RLWAI
 *	== TASK3³==
 *	28:	wup_tsk(TASK1)
 *	== TASK1³==
 *	29:	snd_mbf(MBF1, string3, 10)
 *	== TASK3³==
 *	30:	rel_wai(TASK2)									... (B-3)
 *	== TASK1³==
 *	31:	rcv_mbf(MBF1, buf1) -> 10
 *		assert(strncmp(buf1, string3, 10) == 0)
 *		tslp_tsk(1) -> E_TMOUT
 *	== TASK2-4³==
 *	32:	snd_mbf(MBF1, string1, 26) -> E_RLWAI
 *	== TASK3³==
 *	33:	snd_mbf(MBF1, string2, 26)
 *	== TASK1³==
 *	34:	sta_alm(ALM1, 1U)
 *		slp_tsk()
 *	== ALM1-1 ==
 *	35:	irel_wai(TASK2)									... (C-1)
 *		iwup_tsk(TASK1)
 *		RETURN
 *	== TASK1³==
 *	36:	tslp_tsk(1) -> E_TMOUT
 *	== TASK2-4³==
 *	37:	slp_tsk()
 *	== TASK1³==
 *	38:	rcv_mbf(MBF1, buf1) -> 26
 *		assert(strncmp(buf1, string2, 26) == 0)
 *		wup_tsk(TASK2)
 *		tslp_tsk(1) -> E_TMOUT
 *	== TASK2-4³==
 *	39:	snd_mbf(MBF1, string1, 26) -> E_RLWAI
 *	== TASK3³==
 *	40:	snd_mbf(MBF1, string3, 10)
 *	== TASK1³==
 *	41:	sta_alm(ALM1, 1U)
 *		slp_tsk()
 *	== ALM1-2 ==
 *	42:	irel_wai(TASK2)									... (C-2)
 *		RETURN
 *	== TASK2-4³==
 *	43:	slp_tsk()
 *	== TASK3³==
 *	44:	rcv_mbf(MBF1, buf1) -> 10
 *		assert(strncmp(buf1, string3, 10) == 0)
 *	45:	wup_tsk(TASK2)
 *	== TASK2-4³==
 *	46:	snd_mbf(MBF1, string1, 26) -> E_RLWAI
 *	== TASK3³==
 *	47:	wup_tsk(TASK1)
 *	== TASK1³==
 *	48:	snd_mbf(MBF1, string3, 10)
 *	== TASK3³==
 *	49:	sta_alm(ALM1, 1U)
 *		slp_tsk()
 *	== ALM1-3 ==
 *	50:	irel_wai(TASK2)									... (C-3)
 *		RETURN
 *	== TASK1³==
 *	51:	rcv_mbf(MBF1, buf1) -> 10
 *		assert(strncmp(buf1, string3, 10) == 0)
 *		wup_tsk(TASK3)
 *		slp_tsk()
 *	== TASK2-4³==
  *	52:	tsnd_mbf(MBF1, string1, 26, 1) -> E_TMOUT		... (D-1)
 *	== TASK3³==
 *	53:	snd_mbf(MBF1, string2, 26)
 *	== TASK2-4³==
 *	54:	tslp_tsk(1) -> E_TMOUT
 *	== TASK2-4³==
 *	55:	rcv_mbf(MBF1, buf1) -> 26
 *		assert(strncmp(buf1, string2, 26) == 0)
 *	56:	tsnd_mbf(MBF1, string1, 26, 1) -> E_TMOUT		... (D-2)
 *	== TASK3³==
 *	57:	snd_mbf(MBF1, string3, 10)
 *	== TASK2-4³==
 *	58:	slp_tsk()
 *	== TASK3³==
 *	59:	rcv_mbf(MBF1, buf1) -> 10
 *		assert(strncmp(buf1, string3, 10) == 0)
 *	60:	wup_tsk(TASK2)
 *	== TASK2-4³==
 *	61:	tsnd_mbf(MBF1, string1, 26, 1) -> E_TMOUT		... (D-3)
 *	== TASK3³==
 *	62:	wup_tsk(TASK1)
 *	== TASK1³==
 *	63:	snd_mbf(MBF1, string3, 10)
 *	== TASK3³==
 *	64:	slp_tsk()
 *	== TASK1³==
 *	65:	rcv_mbf(MBF1, buf1) -> 10
 *		assert(strncmp(buf1, string3, 10) == 0)
 *		slp_tsk()
 *	== TASK2-4³==
 *	66:	END
 */

#include <kernel.h>
#include <t_syslog.h>
#include "kernel_cfg.h"
#include "test_lib.h"
#include "test_messagebuf2.h"
#include <string.h>

const char string1[26] = "abcdefghijklmnopqrstuvwxyz";
const char string2[26] = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
const char string3[16] = "0123456789abcdef";

char buf1[26];

extern ER	bit_kernel(void);

/* DO NOT DELETE THIS LINE -- gentest depends on it. */

static uint_t	alarm1_count = 0;

void
alarm1_handler(intptr_t exinf)
{
	ER_UINT	ercd;

	switch (++alarm1_count) {
	case 1:
		check_point(35);
		ercd = irel_wai(TASK2);
		check_ercd(ercd, E_OK);

		ercd = iwup_tsk(TASK1);
		check_ercd(ercd, E_OK);

		return;

		check_point(0);

	case 2:
		check_point(42);
		ercd = irel_wai(TASK2);
		check_ercd(ercd, E_OK);

		return;

		check_point(0);

	case 3:
		check_point(50);
		ercd = irel_wai(TASK2);
		check_ercd(ercd, E_OK);

		return;

		check_point(0);

	default:
		check_point(0);
	}
	check_point(0);
}

void
task1(intptr_t exinf)
{
	ER_UINT	ercd;

	test_start(__FILE__);

	set_bit_func(bit_kernel);

	check_point(1);
	ercd = act_tsk(TASK2);
	check_ercd(ercd, E_OK);

	ercd = act_tsk(TASK3);
	check_ercd(ercd, E_OK);

	ercd = tslp_tsk(1);
	check_ercd(ercd, E_TMOUT);

	check_point(4);
	ercd = ter_tsk(TASK2);
	check_ercd(ercd, E_OK);

	ercd = tslp_tsk(1);
	check_ercd(ercd, E_TMOUT);

	check_point(5);
	ercd = rcv_mbf(MBF1, buf1);
	check_ercd(ercd, 26);

	check_assert(strncmp(buf1, string2, 26) == 0);

	ercd = act_tsk(TASK2);
	check_ercd(ercd, E_OK);

	ercd = tslp_tsk(1);
	check_ercd(ercd, E_TMOUT);

	check_point(8);
	ercd = ter_tsk(TASK2);
	check_ercd(ercd, E_OK);

	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(13);
	ercd = snd_mbf(MBF1, string3, 10);
	check_ercd(ercd, E_OK);

	check_point(15);
	ercd = rcv_mbf(MBF1, buf1);
	check_ercd(ercd, 10);

	check_assert(strncmp(buf1, string3, 10) == 0);

	ercd = act_tsk(TASK2);
	check_ercd(ercd, E_OK);

	ercd = tslp_tsk(1);
	check_ercd(ercd, E_TMOUT);

	check_point(18);
	ercd = rel_wai(TASK2);
	check_ercd(ercd, E_OK);

	ercd = tslp_tsk(1);
	check_ercd(ercd, E_TMOUT);

	check_point(20);
	ercd = rcv_mbf(MBF1, buf1);
	check_ercd(ercd, 26);

	check_assert(strncmp(buf1, string2, 26) == 0);

	ercd = wup_tsk(TASK2);
	check_ercd(ercd, E_OK);

	ercd = tslp_tsk(1);
	check_ercd(ercd, E_TMOUT);

	check_point(23);
	ercd = rel_wai(TASK2);
	check_ercd(ercd, E_OK);

	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(29);
	ercd = snd_mbf(MBF1, string3, 10);
	check_ercd(ercd, E_OK);

	check_point(31);
	ercd = rcv_mbf(MBF1, buf1);
	check_ercd(ercd, 10);

	check_assert(strncmp(buf1, string3, 10) == 0);

	ercd = tslp_tsk(1);
	check_ercd(ercd, E_TMOUT);

	check_point(34);
	ercd = sta_alm(ALM1, 1U);
	check_ercd(ercd, E_OK);

	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(36);
	ercd = tslp_tsk(1);
	check_ercd(ercd, E_TMOUT);

	check_point(38);
	ercd = rcv_mbf(MBF1, buf1);
	check_ercd(ercd, 26);

	check_assert(strncmp(buf1, string2, 26) == 0);

	ercd = wup_tsk(TASK2);
	check_ercd(ercd, E_OK);

	ercd = tslp_tsk(1);
	check_ercd(ercd, E_TMOUT);

	check_point(41);
	ercd = sta_alm(ALM1, 1U);
	check_ercd(ercd, E_OK);

	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(48);
	ercd = snd_mbf(MBF1, string3, 10);
	check_ercd(ercd, E_OK);

	check_point(51);
	ercd = rcv_mbf(MBF1, buf1);
	check_ercd(ercd, 10);

	check_assert(strncmp(buf1, string3, 10) == 0);

	ercd = wup_tsk(TASK3);
	check_ercd(ercd, E_OK);

	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(63);
	ercd = snd_mbf(MBF1, string3, 10);
	check_ercd(ercd, E_OK);

	check_point(65);
	ercd = rcv_mbf(MBF1, buf1);
	check_ercd(ercd, 10);

	check_assert(strncmp(buf1, string3, 10) == 0);

	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(0);
}

static uint_t	task2_count = 0;

void
task2(intptr_t exinf)
{
	ER_UINT	ercd;

	switch (++task2_count) {
	case 1:
		check_point(2);
		ercd = snd_mbf(MBF1, string1, 26);
		check_ercd(ercd, E_OK);

		check_point(0);

	case 2:
		check_point(6);
		ercd = snd_mbf(MBF1, string1, 26);
		check_ercd(ercd, E_OK);

		check_point(0);

	case 3:
		check_point(11);
		ercd = snd_mbf(MBF1, string1, 26);
		check_ercd(ercd, E_OK);

		check_point(0);

	case 4:
		check_point(16);
		ercd = snd_mbf(MBF1, string1, 26);
		check_ercd(ercd, E_RLWAI);

		check_point(19);
		ercd = slp_tsk();
		check_ercd(ercd, E_OK);

		check_point(21);
		ercd = snd_mbf(MBF1, string1, 26);
		check_ercd(ercd, E_RLWAI);

		check_point(24);
		ercd = slp_tsk();
		check_ercd(ercd, E_OK);

		check_point(27);
		ercd = snd_mbf(MBF1, string1, 26);
		check_ercd(ercd, E_RLWAI);

		check_point(32);
		ercd = snd_mbf(MBF1, string1, 26);
		check_ercd(ercd, E_RLWAI);

		check_point(37);
		ercd = slp_tsk();
		check_ercd(ercd, E_OK);

		check_point(39);
		ercd = snd_mbf(MBF1, string1, 26);
		check_ercd(ercd, E_RLWAI);

		check_point(43);
		ercd = slp_tsk();
		check_ercd(ercd, E_OK);

		check_point(46);
		ercd = snd_mbf(MBF1, string1, 26);
		check_ercd(ercd, E_RLWAI);

		check_point(52);
		ercd = tsnd_mbf(MBF1, string1, 26, 1);
		check_ercd(ercd, E_TMOUT);

		check_point(54);
		ercd = tslp_tsk(1);
		check_ercd(ercd, E_TMOUT);

		check_point(55);
		ercd = rcv_mbf(MBF1, buf1);
		check_ercd(ercd, 26);

		check_assert(strncmp(buf1, string2, 26) == 0);

		check_point(56);
		ercd = tsnd_mbf(MBF1, string1, 26, 1);
		check_ercd(ercd, E_TMOUT);

		check_point(58);
		ercd = slp_tsk();
		check_ercd(ercd, E_OK);

		check_point(61);
		ercd = tsnd_mbf(MBF1, string1, 26, 1);
		check_ercd(ercd, E_TMOUT);

		check_finish(66);
		check_point(0);

	default:
		check_point(0);
	}
	check_point(0);
}

void
task3(intptr_t exinf)
{
	ER_UINT	ercd;

	check_point(3);
	ercd = snd_mbf(MBF1, string2, 26);
	check_ercd(ercd, E_OK);

	check_point(7);
	ercd = snd_mbf(MBF1, string3, 10);
	check_ercd(ercd, E_OK);

	check_point(9);
	ercd = rcv_mbf(MBF1, buf1);
	check_ercd(ercd, 10);

	check_assert(strncmp(buf1, string3, 10) == 0);

	check_point(10);
	ercd = act_tsk(TASK2);
	check_ercd(ercd, E_OK);

	check_point(12);
	ercd = wup_tsk(TASK1);
	check_ercd(ercd, E_OK);

	check_point(14);
	ercd = ter_tsk(TASK2);
	check_ercd(ercd, E_OK);

	check_point(17);
	ercd = snd_mbf(MBF1, string2, 26);
	check_ercd(ercd, E_OK);

	check_point(22);
	ercd = snd_mbf(MBF1, string3, 10);
	check_ercd(ercd, E_OK);

	check_point(25);
	ercd = rcv_mbf(MBF1, buf1);
	check_ercd(ercd, 10);

	check_assert(strncmp(buf1, string3, 10) == 0);

	check_point(26);
	ercd = wup_tsk(TASK2);
	check_ercd(ercd, E_OK);

	check_point(28);
	ercd = wup_tsk(TASK1);
	check_ercd(ercd, E_OK);

	check_point(30);
	ercd = rel_wai(TASK2);
	check_ercd(ercd, E_OK);

	check_point(33);
	ercd = snd_mbf(MBF1, string2, 26);
	check_ercd(ercd, E_OK);

	check_point(40);
	ercd = snd_mbf(MBF1, string3, 10);
	check_ercd(ercd, E_OK);

	check_point(44);
	ercd = rcv_mbf(MBF1, buf1);
	check_ercd(ercd, 10);

	check_assert(strncmp(buf1, string3, 10) == 0);

	check_point(45);
	ercd = wup_tsk(TASK2);
	check_ercd(ercd, E_OK);

	check_point(47);
	ercd = wup_tsk(TASK1);
	check_ercd(ercd, E_OK);

	check_point(49);
	ercd = sta_alm(ALM1, 1U);
	check_ercd(ercd, E_OK);

	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(53);
	ercd = snd_mbf(MBF1, string2, 26);
	check_ercd(ercd, E_OK);

	check_point(57);
	ercd = snd_mbf(MBF1, string3, 10);
	check_ercd(ercd, E_OK);

	check_point(59);
	ercd = rcv_mbf(MBF1, buf1);
	check_ercd(ercd, 10);

	check_assert(strncmp(buf1, string3, 10) == 0);

	check_point(60);
	ercd = wup_tsk(TASK2);
	check_ercd(ercd, E_OK);

	check_point(62);
	ercd = wup_tsk(TASK1);
	check_ercd(ercd, E_OK);

	check_point(64);
	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(0);
}
