/*
 *  TOPPERS Software
 *      Toyohashi Open Platform for Embedded Real-Time Systems
 * 
 *  Copyright (C) 2014 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ(1)(4)ξ˸¤ꡤܥեȥ
 *  ܥեȥѤΤޤࡥʲƱˤѡʣ
 *  ѡۡʰʲѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *      ޤܥեȥΥ桼ޤϥɥ桼Τʤ
 *      ͳ˴Ťᤫ⡤嵭ԤTOPPERSץȤ
 *      դ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơλŪ
 *  ФŬޤơʤݾڤԤʤޤܥեȥ
 *  ѤˤľŪޤϴŪʤ»˴ؤƤ⡤
 *  Ǥʤ
 * 
 *  $Id$
 */

/* 
 *		åХåեΥƥ(1)
 *
 * ڥƥȤŪ
 *
 *  FIFOåХåեˡåȼ
 *  ̤ƥȤ롥
 *
 * ڥƥȹܡ
 *
 *	(A) åХåեؤsnd_mbfsend_message
 *		(A-1) Ԥ塼Ƭʥڴʤ
 *		(A-2) Ԥ塼Ƭʥڴ
 *		(A-3) åХåեΰ˳Ǽ
 *		(A-4) Ԥ塼˥뤿Ԥ֤
 *		(A-5) åХåեΰ˶ʤԤ֤
 *	(B) åХåեμrcv_mbfreceive_message
 *		(B-1) åХåեΰ褫
 *		(B-2) (B-1)Ԥ1ĤޤʣˤԤʥ
 *			  ڴʤ
 *		(B-3) (B-1)Ԥ1ĤޤʣˤԤʥ
 *			  ڴ
 *		(B-4) Ԥ塼ƬΥΥåʥ
 *			  ʤ
 *		(B-5) Ԥ塼ƬΥΥåʥ
 *			  
 *		(B-6) Ԥ֤
 *	(C) åХåեΰؤΥåγǼenqueue_message
 *		(C-1) ȥåΤϢΰ˳Ǽ
 *		(C-2) Ǽ˴ΰƬ
 *		(C-3) åΤγǼǴΰƬ
 *		(C-4) åΤγǼ˴ΰƬ
 *	(D) åХåեΰ褫ΥåμФdequeue_message
 *		(D-1) ȥåΤϢΰ褫Ф
 *		(D-2) Ф˴ΰƬ
 *		(D-3) åΤμФǴΰƬ
 *		(D-4) åΤμФ˴ΰƬ
 *
 * ڻѥ꥽
 *
 *	TASK1: ͥ٥ᥤ󥿥ǽ餫鵯ư
 *	TASK2: ͥ٥
 *	TASK3: ͥ٥
 *	MBF1: åХåեTA_NULL°å26
 *		  ХåեΰΥ26ºݤˤ28
 *
 * ڥƥȥ󥹡
 *
 *	== TASK1ͥ١==
 *		call(set_bit_func(bit_kernel))
 *	1:	act_tsk(TASK2)
 *		act_tsk(TASK3)
 *		ref_mbf(MBF1, &rmbf)
 *		assert(rmbf.stskid == TSK_NONE)
 *		assert(rmbf.rtskid == TSK_NONE)
 *		assert(rmbf.smbfcnt == 0)
 *		snd_mbf(MBF1, string1, 9)		... (A-3)(C-1)ѡ015
 *	2:	snd_mbf(MBF1, string2, 5)		... (A-3)(C-4)ѡ027
 *	3:	snd_mbf(MBF1, string3, 4)		... (A-5)
 *	== TASK2ͥ١==
 *	4:	ref_mbf(MBF1, &rmbf)
 *		assert(rmbf.stskid == TASK1)
 *		assert(rmbf.rtskid == TSK_NONE)
 *		assert(rmbf.smbfcnt == 2)
 *	5:	snd_mbf(MBF1, string1, 4)		... (A-4)
 *	== TASK3ͥ١==
 *	6:	rcv_mbf(MBF1, buf1) -> 9		... (B-3)(D-1)(C-1)ѡ1627,015
 *	== TASK1³==
 *	7:	assert(strncmp(buf1, string1, 9) == 0)
 *		slp_tsk()
 *	== TASK2³==
 *	8:	rcv_mbf(MBF1, buf1) -> 5		... (B-1)(D-4)ѡ015
 *		assert(strncmp(buf1, string2, 5) == 0)
 *		rcv_mbf(MBF1, buf1) -> 4		... (B-1)(D-1)ѡ815
 *		assert(strncmp(buf1, string3, 4) == 0)
 *		rcv_mbf(MBF1, buf1) -> 4		... (B-1)(D-1)ѡʤ
 *		assert(strncmp(buf1, string1, 4) == 0)
 *	9:	rcv_mbf(MBF1, buf1) -> 10		... (B-6)
 *	== TASK3³==
 *	10:	ref_mbf(MBF1, &rmbf)
 *		assert(rmbf.stskid == TSK_NONE)
 *		assert(rmbf.rtskid == TASK2)
 *		assert(rmbf.smbfcnt == 0)
 *	11:	snd_mbf(MBF1, string2, 10)		... (A-2)
 *	== TASK2³==
 *	12:	assert(strncmp(buf1, string2, 10) == 0)
 *		rcv_mbf(MBF1, buf1) -> 11		... (B-6)
 *	== TASK3³==
 *	13:	wup_tsk(TASK1)
 *	== TASK1³==
 *	14:	snd_mbf(MBF1, string3, 11)		... (A-1)
 *		assert(strncmp(buf1, string3, 11) == 0)
 *		snd_mbf(MBF1, string1, 16)		... (A-3)(C-3)ѡ1627,07
 *		tslp_tsk(1) -> E_TMOUT
 *	== TASK2³==
 *	15:	slp_tsk()
 *	== TASK3³==
 *	16:	snd_mbf(MBF1, string2, 12)		... (A-5)
 *	== TASK1³==
 *	17:	wup_tsk(TASK2)
 *		tslp_tsk(1) -> E_TMOUT
 *	== TASK2³==
 *	18:	snd_mbf(MBF1, string3, 4)		... (A-4)
 *	== TASK1³==
 *	19:	rcv_mbf(MBF1, buf1) -> 16		... (B-2)(D-3)(C-1)(C-2)
 *										... 				ѡ827,03
 *		assert(strncmp(buf1, string1, 16) == 0)
 *		slp_tsk()
 *	== TASK2³==
 *	20:	rcv_mbf(MBF1, buf1) -> 12		... (B-1)(D-1)ѡ242703
 *		assert(strncmp(buf1, string2, 12) == 0)
 *	21:	snd_mbf(MBF1, string1, 25)		... (A-5)
 *	== TASK3³==
 *	22:	rcv_mbf(MBF1, buf1) -> 4		... (B-1)(D-2)ѡʤ
 *		assert(strncmp(buf1, string3, 4) == 0)
 *		rcv_mbf(MBF1, buf1) -> 25		... (B-5)
 *	== TASK2³==
 *	23:	assert(strncmp(buf1, string1, 25) == 0)
 *		snd_mbf(MBF1, string2, 26)		... (A-5)
 *	== TASK3³==
 *	24:	wup_tsk(TASK1)
 *	== TASK1³==
 *	25:	rcv_mbf(MBF1, buf1) -> 26		... (B-4)
 *		assert(strncmp(buf1, string2, 26) == 0)
 *		slp_tsk()
 *	== TASK2³==
 *	26:	slp_tsk()
 *	== TASK3³==
 *	27:	END
 */

#include <kernel.h>
#include <t_syslog.h>
#include "kernel_cfg.h"
#include "test_lib.h"
#include "test_messagebuf1.h"
#include <string.h>

const char string1[26] = "abcdefghijklmnopqrstuvwxyz";
const char string2[26] = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
const char string3[16] = "0123456789abcdef";

char buf1[26];

extern ER	bit_kernel(void);

/* DO NOT DELETE THIS LINE -- gentest depends on it. */

void
task1(intptr_t exinf)
{
	ER_UINT	ercd;
	T_RMBF	rmbf;

	test_start(__FILE__);

	set_bit_func(bit_kernel);

	check_point(1);
	ercd = act_tsk(TASK2);
	check_ercd(ercd, E_OK);

	ercd = act_tsk(TASK3);
	check_ercd(ercd, E_OK);

	ercd = ref_mbf(MBF1, &rmbf);
	check_ercd(ercd, E_OK);

	check_assert(rmbf.stskid == TSK_NONE);

	check_assert(rmbf.rtskid == TSK_NONE);

	check_assert(rmbf.smbfcnt == 0);

	ercd = snd_mbf(MBF1, string1, 9);
	check_ercd(ercd, E_OK);

	check_point(2);
	ercd = snd_mbf(MBF1, string2, 5);
	check_ercd(ercd, E_OK);

	check_point(3);
	ercd = snd_mbf(MBF1, string3, 4);
	check_ercd(ercd, E_OK);

	check_point(7);
	check_assert(strncmp(buf1, string1, 9) == 0);

	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(14);
	ercd = snd_mbf(MBF1, string3, 11);
	check_ercd(ercd, E_OK);

	check_assert(strncmp(buf1, string3, 11) == 0);

	ercd = snd_mbf(MBF1, string1, 16);
	check_ercd(ercd, E_OK);

	ercd = tslp_tsk(1);
	check_ercd(ercd, E_TMOUT);

	check_point(17);
	ercd = wup_tsk(TASK2);
	check_ercd(ercd, E_OK);

	ercd = tslp_tsk(1);
	check_ercd(ercd, E_TMOUT);

	check_point(19);
	ercd = rcv_mbf(MBF1, buf1);
	check_ercd(ercd, 16);

	check_assert(strncmp(buf1, string1, 16) == 0);

	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(25);
	ercd = rcv_mbf(MBF1, buf1);
	check_ercd(ercd, 26);

	check_assert(strncmp(buf1, string2, 26) == 0);

	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(0);
}

void
task2(intptr_t exinf)
{
	ER_UINT	ercd;
	T_RMBF	rmbf;

	check_point(4);
	ercd = ref_mbf(MBF1, &rmbf);
	check_ercd(ercd, E_OK);

	check_assert(rmbf.stskid == TASK1);

	check_assert(rmbf.rtskid == TSK_NONE);

	check_assert(rmbf.smbfcnt == 2);

	check_point(5);
	ercd = snd_mbf(MBF1, string1, 4);
	check_ercd(ercd, E_OK);

	check_point(8);
	ercd = rcv_mbf(MBF1, buf1);
	check_ercd(ercd, 5);

	check_assert(strncmp(buf1, string2, 5) == 0);

	ercd = rcv_mbf(MBF1, buf1);
	check_ercd(ercd, 4);

	check_assert(strncmp(buf1, string3, 4) == 0);

	ercd = rcv_mbf(MBF1, buf1);
	check_ercd(ercd, 4);

	check_assert(strncmp(buf1, string1, 4) == 0);

	check_point(9);
	ercd = rcv_mbf(MBF1, buf1);
	check_ercd(ercd, 10);

	check_point(12);
	check_assert(strncmp(buf1, string2, 10) == 0);

	ercd = rcv_mbf(MBF1, buf1);
	check_ercd(ercd, 11);

	check_point(15);
	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(18);
	ercd = snd_mbf(MBF1, string3, 4);
	check_ercd(ercd, E_OK);

	check_point(20);
	ercd = rcv_mbf(MBF1, buf1);
	check_ercd(ercd, 12);

	check_assert(strncmp(buf1, string2, 12) == 0);

	check_point(21);
	ercd = snd_mbf(MBF1, string1, 25);
	check_ercd(ercd, E_OK);

	check_point(23);
	check_assert(strncmp(buf1, string1, 25) == 0);

	ercd = snd_mbf(MBF1, string2, 26);
	check_ercd(ercd, E_OK);

	check_point(26);
	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(0);
}

void
task3(intptr_t exinf)
{
	ER_UINT	ercd;
	T_RMBF	rmbf;

	check_point(6);
	ercd = rcv_mbf(MBF1, buf1);
	check_ercd(ercd, 9);

	check_point(10);
	ercd = ref_mbf(MBF1, &rmbf);
	check_ercd(ercd, E_OK);

	check_assert(rmbf.stskid == TSK_NONE);

	check_assert(rmbf.rtskid == TASK2);

	check_assert(rmbf.smbfcnt == 0);

	check_point(11);
	ercd = snd_mbf(MBF1, string2, 10);
	check_ercd(ercd, E_OK);

	check_point(13);
	ercd = wup_tsk(TASK1);
	check_ercd(ercd, E_OK);

	check_point(16);
	ercd = snd_mbf(MBF1, string2, 12);
	check_ercd(ercd, E_OK);

	check_point(22);
	ercd = rcv_mbf(MBF1, buf1);
	check_ercd(ercd, 4);

	check_assert(strncmp(buf1, string3, 4) == 0);

	ercd = rcv_mbf(MBF1, buf1);
	check_ercd(ercd, 25);

	check_point(24);
	ercd = wup_tsk(TASK1);
	check_ercd(ercd, E_OK);

	check_finish(27);
	check_point(0);
}
