/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2004-2014 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ(1)(4)ξ˸¤ꡤܥեȥ
 *  ܥեȥѤΤޤࡥʲƱˤѡʣ
 *  ѡۡʰʲѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *      ޤܥեȥΥ桼ޤϥɥ桼Τʤ
 *      ͳ˴Ťᤫ⡤嵭ԤTOPPERSץȤ
 *      դ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơλŪ
 *  ФŬޤơʤݾڤԤʤޤܥեȥ
 *  ѤˤľŪޤϴŪʤ»˴ؤƤ⡤
 *  Ǥʤ
 * 
 *  $Id$
 */

/*
 *		TOPPERS/ASPͥ ɸإåե
 *
 *  TOPPERS/ASPͥ뤬ݡȤ륵ӥȡɬפʥǡ
 *  ޥޤإåե롥
 *
 *  ֥Υե뤫餳Υե򥤥󥯥롼ɤ
 *  ϡTOPPERS_MACRO_ONLYƤˤꡤޥʳ
 *  褦ˤʤäƤ롥
 *
 *  Υե򥤥󥯥롼ɤ˥󥯥롼ɤƤ٤ե
 *  Ϥʤ
 */

#ifndef TOPPERS_KERNEL_H
#define TOPPERS_KERNEL_H

#ifdef __cplusplus
extern "C" {
#endif

/*
 *	TOPPERS̤Υǡޥ
 */
#include <t_stddef.h>

/*
 *  åȰ¸
 */
#include "target_kernel.h"

#ifndef TOPPERS_MACRO_ONLY

/*
 *  ǡ
 */

/*
 *  ӥåȥѥ䥪ֹ֥η
 */
typedef	uint_t		TEXPTN;		/* 㳰װΥӥåȥѥ */
typedef	uint_t		FLGPTN;		/* ٥ȥե饰Υӥåȥѥ */
typedef	uint_t		INTNO;		/* ֹ */
typedef	uint_t		INHNO;		/* ߥϥɥֹ */
typedef	uint_t		EXCNO;		/* CPU㳰ϥɥֹ */

/*
 *  ñ̤η
 */
typedef void	(*TASK)(intptr_t exinf);
typedef void	(*TEXRTN)(TEXPTN texptn, intptr_t exinf);
typedef void	(*CYCHDR)(intptr_t exinf);
typedef void	(*ALMHDR)(intptr_t exinf);
typedef void	(*ISR)(intptr_t exinf);
typedef void	(*INTHDR)(void);
typedef void	(*EXCHDR)(void *p_excinf);
typedef void	(*INIRTN)(intptr_t exinf);
typedef void	(*TERRTN)(intptr_t exinf);

/*
 *  ΰݤΤη
 */
#ifndef TOPPERS_STK_T
#define TOPPERS_STK_T	intptr_t
#endif /* TOPPERS_STK_T */
typedef	TOPPERS_STK_T	STK_T;	/* åΰݤ뤿η */

#ifndef TOPPERS_MPF_T
#define TOPPERS_MPF_T	intptr_t
#endif /* TOPPERS_MPF_T */
typedef	TOPPERS_MPF_T	MPF_T;	/* Ĺסΰݤ뤿η */

/*
 *  åإåη
 */
typedef	struct t_msg {			/* ᡼ܥåΥåإå */
	struct t_msg	*pk_next;
} T_MSG;

typedef	struct t_msg_pri {		/* ͥդåإå */
	T_MSG	msgque;				/* åإå */
	PRI		msgpri;				/* åͥ */
} T_MSG_PRI;

/*
 *  ѥåȷ
 */
typedef struct t_rtsk {
	STAT	tskstat;	/*  */
	PRI		tskpri;		/* θͥ */
	PRI		tskbpri;	/* Υ١ͥ */
	STAT	tskwait;	/* Ԥװ */
	ID		wobjid;		/* ԤоݤΥ֥ȤID */
	TMO		lefttmo;	/* ॢȤޤǤλ */
	uint_t	actcnt;		/* ư׵ᥭ塼󥰿 */
	uint_t	wupcnt;		/* ׵ᥭ塼󥰿 */
} T_RTSK;

typedef struct t_rtex {
	STAT	texstat;	/* 㳰ξ */
	TEXPTN	pndptn;		/* α㳰װ */
} T_RTEX;

typedef struct t_rsem {
	ID		wtskid;		/* ޥեԤƬΥIDֹ */
	uint_t	semcnt;		/* ޥեθߤλ񸻿 */
} T_RSEM;

typedef struct t_rflg {
	ID		wtskid;		/* ٥ȥե饰ԤƬΥIDֹ */
	FLGPTN	flgptn;		/* ٥ȥե饰θߤΥӥåȥѥ */
} T_RFLG;

typedef struct t_rdtq {
	ID		stskid;		/* ǡ塼ԤƬΥIDֹ */
	ID		rtskid;		/* ǡ塼μԤƬΥIDֹ */
	uint_t	sdtqcnt;	/* ǡ塼ΰ˳ǼƤǡο */
} T_RDTQ;

typedef struct t_rpdq {
	ID		stskid;		/* ͥ٥ǡ塼ԤƬΥ
						   IDֹ */
	ID		rtskid;		/* ͥ٥ǡ塼μԤƬΥ
						   IDֹ */
	uint_t	spdqcnt;	/* ͥ٥ǡ塼ΰ˳ǼƤǡ
						   ο */
} T_RPDQ;

typedef struct t_rmbx {
	ID		wtskid;		/* ᡼ܥåԤƬΥIDֹ */
	T_MSG	*pk_msg;	/* å塼ƬˤĤʤ줿å
						   Ƭ */
} T_RMBX;

typedef struct t_rmbf {
	ID		stskid;		/* åХåեԤƬΥ
						   IDֹ */
	ID		rtskid;		/* åХåեμԤƬΥ
						   IDֹ */
	uint_t	smbfcnt;	/* åХåեΰ˳ǼƤ
						   ο */
	SIZE	fmbfsz;		/* åХåեΰζΰΥ */
} T_RMBF;

typedef struct t_rmpf {
	ID		wtskid;		/* ĹסԤƬΥ
						   IDֹ */
	uint_t	fblkcnt;	/* Ĺסΰζΰ˳
						   դ뤳ȤǤĹ֥åο */
} T_RMPF;

typedef struct t_rcyc {
	STAT	cycstat;	/* ϥɥư */
	RELTIM	lefttim;	/* ˼ϥɥưޤǤл */
} T_RCYC;

typedef struct t_ralm {
	STAT	almstat;	/* 顼ϥɥư */
	RELTIM	lefttim;	/* 顼ϥɥưޤǤл */
} T_RALM;

/*
 *  ӥ
 */

/*
 *  ǽ
 */
extern ER		act_tsk(ID tskid) throw();
extern ER		iact_tsk(ID tskid) throw();
extern ER_UINT	can_act(ID tskid) throw();
extern ER		ext_tsk(void) throw();
extern ER		ter_tsk(ID tskid) throw();
extern ER		chg_pri(ID tskid, PRI tskpri) throw();
extern ER		get_pri(ID tskid, PRI *p_tskpri) throw();
extern ER		get_inf(intptr_t *p_exinf) throw();
extern ER		ref_tsk(ID tskid, T_RTSK *pk_rtsk) throw();

/*
 *  °Ʊǽ
 */
extern ER		slp_tsk(void) throw();
extern ER		tslp_tsk(TMO tmout) throw();
extern ER		wup_tsk(ID tskid) throw();
extern ER		iwup_tsk(ID tskid) throw();
extern ER_UINT	can_wup(ID tskid) throw();
extern ER		rel_wai(ID tskid) throw();
extern ER		irel_wai(ID tskid) throw();
extern ER		sus_tsk(ID tskid) throw();
extern ER		rsm_tsk(ID tskid) throw();
extern ER		dly_tsk(RELTIM dlytim) throw();

/*
 *  㳰ǽ
 */
extern ER		ras_tex(ID tskid, TEXPTN rasptn) throw();
extern ER		iras_tex(ID tskid, TEXPTN rasptn) throw();
extern ER		dis_tex(void) throw();
extern ER		ena_tex(void) throw();
extern bool_t	sns_tex(void) throw();
extern ER		ref_tex(ID tskid, T_RTEX *pk_rtex) throw();

/*
 *  Ʊ̿ǽ
 */
extern ER		sig_sem(ID semid) throw();
extern ER		isig_sem(ID semid) throw();
extern ER		wai_sem(ID semid) throw();
extern ER		pol_sem(ID semid) throw();
extern ER		twai_sem(ID semid, TMO tmout) throw();
extern ER		ini_sem(ID semid) throw();
extern ER		ref_sem(ID semid, T_RSEM *pk_rsem) throw();

extern ER		set_flg(ID flgid, FLGPTN setptn) throw();
extern ER		iset_flg(ID flgid, FLGPTN setptn) throw();
extern ER		clr_flg(ID flgid, FLGPTN clrptn) throw();
extern ER		wai_flg(ID flgid, FLGPTN waiptn,
						MODE wfmode, FLGPTN *p_flgptn) throw();
extern ER		pol_flg(ID flgid, FLGPTN waiptn,
						MODE wfmode, FLGPTN *p_flgptn) throw();
extern ER		twai_flg(ID flgid, FLGPTN waiptn,
						MODE wfmode, FLGPTN *p_flgptn, TMO tmout) throw();
extern ER		ini_flg(ID flgid) throw();
extern ER		ref_flg(ID flgid, T_RFLG *pk_rflg) throw();

extern ER		snd_dtq(ID dtqid, intptr_t data) throw();
extern ER		psnd_dtq(ID dtqid, intptr_t data) throw();
extern ER		ipsnd_dtq(ID dtqid, intptr_t data) throw();
extern ER		tsnd_dtq(ID dtqid, intptr_t data, TMO tmout) throw();
extern ER		fsnd_dtq(ID dtqid, intptr_t data) throw();
extern ER		ifsnd_dtq(ID dtqid, intptr_t data) throw();
extern ER		rcv_dtq(ID dtqid, intptr_t *p_data) throw();
extern ER		prcv_dtq(ID dtqid, intptr_t *p_data) throw();
extern ER		trcv_dtq(ID dtqid, intptr_t *p_data, TMO tmout) throw();
extern ER		ini_dtq(ID dtqid) throw();
extern ER		ref_dtq(ID dtqid, T_RDTQ *pk_rdtq) throw();

extern ER		snd_pdq(ID pdqid, intptr_t data, PRI datapri) throw();
extern ER		psnd_pdq(ID pdqid, intptr_t data, PRI datapri) throw();
extern ER		ipsnd_pdq(ID pdqid, intptr_t data, PRI datapri) throw();
extern ER		tsnd_pdq(ID pdqid, intptr_t data,
										PRI datapri, TMO tmout) throw();
extern ER		rcv_pdq(ID pdqid, intptr_t *p_data, PRI *p_datapri) throw();
extern ER		prcv_pdq(ID pdqid, intptr_t *p_data, PRI *p_datapri) throw();
extern ER		trcv_pdq(ID pdqid, intptr_t *p_data,
										PRI *p_datapri, TMO tmout) throw();
extern ER		ini_pdq(ID pdqid) throw();
extern ER		ref_pdq(ID pdqid, T_RPDQ *pk_rpdq) throw();

extern ER		snd_mbx(ID mbxid, T_MSG *pk_msg) throw();
extern ER		rcv_mbx(ID mbxid, T_MSG **ppk_msg) throw();
extern ER		prcv_mbx(ID mbxid, T_MSG **ppk_msg) throw();
extern ER		trcv_mbx(ID mbxid, T_MSG **ppk_msg, TMO tmout) throw();
extern ER		ini_mbx(ID mbxid) throw();
extern ER		ref_mbx(ID mbxid, T_RMBX *pk_rmbx) throw();

extern ER		snd_mbf(ID mbfid, const void *msg, uint_t msgsz) throw();
extern ER		psnd_mbf(ID mbfid, const void *msg, uint_t msgsz) throw();
extern ER		tsnd_mbf(ID mbfid, const void *msg,
										uint_t msgsz, TMO tmout) throw();
extern ER_UINT	rcv_mbf(ID mbfid, void *msg) throw();
extern ER_UINT	prcv_mbf(ID mbfid, void *msg) throw();
extern ER_UINT	trcv_mbf(ID mbfid, void *msg, TMO tmout) throw();
extern ER		ini_mbf(ID mbfid) throw();
extern ER		ref_mbf(ID mbfid, T_RMBF *pk_rmbf) throw();

/*
 *  סǽ
 */
extern ER		get_mpf(ID mpfid, void **p_blk) throw();
extern ER		pget_mpf(ID mpfid, void **p_blk) throw();
extern ER		tget_mpf(ID mpfid, void **p_blk, TMO tmout) throw();
extern ER		rel_mpf(ID mpfid, void *blk) throw();
extern ER		ini_mpf(ID mpfid) throw();
extern ER		ref_mpf(ID mpfid, T_RMPF *pk_rmpf) throw();

/*
 *  ִǽ
 */
extern ER		get_tim(SYSTIM *p_systim) throw();
extern ER		get_utm(SYSUTM *p_sysutm) throw();

extern ER		sta_cyc(ID cycid) throw();
extern ER		stp_cyc(ID cycid) throw();
extern ER		ref_cyc(ID cycid, T_RCYC *pk_rcyc) throw();

extern ER		sta_alm(ID almid, RELTIM almtim) throw();
extern ER		ista_alm(ID almid, RELTIM almtim) throw();
extern ER		stp_alm(ID almid) throw();
extern ER		istp_alm(ID almid) throw();
extern ER		ref_alm(ID almid, T_RALM *pk_ralm) throw();

/*
 *  ƥִǽ
 */
extern ER		rot_rdq(PRI tskpri) throw();
extern ER		irot_rdq(PRI tskpri) throw();
extern ER		get_tid(ID *p_tskid) throw();
extern ER		iget_tid(ID *p_tskid) throw();
extern ER		loc_cpu(void) throw();
extern ER		iloc_cpu(void) throw();
extern ER		unl_cpu(void) throw();
extern ER		iunl_cpu(void) throw();
extern ER		dis_dsp(void) throw();
extern ER		ena_dsp(void) throw();
extern bool_t	sns_ctx(void) throw();
extern bool_t	sns_loc(void) throw();
extern bool_t	sns_dsp(void) throw();
extern bool_t	sns_dpn(void) throw();
extern bool_t	sns_ker(void) throw();
extern ER		ext_ker(void) throw();

/*
 *  ߴǽ
 */
extern ER		dis_int(INTNO intno) throw();
extern ER		ena_int(INTNO intno) throw();
extern ER		chg_ipm(PRI intpri) throw();
extern ER		get_ipm(PRI *p_intpri) throw();

/*
 *  CPU㳰ǽ
 */
extern bool_t	xsns_dpn(void *p_excinf) throw();
extern bool_t	xsns_xpn(void *p_excinf) throw();

#endif /* TOPPERS_MACRO_ONLY */

/*
 *  ֥°
 */
#define TA_ACT			UINT_C(0x02)	/* ư줿֤ */

#define TA_TPRI			UINT_C(0x01)	/* Ԥͥٽ */
#define TA_MPRI			UINT_C(0x02)	/* å塼ͥٽ */

#define TA_WMUL			UINT_C(0x02)	/* ʣԤ */
#define TA_CLR			UINT_C(0x04)	/* ٥ȥե饰Υꥢ */

#define TA_STA			UINT_C(0x02)	/* ϥɥư֤ */

#define TA_NONKERNEL	UINT_C(0x02)	/* ͥγ */

#define TA_ENAINT		UINT_C(0x01)	/* ׵ػߥե饰򥯥ꥢ */
#define TA_EDGE			UINT_C(0x02)	/* åȥꥬ */

/*
 *  ӥư⡼ɤ
 */
#define TWF_ORW			UINT_C(0x01)	/* ٥ȥե饰ORԤ */
#define TWF_ANDW		UINT_C(0x02)	/* ٥ȥե饰ANDԤ */

/*
 *  ֥Ȥξ֤
 */
#define TTS_RUN			UINT_C(0x01)	/* ¹Ծ */
#define TTS_RDY			UINT_C(0x02)	/* ¹Բǽ */
#define TTS_WAI			UINT_C(0x04)	/* Ԥ */
#define TTS_SUS			UINT_C(0x08)	/* Ԥ */
#define TTS_WAS			UINT_C(0x0c)	/* Ԥ */
#define TTS_DMT			UINT_C(0x10)	/* ٻ߾ */

#define TTW_SLP			UINT_C(0x0001)	/* Ԥ */
#define TTW_DLY			UINT_C(0x0002)	/* ַвԤ */
#define TTW_SEM			UINT_C(0x0004)	/* ޥեλ񸻳Ԥ */
#define TTW_FLG			UINT_C(0x0008)	/* ٥ȥե饰Ԥ */
#define TTW_SDTQ		UINT_C(0x0010)	/* ǡ塼ؤԤ */
#define TTW_RDTQ		UINT_C(0x0020)	/* ǡ塼μԤ */
#define TTW_SPDQ		UINT_C(0x0100)	/* ͥ٥ǡ塼ؤԤ */
#define TTW_RPDQ		UINT_C(0x0200)	/* ͥ٥ǡ塼μԤ */
#define TTW_MBX			UINT_C(0x0040)	/* ᡼ܥåμԤ */
#define TTW_SMBF		UINT_C(0x0400)	/* åХåեؤԤ */
#define TTW_RMBF		UINT_C(0x0800)	/* åХåեμԤ */
#define TTW_MPF			UINT_C(0x2000)	/* Ĺ֥åγԤ */

#define TTEX_ENA		UINT_C(0x01)	/* 㳰ľ */
#define TTEX_DIS		UINT_C(0x02)	/* 㳰ػ߾ */

#define TCYC_STP		UINT_C(0x01)	/* ϥɥ餬ưƤʤ */
#define TCYC_STA		UINT_C(0x02)	/* ϥɥ餬ưƤ */

#define TALM_STP		UINT_C(0x01)	/* 顼ϥɥ餬ưƤʤ */
#define TALM_STA		UINT_C(0x02)	/* 顼ϥɥ餬ưƤ */

/*
 *  ¾
 */
#define TSK_SELF		0			/*  */
#define TSK_NONE		0			/* 륿ʤ */

#define TPRI_SELF		0			/* Υ١ͥ */
#define TPRI_INI		0			/* εưͥ */

#define TIPM_ENAALL		0			/* ͥ٥ޥ */

/*
 *  ȥޥ
 */

/*
 *  ݡȤ뵡ǽ
 */
#ifdef TOPPERS_TARGET_SUPPORT_DIS_INT
#define TOPPERS_SUPPORT_DIS_INT			/* dis_intݡȤƤ */
#endif /* TOPPERS_TARGET_SUPPORT_DIS_INT */

#ifdef TOPPERS_TARGET_SUPPORT_ENA_INT
#define TOPPERS_SUPPORT_ENA_INT			/* ena_intݡȤƤ */
#endif /* TOPPERS_TARGET_SUPPORT_ENA_INT */

#ifdef TOPPERS_TARGET_SUPPORT_GET_UTM
#define TOPPERS_SUPPORT_GET_UTM			/* get_utmݡȤƤ */
#endif /* TOPPERS_TARGET_SUPPORT_GET_UTM */

#define TOPPERS_SUPPORT_MESSAGEBUF		/* åХåեǽĥ */

/*
 *  ͥ٤ϰ
 */
#define TMIN_TPRI		1			/* ͥ٤κǾ͡ʺǹ͡*/
#define TMAX_TPRI		16			/* ͥ٤κ͡ʺ͡*/
#define TMIN_DPRI		1			/* ǡͥ٤κǾ͡ʺǹ͡*/
#define TMAX_DPRI		16			/* ǡͥ٤κ͡ʺ͡*/
#define TMIN_MPRI		1			/* åͥ٤κǾ͡ʺǹ͡*/
#define TMAX_MPRI		16			/* åͥ٤κ͡ʺ͡*/
#define TMIN_ISRPRI		1			/* ߥӥ롼ͥ٤κǾ */
#define TMAX_ISRPRI		16			/* ߥӥ롼ͥ٤κ */

/*
 *  С
 */
#define TKERNEL_MAKER	UINT_C(0x0118)	/* ͥΥ᡼ */
#define TKERNEL_PRID	UINT_C(0x0007)	/* ͥμֹ */
#define TKERNEL_SPVER	UINT_C(0xf517)	/* ͥͤΥСֹ */
#define TKERNEL_PRVER	UINT_C(0x1092)	/* ͥΥСֹ */

/*
 *  塼󥰲κ
 */
#define TMAX_ACTCNT		UINT_C(1)		/* ư׵ᥭ塼󥰿κ */
#define TMAX_WUPCNT		UINT_C(1)		/* ׵ᥭ塼󥰿κ */

/*
 *  ӥåȥѥΥӥåȿ
 */
#ifndef TBIT_TEXPTN					/* 㳰װΥӥåȿ */
#define TBIT_TEXPTN		(sizeof(TEXPTN) * CHAR_BIT)
#endif /* TBIT_TEXPTN */

#ifndef TBIT_FLGPTN					/* ٥ȥե饰Υӥåȿ */
#define TBIT_FLGPTN		(sizeof(FLGPTN) * CHAR_BIT)
#endif /* TBIT_FLGPTN */

/*
 *  ΰݤΤΥޥ
 *
 *  ʲTOPPERS_COUNT_SZTOPPERS_ROUND_SZϡunit2ζҾǤ
 *  뤳ȤꤷƤ롥
 */
#ifndef TOPPERS_COUNT_SZ
#define TOPPERS_COUNT_SZ(sz, unit)	(((sz) + (unit) - 1) / (unit))
#endif /* TOPPERS_COUNT_SZ */
#ifndef TOPPERS_ROUND_SZ
#define TOPPERS_ROUND_SZ(sz, unit)	(((sz) + (unit) - 1) & ~((unit) - 1))
#endif /* TOPPERS_ROUND_SZ */

#define COUNT_STK_T(sz)		TOPPERS_COUNT_SZ(sz, sizeof(STK_T))
#define ROUND_STK_T(sz)		TOPPERS_ROUND_SZ(sz, sizeof(STK_T))

#define TSZ_MBFMB(msgcnt, msgsz) \
	((msgcnt) * (sizeof(uint_t) + TOPPERS_ROUND_SZ(msgsz, sizeof(uint_t))))

#define COUNT_MPF_T(blksz)	TOPPERS_COUNT_SZ(blksz, sizeof(MPF_T))
#define ROUND_MPF_T(blksz)	TOPPERS_ROUND_SZ(blksz, sizeof(MPF_T))

/*
 *  ¾ι
 */
#define TMAX_MAXSEM		UINT_MAX	/* ޥեκ񸻿κ */

#ifdef __cplusplus
}
#endif

#endif /* TOPPERS_KERNEL_H */
