/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005-2010 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ(1)(4)ξ˸¤ꡤܥեȥ
 *  ܥեȥѤΤޤࡥʲƱˤѡʣ
 *  ѡۡʰʲѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *      ޤܥեȥΥ桼ޤϥɥ桼Τʤ
 *      ͳ˴Ťᤫ⡤嵭ԤTOPPERSץȤ
 *      դ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơλŪ
 *  ФŬޤơʤݾڤԤʤޤܥեȥ
 *  ѤˤľŪޤϴŪʤ»˴ؤƤ⡤
 *  Ǥʤ
 * 
 *  $Id$
 */

/*
 *		⥸塼
 */

#ifndef TOPPERS_TASK_H
#define TOPPERS_TASK_H

#include <queue.h>
#include "time_event.h"

/*
 *  ȥ졼ޥΥǥե
 */
#ifndef LOG_TSKSTAT
#define LOG_TSKSTAT(p_tcb)
#endif /* LOG_TSKSTAT */

/*
 *  ͥ٤ɽɽѴޥ
 */
#define INT_PRIORITY(x)		((uint_t)((x) - TMIN_TPRI))
#define EXT_TSKPRI(x)		((PRI)(x) + TMIN_TPRI)

/*
 *  ֤ɽ
 *
 *  TCBΥ֤Ǥϡ¹Ծ֡RUNNINGˤȼ¹Բǽ֡READY
 *  ϶̤ʤξ֤Τơ¹ԤǤ֡RUNNABLEˤȸƤ֡
 *  Ԥ֤ϡ(TS_WAITING | TS_SUSPENDED)ɽTS_WAIT_???
 *  װɽԤ֡Ԥ֤ޤˤξˤΤꤹ롥
 */
#define TS_DORMANT		0x00U			/* ٻ߾ */
#define TS_RUNNABLE		0x01U			/* ¹ԤǤ */
#define TS_WAITING		0x02U			/* Ԥ */
#define TS_SUSPENDED	0x04U			/* Ԥ */

#define TS_WAIT_DLY		(0x00U << 3)	/* ַвԤ */
#define TS_WAIT_SLP		(0x01U << 3)	/* Ԥ */
#define TS_WAIT_RDTQ	(0x02U << 3)	/* ǡ塼μԤ */
#define TS_WAIT_RPDQ	(0x03U << 3)	/* ͥ٥ǡ塼μԤ */
#define TS_WAIT_SEM		(0x04U << 3)	/* ޥե񸻤γԤ */
#define TS_WAIT_FLG		(0x05U << 3)	/* ٥ȥե饰Ԥ */
#define TS_WAIT_SDTQ	(0x06U << 3)	/* ǡ塼ؤԤ */
#define TS_WAIT_SPDQ	(0x07U << 3)	/* ͥ٥ǡ塼ؤԤ */
#define TS_WAIT_MBX		(0x08U << 3)	/* ᡼ܥåμԤ */
#define TS_WAIT_MPF		(0x09U << 3)	/* Ĺ֥åγԤ */

/*
 *  Ƚ̥ޥ
 *
 *  TSTAT_DORMANTϥٻ߾֤Ǥ뤫ɤTSTAT_RUNNABLE
 *  ¹ԤǤ֤Ǥ뤫ɤȽ̤롥TSTAT_WAITING
 *  ֤Ԥ֤Τ줫Ǥ뤫ɤTSTAT_SUSPENDED
 *  Ԥ֤Ԥ֤Τ줫Ǥ뤫ɤȽ̤롥
 */
#define TSTAT_DORMANT(tstat)	((tstat) == TS_DORMANT)
#define TSTAT_RUNNABLE(tstat)	(((tstat) & TS_RUNNABLE) != 0U)
#define TSTAT_WAITING(tstat)	(((tstat) & TS_WAITING) != 0U)
#define TSTAT_SUSPENDED(tstat)	(((tstat) & TS_SUSPENDED) != 0U)

/*
 *  ԤװȽ̥ޥ
 *
 *  TSTAT_WAIT_SLPϥԤǤ뤫ɤTSTAT_WAIT_WOBJ
 *  ϥƱ֥̿ȤФԤǤ뤫ʸȡ
 *  Ʊ֥̿ȤԤ塼ˤĤʤƤ뤫ˤɤȽ̤
 *  롥ޤTSTAT_WAIT_WOBJCBϥƱ֥̿Ȥδ
 *  ֥åζʬWOBJCBˤԤ塼ˤĤʤƤ뤫ɤ
 *  Ƚ̤롥
 *
 *  TSTAT_WAIT_SLPϡǤդΥ֤椫顤ԤǤ
 *  ȤȽ̤Ǥ롥ʤTSTAT_WAITINGˤԤ֤Ǥ뤳Ȥ
 *  Ƚ̤ˡTSTAT_SLPѤƵԤ֤Ǥ뤳ȤȽ̤Ǥ롥
 *  ΨŪ˼¸뤿ˡTS_WAIT_SLPͤ(0x00U << 3)ǤϤ
 *  (0x01U << 3)ȤƤ롥ΤᡤַвԤ֤Ǥ
 *  ȤȽ̤뤿TSTAT_WAIT_DLYTSTAT_WAIT_SLPƱͤˡ
 *  ¸뤳ȤϤǤʤ
 */
#define TS_WAIT_MASK	(0x0fU << 3)	/* ԤװμФޥ */

#define TSTAT_WAIT_SLP(tstat)		(((tstat) & TS_WAIT_MASK) == TS_WAIT_SLP)
#define TSTAT_WAIT_WOBJ(tstat)		(((tstat) & TS_WAIT_MASK) >= TS_WAIT_RDTQ)
#define TSTAT_WAIT_WOBJCB(tstat)	(((tstat) & TS_WAIT_MASK) >= TS_WAIT_SEM)

/*
 *  Ԥ֥åWINFOˤ
 *
 *  Ԥ֤δ֤ϡTCBӤp_winfoǻؤWINFO򼡤
 *  褦ꤷʤФʤʤ
 *
 *  (a) TCBΥ֤Ԥ֡TS_WAITINGˤˤ롥κݤˡԤ
 *  װTS_WAIT_???ˤꤹ롥
 *
 *  (b) ॢȤƻ뤹뤿ˡ।٥ȥ֥åϿ롥
 *  Ͽ륿।٥ȥ֥åϡԤ륵ӥؿ
 *  ΥѿȤƳݤؤΥݥ󥿤WINFOp_tmevtb˵
 *  롥ॢȤδƻ뤬ɬפʤʱʵԤξˤˤϡ
 *  p_tmevtbNULLˤ롥
 *
 *  Ʊ֥̿ȤФԤ֤ξˤϡɸWINFO
 *  p_wobjcbեɤɲä¤ΡWINFO_WOBJwait.hˤ
 *  ޤʲ(c)(e)Ԥɬפ롥Ʊ֥̿
 *  Ȥ˴طʤԤʵԤַвԤˤξˤϡ(c)(e)
 *  ɬפʤ
 *
 *  (c) TCBԤоݤƱ֥̿ȤԤ塼ˤĤʤ
 *  塼ˤĤʤˡtask_queueȤ
 *
 *  (d) ԤоݤƱ֥̿Ȥδ֥åؤΥݥ󥿤
 *  WINFO_WOBJp_wobjcb˵롥
 *
 *  (e) ԤоݤƱ֥̿Ȥ˰¸Ƶ뤳Ȥɬפ
 *  󤬤ˤϡWINFO_WOBJɬפʾΤΥեɤɲ
 *  ¤ΤWINFO_WOBJѤ롥
 *
 *  Ԥ֤ݤˤϡԤФͤWINFO
 *  wercdꤹ롥wercdɬפʤΤԤʹߤǤΤФơ
 *  p_tmevtbԤɬפʤᡤΤ˶ΤȤ
 *  Ƥ롥Τᡤwercdإ顼ɤꤹΤϡ।٥
 *  ֥åϿˤʤФʤʤ
 */
typedef union waiting_information {
	ER		wercd;			/* ԤΥ顼 */
	TMEVTB	*p_tmevtb;		/* ԤѤΥ।٥ȥ֥å */
} WINFO;

/*
 *  ֥å
 *
 *  ˴ؤͤѤʤROM֤ʬʥ
 *  ֥åˤȡͤѲ뤿RAM֤ʤФʤʤ
 *  ʬʥ֥åTCBˤʬΥTCBб륿
 *  ֥åؤݥ󥿤롥֥åб
 *  TCBؤݥ󥿤ˡRAMδ˾ޤ
 *  ¹ԸΨʤ뤿˺ѤƤʤ¾Υ֥ȤˤĤ
 *  ƤƱͤ˰
 *
 *  ֥åˤϡDEF_TEX륿㳰롼
 *  ˴ؤޤࡥ
 */
typedef struct task_initialization_block {
	ATR			tskatr;			/* ° */
	intptr_t	exinf;			/* γĥ */
	TASK		task;			/* εư */
	uint_t		ipriority;		/* εưͥ١ɽ */

#ifdef USE_TSKINICTXB
	TSKINICTXB	tskinictxb;		/* ƥȥ֥å */
#else /* USE_TSKINICTXB */
	SIZE		stksz;			/* åΰΥʴݤ᤿͡ */
	void		*stk;			/* åΰƬ */
#endif /* USE_TSKINICTXB */

	ATR			texatr;			/* 㳰롼° */
	TEXRTN		texrtn;			/* 㳰롼εư */
} TINIB;

/*
 *  TCBΥեɤΥӥå
 *
 *  ץåˤäƤϡTCBΥեɤΥӥåǥ̤
 *  ǽȥ졼ɥդˤʤ뤿ᡤåȰ¸˥եɤΥӥå
 *  ѹ뤳ȤƤ롥
 */
#ifndef TBIT_TCB_PRIORITY
#define	TBIT_TCB_PRIORITY		8		/* priorityեɤΥӥå */
#endif /* TBIT_TCB_PRIORITY */

/*
 *  ֥åTCB
 *
 *  ASPͥǤϡεư׵ᥭ塼󥰿κ͡TMAX_ACTCNT
 *  ȵ׵ᥭ塼󥰿κ͡TMAX_WUPCNTˤ1˸ꤵƤ
 *  ᡤ塼󥰤Ƥ뤫ɤοͤɽ뤳ȤǤ롥
 *  ޤԤ׵ͥȿκ͡TMAX_SUSCNTˤ1˸ꤵƤ
 *  ΤǡԤ׵ͥȿsuscntˤɬפʤ
 *
 *  TCBΤĤΥեɤϡΥ֤ǤΤͭͤݻ
 *  ʳξͤݾڤʤʤäơȤƤϤʤʤˡ
 *  եɤͭͤݻϼ̤ꡥ
 *
 *  Ͼͭ
 *  		p_tinibtstatactque
 *  ٻ߾ְʳͭʵٻ߾֤ǤϽͤˤʤäƤˡ
 *  		prioritywupqueenatextexptn
 *  Ԥ֡Ԥ֤ޤˤͭ
 *  		p_winfo
 *  ¹ԤǤ֤Ʊ֥̿ȤФԤ֤ͭ
 *  		task_queue
 *  ¹Բǽ֡Ԥ֡Ԥ֡Ԥ֤ͭ
 *  		tskctxb
 */
typedef struct task_control_block {
	QUEUE			task_queue;		/* 塼 */
	const TINIB		*p_tinib;		/* ֥åؤΥݥ */

#ifdef UINT8_MAX
	uint8_t			tstat;			/* ֡ɽ*/
#else /* UINT8_MAX */
	BIT_FIELD_UINT	tstat : 8;		/* ֡ɽ*/
#endif /* UINT8_MAX */
#if defined(UINT8_MAX) && (TBIT_TCB_PRIORITY == 8)
	uint8_t			priority;		/* ߤͥ١ɽ*/
#else /* defined(UINT8_MAX) && (TBIT_TCB_PRIORITY == 8) */
	BIT_FIELD_UINT	priority : TBIT_TCB_PRIORITY;
									/* ߤͥ١ɽ*/
#endif /* defined(UINT8_MAX) && (TBIT_TCB_PRIORITY == 8) */
	BIT_FIELD_BOOL	actque : 1;		/* ư׵ᥭ塼 */
	BIT_FIELD_BOOL	wupque : 1;		/* ׵ᥭ塼 */
	BIT_FIELD_BOOL	enatex : 1;		/* 㳰ľ */

	TEXPTN			texptn;			/* α㳰װ */
	WINFO			*p_winfo;		/* Ԥ֥åؤΥݥ */
	TSKCTXB			tskctxb;		/* ƥȥ֥å */
} TCB;

/*
 *  ¹Ծ֤Υ
 *
 *  ¹Ծ֤ΥʡץåƥȤäƤ륿ˤ
 *  TCBؤݥ󥿡¹Ծ֤ΥʤNULLˤ롥
 *
 *  ӥνǡʥӥƤӽФ
 *  ˤ˴ؤ򻲾Ȥp_runtskȤp_runtsk񤭴
 *  ΤϡǥѥåʤȽˤΤߤǤ롥
 */
extern TCB	*p_runtsk;

/*
 *  ǹ̤ͥΥ
 *
 *  ¹ԤǤ륿Ǻǹ̤ͥΥTCBؤݥ󥿡
 *  ԤǤ륿ʤNULLˤ롥
 *
 *  ǥѥåػ߾֤ʤɡǥѥåαƤ֤p_runtsk
 *  ȰפƤȤϸ¤ʤ
 */
extern TCB	*p_schedtsk;

/*
 *  ǥѥå㳰롼ư׵ե饰
 *
 *  ߥϥɥ顿CPU㳰ϥɥνиˡǥѥåޤ
 *  㳰롼εư׵᤹뤳Ȥ򼨤ե饰
 */
extern bool_t	reqflg;

/*
 *  ͥ٥ޥ
 *
 *  ͥ٥ޥ֤Ǥ뤳Ȥ򼨤ե饰
 */
extern bool_t	ipmflg;

/*
 *  ǥѥåػ߾
 *
 *  ǥѥåػ߾֤Ǥ뤳Ȥ򼨤ե饰
 */
extern bool_t	disdsp;

/*
 *  ǥѥåǽ
 *
 *  ͥ٥ޥ֤Ǥꡤǥѥåľ֤Ǥʥǥ
 *  ѥåػ߾֤ǤʤˤȤ򼨤ե饰
 */
extern bool_t	dspflg;

/*
 *  ǥ塼
 *
 *  ǥ塼ϡ¹ԤǤ֤Υ뤿Υ塼Ǥ롥
 *  ¹Ծ֤ΥƤ뤿ᡤǥʼ¹Բǽ˥塼Ȥ
 *  ̾ΤΤǤϤʤǥ塼Ȥ̾Τ夷Ƥ뤿ᡤ
 *  ̾ΤǸƤ֤Ȥˤ롥
 *
 *  ǥ塼ϡͥ٤ȤΥ塼ǹƤ롥
 *  TCBϡͥ٤Υ塼Ͽ롥
 */
extern QUEUE	ready_queue[TNUM_TPRI];

/*
 *  ǥ塼ΤΥӥåȥޥå
 *
 *  ǥ塼ΥΨ褯Ԥˡͥ٤ȤΥ塼
 *  ˥äƤ뤫ɤ򼨤ӥåȥޥåפѰդƤ롥ӥ
 *  ȥޥåפȤȤǡꥢβ򸺤餹ȤǤ뤬
 *  ӥå̿᤬¤Ƥʤץåǡͥ٤ʳʤ
 *  ˤϡӥåȥޥåΥСإåɤΤˡդ˸Ψ
 *  ǽ⤢롥
 *
 *  ͥ٤16ʳǤ뤳ȤꤷƤ뤿ᡤuint16_tȤƤ롥
 */
extern uint16_t	ready_primap;

/*
 *  ѤƤʤTCBΥꥹ
 */
extern QUEUE	free_tcb;

/*
 *  IDκ͡kernel_cfg.c
 */
extern const ID	tmax_tskid;
extern const ID	tmax_stskid;

/*
 *  ֥åΥꥢkernel_cfg.c
 */
extern const TINIB	tinib_table[];
extern TINIB		atinib_table[];

/*
 *  ơ֥kernel_cfg.c
 */
extern const ID	torder_table[];

/*
 *  TCBΥꥢkernel_cfg.c
 */
extern TCB	tcb_table[];

/*
 *  ο
 */
#define tnum_tsk	((uint_t)(tmax_tskid - TMIN_TSKID + 1))
#define tnum_stsk	((uint_t)(tmax_stskid - TMIN_TSKID + 1))

/*
 *  IDTCBФΥޥ
 */
#define INDEX_TSK(tskid)	((uint_t)((tskid) - TMIN_TSKID))
#define get_tcb(tskid)		(&(tcb_table[INDEX_TSK(tskid)]))
#define get_tcb_self(tskid)	((tskid) == TSK_SELF ? p_runtsk : get_tcb(tskid))

/*
 *  TCB饿IDФΥޥ
 */
#define	TSKID(p_tcb)	((ID)(((p_tcb) - tcb_table) + TMIN_TSKID))

/*
 *  ⥸塼ν
 */
extern void	initialize_task(void);

/*
 *  ǹ̥ͥΥ
 *
 *  ǥ塼κǹ̤ͥΥ򥵡TCBؤΥݥ
 *  ֤ǥ塼ξˤϡδؿƤӽФƤϤʤʤ
 */
extern TCB	*search_schedtsk(void);

/*
 *  ¹ԤǤ֤ؤ
 *
 *  p_tcbǻꤵ륿ǥ塼롥ǥ塼
 *  ͥ٤ǹ̤ͥΥͥ٤⤤ϡ
 *  ǹ̤ͥΥ򹹿ǥѥåľ֤Ǥtrue
 *  Ǥʤfalse֤
 */
extern bool_t	make_runnable(TCB *p_tcb);

/*
 *  ¹ԤǤ֤¾ξ֤ؤ
 *
 *  p_tcbǻꤵ륿ǥ塼롥p_tcbǻꤷ
 *  ǹ̤ͥΥǤäˤϡǹ̤ͥΥ
 *  ꤷʤǥѥåľ֤Ǥtrue֤Ǥʤ
 *  false֤ξ֤Ϲʤ
 */
extern bool_t	make_non_runnable(TCB *p_tcb);

/*
 *  ٻ߾֤ؤ
 *
 *  p_tcbǻꤵ륿ξ֤ٻ߾֤Ȥ롥ޤεư
 *  ˽٤ѿνȡưΤΥƥȤ
 *  ꤹ롥
 */
extern void	make_dormant(TCB *p_tcb);

/*
 *  ٻ߾֤¹ԤǤ֤ؤ
 *
 *  p_tcbǻꤵ륿ξ֤ٻ߾֤¹ԤǤ֤Ȥ롥
 *  ¹ԤǤ֤ܤؤΥǥѥåɬפʾtrue
 *  Ǥʤfalse֤
 */
extern bool_t	make_active(TCB *p_tcb);

/*
 *  ͥ٤ѹ
 *
 *  p_tcbǻꤵ륿ͥ٤newpriɽˤѹ롥ޤ
 *  ɬפʾˤϺǹ̤ͥΥ򹹿ǥѥåľ֤
 *  true֤Ǥʤfalse֤
 */
extern bool_t	change_priority(TCB *p_tcb, uint_t newpri);

/*
 *  ǥ塼βž
 *
 *  ǥ塼Ρpriǻꤵͥ٤Υ塼ž롥
 *  ޤɬפʾˤϺǹ̤ͥΥѹǥѥå
 *  αƤʤtrue֤Ǥʤfalse֤
 */
extern bool_t	rotate_ready_queue(uint_t pri);

/*
 *  㳰롼θƽФ
 *
 *  㳰롼ƤӽФƤӽФˡ¹Ծ֤Υ
 *  α㳰װ򥯥ꥢ㳰ػ߾֤ˤCPUå
 *  롥
 *
 *  㳰롼󤫤ȡޤCPUå֤ᤷδ
 *  α㳰װ0ǤʤʤäƤСƤӥ㳰롼
 *  ƤӽФα㳰װ0ξˤϡ㳰ľ֤ˤƴؿ
 *  ꥿󤹤롥
 *
 *  δؿϡ¹Ծ֤Υ㳰ľ֡enatex
 *  trueˤǡα㳰װ0Ǥʤtexptn0Ǥʤ˾˸ƤӽФ
 *  ȤꤷƤ롥δؿϡCPUå֤ǸƤӽФʤФʤ
 *  ʤ
 */
extern void	call_texrtn(void);

/*
 *  㳰롼εư
 *
 *  ¹Ծ֤Υ㳰롼εưƤС
 *  㳰롼ƤӽФCPU㳰롼ƤӽФ
 *  ϡŪCPUå롥
 *
 *  δؿϡǥѥåߥϥɥ顿CPU㳰ϥɥνи
 *  ƤӽФ뤳ȤꤷƤ롥δؿϡCPUå
 *  ǸƤӽФʤФʤʤ
 *
 *  ¹ԸΨ夲뤿ˡδؿ򥿡åȰ¸ǵҤƤ褤
 *  ξˤϡOMIT_CALLTEXޥ롥
 */
extern void	calltex(void);

#endif /* TOPPERS_TASK_H */
