/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2004-2010 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ(1)(4)ξ˸¤ꡤܥեȥ
 *  ܥեȥѤΤޤࡥʲƱˤѡʣ
 *  ѡۡʰʲѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *      ޤܥեȥΥ桼ޤϥɥ桼Τʤ
 *      ͳ˴Ťᤫ⡤嵭ԤTOPPERSץȤ
 *      դ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơλŪ
 *  ФŬޤơʤݾڤԤʤޤܥեȥ
 *  ѤˤľŪޤϴŪʤ»˴ؤƤ⡤
 *  Ǥʤ
 * 
 *  @(#) $Id$
 */

/*
 *		TOPPERS/ASPͥɸإåե
 *
 *  ΥإåեϡͥץΥե
 *  ɬ󥯥롼ɤ٤ɸإåեǤ롥
 *
 *  ֥Υե뤫餳Υե򥤥󥯥롼ɤ
 *  ϡTOPPERS_MACRO_ONLYƤˤꡤޥʳ
 *  褦ˤʤäƤ롥
 */

#ifndef TOPPERS_KERNEL_IMPL_H
#define TOPPERS_KERNEL_IMPL_H

/*
 *  ͥ̾Υ͡
 */
#include "kernel_rename.h"

/*
 *  ץꥱȶ̤Υإåե
 */
#include <kernel.h>

/*
 *  ƥǽΤ
 */
#include <t_syslog.h>

/*
 *  㥹ȤԤޥ
 */
#ifndef CAST
#define CAST(type, val)		((type)(val))
#endif /* CAST */

/*
 *  åȰ¸
 */
#include "target_config.h"

/*
 *  ٤Ƥδؿ򥳥ѥ뤹뤿
 */
#ifdef ALLFUNC
#include "allfunc.h"
#endif /* ALLFUNC */

/*
 *  ӥåȥեɤǤ̵
 *
 *  8ӥåȰʲΥӥåȥեɤǡ̵ͤݻ
 *  Ѥ٤ǡANSI CǤϡӥåȥեɤΥǡˤ
 *  intunsigned intʤᡤǥեȤunsigned
 *  intȤƤ뤬åȤӥġ¸ǡunsigned charޤ
 *  unsigned shortΨɤ礬롥
 */
#ifndef BIT_FIELD_UINT
#define BIT_FIELD_UINT		unsigned int
#endif /* BIT_FIELD_UINT */

/*
 *  ӥåȥեɤǤΥ֡뷿
 *
 *  1ӥåΥӥåȥեɤǡ֡ͤݻѤ٤
 *  ǡǥեȤǤBIT_FIELD_UINTƱƤ뤬֡
 *  ͤݻ뤳Ȥ뤿̤̾ΤȤƤ롥
 */
#ifndef BIT_FIELD_BOOL
#define BIT_FIELD_BOOL		BIT_FIELD_UINT
#endif /* BIT_FIELD_BOOL */

/*
 *  ֥IDκǾͤ
 */
#define TMIN_TSKID		1		/* IDκǾ */
#define TMIN_SEMID		1		/* ޥեIDκǾ */
#define TMIN_FLGID		1		/* ե饰IDκǾ */
#define TMIN_DTQID		1		/* ǡ塼IDκǾ */
#define TMIN_PDQID		1		/* ͥ٥ǡ塼IDκǾ */
#define TMIN_MBXID		1		/* ᡼ܥåIDκǾ */
#define TMIN_MPFID		1		/* ĹסIDκǾ */
#define TMIN_CYCID		1		/* ϥɥIDκǾ */
#define TMIN_ALMID		1		/* 顼ϥɥIDκǾ */
#define TMIN_ISRID		1		/* ߥӥ롼IDκǾ */

/*
 *  ͥ٤ʳ
 */
#define TNUM_TPRI		(TMAX_TPRI - TMIN_TPRI + 1)
#define TNUM_MPRI		(TMAX_MPRI - TMIN_MPRI + 1)
#define TNUM_INTPRI		(TMAX_INTPRI - TMIN_INTPRI + 1)

/*
 *  ͥǻѤ°
 */
#define TA_NOEXS		((ATR)(-1))			/* ̤Ͽ */

#ifndef TA_MEMALLOC
#define TA_MEMALLOC		UINT_C(0x8000)		/* ΰ򥫡ͥǳ */
#endif /* TA_MEMALLOC */
#ifndef TA_MBALLOC
#define TA_MBALLOC		UINT_C(0x4000)		/* ΰ򥫡ͥǳ */
#endif /* TA_MBALLOC */

/*
 *  åΥ顼åޥΥǥեͤ
 */
#ifndef TARGET_TSKATR
#define TARGET_TSKATR		0U		/* åΥ° */
#endif /* TARGET_TSKATR */

#ifndef TARGET_ISRATR
#define TARGET_ISRATR		0U		/* åISR° */
#endif /* TARGET_ISRATR */

/*
 *  إåեʤ⥸塼δؿѿ
 */
#ifndef TOPPERS_MACRO_ONLY

/*
 *  ƥ⥸塼νkernel_cfg.c
 */
extern void	initialize_object(void);

/*
 *  롼μ¹ԡkernel_cfg.c
 */
extern void	call_inirtn(void);

/*
 *  λ롼μ¹ԡkernel_cfg.c
 */
extern void	call_terrtn(void);

/*
 *  󥿥ƥѤΥåΰkernel_cfg.c
 */
extern const SIZE	istksz;		/* åΰΥʴݤ᤿͡ */
extern STK_T *const	istk;		/* åΰƬ */
#ifdef TOPPERS_ISTKPT
extern STK_T *const	istkpt;		/* åݥ󥿤ν */
#endif /* TOPPERS_ISTKPT */

/*
 *  ͥ뤬դΰkernel_cfg.c
 */
extern const SIZE	kmmsz;		/* ͥ뤬դΰΥ */
extern MB_T *const	kmm;		/* ͥ뤬դΰƬ */

/*
 *  ͥư֥ե饰startup.c
 */
extern bool_t	kerflg;

/*
 *  ͥεưstartup.c
 */
extern void	sta_ker(void);

/*
 *  ͥνλstartup.c
 */
extern void	exit_kernel(void);

/*
 *  ͥγդΰδstartup.c
 */
extern void initialize_kmm(void);
extern void *kernel_malloc(SIZE size);
extern void kernel_free(void *ptr);

#endif /* TOPPERS_MACRO_ONLY */
#endif /* TOPPERS_KERNEL_IMPL_H */
