/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2000 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005-2010 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ(1)(4)ξ˸¤ꡤܥեȥ
 *  ܥեȥѤΤޤࡥʲƱˤѡʣ
 *  ѡۡʰʲѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *      ޤܥեȥΥ桼ޤϥɥ桼Τʤ
 *      ͳ˴Ťᤫ⡤嵭ԤTOPPERSץȤ
 *      դ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơλŪ
 *  ФŬޤơʤݾڤԤʤޤܥեȥ
 *  ѤˤľŪޤϴŪʤ»˴ؤƤ⡤
 *  Ǥʤ
 * 
 *  @(#) $Id$
 */

/*
 *		ߴǽ
 */

#ifndef TOPPERS_INTERRUPT_H
#define TOPPERS_INTERRUPT_H

/*
 *  ߥӥ롼֥å
 */
typedef struct isr_initialization_block {
	ATR			isratr;			/* ߥӥ롼° */
	intptr_t	exinf;			/* ߥӥ롼γĥ */
	INTNO		intno;			/* ߥӥ롼Ͽֹ */
	QUEUE		*p_isr_queue;	/* Ͽߥӥ롼󥭥塼 */
	ISR			isr;			/* ߥӥ롼Ƭ */
	PRI			isrpri;			/* ߥӥ롼ͥ */
} ISRINIB;

/*
 *  ߥӥ롼֥å
 */
typedef struct isr_control_block {
	QUEUE		isr_queue;		/* ߥӥ롼ƽФ塼 */
	const ISRINIB *p_isrinib;	/* ֥åؤΥݥ */
} ISRCB;

/*
 *  ߥӥ롼ƽФ塼򸡺뤿Υǡ¤
 */
typedef struct {
	INTNO		intno;			/* ֹ */
	QUEUE		*p_isr_queue;	/* ߥӥ롼ƽФ塼 */
} ISR_ENTRY;

/*
 *  ߥӥ롼󥭥塼Υȥkernel_cfg.c
 */
extern const uint_t tnum_isr_queue;

/*
 *  ߥӥ롼󥭥塼ꥹȡkernel_cfg.c
 */
extern const ISR_ENTRY isr_queue_list[];

/*
 *  ߥӥ롼󥭥塼Υꥢkernel_cfg.c
 */
extern QUEUE isr_queue_table[];

/*
 *  ѤƤʤߥӥ롼֥åΥꥹ
 */
extern QUEUE	free_isrcb;

/*
 *  ߥӥ롼IDκ͡kernel_cfg.c
 *
 *  Ūߥӥ롼IDֹʤᡤ
 *  tmax_isridưŪߥӥ롼IDֹκ
 *  Ǥ롥Ūߥӥ롼οϡtnum_sisr
 *  롥
 */
extern const ID		tmax_isrid;
extern const uint_t	tnum_sisr;

/*
 *  ߥӥ롼֥åΥꥢkernel_cfg.c
 */
extern const ISRINIB	sisrinib_table[];
extern ISRINIB			aisrinib_table[];

/*
 *  ߥӥ롼֥åΥꥢkernel_cfg.c
 */
extern ISRCB	isrcb_table[];

/*
 *  ߥӥ롼֥åߥӥ롼ID
 *  ФΥޥ
 */
#define	ISRID(p_isrcb)	((ID)(((p_isrcb) - isrcb_table) \
										- tnum_sisr + TMIN_ISRID))

/*
 *  ߥӥ롼ǽν
 */
extern void initialize_isr(void);

/*
 *  ߥӥ롼θƽФ
 */
extern void call_isr(QUEUE *p_isr_queue);

#ifndef OMIT_INITIALIZE_INTERRUPT

/*
 *  ߥϥɥ֥å
 */
typedef struct interrupt_handler_initialization_block {
	INHNO		inhno;			/* ߥϥɥֹ */
	ATR			inhatr;			/* ߥϥɥ° */
	FP			int_entry;		/* ߥϥɥν */
} INHINIB;

/*
 *  ׵饤֥å
 */
typedef struct interrupt_request_initialization_block {
	INTNO		intno;			/* ֹ */
	ATR			intatr;			/* ° */
	PRI			intpri;			/* ͥ */
} INTINIB;

/*
 *  ߥϥɥֹοkernel_cfg.c
 */
extern const uint_t	tnum_inhno;

/*
 *  ߥϥɥ֥åΥꥢkernel_cfg.c
 */
extern const INHINIB	inhinib_table[];

/*
 *  ׵饤οkernel_cfg.c
 */
extern const uint_t	tnum_intno;

/*
 *  ׵饤֥åΥꥢkernel_cfg.c
 */
extern const INTINIB	intinib_table[];

#endif /* OMIT_INITIALIZE_INTERRUPT */

/*
 *  ߴǽν
 */
extern void	initialize_interrupt(void);

#endif /* TOPPERS_INTERRUPT_H */
