/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005-2012 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ(1)(4)ξ˸¤ꡤܥեȥ
 *  ܥեȥѤΤޤࡥʲƱˤѡʣ
 *  ѡۡʰʲѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *      ޤܥեȥΥ桼ޤϥɥ桼Τʤ
 *      ͳ˴Ťᤫ⡤嵭ԤTOPPERSץȤ
 *      դ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơλŪ
 *  ФŬޤơʤݾڤԤʤޤܥեȥ
 *  ѤˤľŪޤϴŪʤ»˴ؤƤ⡤
 *  Ǥʤ
 * 
 *  @(#) $Id$
 */

/*
 *		٥ȥե饰ǽ
 */

#ifndef TOPPERS_EVENTFLAG_H
#define TOPPERS_EVENTFLAG_H

#include "wait.h"

/*
 *  ٥ȥե饰֥å
 *
 *  ι¤ΤϡƱ֥̿Ȥν֥åζʬ
 *  WOBJINIBˤĥʥ֥ȻظηѾˤΤǡ
 *  ǽΥեɤ̤ˤʤäƤ롥
 */
typedef struct eventflag_initialization_block {
	ATR			flgatr;			/* ٥ȥե饰° */
	FLGPTN		iflgptn;		/* ٥ȥե饰Υӥåȥѥν */
} FLGINIB;

/*
 *  ٥ȥե饰֥å
 *
 *  ι¤ΤϡƱ֥̿Ȥδ֥åζʬWOBJCB
 *  ĥʥ֥ȻظηѾˤΤǡǽ2Ĥ
 *  եɤ̤ˤʤäƤ롥
 */
typedef struct eventflag_control_block {
	QUEUE		wait_queue;		/* ٥ȥե饰Ԥ塼 */
	const FLGINIB *p_flginib;	/* ֥åؤΥݥ */
	FLGPTN		flgptn;			/* ٥ȥե饰ߥѥ */
} FLGCB;

/*
 *  ٥ȥե饰Ԥ֥å
 *
 *  ι¤ΤϡƱ֥̿ȤԤ֥åζʬ
 *  WINFO_WOBJˤĥʥ֥ȻظηѾˤΤǡ
 *  ǽ2ĤΥեɤ̤ˤʤäƤ롥
 *
 *  flgptnϡwaiptnwfmodeƱ˻ȤȤϤʤᡤΤ
 *  Х󤹤뤳ȤǽǤ롥
 */
typedef struct eventflag_waiting_information {
	WINFO		winfo;			/* ɸԤ֥å */
	FLGCB		*p_flgcb;		/* ԤäƤ륤٥ȥե饰δ֥å */
	FLGPTN		waiptn;			/* Ԥѥ */
	MODE		wfmode;			/* Ԥ⡼ */
	FLGPTN		flgptn;			/* ԤΥѥ */
} WINFO_FLG;

/*
 *  ѤƤʤ٥ȥե饰֥åΥꥹ
 */
extern QUEUE	free_flgcb;

/*
 *  ٥ȥե饰IDκ͡kernel_cfg.c
 */
extern const ID	tmax_flgid;
extern const ID	tmax_sflgid;

/*
 *  ٥ȥե饰֥åΥꥢkernel_cfg.c
 */
extern const FLGINIB	flginib_table[];
extern FLGINIB			aflginib_table[];

/*
 *  ٥ȥե饰֥åΥꥢkernel_cfg.c
 */
extern FLGCB	flgcb_table[];

/*
 *  ٥ȥե饰֥å饤٥ȥե饰IDФΥޥ
 */
#define	FLGID(p_flgcb)	((ID)(((p_flgcb) - flgcb_table) + TMIN_FLGID))

/*
 *  ٥ȥե饰ǽν
 */
extern void	initialize_eventflag(void);

/*
 *  ٥ȥե饰ԤΥå
 */
extern bool_t	check_flg_cond(FLGCB *p_flgcb, FLGPTN waiptn,
								MODE wfmode, FLGPTN *p_flgptn);

#endif /* TOPPERS_EVENTFLAG_H */
