/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005-2010 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ(1)(4)ξ˸¤ꡤܥեȥ
 *  ܥեȥѤΤޤࡥʲƱˤѡʣ
 *  ѡۡʰʲѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *      ޤܥեȥΥ桼ޤϥɥ桼Τʤ
 *      ͳ˴Ťᤫ⡤嵭ԤTOPPERSץȤ
 *      դ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơλŪ
 *  ФŬޤơʤݾڤԤʤޤܥեȥ
 *  ѤˤľŪޤϴŪʤ»˴ؤƤ⡤
 *  Ǥʤ
 * 
 *  @(#) $Id$
 */

/*
 *		ϥɥ鵡ǽ
 */

#ifndef TOPPERS_CYCLIC_H
#define TOPPERS_CYCLIC_H

#include <queue.h>
#include "time_event.h"

/*
 *  ϥɥ֥å
 */
typedef struct cyclic_handler_initialization_block {
	ATR			cycatr;			/* ϥɥ° */
	intptr_t	exinf;			/* ϥɥγĥ */
	CYCHDR		cychdr;			/* ϥɥεư */
	RELTIM		cyctim;			/* ϥɥεư */
	RELTIM		cycphs;			/* ϥɥεư */
} CYCINIB;

/*
 *  ϥɥ֥å
 */
typedef struct cyclic_handler_control_block {
	const CYCINIB *p_cycinib;	/* ֥åؤΥݥ */
	bool_t		cycsta;			/* ϥɥư */
	EVTTIM		evttim;			/* ˼ϥɥư */
	TMEVTB		tmevtb;			/* ।٥ȥ֥å */
} CYCCB;

/*
 *  ѤƤʤϥɥ֥åΥꥹ
 */
extern QUEUE	free_cyccb;

/*
 *  ϥɥIDκ͡kernel_cfg.c
 */
extern const ID	tmax_cycid;
extern const ID	tmax_scycid;

/*
 *  ϥɥ֥åΥꥢkernel_cfg.c
 */
extern const CYCINIB	cycinib_table[];
extern CYCINIB			acycinib_table[];

/*
 *  ϥɥ֥åΥꥢkernel_cfg.c
 */
extern CYCCB	cyccb_table[];

/*
 *  ϥɥ֥åϥɥIDФΥޥ
 */
#define	CYCID(p_cyccb)	((ID)(((p_cyccb) - cyccb_table) + TMIN_CYCID))

/*
 *  ϥɥ鵡ǽν
 */
extern void	initialize_cyclic(void);

/*
 *  ϥɥ鵯ư롼
 */
extern void	call_cychdr(CYCCB *p_cyccb);

#endif /* TOPPERS_CYCLIC_H */
