/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005-2010 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ(1)(4)ξ˸¤ꡤܥեȥ
 *  ܥեȥѤΤޤࡥʲƱˤѡʣ
 *  ѡۡʰʲѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *      ޤܥեȥΥ桼ޤϥɥ桼Τʤ
 *      ͳ˴Ťᤫ⡤嵭ԤTOPPERSץȤ
 *      դ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơλŪ
 *  ФŬޤơʤݾڤԤʤޤܥեȥ
 *  ѤˤľŪޤϴŪʤ»˴ؤƤ⡤
 *  Ǥʤ
 * 
 *  $Id$
 */

/*
 *		ץå¸⥸塼 ֥M68040ѡ
 */

#define	TOPPERS_MACRO_ONLY
#define UINT_C(val)			(val)		/* uint_tޥ */
#define ULONG_C(val)		(val)		/* ulong_tޥ */
#define CAST(type, val)		(val)		/* 㥹ȤԤޥ */
#include "kernel_impl.h"
#include "offset.h"

/*
 *  ǥѥå
 */
	.text
	.globl dispatch
dispatch:
	/*
	 *  Υ롼ϡƥȡCPUå֡ǥѥå
	 *  ľ֡ʥǥΡ˳ͥ٥ޥ֤ǸƤӽФ
	 *  롥
	 */
	movem.l %d2-%d7/%a2-%a6, -(%sp)		/* 쥸¸ */
	move.l p_runtsk, %a0				/* p_runtskA0 */
	move.l %sp, TCB_msp(%a0)			/* å¸ */
	move.l #dispatch_r, TCB_pc(%a0)		/* ¹ԺƳϤ¸ */
	jbra dispatcher

dispatch_r:
	movem.l (%sp)+, %d2-%d7/%a2-%a6		/* 쥸 */
	btst.b #TCB_enatex_bit, TCB_enatex(%a0)
	jbeq dispatch_r_1					/* enatexfalseʤ꥿ */
	tst.l TCB_texptn(%a0)				/* texptn0ʤ꥿ */
	jbeq dispatch_r_1
	tst.l ipmflg						/* ipmflgtrueǤ            */
	jbne call_texrtn					/*  㳰롼θƽФ */
dispatch_r_1:
	rts

/*
 *  ǥѥåưϡprc_support.S
 */
	.globl start_dispatch
start_dispatch:
	/*
	 *  Υ롼ϡͥ뵯ưˡ٤Ƥγߤػߤ
	 * ʳߥå֤ƱˤǸƤӽФ롥ޤߥ⡼ɡ
	 *  ƥȤƱˤǸƤӽФ뤳ȤꤷƤ롥
	 *
	 *  prc_initializeǡlock_flagtrueˡsaved_iipmIIPM_ENAALL
	 *  Ƥ뤿ᡤͥγߤĤ뤳Ȥǡ
	 *  CPUå֡ʥǥΡ˳ͥ٥ޥ֤ˤʤ롥
	 *  ޤinitialize_taskdisdspfalse˽Ƥ뤿ᡤǥ
	 *  ѥåľ֤ˤʤäƤ롥
	 */
#if TIPM_LOCK == -7
	or.w #0x1000, %sr					/* ޥ⡼ɤ */
#else /* TIPM_LOCK == -7 */
	move.w %sr, %d0						/* ޥ⡼ɡ                */
	and.w #~0x0700, %d0					/*  ͥγߤ */
	or.w #(0x1000 | IIPM_LOCK), %d0
	move.w %d0, %sr
#endif /* TIPM_LOCK == -7 */
	jbra dispatcher_0

/*
 *  ߤΥƥȤΤƤƥǥѥå
 */
	.globl exit_and_dispatch
exit_and_dispatch:
	/* ǥѥåΡdispatcherˤ */

/*
 *  ǥѥå
 */
dispatcher:
	/*
	 *  Υ롼ϡƥȡCPUå֡ǥѥå
	 *  ľ֡ʥǥΡ˳ͥ٥ޥ֤ǸƤӽФ
	 *  롥
	 *
	 *  ʤޥ⡼ɡlock_flagtruedisdspfalsedspflg
	 *  truesaved_iipmIIPM_ENAALLȤʤäƤ롥¹ԺƳϤؤ⤳
	 *  ξ֤Τޤʬ롥
	 */
#ifdef LOG_DSP_ENTER
	move.l p_runtsk, %d0				/* p_runtskѥ᡼ */
	move.l %d0, -(%sp)
	jsr log_dsp_enter
	addq.l #4, %sp
#endif /* LOG_DSP_ENTER */
dispatcher_0:
	move.l p_schedtsk, %a0				/* p_schedtskp_runtsk */
	move.l %a0, p_runtsk
	jbeq dispatcher_1					/* p_runtskNULLʤdispatcher_1 */
	move.l TCB_msp(%a0), %sp			/* å */
#ifdef LOG_DSP_LEAVE
	move.l %a0, -(%sp)					/* p_runtskѥ᡼ */
	jsr log_dsp_leave
	addq.l #4, %sp
	move.l p_runtsk, %a0
#endif /* LOG_DSP_LEAVE */
	move.l TCB_pc(%a0), %a1				/* ¹ԺƳϤʬ */
	jmp (%a1)
dispatcher_1:
	/*
	 *  CPUå֤򤹤롥
	 */
	move.w %sr, %d0						/* SRD0¸ */
	clr.l lock_flag						/* CPUå֤ */
dispatcher_2:
	/*
	 *  ߤĤߥ⡼ɤڤ괹ơߤԤġ
	 *
	 *  ǳߥ⡼ɤڤ괹Τϡȯ߽
	 *  ɤΥåȤȤβȡߥϥɥǤΥ
	 *  ǥѥåɻߤȤ2Ĥΰ̣롥
	 *
	 *  ץåԤ˰ܹԤȡߵĤȤϡԲ
	 *  ʬ˹ԤʤɬפM68040Ǥstop̿ξԤʤΤ
	 *  ˡԲʬ˹Ԥʤʤ硤ߤĤľ˳
	 *  ߤꡤǥ¹Բǽ֤ˤʤȡ¹Ԥ٤
	 *  ˤ⤫餺ץåԤˤʤäƤޤ
	 *
	 *  Ԥδ֤ϡp_runtskNULLʡ0ˤꤷʤФʤ
	 *  Τ褦ꤷʤȡߥϥɥ餫iget_tidƤӽ
	 *  ݤưͤ˹פʤʤ롥
	 */
	stop #0x2000						/* Ԥ */
	move.w %d0, %sr						/* ξ֤᤹ */
	tst.l reqflg						/* reqflgfalseʤdispatcher_2 */
	jbeq dispatcher_2
	clr.l reqflg						/* reqflgfalse */
	/*
	 *  CPUå֤᤹Ԥδ֤˼¹Ԥߥϥɥˤ
	 *  ꡤsaved_iipm񤭴ǽ뤿ᡤ᤹ͤɬ
	 *  פ롥dispatcher¹Ԥϡsaved_iipmIIPM_ENAALL
	 *  ȤʤäƤ뤿ᡤǤsaved_iipmIIPM_ENAALLʡ0ˤ᤻
	 *  Ф褤
	 */
	clr.w saved_iipm					/* saved_iipm0ˤ */
	move.l #true, lock_flag				/* CPUå֤ */
	jbra dispatcher_0

/*
 *  ͥνλθƽФ
 *
 *  M68040Ǥϡ⡼ڴˤꥹåڤ괹뤿ᡤŪʥ
 *  åڴɬפʤǽ餫ߥ⡼ɤǤä⡤Ʊ
 *  Ǥ褤
 */
	.globl call_exit_kernel
call_exit_kernel:
	and.w #~0x1000, %sr					/* ߥ⡼ɤ */
	jmp exit_kernel						/* ͥνλƤ */
	
/*
 *  ϻ
 */
	.text
	.globl start_r
start_r:
	clr.l lock_flag						/* CPUå֤ */
	and.w #~0x0700, %sr
	move.l TCB_p_tinib(%a0), %a1		/* p_runtsk->p_tinibA1 */
	move.l TINIB_exinf(%a1), -(%sp)		/* exinf򥹥åѤ */
	move.l #ext_tsk, -(%sp)				/* ext_tsk򥹥åѤ */
	move.l TINIB_task(%a1), %a0			/* εưϤA0 */
	jmp (%a0)

/*
 *  ߥϥɥи
 *
 *  ret_intϡߥϥɥ餫äľ˼¹Ԥ롼ǡ
 *  INTHDR_ENTRYޥŸߥϥɥǡߥϥ
 *  ɥ餫Ϥꤵ롥
 */
	.text
	.globl ret_int
ret_int:
	btst.b #4, 16(%sp)					/* 褬ߥ⡼ɤʤ */
	jbeq ret_int_1						/*           ˥꥿ */
	/*
	 *  ͥγߤػߤ롥λǤϡCPUå֤
	 *  Ϥʤʤlock_flagsaved_iipmϹʤˡ
	 *
	 *  reqflgå˳ߤػߤΤϡreqflgå
	 *  ľ˳ߥϥɥ餬ư졤ǥǥѥå׵
	 *  줿ˡ˥ǥѥåʤȤ꤬뤿
	 *  Ǥ롥
	 */
#if TIPM_LOCK == -7
	or.w #0x0700, %sr					/* ٤Ƥγߤػ */
#else /* TIPM_LOCK == -7 */
	/*
	 *  Υ롼ϥͥγߤ鵯ư뤿ᡤǤϡ
	 *  ͥ٥ޥTIPM_LOCK㤤Ǥ롥
	 */
	move.w %sr, %d0						/* ͥγߤػ */
	and.w #~0x0700, %d0
	or.w #IIPM_LOCK, %d0
	move.w %d0, %sr
#endif /* TIPM_LOCK == -7 */
	tst.l reqflg						/* reqflgtrueǤret_int_2 */
	jbne ret_int_2
ret_int_1:
	/*
	 *  ߽Υ꥿ˤꡤCPUå֤˰ܹԤ褦
	 *  롥ͥ٥ޥϡRTE̿ˤ긵ͤ뤿ᡤ
	 *  lock_flagfalseˤƤФ褤lock_flagfalseˤΤϡ
	 *  CPUå֤Τޤ޳ߥϥɥ餫äкˡ
	 */
	clr.l lock_flag						/* CPUåν */
	movem.l (%sp)+, %d0-%d1/%a0-%a1		/* å쥸 */
	rte

ret_int_2:
	movem.l (%sp)+, %d0-%d1/%a0-%a1		/* å쥸 */
	addq.l #8, %sp						/* ե졼ΤƤ */
	or.w #0x1000, %sr					/* ޥ⡼ɤˡʥåڴ*/
	movem.l %d0-%d1/%a0-%a1, -(%sp)		/* å쥸¸ */
ret_int_3:
	/*
	 *  ؤϡCPU㳰ϥɥνиʬƤ롥
	 *
	 *  Ǥϡ褬Ǥꡤåϡ㳰åե졼
	 *  ξ˥å쥸Τߤ¸줿֤ˤʤäƤ롥
	 *  ץåϡޥ⡼ɡͥγߤػߤ
	 *  ֤ȤʤäƤ롥
	 */
	clr.l reqflg						/* reqflgfalse */
	/*
	 *  CPUå֤˰ܹԤͥ٥ޥ߽ͤ
	 *	ꤹ롥ͥγߤϤǤ˶ػߤƤΤǡlock_flag
	 *  saved_iipm򹹿롥saved_iipmϡγͥ٥ޥ
	 *  ʤɽˤꤹ롥
	 *
	 *  λCPUå֤ȤΤϡdispatcherʬȡ
	 *  call_texrtnƤӽФˡCPUå֤ˤʤäƤɬפ
	 *  Ǥ롥
	 */
	move.w 16(%sp), %d0					/* SRD0 */
	and.w #0x0700, %d0					/* IPMФsaved_iipm */
	move.w %d0, saved_iipm
	move.l #true, lock_flag				/* lock_flagtrue */
	/*
	 *  dspflgfalseǤȡp_runtskp_schedtskƱˤϡ
	 *  ǥѥåԤʤΥåɬפʤΤϡ㳰
	 *  롼θƽФɬפʾˡǥѥåɬפʤƤ⡤
	 *  reqflgtrueˤ뤿Ǥ롥
	 */
	move.l p_runtsk, %a0				/* p_runtskA0 */
	tst.l dspflg						/* dspflgfalseʤret_int_4 */
	jbeq ret_int_4
	cmp.l p_schedtsk, %a0				/* p_runtskp_schedtskƱʤ */
	jbeq ret_int_4						/*                    ret_int_4 */
	movem.l %d2-%d7/%a2-%a6, -(%sp)		/* ĤΥ쥸¸ */
	move.l %sp, TCB_msp(%a0)			/* å¸ */
	move.l #ret_int_r, TCB_pc(%a0)		/* ¹ԺƳϤ¸ */
	jbra dispatcher

ret_int_r:
	movem.l (%sp)+, %d2-%d7/%a2-%a6		/* 쥸 */
ret_int_4:
	/*
	 *  enatextrueǡtexptn0ǤʤipmflgtrueǤС
	 *  㳰롼ƤӽФ
	 */
	btst.b #TCB_enatex_bit, TCB_enatex(%a0)
	jbeq ret_int_5						/* enatexfalseʤret_int_5 */
	tst.l TCB_texptn(%a0)				/* texptn0ʤret_int_5 */
	jbeq ret_int_5
	tst.l ipmflg						/* ipmflgfalseʤret_int_5 */
	jbeq ret_int_5
	jsr call_texrtn						/* 㳰롼θƽФ */
ret_int_5:
	/*
	 *  ߽Υ꥿ˤꡤCPUå֤˰ܹԤ
	 *  롥ͥ٥ޥϡRTE̿ˤ긵ͤ뤿
	 *  ᡤlock_flagfalseˤƤФ褤
	 */
	clr.l lock_flag						/* CPUåν */
	movem.l (%sp)+, %d0-%d1/%a0-%a1		/* å쥸 */
	rte

/*
 *  CPU㳰ϥɥ
 *
 *  exchdr_entryϡCPU㳰ȯ˼¹Ԥ롼ǡEXCHDR_ENTRY
 *  ޥŸCPU㳰ϥɥ顤CPU㳰ϥɥϤ
 *  A1ˡCPU㳰ϥɥֹD1ʬƤ롥
 *
 *  CPU㳰ϥɥϡ󥿥ƥȤǼ¹Ԥ롥ΤᡤCPU
 *  ϥɥƤӽФ˳ߥ⡼ɤ˰ܹԤ꥿󤷤Ƥ
 *  Υ⡼ɤ᤹Υ⡼ɤ᤹ˡߥ⡼ɤ˰ܹԤ
 *  SRߥå¸ʥ꥿SR򻲾Ȥ⤢
 *  å¸礬ꡤȤΤݡˡ
 */
	.text
	.globl exchdr_entry
exchdr_entry:
	lea.l 16(%sp), %a0					/* 㳰ե졼ƬA0 */
	move.w %sr, %d0						/* SRD0 */
	and.w #~0x1000, %sr					/* ߥ⡼ɤˡʥåڴ*/
	move.l %d0, -(%sp)					/* SR򥹥å¸ */
	and.w #0x0700, %d0					/* IPMINT_IPM(TMIN_INTPRI) */
	cmp.w #INT_IPM(TMIN_INTPRI), %d0	/*    꾮Сͥ */
	blt exchdr_entry_1					/*    CPU㳰ν */

	/*
	 *  ͥCPU㳰ϥɥθƽФ
	 */
	move.l lock_flag, %d0				/* lock_flag򥹥å¸ */
	move.l %d0, -(%sp)
	move.l %a0, -(%sp)					/* A0ѥ᡼ */
	jsr (%a1)							/* CPU㳰ϥɥƤӽФ */
	addq.l #4, %sp						/* åΰΤƤ */
	move.l (%sp)+, %d0					/* lock_flag򸵤᤹ */
	move.l %d0, lock_flag
	move.l (%sp)+, %d0					/* SR򸵤᤹ */
	move.w %d0, %sr
	movem.l (%sp)+, %d0-%d1/%a0-%a1		/* å쥸 */
	rte

	/*
	 *  ͥCPU㳰ϥɥθƽФ
	 */
exchdr_entry_1:
#ifdef LOG_EXC_LEAVE					/* excno_numlog_exc_leave */
	move.l %d1, -(%sp)					/*               ѥ᡼ */
#endif /* LOG_EXC_LEAVE */
	move.l %a0, -(%sp)					/* A0CPU㳰ϥɥΥѥ᡼ */
#ifdef LOG_EXC_ENTER
	move.l %a1, -(%sp)					/* A1¸ */
	move.l %d1, -(%sp)					/* excno_numѥ᡼ */
	jsr _kernel_log_exc_enter			/* log_exc_enterƤӽФ */
	addq.l #4, %sp
	move.l (%sp)+, %a1					/* A1 */
#endif /* LOG_EXC_ENTER */
	jsr (%a1)							/* CPU㳰ϥɥƤӽФ */
	addq.l #4, %sp						/* åΰΤƤ */
#ifdef LOG_EXC_LEAVE
	jsr _kernel_log_exc_leave			/* log_exc_leaveƤӽФ */
	addq.l #4, %sp
#endif /* LOG_EXC_LEAVE */
ret_exc:
	move.l (%sp)+, %d0					/* SRD0 */
	and.w #0x1000, %d0					/* ߥ⡼ɤʤ */
	jbeq ret_exc_1						/*       ˥꥿ */
	/*
	 *  ͥγߤػߤޥ⡼ɤ᤹λǤϡ
	 *  CPUå֤ˤϤʤʤlock_flagsaved_iipmϹʤˡ
	 *
	 *  reqflgå˳ߤػߤΤϡreqflgå
	 *  ľ˳ߥϥɥ餬ư졤ǥǥѥå׵
	 *  줿ˡ˥ǥѥåʤȤ꤬뤿
	 *  Ǥ롥
	 */
#if TIPM_LOCK == -7
	or.w #0x1700, %sr					/* ޥ⡼ɡ߶ػ */
#else /* TIPM_LOCK == -7 */
	/*
	 *  Υ롼ϥͥCPU㳰鵯ư뤿ᡤǤϡ
	 *  ͥ٥ޥTIPM_LOCK㤤Ǥ롥
	 */
	move.w %sr, %d0						/* ޥ⡼ɡ                */
	and.w #~0x0700, %d0					/*    ͥγߤػ */
	or.w #(0x1000|IIPM_LOCK), %d0
	move.w %d0, %sr
#endif /* TIPM_LOCK == -7 */
	/*
	 *  CPU㳰Ǥϳߥ⡼ɤڤ괹ʤᡤreqflgtrueξ硤
	 *  ret_int_2ǤϤʤret_int_3ʬ롥
	 */
	tst.l reqflg						/* reqflgtrueǤret_int_3 */
	jbne ret_int_3
ret_exc_1:
	movem.l (%sp)+, %d0-%d1/%a0-%a1		/* å쥸 */
	rte

/*
 *  ԤSILΥåȰ¸
 */
	.globl _sil_dly_nse
_sil_dly_nse:
	subi.l #SIL_DLY_TIM1, %d0			/* D0SIL_DLY_TIM1 */
	jbhi _sil_dly_nse_1					/* ̤0ʲʤ꥿ */
	rts
_sil_dly_nse_1:
	subi.l #SIL_DLY_TIM2, %d0			/* D0SIL_DLY_TIM2 */
	jbhi _sil_dly_nse_1					/* ̤0礭Х롼 */
	rts
