/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005-2007 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ(1)(4)ξ˸¤ꡤܥեȥ
 *  ܥեȥѤΤޤࡥʲƱˤѡʣ
 *  ѡۡʰʲѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *      ޤܥեȥΥ桼ޤϥɥ桼Τʤ
 *      ͳ˴Ťᤫ⡤嵭ԤTOPPERSץȤ
 *      դ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơλŪ
 *  ФŬޤơʤݾڤԤʤޤܥեȥ
 *  ѤˤľŪޤϴŪʤ»˴ؤƤ⡤
 *  Ǥʤ
 * 
 *  @(#) $Id$
 */

/*
 *		ץåü̿Υ饤ؿM68040ѡ
 */

#ifndef	TOPPERS_PRC_INSN_H
#define	TOPPERS_PRC_INSN_H

/*
 *  ơ쥸SRˤθͤɽФ
 */
Inline uint16_t
current_sr(void)
{
	uint16_t	sr;

	Asm("move.w %%sr, %0" : "=g"(sr));
	return(sr);
}

/*
 *  ơ쥸SRˤθͤ
 */
Inline void
set_sr(uint16_t sr)
{
	Asm("move.w %0, %%sr" : : "g"(sr) : "cc");
}

/*
 *  NMI٤Ƥγߤζػ
 *
 *  set_srѤƼ¸뤳ȤǤ뤬̤̿ѤƼ¸
 *  ΨɤѰդƤ롥
 */
Inline void
disint(void)
{
	Asm("or.w #0x0700, %sr");
}

/*
 *  ٤Ƥγߤε
 *
 *  set_srѤƼ¸뤳ȤǤ뤬̤̿ѤƼ¸
 *  ΨɤѰդƤ롥
 */
Inline void
enaint(void)
{
	Asm("and.w #~0x0700, %sr");
}

/*
 *  ٥١쥸VBRˤθͤɽФ
 */
Inline void
*current_vbr(void)
{
	void	*vbr;

	Asm("movec.l %%vbr, %0" : "=r"(vbr));
	return(vbr);
}

/*
 *  ٥١쥸VBRˤθͤ
 */
Inline void
set_vbr(void *vbr)
{
	Asm("movec.l %0, %%vbr" : : "r"(vbr));
}

/*
 *  ǥ塼ΤΥӥåȥޥåץؿ
 *
 *  bfffo̿ϺǾ̥ӥåȤ饵뤿ᡤǾ̥ӥåȤǹͥ
 *  б롥
 */
#define	OMIT_BITMAP_SEARCH
#define	PRIMAP_BIT(pri)		(0x8000U >> (pri))

Inline uint_t
bitmap_search(uint16_t bitmap)
{
	uint32_t	offset;

	Asm("bfffo %1{16,16}, %0" : "=d"(offset) : "d"((uint32_t) bitmap));
	return((uint_t)(offset - 16));
}

#endif /* TOPPERS_PRC_INSN_H */
