/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005-2010 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ(1)(4)ξ˸¤ꡤܥեȥ
 *  ܥեȥѤΤޤࡥʲƱˤѡʣ
 *  ѡۡʰʲѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *      ޤܥեȥΥ桼ޤϥɥ桼Τʤ
 *      ͳ˴Ťᤫ⡤嵭ԤTOPPERSץȤ
 *      դ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơλŪ
 *  ФŬޤơʤݾڤԤʤޤܥեȥ
 *  ѤˤľŪޤϴŪʤ»˴ؤƤ⡤
 *  Ǥʤ
 * 
 *  $Id$
 */

/*
 *		ץå¸⥸塼M68040ѡ
 *
 *  Υ󥯥롼ɥեϡtarget_config.hʤޤϡ饤
 *  롼ɤեˤΤߤ饤󥯥롼ɤ롥¾Υե뤫
 *  ľܥ󥯥롼ɤƤϤʤʤ
 */

#ifndef TOPPERS_PRC_CONFIG_H
#define TOPPERS_PRC_CONFIG_H

#ifndef TOPPERS_MACRO_ONLY

/*
 *  ץåü̿Υ饤ؿ
 */
#include "prc_insn.h"

/*
 *  ƥȥ֥å
 */
typedef struct task_context_block {
	void	*msp;		/* åݥ */
	FP		pc;			/* ץ५ */
} TSKCTXB;

#endif /* TOPPERS_MACRO_ONLY */

/*
 *  ͥ٥ޥ饤֥
 *
 *  M68040Ǥϡơ쥸SRˤβ810ӥåȤ3ӥå
 *  ˳ͥ٥ޥʥϡɥγͥ٥ޥIPMˤ֤
 *  Ƥ롥IPM¸Ƥˡͥ٤γɽ-1Ϣ
 *  ³͡ˤȤȤǽǤ뤬;פʺӥåȥեȤ
 *  ȿžɬפˤʤ롥򤱤뤿ˡIPM¸ˤϡSR
 *  810ӥåȤФͤȤȤˤ롥ͤͥ٥
 *  ɽȸƤӡIIPMȽ񤯤Ȥˤ롥
 */

/*
 *  ͥ٥ޥγɽɽѴ
 */
#define EXT_IPM(iipm)	(-CAST(PRI, (iipm) >> 8))		/* ɽѴ */
#define INT_IPM(ipm)	(CAST(uint16_t, -(ipm)) << 8)	/* ɽѴ */

#ifndef TOPPERS_MACRO_ONLY

/*
 *  IPMʥϡɥγͥ٥ޥɽˤθͤɽФ
 */
Inline uint16_t
current_iipm(void)
{
	return(current_sr() & 0x0700U);
}

/*
 *  IPMʥϡɥγͥ٥ޥɽˤθͤ
 */
Inline void
set_iipm(uint16_t iipm)
{
	set_sr((current_sr() & ~0x0700U) | iipm);
}

/*
 *  TOPPERSɸ߽ǥμ¸
 *
 *  M68040ϡơ쥸SR˳ͥ٥ޥʥϡɥ
 *  γͥ٥ޥIPMˤäƤ뤬CPUåե饰
 *  뵡ǽʤΤᡤCPUåե饰εǽIPMˤä
 *  ¸롥
 *
 *  ޤCPUåե饰͡ʤʤCPUå֤CPUå
 *  ˤϡΤѿlock_flagˤѰդݻ롥
 *
 *  CPUåե饰ꥢƤ֡ʤʤCPUå֤
 *  ֡ˤϡIPMʥϡɥγͥ٥ޥˤ򡤥ǥγ
 *  ͥ٥ޥͤꤹ롥δ֤ϡǥγͥ٥ޥ
 *  ϡIPMѤݻ롥
 *
 *  ФCPUåե饰åȤƤ֡ʤʤCPU
 *  ֤δ֡ˤϡIPMʥϡɥγͥ٥ޥˤ򡤥ͥ
 *  γߤ򤹤٤ƥޥ͡TIPM_LOCKˤȡǥγͥ
 *  ٥ޥȤι⤤ꤹ롥δ֤Υǥγͥ٥ޥ
 *  ϡΤѿsaved_iipmɽݻˤѰդݻ
 *  롥
 */

/*
 *  ƥȤλ
 *
 *  M68040ǤϡƥȤޥ⡼ɤǡ󥿥ƥ
 *  Ȥߥ⡼ɤǼ¹Ԥ롥ޥ⡼ɤߥ⡼ɤϡơ
 *  쥸SRγߥ⡼ɥӥåȤˤȽ̤Ǥ롥
 */
Inline bool_t
sense_context(void)
{
	return((current_sr() & 0x1000U) == 0U);
}

#endif /* TOPPERS_MACRO_ONLY */

/*
 *  CPUå֤Ǥγͥ٥ޥ
 *
 *  TIPM_LOCKϡͥγߤ򤹤٤ƥޥͤ롥
 *
 *  TIPM_LOCKϡŪˤTMIN_INTPRI˰פФ褤M68040Ǥϡ
 *  IPMʥϡɥγͥ٥ޥˤ-6ξ-7ξο
 *  ƱǡIPM-7ꤹ뤳ȤϸΨŪ˹Ԥ뤳Ȥ顤
 *  TMIN_INTPRI-6λTIPM_LOCK-7ˤƤ롥
 */
#if TMIN_INTPRI == -6		/* NMIʳ˥ͥγߤߤʤ */
#define TIPM_LOCK		(-7)
#else /* TMIN_INTPRI == -6 */
#if (-1 >= TMIN_INTPRI) && (TMIN_INTPRI > -6)
#define TIPM_LOCK		TMIN_INTPRI
#else /* (-1 >= TMIN_INTPRI) && (TMIN_INTPRI > -6) */
#error TMIN_INTPRI out of range.
#endif /* (-1 >= TMIN_INTPRI) && (TMIN_INTPRI > -6) */
#endif /* TMIN_INTPRI == -6 */

/*
 *  CPUå֤Ǥγͥ٥ޥɽ
 */
#define IIPM_LOCK		INT_IPM(TIPM_LOCK)

/*
 *  TIPM_ENAALLʳͥ٥ޥˤɽ
 */
#define IIPM_ENAALL		INT_IPM(TIPM_ENAALL)

#ifndef TOPPERS_MACRO_ONLY

/*
 *  CPUåե饰¸Τѿ
 *
 *  ѿϡCPUå֤λΤ߽񤭴Ƥ褤ΤȤ롥
 */
extern volatile bool_t		lock_flag;	/* CPUåե饰ͤݻѿ */
extern volatile uint16_t	saved_iipm;	/* ͥ٥ޥ¸ѿ */

/*
 *  CPUå֤ؤΰܹ
 *
 *  IPMʥϡɥγͥ٥ޥˤsaved_iipm¸
 *  ͥγߤ򤹤٤ƥޥ͡TIPM_LOCKˤꤹ롥ޤ
 *  lock_flagtrueˤ롥
 *
 *  IPMǽ餫TIPM_LOCKƱ⤤ˤϡ
 *  saved_iipm¸ΤߤǡTIPM_LOCKˤꤷʤϡǥ
 *  γͥ٥ޥTIPM_LOCKƱ⤤٥
 *  Ƥ֤ˤ롥
 *
 *  δؿϡCPUå֡lock_flagtrueξ֡ˤǸƤФ뤳Ȥ
 *  ʤΤꤷƤ롥
 */
Inline void
x_lock_cpu(void)
{
	uint16_t	iipm;

	/*
	 *  current_iipm()֤ͤľsaved_iipm¸ѿiipm
	 *  ѤƤΤϡcurrent_iipm()Ƥľ˳ߤȯ
	 *  ư줿߽saved_iipmѹǽ뤿
	 *  롥
	 */
	iipm = current_iipm();
#if TIPM_LOCK == -7
	disint();
#else /* TIPM_LOCK == -7 */
	if (IIPM_LOCK > iipm) {
		set_iipm(IIPM_LOCK);
	}
#endif /* TIPM_LOCK == -7 */
	saved_iipm = iipm;
	lock_flag = true;
	Asm("":::"memory");
}

#define t_lock_cpu()	x_lock_cpu()
#define i_lock_cpu()	x_lock_cpu()

/*
 *  CPUå֤β
 *
 *  lock_flagfalseˤIPMʥϡɥγͥ٥ޥˤ
 *  saved_iipm¸᤹ͤ
 *
 *  δؿϡCPUå֡lock_flagtrueξ֡ˤǤΤ߸ƤФ
 *  ΤꤷƤ롥
 */
Inline void
x_unlock_cpu(void)
{
	Asm("":::"memory");
	lock_flag = false;
	set_iipm(saved_iipm);
}

#define t_unlock_cpu()	x_unlock_cpu()
#define i_unlock_cpu()	x_unlock_cpu()

/*
 *  CPUå֤λ
 */
Inline bool_t
x_sense_lock(void)
{
	return(lock_flag);
}

#define t_sense_lock()	x_sense_lock()
#define i_sense_lock()	x_sense_lock()

/*
 *  chg_ipmͭʳͥ٤ϰϤȽ
 *
 *  TMIN_INTPRIͤˤ餺chg_ipmǤϡ-6TIPM_ENAALLʡ0ˤϰ
 *  Ǥ뤳ȤȤʥåγĥˡ
 */
#define VALID_INTPRI_CHGIPM(intpri) \
				(-6 <= (intpri) && (intpri) <= TIPM_ENAALL)

/*
 * ʥǥΡ˳ͥ٥ޥ
 *
 *  CPUåե饰ꥢƤϡϡɥγͥ٥
 *  ꤹ롥CPUåե饰åȤƤϡsaved_iipm
 *  ꤷˡϡɥγͥ٥ޥꤷ褦
 *  ʥǥΡ˳ͥ٥ޥTIPM_LOCKι⤤ꤹ롥
 */
Inline void
x_set_ipm(PRI intpri)
{
	uint16_t	iipm = INT_IPM(intpri);

	if (!lock_flag) {
		set_iipm(iipm);
	}
	else {
		saved_iipm = iipm;
#if TIPM_LOCK == -7
		/*
		 *  TIPM_LOCK-7ξˤϡλǥϡɥγͥ
		 *  ٥ޥɬ7ꤵƤ뤿ᡤꤷʤɬפʤ
		 */
#else /* TIPM_LOCK == -7 */
		set_iipm(iipm > IIPM_LOCK ? iipm : IIPM_LOCK);
#endif /* TIPM_LOCK == -7 */
	}
}

#define t_set_ipm(intpri)	x_set_ipm(intpri)
#define i_set_ipm(intpri)	x_set_ipm(intpri)

/*
 * ʥǥΡ˳ͥ٥ޥλ
 *
 *  CPUåե饰ꥢƤϥϡɥγͥ٥
 *  򡤥åȤƤsaved_iipm򻲾Ȥ롥
 */
Inline PRI
x_get_ipm(void)
{
	uint16_t	iipm;

	if (!lock_flag) {
		iipm = current_iipm();
	}
	else {
		iipm = saved_iipm;
	}
	return(EXT_IPM(iipm));
}

#define t_get_ipm()		x_get_ipm()
#define i_get_ipm()		x_get_ipm()

/*
 *  ǹ̥ͥؤΥǥѥåprc_support.S
 *
 *  dispatchϡƥȤƤӽФ줿ӥ
 *  ƤӽФ٤ΤǡƥȡCPUå֡ǥѥ
 *  ľ֡ʥǥΡ˳ͥ٥ޥ֤ǸƤӽФ
 *  Фʤʤ
 */
extern void	dispatch(void);

/*
 *  ǥѥåưϡprc_support.S
 *
 *  start_dispatchϡͥ뵯ư˸ƤӽФ٤Τǡ٤Ƥγ
 *  ߤػߤ֡ʳߥå֤Ʊξ֡ˤǸƤӽФʤ
 *  ʤʤ
 */
extern void	start_dispatch(void) NoReturn;

/*
 *  ߤΥƥȤΤƤƥǥѥåprc_support.S
 *
 *  exit_and_dispatchϡext_tskƤӽФ٤Τǡƥ
 *  ȡCPUå֡ǥѥåľ֡ʥǥΡ˳ͥ
 *  ٥ޥ֤ǸƤӽФʤФʤʤ
 */
extern void	exit_and_dispatch(void) NoReturn;

/*
 *  ͥνλθƽФprc_support.S
 *
 *  call_exit_kernelϡͥνλ˸ƤӽФ٤Τǡ󥿥
 *  ƥȤڤ괹ơͥνλexit_kernelˤƤӽ
 *  
 */
extern void call_exit_kernel(void) NoReturn;

/*
 *  ƥȤν
 *
 *  ٻ߾֤¹ԤǤ֤˰ܹԤ˸ƤФ롥λ
 *  ǥåΰȤäƤϤʤʤ
 *
 *  activate_context򡤥饤ؿǤϤʤޥȤƤΤϡ
 *  λǤTCBƤʤǤ롥
 */
extern void	start_r(void);

#define activate_context(p_tcb)											\
{																		\
	(p_tcb)->tskctxb.msp = (void *)((char *)((p_tcb)->p_tinib->stk)		\
										+ (p_tcb)->p_tinib->stksz);		\
	(p_tcb)->tskctxb.pc = (void *) start_r;								\
}

/*
 *  calltexϻѤʤ
 */
#define OMIT_CALLTEX

/*
 *  㳰٥ơ֥ι¤
 */
typedef struct exc_vector_entry {
	FP		exc_handler;		/* 㳰ϥɥεư */
} EXCVE;

/*
 *  ߥϥɥֹCPU㳰ϥɥֹϰϤȽ
 */
#define VALID_INHNO_DEFINH(inhno)	((0x10U <= (inhno) && (inhno) <= 0x1fU) \
									|| (0x40U <= (inhno) && (inhno) <= 0xffU))
#define VALID_EXCNO_DEFEXC(excno)	((0x02U <= (excno) && (excno) <= 0x0fU) \
									|| (0x20U <= (excno) && (excno) <= 0x3fU))

/*
 *  ߥϥɥ
 *
 *  ٥ȥֹinhnoγߥϥɥνϤint_entry
 *  ꤹ롥
 */
Inline void
x_define_inh(INHNO inhno, FP int_entry)
{
	EXCVE	*excvt;

	assert(VALID_INHNO_DEFINH(inhno));

#ifdef EXCVT_KERNEL
	/*
	 *  EXCVT_KERNELƤϡVBR
	 *  EXCVT_KERNELꤹΤǡEXCVT_KERNELȤ
	 */
	excvt = (EXCVE *) EXCVT_KERNEL;
#else /* EXCVT_KERNEL */
	excvt = (EXCVE *) current_vbr();
#endif /* EXCVT_KERNEL */
	excvt[inhno].exc_handler = int_entry;
}

/*
 *  CPU㳰ϥɥ
 *
 *  ٥ȥֹexcnoCPU㳰ϥɥνϤexc_entry
 *  ꤹ롥
 */
Inline void
x_define_exc(EXCNO excno, FP exc_entry)
{
	EXCVE	*excvt;

	assert(VALID_EXCNO_DEFEXC(excno));

#ifdef EXCVT_KERNEL
	/*
	 *  EXCVT_KERNELƤϡVBR
	 *  EXCVT_KERNELꤹΤǡEXCVT_KERNELȤ
	 */
	excvt = (EXCVE *) EXCVT_KERNEL;
#else /* EXCVT_KERNEL */
	excvt = (EXCVE *) current_vbr();
#endif /* EXCVT_KERNEL */
	excvt[excno].exc_handler = exc_entry;
}

/*
 *  ߥϥɥν
 */

/*
 *  ߥϥɥνΥ٥ޥ
 */
#define INT_ENTRY(inhno, inthdr)	_kernel_##inthdr##_##inhno

/*
 *  LOG_INH_ENTERޥƤˡCALL_LOG_INH_ENTER
 *  inhno_numѥ᡼Ȥlog_inh_enterƤӽФ֥쥳
 *  ɤ˥ޥ롥
 */
#ifdef LOG_INH_ENTER

#define CALL_LOG_INH_ENTER(inhno_num) \
"	move.l #" #inhno_num ", -(%sp)	\n"  /* inhno_numѥ᡼ */ \
"	jsr _kernel_log_inh_enter		\n"  /* log_inh_enterƤӽФ */ \
"	addq.l #4, %sp					\n"

#else /* LOG_INH_ENTER */
#define CALL_LOG_INH_ENTER(inhno_num)
#endif /* LOG_INH_ENTER */

#ifdef LOG_INH_LEAVE

/*
 *  CALL_LOG_INH_LEAVEinhno_numѥ᡼Ȥlog_inh_leave
 *  ӽФ֥쥳ɤ˥ޥ롥
 */
#define CALL_LOG_INH_LEAVE(inhno_num) \
"	move.l #" #inhno_num ", -(%sp)	\n"  /* inhno_numѥ᡼ */ \
"	jsr _kernel_log_inh_leave		\n"  /* log_inh_leaveƤӽФ */ \
"	addq.l #4, %sp					\n"

/*
 *  LOG_INH_LEAVEޥƤγߥϥɥν
 *  ߥϥɥ򥵥֥롼󥳡뤷äƤ顤ȥ졼
 *  塤ret_intʬ롥
 */
#define INTHDR_ENTRY(inhno, inhno_num, inthdr) \
extern void _kernel_##inthdr##_##inhno(void); \
asm(".text							\n" \
"_kernel_" #inthdr "_" #inhno ":	\n" \
"	movem.l %d0-%d1/%a0-%a1, -(%sp)	\n"  /* å쥸¸ */ \
	CALL_LOG_INH_ENTER(inhno_num) \
"	jsr " #inthdr "					\n"  /* ߥϥɥƤӽФ */ \
	CALL_LOG_INH_LEAVE(inhno_num) \
"	jmp _kernel_ret_int				\n");/* ret_intʬ */

#else /* LOG_INH_LEAVE */

/*
 *  LOG_INH_LEAVEޥƤʤγߥϥɥν
 *  ϤȤret_int򥹥åѤ塤ߥϥɥεư
 *  Ϥʬ롥ߥϥɥ餫Υ꥿ˤꡤret_intʬ
 *  롥
 */
#define INTHDR_ENTRY(inhno, inhno_num, inthdr) \
extern void _kernel_##inthdr##_##inhno(void); \
asm(".text							\n" \
"_kernel_" #inthdr "_" #inhno ":	\n" \
"	movem.l %d0-%d1/%a0-%a1, -(%sp)	\n"  /* å쥸¸ */ \
	CALL_LOG_INH_ENTER(inhno_num) \
"	move.l #_kernel_ret_int, -(%sp)	\n"  /* Ϥ򥹥åѤ */ \
"	jmp " #inthdr "					\n");/* ߥϥɥʬ */

#endif /* LOG_INH_LEAVE */

/*
 *  CPU㳰ϥɥν
 *
 *  CPU㳰ϥɥϤA1ˡCPU㳰ϥɥֹD1ơ
 *  exchdr_entryʬ롥ߥϥɥνƱͤˡCPU㳰
 *  ϥɥCPU㳰ϥɥƤӽФŸˡ⤢뤬Ÿ
 *  ƤʣǤ뤿ᡤѤƤʤ
 */

/*
 *  CPU㳰ϥɥνΥ٥ޥ
 */
#define EXC_ENTRY(excno, exchdr)	_kernel_##exchdr##_##excno

/*
 *  CPU㳰ϥɥν
 */
#define EXCHDR_ENTRY(excno, excno_num, exchdr) \
extern void _kernel_##exchdr##_##excno(void *sp); \
asm(".text							\n" \
"_kernel_" #exchdr "_" #excno ":	\n" \
"	movem.l %d0-%d1/%a0-%a1, -(%sp)	\n"  /* å쥸¸ */ \
"	lea.l " #exchdr ", %a1			\n"  /* CPU㳰ϥɥϤA1 */ \
"	move.l #" #excno_num ", %d1		\n"  /* excno_numD1 */ \
"	jmp _kernel_exchdr_entry		\n");/* exchdr_entryʬ */

/*
 *  CPU㳰ȯΥƥȤλ
 *
 *  CPU㳰ȯΥƥȤƥȤλfalse
 *  Ǥʤtrue֤
 */
Inline bool_t
exc_sense_context(void *p_excinf)
{
	return((*((uint16_t *) p_excinf) & 0x1000U) == 0U);
}

/*
 *  CPU㳰ȯIPMʥϡɥγͥ٥ޥɽ
 *  ˤλ
 */
Inline uint16_t
exc_get_iipm(void *p_excinf)
{
	return(*((uint16_t *) p_excinf) & 0x0700U);
}

/*
 *  CPU㳰ȯΥƥȤȳߤΥޥ֤λ
 *
 *  CPU㳰ȯΥƥ֤ͥ¹Ǥʤ
 *  ƥȤǤꡤߥå֤ǤʤCPUå֤Ǥʤ
 *  ͥ٥ޥ֤ǤtrueǤʤfalse֤
 *  CPU㳰ͥγ߽ȯˤfalse
 *  ˡ
 *
 *  M68040ǤϡCPU㳰ȯIPMʥϡɥγͥ٥
 *  ˤ٤ƤγߤĤ֤Ǥ뤳Ȥå뤳Ȥǡ
 *  ͥ¹Ǥʤȡߥå֤ǤʤȡCPUå
 *  ֤Ǥʤȡͥ٥ޥ֤Ǥ뤳Ȥ4Ĥξ
 *  å뤳ȤǤCPU㳰ȯlock_flag򻲾Ȥ
 *  ɬפϤʤˡ
 */
Inline bool_t
exc_sense_intmask(void *p_excinf)
{
	return(!exc_sense_context(p_excinf)
					&& exc_get_iipm(p_excinf) == IIPM_ENAALL);
}

/*
 *  ץå¸ν
 */
extern void	prc_initialize(void);

/*
 *  ץå¸νλ
 */
extern void	prc_terminate(void);

#endif /* TOPPERS_MACRO_ONLY */
#endif /* TOPPERS_PRC_CONFIG_H */
