/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005-2009 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ(1)(4)ξ˸¤ꡤܥեȥ
 *  ܥեȥѤΤޤࡥʲƱˤѡʣ
 *  ѡۡʰʲѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *      ޤܥեȥΥ桼ޤϥɥ桼Τʤ
 *      ͳ˴Ťᤫ⡤嵭ԤTOPPERSץȤ
 *      դ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơλŪ
 *  ФŬޤơʤݾڤԤʤޤܥեȥ
 *  ѤˤľŪޤϴŪʤ»˴ؤƤ⡤
 *  Ǥʤ
 * 
 *  @(#) $Id$
 */

/*
 *		ץå¸⥸塼M68040ѡ
 */

#include "kernel_impl.h"
#include "check.h"
#include "task.h"

/*
 *  CPUåե饰¸Τѿ
 */
volatile bool_t		lock_flag;		/* CPUåե饰ͤݻѿ */
volatile uint16_t	saved_iipm;		/* ͥ٥ޥ¸ѿ */

/*
 *  ץå¸ν
 */
void
prc_initialize(void)
{
	/*
	 *  CPUåե饰¸Τѿν
	 */
	lock_flag = true;
	saved_iipm = IIPM_ENAALL;

	/*
	 *  㳰٥ơ֥ν
	 */
#ifdef EXCVT_KERNEL
	memcpy(EXCVT_KERNEL, EXCVT_ORIG, EXCVT_LEN);
	set_vbr(EXCVT_KERNEL);
#endif /* EXCVT_KERNEL */
}

/*
 *  ץå¸νλ
 */
void
prc_terminate(void)
{
	extern void	software_term_hook(void);
	void (*volatile fp)(void) = software_term_hook;

	/*
	 *  software_term_hookؤΥݥ󥿤򡤰övolatileΤfp
	 *  ƤȤΤϡ0ȤӤŬǺʤ褦ˤ뤿
	 *  Ǥ롥
	 */
	if (fp != 0) {
		(*fp)();
	}

#ifdef EXCVT_KERNEL
	set_vbr(EXCVT_ORIG);
#endif /* EXCVT_KERNEL */
}

/*
 *  CPU㳰ȯΥ
 *
 *  CPU㳰ϥɥ椫顤CPU㳰ݥ󥿡p_excinfˤȤ
 *  ƸƤӽФȤǡCPU㳰ȯ򥷥ƥ˽Ϥ롥
 */
#ifdef SUPPORT_XLOG_SYS

void
xlog_sys(void *p_excinf)
{
	char	*excsp = (char *) p_excinf;
	uint_t	format;

	syslog_0(LOG_ERROR, "CPU Exception Information:");
	syslog_4(LOG_ERROR, "SR = %04x (M = %d, S = %d, IPM = %d)",
				*((uint16_t *) excsp),
				(*((uint16_t *) excsp) & 0x1000U) >> 12,
				(*((uint16_t *) excsp) & 0x2000U) >> 13,
				(*((uint16_t *) excsp) & 0x0700U) >> 8);
	syslog_1(LOG_ERROR, "PC = %08x", *((uint32_t *)(excsp + 2)));
	format = (*((uint16_t *)(excsp + 6)) & 0xf000U) >> 12;
	syslog_2(LOG_ERROR, "Format = %d, Vector Offset = %03x",
				format, (*((uint16_t *)(excsp + 6)) & 0x0fffU));
	if (format >= 2U) {
		syslog_1(LOG_ERROR, "ADR = %08x", *((uint32_t *)(excsp + 8)));
	}
}

#endif /* SUPPORT_XLOG_SYS */
