/*
 *  TOPPERS Software
 *      Toyohashi Open Platform for Embedded Real-Time Systems
 * 
 *  Copyright (C) 2007-2013 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ(1)(4)ξ˸¤ꡤܥեȥ
 *  ܥեȥѤΤޤࡥʲƱˤѡʣ
 *  ѡۡʰʲѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *      ޤܥեȥΥ桼ޤϥɥ桼Τʤ
 *      ͳ˴Ťᤫ⡤嵭ԤTOPPERSץȤ
 *      դ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơλŪ
 *  ФŬޤơʤݾڤԤʤޤܥեȥ
 *  ѤˤľŪޤϴŪʤ»˴ؤƤ⡤
 *  Ǥʤ
 * 
 *  $Id$
 */

/* 
 *		⥸塼Υƥ(1)
 *
 * ڥƥȤŪ
 *
 *  make_runnablemake_non_runnableŪ˥ƥȤ롥
 *
 * ڥƥȹܡ
 *
 *	(A) ¹Ծ֤Υ⤤ͥ٤Υ¹ԤǤ֤ˤ
 *		(A-1) ǥѥåα֤ǤϤʤ
 *		(A-2) ǥѥåα֤ξ
 *	(B) ¹Ծ֤ΥƱͥ٤Υ¹ԤǤ֤ˤ
 *		Ʊͥ٤Υ뤳Ȥǧ
 *	(C) ¹Ծ֤Υ㤤ͥ٤Υ¹ԤǤ֤ˤ
 *		Ʊͥ٤Υ뤳Ȥǧ
 *	(D) ¹ԤǤ֤Υʤ֤ǡ¹ԤǤ֤ˤ
 *		ξϡǥѥåα֤ǤϤʤ
 *	(E) ǥѥåα֤ǡ¹Ծ֤ˤʤ٤¹Բǽ֥
 *		⤤ͥ٤Υ򡤼¹ԤǤ֤ˤ
 *	(F) ǥѥåα֤ǡ¹Ծ֤ˤʤ٤¹Բǽ֥
 *		Ʊͥ٤Υ򡤼¹ԤǤ֤ˤ
 *	(G) ǥѥåα֤ǡ¹Ծ֤ˤʤ٤¹Բǽ֥
 *		㤤ͥ٤Υ򡤼¹ԤǤ֤ˤ
 *	(H) ¹Ծ֤Υ򡤼¹ԤǤ֤Ǥʤ
 *		(H-1) ¹ԤǤ֤Υʤʤ
 *		(H-2) Ʊͥ٤Υʤʤ
 *		(H-3) Ʊͥ٤Υʤʤʤ
 *	(I) ¹Բǽ֤Υ򡤼¹ԤǤ֤Ǥʤ
 *		(I-1) Ʊͥ٤Υʤʤ
 *		(I-2) Ʊͥ٤Υʤʤʤ
 *	(J) ǥѥåα֤ǡ¹Ծ֤ˤʤ٤¹Բǽ֤Ȥʤ
 *		Ƥ륿򡤼¹ԤǤ֤Ǥʤ
 *		(J-1) Ʊͥ٤Υʤʤ
 *		(J-2) Ʊͥ٤Υʤʤʤ
 *	(K) ǥѥåα֤ǡ¹Բǽ֤ˤʤ٤¹Ծ֤Υ
 *		򡤼¹ԤǤ֤Ǥʤ
 *		ǥѥåαǤϡ¹Ծ֤Υ¹ԤǤ֤Ǥʤ
 *		ʤ褦ܤ򵯤ȤǤʤᡤξϵʤ
 *
 * ڻѥ꥽
 *
 *	TASK1: ͥ٥ᥤ󥿥ǽ餫鵯ư
 *	TASK2: ͥ٥
 *	TASK3: ͥ٥
 *	TASK4: ͥ٥
 *	TASK5: ͥ٥
 *	TASK6: ͥ٥
 *	ALM1:  顼ϥɥ
 *
 * ڥƥȥ󥹡
 *
 *	== TASK1ͥ١==
 *	1:	act_tsk(TASK2)					... (A-1)
 *	== TASK2ͥ١==
 *	2:	slp_tsk()						... (H-2)
 *	== TASK1³==
 *	3:	act_tsk(TASK3)					... (B)
 *	4:	act_tsk(TASK4)					... (B)
 *	5:	slp_tsk()						... (H-3)
 *	== TASK3ͥ١==
 *	6:	slp_tsk()						... (H-3)
 *	== TASK4ͥ١==
 *	7:	wup_tsk(TASK1)
 *	8:	slp_tsk()						... (H-3)
 *	== TASK1³==
 *	9:	act_tsk(TASK5)					... (C)
 *	10:	act_tsk(TASK6)					... (C)
 *	11:	sus_tsk(TASK6)					... (I-2)
 *	12:	sus_tsk(TASK5)					... (I-1)
 *	13:	rsm_tsk(TASK5)					... (C)
 *	14:	rsm_tsk(TASK6)					... (C)
 *	15:	slp_tsk()						... (H-2)
 *	== TASK5ͥ١==
 *	16:	slp_tsk()						... (H-3)
 *	== TASK6ͥ١==
 *	17:	dis_dsp()
 *	18:	wup_tsk(TASK1)					... (A-2)
 *	19:	wup_tsk(TASK2)					... (E)
 *	20:	sus_tsk(TASK2)					... (J-1)
 *	21:	wup_tsk(TASK3)					... (F)
 *	22:	wup_tsk(TASK4)					... (F)
 *	23:	sus_tsk(TASK1)					... (J-2)
 *	24:	ena_dsp()
 *	== TASK3³==
 *	25:	slp_tsk()						... (H-3)
 *	== TASK4³==
 *	26:	slp_tsk()						... (H-2)
 *	== TASK6³==
 *	27:	dis_dsp()
 *	28:	rsm_tsk(TASK1)					... (A-2)
 *	29:	wup_tsk(TASK5)					... (G)
 *	30:	ena_dsp()
 *	== TASK1³==
 *	31:	slp_tsk()						... (H-2)
 *	== TASK6³==
 *	32:	slp_tsk()						... (H-3)
 *	== TASK5³==
 *	33:	sta_alm(ALM1, 10)
 *	34:	slp_tsk()						... (H-1)
 *	== ALM1 ==
 *	35:	iget_tid(&tskid)
 *		assert(tskid == TSK_NONE)
 *	36:	iwup_tsk(TASK1)					... (D)
 *	37:	RETURN
 *	== TASK1³==
 *	38: END
 */

#include <kernel.h>
#include <test_lib.h>
#include <t_syslog.h>
#include "kernel_cfg.h"
#include "test_task1.h"

/* DO NOT DELETE THIS LINE -- gentest depends on it. */

void
alarm1_handler(intptr_t exinf)
{
	ID		tskid;
	ER_UINT	ercd;

	check_point(35);
	ercd = iget_tid(&tskid);
	check_ercd(ercd, E_OK);

	check_assert(tskid == TSK_NONE);

	check_point(36);
	ercd = iwup_tsk(TASK1);
	check_ercd(ercd, E_OK);

	check_point(37);
	return;

	check_point(0);
}

void
task1(intptr_t exinf)
{
	ER_UINT	ercd;

	test_start(__FILE__);

	check_point(1);
	ercd = act_tsk(TASK2);
	check_ercd(ercd, E_OK);

	check_point(3);
	ercd = act_tsk(TASK3);
	check_ercd(ercd, E_OK);

	check_point(4);
	ercd = act_tsk(TASK4);
	check_ercd(ercd, E_OK);

	check_point(5);
	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(9);
	ercd = act_tsk(TASK5);
	check_ercd(ercd, E_OK);

	check_point(10);
	ercd = act_tsk(TASK6);
	check_ercd(ercd, E_OK);

	check_point(11);
	ercd = sus_tsk(TASK6);
	check_ercd(ercd, E_OK);

	check_point(12);
	ercd = sus_tsk(TASK5);
	check_ercd(ercd, E_OK);

	check_point(13);
	ercd = rsm_tsk(TASK5);
	check_ercd(ercd, E_OK);

	check_point(14);
	ercd = rsm_tsk(TASK6);
	check_ercd(ercd, E_OK);

	check_point(15);
	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(31);
	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_finish(38);
	check_point(0);
}

void
task2(intptr_t exinf)
{
	ER_UINT	ercd;

	check_point(2);
	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(0);
}

void
task3(intptr_t exinf)
{
	ER_UINT	ercd;

	check_point(6);
	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(25);
	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(0);
}

void
task4(intptr_t exinf)
{
	ER_UINT	ercd;

	check_point(7);
	ercd = wup_tsk(TASK1);
	check_ercd(ercd, E_OK);

	check_point(8);
	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(26);
	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(0);
}

void
task5(intptr_t exinf)
{
	ER_UINT	ercd;

	check_point(16);
	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(33);
	ercd = sta_alm(ALM1, 10);
	check_ercd(ercd, E_OK);

	check_point(34);
	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(0);
}

void
task6(intptr_t exinf)
{
	ER_UINT	ercd;

	check_point(17);
	ercd = dis_dsp();
	check_ercd(ercd, E_OK);

	check_point(18);
	ercd = wup_tsk(TASK1);
	check_ercd(ercd, E_OK);

	check_point(19);
	ercd = wup_tsk(TASK2);
	check_ercd(ercd, E_OK);

	check_point(20);
	ercd = sus_tsk(TASK2);
	check_ercd(ercd, E_OK);

	check_point(21);
	ercd = wup_tsk(TASK3);
	check_ercd(ercd, E_OK);

	check_point(22);
	ercd = wup_tsk(TASK4);
	check_ercd(ercd, E_OK);

	check_point(23);
	ercd = sus_tsk(TASK1);
	check_ercd(ercd, E_OK);

	check_point(24);
	ercd = ena_dsp();
	check_ercd(ercd, E_OK);

	check_point(27);
	ercd = dis_dsp();
	check_ercd(ercd, E_OK);

	check_point(28);
	ercd = rsm_tsk(TASK1);
	check_ercd(ercd, E_OK);

	check_point(29);
	ercd = wup_tsk(TASK5);
	check_ercd(ercd, E_OK);

	check_point(30);
	ercd = ena_dsp();
	check_ercd(ercd, E_OK);

	check_point(32);
	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(0);
}
