/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005-2010 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ(1)(4)ξ˸¤ꡤܥեȥ
 *  ܥեȥѤΤޤࡥʲƱˤѡʣ
 *  ѡۡʰʲѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *      ޤܥեȥΥ桼ޤϥɥ桼Τʤ
 *      ͳ˴Ťᤫ⡤嵭ԤTOPPERSץȤ
 *      դ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơλŪ
 *  ФŬޤơʤݾڤԤʤޤܥեȥ
 *  ѤˤľŪޤϴŪʤ»˴ؤƤ⡤
 *  Ǥʤ
 * 
 *  @(#) $Id$
 */

/*
 *		åȰ¸⥸塼DVE-68K/40ѡ
 *
 *  ͥΥåȰ¸Υ󥯥롼ɥե롥kernel_impl.hΥ
 *  åȰ¸ΰդȤʤ롥
 */

#ifndef TOPPERS_TARGET_CONFIG_H
#define TOPPERS_TARGET_CONFIG_H

/*
 *  åȥƥΥϡɥ񸻤
 */
#include "dve68k.h"

/*
 *  åΥ֥°
 */
#define TARGET_INHATR	TA_NONKERNEL	/* ͥγ */

/*
 *  顼åˡλ
 */
#define CHECK_STKSZ_ALIGN	4	/* åΥ饤ñ */
#define CHECK_FUNC_ALIGN	2	/* ؿΥ饤ñ */
#define CHECK_FUNC_NONNULL		/* ؿNULLå */
#define CHECK_STACK_ALIGN	4	/* åΰΥ饤ñ */
#define CHECK_STACK_NONNULL		/* åΰNULLå */
#define CHECK_MPF_ALIGN		4	/* ĹסΰΥ饤ñ */
#define CHECK_MPF_NONNULL		/* ĹסΰNULLå */
#define CHECK_MB_ALIGN		4	/* ΰΥ饤ñ */

/*
 *  ȥ졼˴ؤ
 */
#ifdef TOPPERS_ENABLE_TRACE
#include "logtrace/trace_config.h"
#endif /* TOPPERS_ENABLE_TRACE */

/*
 *  ASPͥưΥޥåפȴϢ
 *
 *	00000000 - 0000ffff		ROM˥֥ꥢ64KB
 *	00010000 - 000fffff		ΰ1MB
 *	00100000 -				ǡΰ3MB
 *			 - 003fffff		ǥեȤ󥿥ƥѤΥåΰ
 */

/*
 *  ǥեȤ󥿥ƥѤΥåΰ
 */
#define DEFAULT_ISTKSZ		0x2000U
#define DEFAULT_ISTK		(void *)(0x00400000U - DEFAULT_ISTKSZ)

#ifndef TOPPERS_MACRO_ONLY

/*
 *  ץå̤Τѿʥޥץåб
 */
extern uint_t	board_id;		/* ܡID */
extern void		*board_addr;	/* Ƭɥ쥹 */

/*
 *  ֹϰϤȽ
 *
 *  ӥåȥѥΤưפˤ뤿ˡ8Ϸ֤ˤʤäƤ롥
 */
#define VALID_INTNO(intno)	(1U <= (intno) && (intno) <= 31U && (intno) != 8U)
#define	VALID_INTNO_CREISR(intno)	VALID_INTNO(intno)
#define VALID_INTNO_DISINT(intno)	VALID_INTNO(intno)
#define VALID_INTNO_CFGINT(intno)	VALID_INTNO(intno)

/*
 *  ׵뤿Υӥåȥѥޥ
 *
 *  եȱ黻٤ץåǡ;͵ˤϡɽ
 *  Ǽ褤ɽʤ顤ֹ8֤ˤ
 *  ɬפϤʤ
 */
#define DGA_INT_BITPAT(intno)	(1U << (32U - (intno)))

/*
 *  ٥ȥꥬåȥꥬǤ뤫Ƚ
 */
#define DGA_INT_TRG_CONF	(0xe0000000U)	/* ˤǤ */
#define DGA_INT_TRG_LEVEL	(0x108f00feU)	/* ٥ȥꥬ˸ */
#define DGA_INT_TRG_EDGE	(0x0e70ff00U)	/* åȥꥬ˸ */

/*
 *  °ꤵƤ뤫Ƚ̤뤿ѿkernel_cfg.c
 */
extern const uint32_t	bitpat_cfgint;

/*
 *  ׵ػߥե饰Υå
 *
 *  °ꤵƤʤ׵饤ФƳ׵ػ
 *  ե饰򥻥åȤ褦Ȥˤϡfalse֤
 */
Inline bool_t
x_disable_int(INTNO intno)
{
	uint32_t	bitpat = DGA_INT_BITPAT(intno);

	if ((bitpat_cfgint & bitpat) == 0U) {
		return(false);
	}
	dga_bit_and((void *) TADR_DGA_CSR21, ~bitpat);
	return(true);
}

#define t_disable_int(intno)	x_disable_int(intno)
#define i_disable_int(intno)	x_disable_int(intno)

/*
 *  ׵ػߥե饰Υꥢ
 *
 *  °ꤵƤʤ׵饤ФƳ׵ػ
 *  ե饰򥯥ꥢ褦Ȥˤϡfalse֤
 */
Inline bool_t
x_enable_int(INTNO intno)
{
	uint32_t	bitpat = DGA_INT_BITPAT(intno);

	if ((bitpat_cfgint & bitpat) == 0U) {
		return(false);
	}
	dga_bit_or((void *) TADR_DGA_CSR21, bitpat);
	return(true);
}

#define t_enable_int(intno)		x_enable_int(intno)
#define i_enable_int(intno)		x_enable_int(intno)

/*
 *  ׵Υꥢ
 */
Inline void
x_clear_int(INTNO intno)
{
	dga_write((void *) TADR_DGA_CSR23, DGA_INT_BITPAT(intno));
}

#define t_clear_int(intno)		x_clear_int(intno)
#define i_clear_int(intno)		x_clear_int(intno)

/*
 *  ׵Υå
 */
Inline bool_t
x_probe_int(INTNO intno)
{
	return((dga_read((void *) TADR_DGA_CSR20) & DGA_INT_BITPAT(intno)) != 0U);
}

#define t_probe_int(intno)		x_probe_int(intno)
#define i_probe_int(intno)		x_probe_int(intno)

/*
 *  ׵饤°
 *
 *  DVE-68K/40IRCǤϡ׵饤γͥ٤NMIꤹ
 *  ȤǤᡤ-7ͿNMIꤵ뤳ȤȤʥå
 *  γĥˡ
 */
extern void	x_config_int(INTNO intno, ATR intatr, PRI intpri);

/*
 *  ߥϥɥɬפIRC
 *
 *  åȥꥬξˤϡ׵򥯥ꥢ롥åȥꥬ
 *  ȥꥬǤ⡤ߤͤ򸫤˥ꥢƤ롥
 *  ٥ȥꥬξ⥯ꥢ򤷤ƺ٤ʤŬǾä
 *  ȤԤơꥢʤȤȤƤ롥
 */
Inline void
i_begin_int(INTNO intno)
{
	if ((DGA_INT_BITPAT(intno) & (DGA_INT_TRG_CONF | DGA_INT_TRG_EDGE))
																!= 0U) {
		i_clear_int(intno);
	}
}

/*
 *  ߥϥɥνиɬפIRC
 *
 *  DVE-68K/40ǤɬפIRCϤʤ
 */
Inline void
i_end_int(INTNO intno)
{
}

#endif /* TOPPERS_MACRO_ONLY */

#ifndef TOPPERS_MACRO_ONLY

/*
 *  åȥƥ¸ν
 */
extern void	target_initialize(void);

/*
 *  åȥƥνλ
 *
 *  ƥλ˻Ȥ
 */
extern void	target_exit(void) NoReturn;

#endif /* TOPPERS_MACRO_ONLY */

/*
 *  ԤΤSILΥåȰ¸
 */
#define SIL_DLY_TIM1	420
#define SIL_DLY_TIM2	90

/*
 *  ץå¸⥸塼M68040ѡ
 */
#include "m68k_gcc/prc_config.h"

#endif /* TOPPERS_TARGET_CONFIG_H */
